#pragma once

#include <set>
#include "util/generic/hash_set.h"
#include "tlogsgroup.h"
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "trulestat.h"
#include "ktypes.h"
#include "tpackets.h"
#include "trcptclass.h"
#include "tsummarydata.h"
#include "tshortipstorage.h"
#include "tpasswdchangeipstat.h"
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include "tsymbolsclass.h"

//******************************************************************************************************************
//
//******************************************************************************************************************

struct TMidnightTimingItem {
    ui32 m_lock_wait_time{};
    ui32 m_midnight_time{};
    ui32 m_del_yesterday_time{};
    ui32 m_write_dump_time{};

    TMidnightTimingItem() {
        Clear();
    }

    void Clear() {
        m_lock_wait_time = 0;
        m_midnight_time = 0;
        m_del_yesterday_time = 0;
        m_write_dump_time = 0;
    }
};

struct TMidnightTiming {
    TMidnightTimingItem m_Ips;
    TMidnightTimingItem m_FUID;
    TMidnightTimingItem m_Packet1;
    TMidnightTimingItem m_Packet2;
    TMidnightTimingItem m_Packet3;
    TMidnightTimingItem m_Packet4;
    TMidnightTimingItem m_Packet5;
    TMidnightTimingItem m_GeoStatCountry;
    TMidnightTimingItem m_GeoStat;
    TMidnightTimingItem m_GeoStatAS;
    TMidnightTimingItem m_Host2Level;
    TMidnightTimingItem m_Host3Level;
    TMidnightTimingItem m_Domen;
    TMidnightTimingItem m_DublicatLogin;
    TMidnightTimingItem m_IPv6Maska1;
    TMidnightTimingItem m_IPv6Maska2;
    TMidnightTimingItem m_IPv6Maska3;
    TMidnightTimingItem m_IPv4MaskaC;

    TMidnightTiming() {
        Clear();
    }

    void Clear() {
        m_Ips.Clear();
        m_FUID.Clear();
        m_Packet1.Clear();
        m_Packet2.Clear();
        m_Packet3.Clear();
        m_Packet4.Clear();
        m_Packet5.Clear();
        m_GeoStatCountry.Clear();
        m_GeoStat.Clear();
        m_GeoStatAS.Clear();
        m_Host2Level.Clear();
        m_Host3Level.Clear();
        m_Domen.Clear();
        m_DublicatLogin.Clear();
        m_IPv6Maska1.Clear();
        m_IPv6Maska2.Clear();
        m_IPv6Maska3.Clear();
        m_IPv4MaskaC.Clear();
    }
};

//******************************************************************************************************************
//                                                 CStat
//******************************************************************************************************************

class CStat {
public:
    size_t m_IpsSize{};
    size_t m_IpsSizeToday{};
    size_t m_FUIDSize{};
    size_t m_FUIDSizeToday{};
    size_t m_Pack1Size{};
    size_t m_Pack1SizeToday{};
    size_t m_Pack2Size{};
    size_t m_Pack2SizeToday{};
    size_t m_Pack3Size{};
    size_t m_Pack3SizeToday{};
    size_t m_Pack4Size{};
    size_t m_Pack4SizeToday{};
    size_t m_Pack5Size{};
    size_t m_Pack5SizeToday{};
    size_t m_GeoStatCountrySize{};
    size_t m_GeoStatCountrySizeToday{};
    size_t m_GeoStatSize{};
    size_t m_GeoStatSizeToday{};
    size_t m_GeoStatASSize{};
    size_t m_GeoStatASSizeToday{};
    size_t m_DublicatLoginSize{};
    size_t m_DublicatLoginSizeToday{};
    size_t m_LoginSize{};
    size_t m_LoginSizeToday{};
    size_t m_Host2LevelSize{};
    size_t m_Host2LevelSizeToday{};
    size_t m_Host3LevelSize{};
    size_t m_Host3LevelSizeToday{};
    size_t m_DomenSize{};
    size_t m_DomenSizeToday{};
    size_t m_IPv6Maska1Size{};
    size_t m_IPv6Maska1SizeToday{};
    size_t m_IPv6Maska2Size{};
    size_t m_IPv6Maska2SizeToday{};
    size_t m_IPv6Maska3Size{};
    size_t m_IPv6Maska3SizeToday{};
    size_t m_IPv4MaskaCSize{};
    size_t m_IPv4MaskaCSizeToday{};

    CStat() {
        Reset();
    }

    void Reset() {
        m_IpsSize = 0;
        m_IpsSizeToday = 0;
        m_FUIDSize = 0;
        m_FUIDSizeToday = 0;
        m_Pack1Size = 0;
        m_Pack1SizeToday = 0;
        m_Pack2Size = 0;
        m_Pack2SizeToday = 0;
        m_Pack3Size = 0;
        m_Pack3SizeToday = 0;
        m_Pack4Size = 0;
        m_Pack4SizeToday = 0;
        m_Pack5Size = 0;
        m_Pack5SizeToday = 0;
        m_GeoStatCountrySize = 0;
        m_GeoStatCountrySizeToday = 0;
        m_GeoStatSize = 0;
        m_GeoStatSizeToday = 0;
        m_GeoStatASSize = 0;
        m_GeoStatASSizeToday = 0;
        m_DublicatLoginSize = 0;
        m_DublicatLoginSizeToday = 0;
        m_LoginSize = 0;
        m_LoginSizeToday = 0;
        m_Host2LevelSize = 0;
        m_Host2LevelSizeToday = 0;
        m_Host3LevelSize = 0;
        m_Host3LevelSizeToday = 0;
        m_DomenSize = 0;
        m_DomenSizeToday = 0;
        m_IPv6Maska1Size = 0;
        m_IPv6Maska1SizeToday = 0;
        m_IPv6Maska2Size = 0;
        m_IPv6Maska2SizeToday = 0;
        m_IPv6Maska3Size = 0;
        m_IPv6Maska3SizeToday = 0;
        m_IPv4MaskaCSize = 0;
        m_IPv4MaskaCSizeToday = 0;
    }
};

//************************************************************************************
//                                  CItemStore2
//************************************************************************************

typedef std::set<ui32> TIPSet;
typedef std::set<ui32>::iterator TIPSetIt;

template <class TKey, class TValue>
class CItemStore2 {
public:
    static const ui32 INIT_HASH_SIZE = 100000;

    typedef THashMap<TKey, TValue> TItemHash;

    TItemHash m_pItemToday;
    TItemHash m_pItemYesterday;
    Y_SAVELOAD_DEFINE(m_pItemToday, m_pItemYesterday)
private:
    TMutex m_Mutex;

    void Lock();
    void UnLock();

public:
    void Init(const TString& db, const TString& collection_base);

    bool Exists(TKey Key, TValue Val);
    bool Add(TKey Key, TValue Val);
    bool Add2(TKey Key, TValue Val);
    size_t Midnight(ui32& lock_wait_time, ui32& midnight_time, ui32& del_yesterday_time);
    void GetStat(TKey Key, TValue& Stat);
    void GetStatEx(TKey Key, TValue& Stat, time_t sec, bool del, ui64 RequestCount, ui32& reccount);
    size_t GetSize();
    size_t GetSizeToday();
    size_t GetSizeGreatOne();
    size_t GetSizeTodayGreatOne();
    TValue* Find(TKey Key);
    TValue* FindPrev(TKey Key);
    bool Del(TKey Key);
    void Clear();
};

//*************************************************************************************************************
//                                        TIPv6Storage
//*************************************************************************************************************

//*************************************************************************************************************
//                                                   CSoStore
//*************************************************************************************************************

using TItemStatSetPtr = TAtomicSharedPtr<CItemStatSet>;
using TIpCache = NCache::TCacheBase<TKIPv6, TItemStatSetPtr>;

class CSoStore {
private:
    time_t m_LiveTime;
    TLogsGroup* LogsGroup;

    bool m_loadatstartup;
    TString m_todaybackup;
    TString m_yesterdaybackup;

    TIpCache IpCache;
//    TIPv6Storage m_Ips;                                  //��������������� ��������� �� ip
    CItemStore2<ui64, TCountValue> m_FUID;               //��������������� (�����/�������) ��������� �� fuid
    CItemStore2<ui64, TCountValue> m_Packet1;            //��������������� (�����/�������) ��������� �� ������� 1
    CItemStore2<ui64, TCountValue> m_Packet2;            //��������������� (�����/�������) ��������� �� ������� 2
    CItemStore2<ui64, TCountValue> m_Packet3;            //��������������� (�����/�������) ��������� �� ������� 3
    CItemStore2<ui64, TCountValue> m_Packet4;            //��������������� (�����/�������) ��������� �� ������� 4
    CItemStore2<ui64, TCountValue> m_Packet5;            //��������������� (�����/�������) ��������� �� ������� 5
    CItemStore2<ui64, TCountAndIPValue> m_DublicatLogin; //��������������� (�����/�������) ��������� �� �������
    CItemStore2<ui64, TCountValue> m_GeoStatCountry;     //��������������� (�����/�������) ��������� �� ��������� (������)
    CItemStore2<ui64, TCountValue> m_GeoStat;            //��������������� (�����/�������) ��������� �� ��������� (������ + �����)
    CItemStore2<ui64, TCountValue> m_GeoStatAS;          //��������������� (�����/�������) ��������� �� ��������� (AS)
    CItemStore2<ui64, TCountValue> m_Host2Level;         //��������������� (�����/�������) ��������� �� ������� 2 ������
    CItemStore2<ui64, TCountValue> m_Host3Level;         //��������������� (�����/�������) ��������� �� ������� 3 ������
    CItemStore2<ui64, TCountValue> m_Domen;              //��������������� (�����/�������) ��������� �� �������, ���� � ������ ���� @
    CItemStore2<ui64, TCountValue> m_IPv4MaskaC;         //��������������� (�����/�������) ��������� �� ipv4 � ������
    CItemStore2<ui64, TCountValue> m_IPv6Maska1;         //��������������� (�����/�������) ��������� �� ipv6 � ������
    CItemStore2<ui64, TCountValue> m_IPv6Maska2;         //��������������� (�����/�������) ��������� �� ipv6 � ������
    CItemStore2<ui64, TCountValue> m_IPv6Maska3;         //��������������� (�����/�������) ��������� �� ipv6 � ������
    TSummaryDataArray m_Sumdata;                         //���������� �� ��������� 300 � 1200 ���
    TRuleStat m_RuleStat;                                //��������� �� ����������� ��������
    TPasswdChange m_PasswdChange;                        //�������� ��� ����������� ���� "����� ������"

    TMutex m_MutexFUID;
    TMutex m_MutexPacket1;
    TMutex m_MutexPacket2;
    TMutex m_MutexPacket3;
    TMutex m_MutexPacket4;
    TMutex m_MutexPacket5;
    TMutex m_MutexDublicatLogin;
    TMutex m_MutexGeo;
    TMutex m_MutexHost;
    TMutex m_MutexDomen;
    TMutex m_MutexIPv6Maska;
    TMutex m_MutexIPv4Maska;

private:
    //������������� ���������� �� ������
    TString CorrectLogin(CItemStatSet* iss, TKIPv6 ip, const TString& login, ui32 karma, i32& ham0, i32& spam85, i32& spam100);
    ui64 CalcShingle(const TString& strdata);

public:
    Y_SAVELOAD_DEFINE(
        m_FUID,
        m_Packet1,
        m_Packet2,
        m_Packet3,
        m_Packet4,
        m_Packet5,
        m_GeoStatCountry,
        m_GeoStat,
        m_GeoStatAS,
        m_Host2Level,
        m_Host3Level,
        m_Domen,
        m_DublicatLogin,
        m_Sumdata,
        m_RuleStat,
        m_PasswdChange,
        m_IPv6Maska1,
        m_IPv6Maska2,
        m_IPv6Maska3,
        m_IPv4MaskaC)
    CSoStore();
    ~CSoStore();

    void Init(TLogsGroup* LogsGroupA, bool convert, TKConfig* configobjA);

    //��������������� (�����/�������) ��������� �� ip
    void AddHostname(TKIPv6 Ip, TString& host);
    void AddGeoToIP(TKIPv6 Ip, TString& geo);
    void GetGeoAndHost(TKIPv6 Ip, TString& geo, TString& host);
    int LoginInfo(TKIPv6 ip, TString& login);
    TIPStat AddCalcIPStatist(TKIPv6 Ip, time_t ip_count, const TString& login, const TString& LoginPrefix, ui16 loginprefix_count, TPackHint PasswHint, ui16 passwhint_count, TPackHint QuestHint, ui16 questhint_count, TString LoginFirstNSymb, ui16 loginfirstnsymb_count, TPackHint AnswerHint, ui32 uidA, TString iname, TString fname, TPacket packet2, ui32 geodata, bool ispdd);

    //��������������� (�����/�������) ��������� �� fuid
    TCountValue AddGetFUID(const TString& fuid, ui32 count);

    //��������������� (�����/�������) ��������� �� ������� 1
    TCountValue AddGetPacket1(TPacket pk, ui32 count);

    //��������������� (�����/�������) ��������� �� ������� 2
    TCountValue AddGetPacket2(TPacket pk, ui32 count);

    //��������������� (�����/�������) ��������� �� ������� 3
    TCountValue AddGetPacket3(TPacket3 pk, ui32 count);

    //��������������� (�����/�������) ��������� �� ������� 4
    TCountValue AddGetPacket4(TPacket4 pk, ui32 count);

    //��������������� (�����/�������) ��������� �� ������� 5
    TCountValue AddGetPacket5(TPacket2 pk, ui32 count);

    //��������������� (�����/�������) ��������� �� �������
    TCountAndIPValue AddGetDublicatLogin(TString& login, TKIPv6 ip);
    TCountAndIPValue GetDubLoginStat(TString& login);

    //��������������� (�����/�������) ��������� �� ���������
    TCountValue AddGetGeoCountry(TString& geos, ui32 count); //������ ������
    TCountValue AddGetGeo(TString& geos, ui32 count);        //������� (������ + �����)
    TCountValue AddGetGeoAS(TString& geos_as, ui32 count);   //AS

    //��������������� (�����/�������) ��������� �� ������
    TCountValue AddHost2Level(TString& host2level, ui32 count); //���� 2 ������
    TCountValue AddHost3Level(TString& host3level, ui32 count); //���� 3 ������

    //��������������� (�����/�������) ��������� �� ipv4/24 (net C)
    TCountValue AddIPv4MaskaC(ui64 ipmaska1, ui32 count);

    //��������������� (�����/�������) ��������� �� ipv6/maska
    TCountValue AddIPv6Maska1(ui64 ipmaska1, ui32 count);
    TCountValue AddIPv6Maska2(ui64 ipmaska2, ui32 count);
    TCountValue AddIPv6Maska3(ui64 ipmaska3, ui32 count);

    //��������������� ��������� �� ������ ��� ������� � @
    TCountValue AddDomen(const TString& domenA, ui32 count, TString& resdomen, bool& est_domen);

    //��������� �� ����������� ��������
    void SetRuleStatList(TKIniFile* rulestatlist);
    void AddRuleStat(time_t sec, const char* BUFF);
    void GetRuleStat(time_t sec, TRuleStatResList& res, bool del, ui64& RequestCount);

    //���������� �� ��������� 300 � 1200 ���
    TLTCSum AddGetCountFromSummDataNew(time_t regtime, TString& prefix_login, TString& first_nsymb_login, TPacket pack1, TString& email, TString& nickname, TString& phone, ui64 RequestCount, ui64 useragentA, ui64 reserv1, ui64 reserv2, ui64 reserv3);

    //�������� ��� ����������� ���� "����� ������"
    TPasswdChangeStat AddElementPasswdChange(ui32 currenttime, TKIPv6 ip);

    //������ �������
    void Clear();
    void Midnight();
    void EventTick() {
        IpCache.EventTick();
    }
    void GetStat(CStat& Stat);

    void AllResemblances(const TKIPv6& Ip, const TBackSpam& BackSpamAlg, const TOData& odata, TLTExtList& SpamList);

    //�������� ���������
    void SetSpamPriznak(TKIPv6 Ip, bool spam, time_t t, TString login, ui8 weight);

    //������������� ���������� �� ������
    TString CorrectLogins(TKIPv6 ip, TString login, ui32 karma, i32& ham0, i32& spam85, i32& spam100);
};

TString GetDomenNLevel(TString& host, int level);

//*****************************************************************************************
