#include "stato.h"

TStatO::TStatO() {
    log = NULL;
    ttemp = 0;
    Filenamelog = "";
}

TStatO::~TStatO() {
    data.clear();
}

void TStatO::Init(TString FilenamelogA) {
    Filenamelog = FilenamelogA;
}

void TStatO::Lock() {
    m_Mutex.Acquire();
}

void TStatO::UnLock() {
    m_Mutex.Release();
}

void TStatO::AddAll(time_t t) {
    Lock();

    TStatODataIt it;
    TStatShap ss(t);
    time_t tt = ss.time();

    char bufft1[256], bufft2[256];

    memset(bufft1, 0, sizeof(bufft1));
    memset(bufft2, 0, sizeof(bufft2));
    char* s1 = ctime(&t);
    strncpy(bufft1, s1, sizeof(bufft1) - 1);
    char* s2 = ctime(&tt);
    strncpy(bufft2, s2, sizeof(bufft2) - 1);

    if (tt != ttemp)
        ttemp = tt;
    it = data.find(ss);
    if (it != data.end()) {
        (*it).second.reg_count++;
    } else {
        data[ss] = TStatData(1, 0, 0);
    }

    UnLock();
}

void TStatO::AddSpam(time_t t) {
    Lock();

    TStatODataIt it;
    TStatShap ss(t);

    it = data.find(ss);
    if (it != data.end()) {
        (*it).second.spam_count++;
    } else {
        data[ss] = TStatData(0, 1, 0);
    }

    UnLock();
}

void TStatO::AddError(time_t t) {
    Lock();

    TStatODataIt it;
    TStatShap ss(t);

    it = data.find(ss);
    if (it != data.end()) {
        (*it).second.error_count++;
    } else {
        data[ss] = TStatData(0, 0, 1);
    }

    UnLock();
}

bool TStatO::GetData(int yearA, int monA, int dayA, int hourA, time_t t) {
    bool res = false;

    if (Filenamelog.size() == 0)
        return res;

    Lock();

    log = fopen(Filenamelog.c_str(), "ab");
    if (log != NULL) {
        TStatDataSetS sdss;
        TStatODataIt it;
        TStatDataSetSIt its;
        char buff[512];
        int full_year;
        int full_mon;
        int full_day;
        int full_hour;
        tm tv;
        time_t tn = 0;
        ui32 allcount = 0, spamcount = 0, errorcount = 0;
        float proc = 0;
        bool first = true;
        time_t t1 = 0;

        it = data.begin();
        while (it != data.end()) {
            t1 = (*it).first.time();
            if ((*it).first.time() >= t)
                sdss.insert(TStatDataSet((*it).first.time(), (*it).second.reg_count, (*it).second.spam_count, (*it).second.error_count));
            ++it;
        }
        its = sdss.begin();
        while (its != sdss.end()) {
            if (first) {
                first = false;
                fprintf(log, "\n#year=%d\tmon=%02d\tday=%02d\thour=%02d\n", 1900 + yearA, monA + 1, dayA, hourA);
                fprintf(log, "#  data(0)\ttime(1)\tall(2)\tspam(3)\tdiv(4)\terror\n");
            }
            memset(buff, 0, sizeof(buff));

            tn = (*its).gettime();
            allcount = (*its).getallreg();
            spamcount = (*its).getspamreg();
            errorcount = (*its).geterrorreg();
            tv = *localtime(&tn);
            full_year = tv.tm_year;
            full_mon = tv.tm_mon;
            full_day = tv.tm_mday;
            full_hour = tv.tm_hour;
            if (allcount > 0)
                proc = (float)((float)spamcount / (float)allcount);
            else
                proc = 0;
            snprintf(buff, sizeof(buff) - 1, "%4d.%02d.%02d\t     %02d\t%6u\t%7u\t  %2.2f\t%5u\n", 1900 + full_year, full_mon + 1, full_day, full_hour, allcount, spamcount, proc, errorcount);
            fprintf(log, "%s", buff);
            res = true;
            ++its;
        }
        fflush(log);
        fclose(log);
    }
    UnLock();

    return res;
}

bool TStatO::GetDataI(int /*yearA*/, int /*monA*/, int /*dayA*/, int /*hourA*/, time_t t, TStatDataSetS& statlist) {
    bool res = false;

    Lock();

    TStatODataIt it;

    statlist.clear();

    it = data.begin();
    while (it != data.end()) {
        if ((*it).first.time() >= t)
            statlist.insert(TStatDataSet((*it).first.time(), (*it).second.reg_count, (*it).second.spam_count, (*it).second.error_count));
        ++it;
    }

    UnLock();

    return res;
}

TStatAvr TStatO::GetAverage(time_t t) {
    const int hist = 3; //������� ������� (�� 3 ������ �����)

    Lock();

    ui32 avr_all = 0, avr_spam = 0, avr_err = 0, avr_ham = 0;
    ui32 summ_all = 0, summ_spam = 0, summ_err = 0, summ_ham = 0;
    ui32 ham = 0;
    int n = 0;
    TStatODataIt it;
    int step = hist;
    time_t last_t[hist];

    for (int i = 0; i < step; i++) {
        last_t[i] = t - (i + 1) * 7 * 86400;
        it = data.find(TStatShap(last_t[i]));
        if (it != data.end()) {
            n++;
            ham = (*it).second.reg_count - (*it).second.spam_count - (*it).second.error_count;
            summ_all += (*it).second.reg_count;
            summ_spam += (*it).second.spam_count;
            summ_err += (*it).second.error_count;
            summ_ham += ham;
        }
    }
    if (n > 0) {
        avr_all = summ_all / n;
        avr_spam = summ_spam / n;
        avr_err = summ_err / n;
        avr_ham = summ_ham / n;
    }

    UnLock();

    return TStatAvr(avr_all, avr_spam, avr_err, avr_ham);
}

TStatAvr TStatO::GetNow(time_t t) {
    Lock();

    ui32 avr_all = 0, avr_spam = 0, avr_err = 0, avr_ham = 0;
    TStatODataIt it;
    ui32 ham = 0;
    tm tl;

    tl = *localtime(&t);
    if ((tl.tm_min == 59) && (tl.tm_sec > 0)) {
        it = data.find(TStatShap(t));
        if (it != data.end()) {
            ham = (*it).second.reg_count - (*it).second.spam_count - (*it).second.error_count;
            avr_all = (*it).second.reg_count;
            avr_spam = (*it).second.spam_count;
            avr_err = (*it).second.error_count;
            avr_ham = ham;
        }
    }

    UnLock();

    return TStatAvr(avr_all, avr_spam, avr_err, avr_ham);
}
