#include "tallowuser.h"

TAllowUser::TAllowUser()
{

}

TAllowUser::~TAllowUser()
{

}

void TAllowUser::Lock()
{
   m_Mutex.Acquire();
}

void TAllowUser::UnLock()
{
   m_Mutex.Release();
}

ui64 TAllowUser::CalcShingle(const TString &login)
{
   ui64     res   = 0;
   char     sshingle[32];
   TString   stemp = "";

   if (!login.empty())
   {
      stemp = Trim(login);
      to_lower_k(stemp);
      memset(sshingle, 0, sizeof(sshingle));
      calc_strcrc64(stemp.c_str(), stemp.size(), sshingle);
      sscanf(sshingle, "%lx", &res);
   }

   return res;
}

bool TAllowUser::ExistsLogin(const TString &login)
{
   bool                 res = false;
   ui64                 shingle = 0;
   TAllowUserDataHashIt it;
   time_t               current_time = time(NULL);
   TString               m_login = "";

   m_login = Trim(login);
   if (!m_login.empty())
   {
      to_lower_k(m_login);

      shingle = CalcShingle(m_login);
      if (shingle != 0)
      {
         Lock();

         it = data.find(shingle);
         if (it != data.end())
         {
            if ((*it).second.m_login == m_login)
            {
               if ( current_time <= ((*it).second.m_add_time + (*it).second.m_lifetime) )
               {
                  res = true;
               } else
               {
                  data.erase(it);
               }
            }
         }

         UnLock();
      }
   }

   return res;
}


void TAllowUser::AddLogin(const TString &login, ui32 lifetime)
{
   ui64                 shingle = 0;
   TAllowUserDataHashIt it;
   time_t               current_time = time(NULL);
   TString               m_login = "";

   m_login = Trim(login);
   if (!m_login.empty())
   {
      to_lower_k(m_login);

      shingle = CalcShingle(m_login);
      if (shingle != 0)
      {
         Lock();

         it = data.find(shingle);
         if (it != data.end())
         {
            if ((*it).second.m_login == m_login)
            {
               (*it).second.m_add_time = current_time;
               (*it).second.m_lifetime = lifetime;
            }

         } else
         {
           data[shingle] = TAllowUserData(m_login, lifetime, current_time);
         }

         UnLock();
      }
   }
}

bool TAllowUser::RemoveLogin(const TString &login)
{
   bool                 res = false;
   ui64                 shingle = 0;
   TAllowUserDataHashIt it;
   TString               m_login = "";

   m_login = Trim(login);
   if (!m_login.empty())
   {
      to_lower_k(m_login);

      shingle = CalcShingle(m_login);
      if (shingle != 0)
      {
         Lock();

         it = data.find(shingle);
         if (it != data.end())
         {
            data.erase(it);
            res = true;
         }

         UnLock();
      }
   }

   return res;
}

TAllowUserData TAllowUser::Get(const TString &login)
{
   TAllowUserData       res;
   ui64                 shingle      = 0;
   TAllowUserDataHashIt it;
   TString               m_login      = "";
   time_t               current_time = time(NULL);

   m_login = Trim(login);
   if (!m_login.empty())
   {
      to_lower_k(m_login);

      shingle = CalcShingle(m_login);
      if (shingle != 0)
      {
         Lock();

         it = data.find(shingle);
         if (it != data.end())
         {
            if ((*it).second.m_login == m_login)
            {
               if ( current_time <= ((*it).second.m_add_time + (*it).second.m_lifetime) )
               {
                  res = (*it).second;
               } else
               {
                  data.erase(it);
               }
            }
         }

         UnLock();
      }
   }


   return res;
}

void TAllowUser::Midnight()
{
   TAllowUserDataHashIt it;
   time_t               current_time = time(NULL);

   Lock();

   it = data.begin();
   while (it != data.end())  //������� �������� ���������, �.�. ��������������, ��� ������ ����� ���������
   {
      if ( current_time > ((*it).second.m_add_time + (*it).second.m_lifetime) )
      {
         data.erase(it++);
         continue;
      }

      ++it;
   }

   UnLock();

}

ui32 TAllowUser::Size()
{
   ui32 res = 0;

   Lock();

   res = data.size();

   UnLock();

   return res;
}
