#pragma once

#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>

struct TAllowUserData {
    ui32 m_lifetime{};   //lifetime in sec
    time_t m_add_time{}; //create time
    TString m_login;   //login

    Y_SAVELOAD_DEFINE(m_lifetime, m_add_time, m_login)

    TAllowUserData() {
        m_login = "";
        m_lifetime = 0;
    }

    TAllowUserData(const TString& login, ui32 lifetime, time_t add_time) {
        m_login = login;
        m_lifetime = lifetime;
        m_add_time = add_time;
    }

    [[nodiscard]] size_t size() const {
        size_t res = 0;

        res = sizeof(m_lifetime) + sizeof(m_add_time) + m_login.length();

        return res;
    }
};

typedef THashMap<ui64, TAllowUserData> TAllowUserDataHash;
typedef TAllowUserDataHash::iterator TAllowUserDataHashIt;

class TAllowUser {
private:
    static const ui32 MAXREADDUMPBUFFERU = 1000000;

private:
    TAllowUserDataHash data;
    TMutex m_Mutex;

    void Lock();
    void UnLock();
    ui64 CalcShingle(const TString& login);

public:
    Y_SAVELOAD_DEFINE(data)
    TAllowUser();
    ~TAllowUser();

    bool ExistsLogin(const TString& login);
    void AddLogin(const TString& login, ui32 lifetime);
    bool RemoveLogin(const TString& login);
    void Midnight();
    TAllowUserData Get(const TString& login);
    ui32 Size();
};
