#include <mail/so/spamstop/tools/so-common/color_scheme.h>
#include "tasynccheck.h"
#include "tgeneralobject.h"

//*******************************************************************************************************************************************
//                                              TAsyncCheckQueue
//*******************************************************************************************************************************************

TAsyncCheckQueue::TAsyncCheckQueue() {
    m_LogsGroup = NULL;
    m_queue_size = 1000;
}

TAsyncCheckQueue::~TAsyncCheckQueue() {
}

void TAsyncCheckQueue::Init(ui32 queue_sizeA, TLogsGroup* LogsGroup) {
    m_LogsGroup = LogsGroup;
    m_queue_size = queue_sizeA;
}

void TAsyncCheckQueue::Midnight() {
    m_Mutex.Acquire();

    m_stat.Midnight();

    m_Mutex.Release();
}

bool TAsyncCheckQueue::AddRecord(const TAsyncCheckStruct& record, const TString& source_request, TSpamonLogStruct& monlogdata) {
    bool res = false;
    ui32 tick = 0;

    tick = CShingleTime::GetMs();

    m_Mutex.Acquire();

    m_stat.m_today.m_input = IncMax32(m_stat.m_today.m_input, 1);
    if (m_data.size() < m_queue_size) {
        m_data.push_back(record);
        res = true;

        monlogdata.AddTag("FRODO", "QA", TSpamonLogStruct::OK, CShingleTime::GetMs() - tick);

    } else {
        m_stat.m_today.m_lost = IncMax32(m_stat.m_today.m_lost, 1);
        res = false;

        monlogdata.AddTag("FRODO", "QA", TSpamonLogStruct::LOST, CShingleTime::GetMs() - tick);
    }

    m_Mutex.Release();

    if ((!res) && (m_LogsGroup != NULL) && (m_LogsGroup->GetAsyncCheckLostLog(record.is_return_upstream_request) != NULL)) {
        ui32 tick_ltl = CShingleTime::GetMs();

        m_LogsGroup->GetAsyncCheckLostLog(record.is_return_upstream_request)->WriteMessageAndDataStatus(KERROR, "%s %s", record.Numbrequest.c_str(), source_request.c_str());

        monlogdata.AddTag("FRODO", "QWL", TSpamonLogStruct::OK, CShingleTime::GetMs() - tick_ltl);
    }

    return res;
}

bool TAsyncCheckQueue::GetRecord(TAsyncCheckStruct& data) {
    bool res = false;

    data.Clear();

    m_Mutex.Acquire();

    TAsyncCheckStructListIt it;

    it = m_data.begin();
    if (it != m_data.end()) {
        data = (*it);
        m_data.erase(it);
        m_stat.m_today.m_output = IncMax32(m_stat.m_today.m_output, 1);
        res = true;
    }

    m_Mutex.Release();

    return res;
}

TAsyncCheckQueueStat TAsyncCheckQueue::GetStat() {
    TAsyncCheckQueueStat res;

    m_Mutex.Acquire();

    m_stat.m_today.m_count = m_data.size();
    res = m_stat;

    m_Mutex.Release();

    return res;
}

//*******************************************************************************************************************************************
//                                                 TAsyncCheckStat
//*******************************************************************************************************************************************

TString TAsyncCheckStat::GetWebStat() {
    TString res = "";

    res += "<br>";
    res += "<b><i>Async mode (CHECK) statistic.</i></b>&nbsp;";
    res += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(color_table_default) + ">\n";

    res += "<tr align='center'><td width='25%'>&nbsp;</td><td width='38%'><b>TODAY</b></td><td width='37%'><b>YESTERDAY</b></td></tr>\n";

    res += "<tr align='right'><td align='left'>CHECK: ALL</td><td>" + IntToStroka(m_today.m_all_count) + "</td><td>" + IntToStroka(m_yesterday.m_all_count) + "</td></tr>\n";
    res += "<tr align='right'><td align='left'>CHECK: 200</td><td>" + IntToStroka(m_today.m_200_count) + "</td><td>" + IntToStroka(m_yesterday.m_200_count) + "</td></tr>\n";
    res += "<tr align='right'><td align='left'>CHECK: 400</td><td>" + IntToStroka(m_today.m_400_count) + "</td><td>" + IntToStroka(m_yesterday.m_400_count) + "</td></tr>\n";
    res += "<tr align='right'><td align='left'>CHECK: 500</td><td>" + IntToStroka(m_today.m_500_count) + "</td><td>" + IntToStroka(m_yesterday.m_500_count) + "</td></tr>\n";
    //res += "<tr><td colspan='3'>&nbsp;</td></tr>\n";
    res += "<tr align='right'><td align='left'>QUEUE: COUNT</td><td>" + IntToStroka(m_queue.m_today.m_count) + "</td><td>-</td></tr>\n";
    res += "<tr align='right'><td align='left'>QUEUE: INPUT</td><td>" + IntToStroka(m_queue.m_today.m_input) + "</td><td>" + IntToStroka(m_queue.m_yesterday.m_input) + "</td></tr>\n";
    res += "<tr align='right'><td align='left'>QUEUE: LOST</td><td>" + IntToStroka(m_queue.m_today.m_lost) + "</td><td>" + IntToStroka(m_queue.m_yesterday.m_lost) + "</td></tr>\n";
    res += "<tr align='right'><td align='left'>QUEUE: OUTPUT</td><td>" + IntToStroka(m_queue.m_today.m_output) + "</td><td>" + IntToStroka(m_queue.m_yesterday.m_output) + "</td></tr>\n";

    res += "</table>";

    return res;
}

//*******************************************************************************************************************************************
//                                                 TAsyncCheck
//*******************************************************************************************************************************************

void TACThreadProc(void* par) {
    TAsyncCheck* ss = (TAsyncCheck*)par;

    if (ss != NULL) {
        int threadnumber = ss->IncrementNumberThread();

        //printf("sth=%d\n", threadnumber);
        while (!ss->QueueThreadShouldStop()) {
            ss->ActionFunction(threadnumber);
        }

        ss->DecrementNumberThread();
    }
}

TAsyncCheck::TAsyncCheck() {
    m_generalobj = NULL;
    for (size_t i = 0; i < MAX_THREAD_WORK; i++)
        m_QueueThread[i] = NULL;
    use_threadcount = 0;
    run_scan_thread = false;
    m_StopQueueThread = false;
    m_thread_count = 1;
    m_queue_size = DEFAULT_QUEUE_SIZE;
}

TAsyncCheck::~TAsyncCheck() {
    if (run_scan_thread) {
        StopQueueThread();
        while (!QueueThreadStopped())
            usleep(5000);

        for (size_t i = 0; i < MAX_THREAD_WORK; i++) {
            if (m_QueueThread[i] != NULL) {
                delete m_QueueThread[i];
                m_QueueThread[i] = NULL;
            }
        }
    }
}

bool TAsyncCheck::InitBase(TLogsGroup* LogsGroup, ui32 thread_count, ui32 queue_size) {
    bool res = true;

    m_thread_count = thread_count;
    if (m_thread_count < 1)
        m_thread_count = 1;
    if (m_thread_count >= MAX_THREAD_WORK)
        m_thread_count = MAX_THREAD_WORK;

    if (queue_size == 0)
        m_queue_size = 10000;
    else if (queue_size > 5000000)
        m_queue_size = 5000000;
    else
        m_queue_size = queue_size;

    m_queue.Init(m_queue_size, LogsGroup);

    StartQueueThread();

    return res;
}

bool TAsyncCheck::Init(TGeneralObject* generalobjA, TKConfig* configobjA, TLogsGroup* LogsGroup) {
    bool res = false;
    ui32 thread_count = DEFAULT_THREAD_WORK;
    ui32 queue_size = DEFAULT_QUEUE_SIZE;
    bool use_async_check_mode = false;

    m_generalobj = generalobjA;

    if (configobjA != NULL) {
        use_async_check_mode = configobjA->ReadBool("async_check", "enable", false);
        thread_count = configobjA->ReadInteger("async_check", "thread_count", DEFAULT_THREAD_WORK);
        queue_size = configobjA->ReadInteger("async_check", "queue_max_size", DEFAULT_QUEUE_SIZE);
    }

    res = InitBase(LogsGroup, thread_count, queue_size);

    return res;
}

void TAsyncCheck::Midnight() {
    m_queue.Midnight();

    m_MutexStat.Acquire();

    m_stat.Midnight();

    m_MutexStat.Release();
}

void TAsyncCheck::StartQueueThread() {
    m_QueueMutex.Acquire();

    m_StopQueueThread = false;

    for (size_t i = 0; i < m_thread_count; i++) {
        m_QueueThread[i] = new TThread((TThread::TThreadProc)&TACThreadProc, this);
        m_QueueThread[i]->Start();
    }
    run_scan_thread = true;

    m_QueueMutex.Release();
}

int TAsyncCheck::IncrementNumberThread() {
    int res = 0;

    m_QueueMutex.Acquire();

    use_threadcount++;
    res = use_threadcount;

    m_QueueMutex.Release();

    return res;
}

void TAsyncCheck::DecrementNumberThread() {
    m_QueueMutex.Acquire();

    if (use_threadcount > 0)
        use_threadcount--;

    m_QueueMutex.Release();
}

void TAsyncCheck::StopQueueThread() {
    m_QueueMutex.Acquire();
    m_StopQueueThread = true;
    m_QueueMutex.Release();
}

bool TAsyncCheck::QueueThreadStopped() {
    bool res = false;

    if (use_threadcount == 0)
        res = true;

    return res;
}

void TAsyncCheck::ActionFunction(int /*threadnumber*/) {
    bool needstop = false;
    TAsyncCheckStruct data;
    TResStruct res_answ;

    if (m_generalobj != NULL) {
        if (m_queue.GetRecord(data)) {
            res_answ = m_generalobj->CheckAsyncDo(data);

            m_MutexStat.Acquire();

            m_stat.m_today.m_all_count = IncMax32(m_stat.m_today.m_all_count, 1);

            if (res_answ.m_code == 200)
                m_stat.m_today.m_200_count = IncMax32(m_stat.m_today.m_200_count, 1);
            else if (res_answ.m_code == 400)
                m_stat.m_today.m_400_count = IncMax32(m_stat.m_today.m_400_count, 1);
            else if (res_answ.m_code == 500)
                m_stat.m_today.m_500_count = IncMax32(m_stat.m_today.m_500_count, 1);

            m_MutexStat.Release();

        } else
            usleep(30000);
    }

    if (needstop)
        StopQueueThread();
}

bool TAsyncCheck::AddCheck(const TAsyncCheckStruct& record, const TString& source_request, TSpamonLogStruct& monlogdata) {
    bool res = false;

    res = m_queue.AddRecord(record, source_request, monlogdata);

    return res;
}

TString TAsyncCheck::GetWebStat() {
    TString res = "";
    TAsyncCheckStat stat;

    stat = m_stat;
    stat.m_queue = m_queue.GetStat();
    res = stat.GetWebStat();

    return res;
}

//*******************************************************************************************************************************************
