#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "util/system/thread.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/fcgiserver_base/sotypes.h>
#include "tlogsgroup.h"
#include "tspamonlog.h"

//*******************************************************************************************************************************************
//                                                 TAsyncCheckStruct
//*******************************************************************************************************************************************

struct TAsyncCheckStruct
{
   TReqParams        ReqParams;
   TString           Numbrequest;
   bool              is_obrab_upstream_request;
   bool              is_return_upstream_request;
   ui64              createtime;

   TAsyncCheckStruct()
   {
      Clear();
   }

   TAsyncCheckStruct(TReqParams* pReqParamsA, const TString &NumbrequestA, bool is_obrab_upstream_requestA, bool is_return_upstream_requestA, ui64 createtimeA)
   {
      Clear();

      TReqParams::iterator it;

      if (pReqParamsA != NULL)
      {
         it = pReqParamsA->begin();
         while (it != pReqParamsA->end())
         {
            ReqParams[(*it).first] = (*it).second;

            ++it;
         }

      }

      Numbrequest                = NumbrequestA;
      is_obrab_upstream_request  = is_obrab_upstream_requestA;
      is_return_upstream_request = is_return_upstream_requestA;
      createtime                 = createtimeA;
   }

   void Clear()
   {
      ReqParams.clear();
      Numbrequest                = "";
      is_obrab_upstream_request  = false;
      is_return_upstream_request = false;
      createtime                 = 0;
   }
};

typedef std::list<TAsyncCheckStruct>    TAsyncCheckStructList;
typedef TAsyncCheckStructList::iterator TAsyncCheckStructListIt;

//*******************************************************************************************************************************************
//                                              TAsyncCheckQueue
//*******************************************************************************************************************************************

struct TAsyncCheckQueueStatItem
{
   ui32 m_input;
   ui32 m_lost;
   ui32 m_count;
   ui32 m_output;

   TAsyncCheckQueueStatItem()
   {
      Clear();
   }

   void Clear()
   {
      m_input  = 0;
      m_lost   = 0;
      m_count  = 0;
      m_output = 0;
   }

};

struct TAsyncCheckQueueStat
{
   TAsyncCheckQueueStatItem m_today;
   TAsyncCheckQueueStatItem m_yesterday;

   TAsyncCheckQueueStat()
   {
      Clear();
   }

   void Clear()
   {
      m_today.Clear();
      m_yesterday.Clear();
   }

   void Midnight()
   {
      m_yesterday = m_today;
      m_today.Clear();

   }
};

class TAsyncCheckQueue
{
private:
         TLogsGroup            *m_LogsGroup;
         TAsyncCheckStructList m_data;
         ui32                  m_queue_size;
         TMutex                m_Mutex;
         TAsyncCheckQueueStat  m_stat;
public:
         TAsyncCheckQueue();
         ~TAsyncCheckQueue();

         void Init(ui32 queue_sizeA, TLogsGroup *LogsGroup);
         void Midnight();

         bool AddRecord(const TAsyncCheckStruct &record, const TString &source_request, TSpamonLogStruct &monlogdata);
         bool GetRecord(TAsyncCheckStruct &data);

         TAsyncCheckQueueStat GetStat();

};

//*******************************************************************************************************************************************
//                                                 TAsyncCheckStat
//*******************************************************************************************************************************************

struct TAsyncCheckStatItem
{
   ui32                 m_all_count;
   ui32                 m_200_count;
   ui32                 m_400_count;
   ui32                 m_500_count;

   TAsyncCheckStatItem()
   {
      Clear();
   }

   void Clear()
   {
      m_all_count = 0;
      m_200_count = 0;
      m_400_count = 0;
      m_500_count = 0;
   }
};

struct TAsyncCheckStat
{
   TAsyncCheckStatItem  m_today;
   TAsyncCheckStatItem  m_yesterday;
   TAsyncCheckQueueStat m_queue;

   TAsyncCheckStat()
   {
      Clear();
   }

   void Clear()
   {
      m_today.Clear();
      m_yesterday.Clear();
      m_queue.Clear();
   }

   void Midnight()
   {
      m_yesterday = m_today;
      m_today.Clear();

   }

   TString GetWebStat();
};

//*******************************************************************************************************************************************
//                                                 TAsyncCheck
//*******************************************************************************************************************************************

class TGeneralObject;

class TAsyncCheck
{
public:
         static const ui32    MAX_THREAD_WORK          = 256;
         static const ui32    DEFAULT_THREAD_WORK      = 128;
         static const ui32    DEFAULT_QUEUE_SIZE       = 100000;
private:
         TGeneralObject       *m_generalobj;
         TAsyncCheckQueue     m_queue;
         ui32                 m_queue_size;
         TAsyncCheckStat      m_stat;
         TMutex               m_MutexStat;
private:
         TThread              *m_QueueThread[MAX_THREAD_WORK];
         TMutex               m_QueueMutex;
         bool                 m_StopQueueThread;
         bool                 run_scan_thread;
         ui32                 m_thread_count;

         int                  use_threadcount;
         void                 StartQueueThread();
         bool                 QueueThreadStopped();

public:
         ui32                 GetThreadCount(){ return m_thread_count; }
         void                 StopQueueThread();
         int                  IncrementNumberThread();
         void                 DecrementNumberThread();
         bool                 QueueThreadShouldStop(){ return m_StopQueueThread; }
         void                 ActionFunction(int threadnumber);
         bool                 InitBase(TLogsGroup *LogsGroup, ui32 thread_count, ui32 queue_size);

public:
         TAsyncCheck();
         ~TAsyncCheck();

         bool                  Init(TGeneralObject *generalobjA, TKConfig *configobjA, TLogsGroup *LogsGroup);
         void                  Midnight();

         bool                  AddCheck(const TAsyncCheckStruct &record, const TString &source_request, TSpamonLogStruct &monlogdata);
         TString                GetWebStat();

};

//*******************************************************************************************************************************************


