#include "tclustclt.h"

//****************************************************************************************************************************************
//                                                    TClustDataRes
//****************************************************************************************************************************************

TString TClustDataRes::toDeliveryLog()
{
   TString res = "-";

   if (m_err != poolhttpcl::KNONEERROR)
   {
      res = poolhttpcl::TReqErrorToTString(m_err);
      if (m_err == poolhttpcl::KREQUESTANSWERERROR)
         res += " (" + IntToStroka(m_err_code) + ")";


   } else
   {
      if (m_exists_data)
         res = "N=" + UI64ToStroka(m_cluster_number) + ", d=" + FloatToStr(m_cluster_distance) + ", rmax=" + FloatToStr(m_cluster_radius_max) + ", rmin=" + FloatToStr(m_cluster_radius_min) + ", %spam=" + FloatToStr(m_cluster_spam_percent);
      else
         res = "empty";

   }

   return res;
}

//****************************************************************************************************************************************
//                                                    TClustData
//****************************************************************************************************************************************

TClustData::TClustData()
{


}

TClustData::~TClustData()
{


}

TClustDataRes TClustData::ReturnData()
{
   TClustDataRes res;
   TString        ident = "\r\n\r\n";
   const char    *p    = NULL;

   if (!m_res_empty)
   {
      p = strstr(m_res_answer_from_server.c_str(), ident.c_str());
      if (p != NULL)
         m_res_answer_from_server = TString(p + ident.length());

      if (Trim(m_res_answer_from_server) == "-")
      {
         res.m_exists_data = false;
         res.m_err         = poolhttpcl::KNONEERROR;
         res.m_err_code    = 0;

      } else
      {
         TStringInput ss(m_res_answer_from_server);
         try
         {
            ss >> res.m_cluster_number;
            ss >> res.m_cluster_distance;
            ss >> res.m_cluster_radius_max;
            ss >> res.m_cluster_radius_min;
            ss >> res.m_cluster_spam_percent;

            res.m_exists_data = true;

         } catch(...)
         {
            res.m_exists_data = false;
            res.m_err         = poolhttpcl::KREQUESTANSWERERROR;
            res.m_err_code    = 123;
         }
      }

   } else
   {
      res.m_exists_data = false;
      res.m_err         = m_res_error;
      res.m_err_code    = m_res_code;

   }

   return res;
}

//****************************************************************************************************************************************
