#pragma once

#include <mail/so/spamstop/tools/so-common/tpoolhttpclients.h>
#include <util/stream/str.h>

//****************************************************************************************************************************************
//                                                    TClustDataRes
//****************************************************************************************************************************************

struct TClustDataRes
{
   bool                    m_exists_data{};
   poolhttpcl::TReqError   m_err = poolhttpcl::KNONEERROR;
   ui32                    m_err_code{};
   ui64                    m_cluster_number{};
   float                   m_cluster_distance{};
   float                   m_cluster_radius_max{};
   float                   m_cluster_radius_min{};
   float                   m_cluster_spam_percent{};

   TClustDataRes() = default;

   TClustDataRes(ui64 cluster_number, float cluster_distance, float cluster_radius_max, float cluster_radius_min, float cluster_spam_percent)
   {
      m_exists_data      = true;
      m_cluster_number   = cluster_number;
      m_cluster_distance = cluster_distance;
      m_cluster_radius_max = cluster_radius_max;
      m_cluster_radius_min = cluster_radius_min;
      m_cluster_spam_percent = cluster_spam_percent;
   }

   TString toDeliveryLog();

   TString cluster_number_s()       const { return IntToStroka(m_cluster_number);      }
   TString cluster_distance_s()     const { return FloatToStr(m_cluster_distance);     }
   TString cluster_radius_max_s()   const { return FloatToStr(m_cluster_radius_max);   }
   TString cluster_radius_min_s()   const { return FloatToStr(m_cluster_radius_min);   }
   TString cluster_spam_percent_s() const { return FloatToStr(m_cluster_spam_percent); }
};

//****************************************************************************************************************************************
//                                                    TClustData
//****************************************************************************************************************************************

class TClustData: public poolhttpcl::THttpBase
{
private:

public:
         TClustData();
         ~TClustData();

         TClustDataRes ReturnData();
};

//****************************************************************************************************************************************
