#include "tconsolestat.h"

TString PrintServersStatistik(TConsoleStatDataList &servers_stats)
{
   TString text         = "";
   const char   *table_color = "'#ffffcc'";
   const char   *rps_color   = "'#FFFDAB'";
   int    width_title  = 25;
   int    width_item   = 0;
   ui32   current_time = time(NULL);
   ui32   tdiff        = 0;
   TString lost_color   = "";

   if (servers_stats.size() > 0)
   {
      width_item = (100 - width_title) / servers_stats.size();
      text += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";

      text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title) + "%' colspan='2'>&nbsp;</td>";
      for (size_t i = 0; i < servers_stats.size(); i++)
      {
         tdiff = current_time - servers_stats[i].m_lastdate;
         if (tdiff <= 60)
            text += "<td width='" + IntToStroka(width_item) + "%'>" + TString(servers_stats[i].m_servercode) + " (" + GetTimePeriod(tdiff) + ")</td>";
         else
            text += "<td width='" + IntToStroka(width_item) + "%' bgcolor='clRed'>" + TString(servers_stats[i].m_servercode) + " (" + GetTimePeriod(tdiff) + ")</td>";
      }
      text += "</tr>";

      text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title) + "%' colspan='2'>Host name</td>";
      for (size_t i = 0; i < servers_stats.size(); i++)
         text += "<td width='" + IntToStroka(width_item) + "%'>" + TString(servers_stats[i].m_serverhostname) + " &nbsp;</td>";
      text += "</tr>";

      text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title) + "%' colspan='2'>Version</td>";
      for (size_t i = 0; i < servers_stats.size(); i++)
         text += "<td width='" + IntToStroka(width_item) + "%'>" + TString(servers_stats[i].m_serverversion) + " &nbsp;</td>";
      text += "</tr>";

      text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title) + "%' colspan='2'>Start time</td>";
      for (size_t i = 0; i < servers_stats.size(); i++)
         text += "<td width='" + IntToStroka(width_item) + "%'>" + TString(servers_stats[i].m_serverstarttime) + " &nbsp;</td>";
      text += "</tr>";

      text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title) + "%' colspan='2'>Rate status (upstream / minor; '+' last upstream, '-' last minor; mode)</td>";
      for (size_t i = 0; i < servers_stats.size(); i++)
         text += "<td width='" + IntToStroka(width_item) + "%'>" + TString(servers_stats[i].m_rate_mode) + " &nbsp;</td>";
      text += "</tr>";

      for (size_t index = 0; index < 3; index++)
      {
         text += "<tr valign='top'><td valign='left' width='10%' rowspan='7'>" + TConsoleStatData::Name(index) + "</td><td valign='left' width='" + IntToStroka(width_title - 10) + "%'>RPS</td>";
         for (size_t i = 0; i < servers_stats.size(); i++)
            text += "<td width='" + IntToStroka(width_item) + "%' bgcolor=" + TString(rps_color) + ">" + TString(servers_stats[i].m_data[index].m_cps) + " &nbsp;</td>";
         text += "</tr>";
         text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title - 10) + "%'>Today request</td>";
         for (size_t i = 0; i < servers_stats.size(); i++)
            text += "<td width='" + IntToStroka(width_item) + "%'>" + UI64ToStroka(servers_stats[i].m_data[index].m_today_rqst) + " &nbsp;</td>";
         text += "</tr>";
         text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title - 10) + "%'>Today SKEEP (by LIMIT)</td>";
         for (size_t i = 0; i < servers_stats.size(); i++)
            text += "<td width='" + IntToStroka(width_item) + "%'>" + servers_stats[i].m_data[index].GetTodayLostStat() + " &nbsp;</td>";
         text += "</tr>";
         text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title - 10) + "%'>Yesterday request</td>";
         for (size_t i = 0; i < servers_stats.size(); i++)
            text += "<td width='" + IntToStroka(width_item) + "%'>" + UI64ToStroka(servers_stats[i].m_data[index].m_yesterday_rqst) + " &nbsp;</td>";
         text += "</tr>";
         text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title - 10) + "%'>Yesterday SKEEP (by LIMIT)</td>";
         for (size_t i = 0; i < servers_stats.size(); i++)
            text += "<td width='" + IntToStroka(width_item) + "%'>" + servers_stats[i].m_data[index].GetYesterdayLostStat() + " &nbsp;</td>";
         text += "</tr>";
         text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title - 10) + "%'>Today putqueue (count/lost)</td>";
         for (size_t i = 0; i < servers_stats.size(); i++)
         {
            if (servers_stats[i].m_data[index].m_today_putqueue_lost > 0)
               lost_color = "bgcolor='red'";
            else
               lost_color = "";
            text += "<td width='" + IntToStroka(width_item) + "%' " + lost_color + ">" + UI64ToStroka(servers_stats[i].m_data[index].m_today_putqueue_count) + " / " + UI64ToStroka(servers_stats[i].m_data[index].m_today_putqueue_lost) + " &nbsp;</td>";
         }
         text += "</tr>";
         text += "<tr valign='top'><td valign='left' width='" + IntToStroka(width_title - 10) + "%'>Yest. putqueue (count/lost)</td>";
         for (size_t i = 0; i < servers_stats.size(); i++)
         {
            if (servers_stats[i].m_data[index].m_yesterday_putqueue_lost > 0)
               lost_color = "bgcolor='red'";
            else
               lost_color = "";
            text += "<td width='" + IntToStroka(width_item) + "%' " + lost_color + ">" + UI64ToStroka(servers_stats[i].m_data[index].m_yesterday_putqueue_count) + " / " + UI64ToStroka(servers_stats[i].m_data[index].m_yesterday_putqueue_lost) + " &nbsp;</td>";
         }
         text += "</tr>";
      }

      text += "</table>";
   }

   return text;
}
