#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "util/string/util.h"
#include "util/system/rwlock.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/system/env.h"
#include <util/generic/map.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>

#include <mail/so/spamstop/tools/so-common/eventhandler.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>

#include "tstoragenosql.h"
#include "loggerhandler.h"
#include "tconsolestat.h"
#include "tstoragetypes.h"

//*********************************************************************************************************************************
//                                                       TDataBasaHash
//*********************************************************************************************************************************

typedef THashMap<ui64, frodo_st::TStorageDataItem> THashLongIP;
typedef THashLongIP::iterator THashLongIPIt;

class TDataBasaHash : public TStorageNoSql {
private:
    THashLongIP m_data;
    TRWMutex m_Mutex;

    void Save(IOutputStream* s) const override {
        TReadGuard g(m_Mutex);
        ::Save(s, m_data);
    }

    void Load(IInputStream* s) override {
        TWriteGuard g(m_Mutex);
        ::Load(s, m_data);
    }
private:
    bool StorageUpdate(ui64 shingle, int type, TShingleStorageType sstype, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err) override;
    bool StorageFindOne(ui64 shingle, int type, TShingleStorageType sstype, nosql::HashMap& hash, bool& err) override;
    bool StorageFind(TShingleStorageType sstype, TVector<nosql::HashMap>& hashes, bool& err) override;
    bool StorageErase(ui64 shingle, int type, TShingleStorageType sstype, bool& err) override;
    i64 StorageSize(int type, TShingleStorageType sstype, bool& err) override;
    void StorageMultiAction(TStorageActionList& actlist, bool& err) override;

    TString ReturnDriverProp() override;

    bool CheckConnection(TString& status);
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatMaster() override;
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatReplica() override;

public:
    TDataBasaHash();
    ~TDataBasaHash() override;

    bool InitBeforeFork(const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA) override;
    bool InitBeforeForkNum(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA) override;
    void InitAfterFork() override;

private:
};
