#pragma once

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "util/string/util.h"
#include "util/system/rwlock.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/system/env.h"
#include <util/generic/map.h>
#include <util/generic/vector.h>

#include <mail/so/spamstop/tools/so-common/eventhandler.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/postgreclient/interface.h>
#include <mail/so/spamstop/tools/postgreclient/pq/Error.h>

#include "tstoragenosql.h"
#include "loggerhandler.h"
#include "tconsolestat.h"
#include "tstoragetypes.h"

//*********************************************************************************************************************************
//                                                       TDataBasaPostgre
//*********************************************************************************************************************************

#define ASYNC_MODE true
//#define ASYNC_MODE false

struct TBulkReadData {
    TMap<ui64, nosql::HashMap*> m_bulk_read_hash;
    TMap<ui64, bool*> m_bulk_read_error;
    TShingleStorageType m_sstype = SST_LONGSTAT;
    bool m_err{};

    TBulkReadData() = default;

    TBulkReadData(TShingleStorageType sstype, ui64 shingle, nosql::HashMap* data, bool* errp) {
        m_sstype = sstype;
        m_bulk_read_hash[shingle] = data;
        m_bulk_read_error[shingle] = errp;
    }

    void SetErrors() {
        TMap<ui64, bool*>::iterator it;

        it = m_bulk_read_error.begin();
        while (it != m_bulk_read_error.end()) {
            if ((*it).second != NULL)
                (*((*it).second)) = m_err;

            ++it;
        }
    }
};

typedef std::list<TBulkReadData> TBulkReadDataList;
typedef TBulkReadDataList::iterator TBulkReadDataListIt;

class TDataBasaPostgre : public TStorageNoSql {
private:
    class StorageLogger;
    static TAtomic inited;

    TString m_host;
    TString m_user;
    bool m_pwd_define;
    size_t m_port;
    static bool skipResponsesToBD;
    ui32 m_pool_item_size_master;
    ui32 m_wait_pool_item_ms_master;
    ui32 m_pool_item_size_replica;
    ui32 m_wait_pool_item_ms_replica;
    ui32 m_rcv_timeout_ms;
    ui32 m_allow_full_time;
    TString m_conn_string;
    TString m_conn_string_hidden;

    typedef enum { RT_REPLICA,
                   RT_MASTER } TRequestType;

private:
    bool StorageUpdate(ui64 shingle, int type, TShingleStorageType sstype, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err) override;
    bool StorageFindOne(ui64 shingle, int type, TShingleStorageType sstype, nosql::HashMap& hash, bool& err) override;
    bool StorageFind(TShingleStorageType sstype, TVector<nosql::HashMap>& hashes, bool& err) override;
    bool StorageErase(ui64 shingle, int type, TShingleStorageType sstype, bool& err) override;
    i64 StorageSize(int type, TShingleStorageType sstype, bool& err) override;
    void StorageMultiAction(TStorageActionList& actlist, bool& err) override;

    TString ReturnDriverProp() override;

    bool CheckConnection(TString& status);
    void prepareTables();
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatMaster() override;
    qustat::TDriverRqstPoolStat ReturnLiveRqstStatReplica() override;

    TString CorrectInitPassword(const TString& init_str);

public:
    TDataBasaPostgre();
    ~TDataBasaPostgre() override;

    bool InitBeforeFork(const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA) override;
    bool InitBeforeForkNum(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA) override;
    void InitAfterFork() override;

    void Save(Y_DECLARE_UNUSED IOutputStream* s) const override {}
    void Load(Y_DECLARE_UNUSED IInputStream* s) override {}

private:
    TMap<TString, sql::table_t> tables;
};

//*********************************************************************************************************************************
