#include "tdelaysquantile.h"

//********************************************************************************************************************************
//                                                    TDelaysQuantileClass
//********************************************************************************************************************************

TDelaysQuantileItem::TDelaysQuantileItem()
{
   data_today.Clear();
   data_yesterday.Clear();
}

TDelaysQuantileItem::TDelaysQuantileItem(ui32 delay, bool add50, bool add100, bool add150, bool add190)
{
   data_today.Clear();
   data_yesterday.Clear();
   Increment(delay, add50, add100, add150, add190);
}

TDelaysQuantileItem::~TDelaysQuantileItem()
{

}

void TDelaysQuantileItem::Lock()
{
   //m_Mutex.Acquire();
}

void TDelaysQuantileItem::UnLock()
{
   //m_Mutex.Release();

}

void TDelaysQuantileItem::Increment(ui32 delay, bool add50, bool add100, bool add150, bool add190)
{
   Lock();

   if (delay < 10)
      data_today.m_0_10 = IncMax32(data_today.m_0_10, 1);
   else if (delay < 20)
      data_today.m_10_20 = IncMax32(data_today.m_10_20, 1);
   else if (delay < 30)
      data_today.m_20_30 = IncMax32(data_today.m_20_30, 1);
   else if (delay < 50)
      data_today.m_30_50 = IncMax32(data_today.m_30_50, 1);
   else if (delay < 100)
      data_today.m_50_100 = IncMax32(data_today.m_50_100, 1);
   else if (delay < 150)
      data_today.m_100_150 = IncMax32(data_today.m_100_150, 1);
   else if (delay < 190)
      data_today.m_150_190 = IncMax32(data_today.m_150_190, 1);
   else if (delay < 500)
      data_today.m_190_500 = IncMax32(data_today.m_190_500, 1);
   else
      data_today.m_more500 = IncMax32(data_today.m_more500, 1);

   if (add50)
   {
      data_today.summ_tick_50 = IncMax64(data_today.summ_tick_50, delay);
      data_today.count_tick_50 = IncMax64(data_today.count_tick_50, 1);
   }

   if (add100)
   {
      data_today.summ_tick_100 = IncMax64(data_today.summ_tick_100, delay);
      data_today.count_tick_100 = IncMax64(data_today.count_tick_100, 1);
   }

   if (add150)
   {
      data_today.summ_tick_150 = IncMax64(data_today.summ_tick_150, delay);
      data_today.count_tick_150 = IncMax64(data_today.count_tick_150, 1);
   }

   if (add190)
   {
      data_today.summ_tick_190 = IncMax64(data_today.summ_tick_190, delay);
      data_today.count_tick_190 = IncMax64(data_today.count_tick_190, 1);
   }

   UnLock();
}

TDelaysQuantileItemStat TDelaysQuantileItem::GetDiff()
{
   TDelaysQuantileItemStat res;

   Lock();

   res = data_today;
   data_today.Clear();

   UnLock();

   return res;
}

TDelaysQuantileItemStat TDelaysQuantileItem::GetToday()
{
   return data_today;
}

TDelaysQuantileItemStat TDelaysQuantileItem::GetYesterday()
{
   return data_yesterday;
}

void TDelaysQuantileItem::Midnight()
{
   Lock();

   data_yesterday = data_today;
   data_today.Clear();

   UnLock();
}

TDelaysQuantileClass::TDelaysQuantileClass()
{


}

TDelaysQuantileClass::~TDelaysQuantileClass()
{


}

void TDelaysQuantileClass::Lock()
{
   m_Mutex.Acquire();
}

void TDelaysQuantileClass::UnLock()
{
   m_Mutex.Release();

}

void TDelaysQuantileClass::Increment(ui32 all_tick, TSrvcDelayItemList &idlist)
{
   TDelaysQuantileItemHashIt     it;
   TSrvcDelayItemListIt lit;
   bool                 add50  = false;
   bool                 add100 = false;
   bool                 add150 = false;
   bool                 add190 = false;

   Lock();

   if ( (all_tick >= 50) && (all_tick < 100) )
      add50 = true;
   else if ( (all_tick >= 100) && (all_tick < 150) )
      add100 = true;
   else if ( (all_tick >= 150) && (all_tick < 190) )
      add150 = true;
   else if (all_tick >= 190)
      add190 = true;

   lit = idlist.begin();
   while (lit != idlist.end())
   {

      it = delay_list.find((*lit).ident);
      if (it != delay_list.end())
      {
         (*it).second.Increment((*lit).tick, add50, add100, add150, add190);

      } else
      {
         //delay_list[ident] = TDelaysQuantileItem(delay);
         delay_list.insert(TDelaysQuantileItemHash::value_type((*lit).ident, TDelaysQuantileItem((*lit).tick, add50, add100, add150, add190)));

      }

      ++lit;
   }

   UnLock();
}

void TDelaysQuantileClass::Increment(ui32 all_tick, const TString &ident, ui32 delay)
{
   TDelaysQuantileItemHashIt it;
   bool             add50  = false;
   bool             add100 = false;
   bool             add150 = false;
   bool             add190 = false;

   Lock();

   if ( (all_tick >= 50) && (all_tick < 100) )
      add50 = true;
   else if ( (all_tick >= 100) && (all_tick < 150) )
      add100 = true;
   else if ( (all_tick >= 150) && (all_tick < 190) )
      add150 = true;
   else if (all_tick >= 190)
      add190 = true;

   it = delay_list.find(ident);
   if (it != delay_list.end())
   {
      (*it).second.Increment(delay, add50, add100, add150, add190);

   } else
   {
      //delay_list[ident] = TDelaysQuantileItem(delay);
      delay_list.insert(TDelaysQuantileItemHash::value_type(ident, TDelaysQuantileItem(delay, add50, add100, add150, add190)));

   }

   UnLock();
}


void TDelaysQuantileClass::Midnight()
{
   TDelaysQuantileItemHashIt it;

   Lock();

   it = delay_list.begin();
   while (it != delay_list.end())
   {
      (*it).second.Midnight();

      ++it;
   }

   UnLock();
}
