#pragma once

#include "util/generic/hash.h"
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>

//********************************************************************************************************************************
//                                                    TDelaysQuantileClass
//********************************************************************************************************************************

struct TDelaysQuantileItemStat
{
   ui32 m_0_10{};      //0 - 10 ms
   ui32 m_10_20{};     //10 - 20 ms
   ui32 m_20_30{};     //20 - 30 ms
   ui32 m_30_50{};     //30 - 50 ms
   ui32 m_50_100{};    //50 - 100 ms
   ui32 m_100_150{};   //100 - 150 ms
   ui32 m_150_190{};   //150 - 190 ms
   ui32 m_190_500{};   //190 - 500 ms
   ui32 m_more500{};   //more 500 ms

   ui64 summ_tick_50{};  //50 ms <= tick <100 vs (summa)
   ui64 count_tick_50{}; //50 ms <= tick <100 vs (count request)
   ui64 summ_tick_100{};  //100 ms <= tick <150 vs (summa)
   ui64 count_tick_100{}; //100 ms <= tick <150 vs (count request)
   ui64 summ_tick_150{};  //150 ms <= tick <190 vs (summa)
   ui64 count_tick_150{}; //150 ms <= tick <190 vs (count request)
   ui64 summ_tick_190{};  //190 ms <= tick (summa)
   ui64 count_tick_190{}; //190 ms <= tick (count request)

   TDelaysQuantileItemStat()
   {
      Clear();
   }

   void Clear()
   {
      m_0_10         = 0;
      m_10_20        = 0;
      m_20_30        = 0;
      m_30_50        = 0;
      m_50_100       = 0;
      m_100_150      = 0;
      m_150_190      = 0;
      m_190_500      = 0;
      m_more500      = 0;

      summ_tick_50   = 0;
      count_tick_50  = 0;
      summ_tick_100  = 0;
      count_tick_100 = 0;
      summ_tick_150  = 0;
      count_tick_150 = 0;
      summ_tick_190  = 0;
      count_tick_190 = 0;
   }

   TString toLog()
   {
      TString res = "";
      char   buff[256];

      memset(buff, 0, sizeof(buff));
      snprintf(buff, sizeof(buff), "%u-%u-%u-%u-%u-%u-%u-%u-%u", m_0_10, m_10_20, m_20_30, m_30_50, m_50_100, m_100_150, m_150_190, m_190_500, m_more500);
      res = TString(buff);

      return res;
   }
};

class TDelaysQuantileItem
{
private:
         TDelaysQuantileItemStat data_today;
         TDelaysQuantileItemStat data_yesterday;
         //TMutex                  m_Mutex;

         void             Lock();
         void             UnLock();
public:
         TDelaysQuantileItem();
         TDelaysQuantileItem(ui32 delay, bool add50, bool add100, bool add150, bool add190);
         ~TDelaysQuantileItem();

         void                    Increment(ui32 delay, bool add50, bool add100, bool add150, bool add190);
         TDelaysQuantileItemStat GetDiff();
         TDelaysQuantileItemStat GetToday();
         TDelaysQuantileItemStat GetYesterday();
         void                    Midnight();

};

typedef THashMap<TString, TDelaysQuantileItem> TDelaysQuantileItemHash;
typedef TDelaysQuantileItemHash::iterator  TDelaysQuantileItemHashIt;

struct TSrvcDelayItem
{
   TString ident;
   ui32   tick{};

   TSrvcDelayItem()
   {
      Clear();
   }

   TSrvcDelayItem(const TString &identA, ui32 tickA)
   {
      ident = identA;
      tick  = tickA;
   }

   void Clear()
   {
      ident = "";
      tick  = 0;
   }
};

typedef std::list<TSrvcDelayItem>    TSrvcDelayItemList;
typedef TSrvcDelayItemList::iterator TSrvcDelayItemListIt;

class TDelaysQuantileClass
{
private:
         TDelaysQuantileItemHash delay_list;
         TMutex                  m_Mutex;

         void                    Lock();
         void                    UnLock();

public:
         TDelaysQuantileClass();
         ~TDelaysQuantileClass();

         void             Increment(ui32 all_tick, const TString &ident, ui32 delay);
         void             Increment(ui32 all_tick, TSrvcDelayItemList &idlist);
         void             Midnight();
};

//********************************************************************************************************************************

