#include "tfrodotypes.h"

TString TPassportRequestTypeToTString(TPassportRequestType type, const TString &action_source)
{
   TString res = "";

   switch (type)
   {
    case TP_LIGHTREGISTER:
                                    res = "LIGHTREGISTER";
                                    break;
    case TP_REGONE:
                                    res = "REGONE";
                                    break;
    case TP_REGISTER:
                                    res = "REGISTER";
                                    break;
    case TP_ADMSOCIALREG:
                                    res = "ADMSOCIALREG";
                                    break;
    case TP_ADMIMPORTREG:
                                    res = "ADMIMPORTREG";
                                    break;
    case TP_ADMREG:
                                    res = "ADMREG";
                                    break;
    case TP_CHANGEPASS_BASE:
                                    res = "CHANGEPASS";
                                    break;
    case TP_CHANGE_PASSWORD_FORCE:
                                    res = "CHANGE_PASSWORD_FORCE";
                                    break;
    case TP_CHANGE_PASSWORD_STRONG:
                                    res = "CHANGE_PASSWORD_STRONG";
                                    break;
    case TP_CHANGE_PASSWORD_VOLUNTARILY:
                                    res = "CHANGE_PASSWORD_VOLUNTARILY";
                                    break;
    case TP_CHANGE_PASSWORD:
                                    res = "CHANGE_PASSWORD";
                                    break;
    case TP_SIMPLEREG:
                                    res = "SIMPLEREG";
                                    break;
    case TP_POSTREGISTRATION:
                                    res = "POSTREGISTRATION";
                                    break;
    case TP_PHONEREG:
                                    res = "PHONEREG";
                                    break;
    case TP_ALTERNATIVEPHONE:
                                    res = "ALTERNATIVEPHONE";
                                    break;
    case TP_ALTERNATIVEHINT:
                                    res = "ALTERNATIVEHINT";
                                    break;
    case TP_UNCOMPLEATESETPASWD:
                                    res = "UNCOMPLEATESETPASWD";
                                    break;
    case TP_REQTYPE_COMPLETE:
                                    res = "REQTYPE_COMPLETE";
                                    break;
    case TP_COMPLEATE_PDD:
                                    res = "COMPLEATE_PDD";
                                    break;
    case TP_DIRECTORYREG:
                                    res = "DIRECTORYREG";
                                    break;
    case TP_CHANGE_FLUSHED_PASSWORD:
                                    res = "CHANGE_FLUSHED_PASSWORD";
                                    break;
    case TP_KINOPOISK_REG:
                                    res = "KINOPOISK_REG";
                                    break;
    default:
                                    res = action_source + "(UNKNOWN)";
   };

   return res;
}

bool IsChangePass(TPassportRequestType type)
{
   bool res = false;

   if ( (type == TP_CHANGEPASS_BASE)               ||
        (type == TP_CHANGE_PASSWORD_FORCE)         ||
        (type == TP_CHANGE_PASSWORD_STRONG)        ||
        (type == TP_CHANGE_PASSWORD_VOLUNTARILY)   ||
        (type == TP_CHANGE_PASSWORD)               ||
        (type == TP_CHANGE_FLUSHED_PASSWORD)
      )
      res = true;

   return res;
}

TKIPv6 TStringToTKIPv6(const TString &text)
{
   TKIPv6 res     = TKIPv6();
   ui64   shingle = 0;

   if (!text.empty())
   {
      shingle = ShingleFromStroka(text);
      if (shingle != 0)
         res = TKIPv6(0, shingle);

   }

   return res;
}

namespace frodo_st
{
   TString TStorageDataTypeToTString(TStorageDataType type)
   {
      TString res = "";

      switch (type)
      {
      case SDT_IPADDRESS:
                           res = "IPADDRESS";
                           break;
      case SDT_INAME:
                           res = "INAME";
                           break;
      case SDT_FNAME:
                           res = "FNAME";
                           break;
      case SDT_IFNAME:
                           res = "IFNAME";
                           break;
      case SDT_PHONE:
                           res = "PHONE";
                           break;
      default:
                           res = "UNKNOWN";
      };

      return res;
   }

   TKIPv6 TStringToTKIPv6FST(TStorageDataType type, const TString &text)
   {
      TKIPv6 res     = TKIPv6();
      ui64   shingle = 0;

      if (!text.empty())
      {
         shingle = ShingleFromStroka(text);
         if (shingle != 0)
            res = TKIPv6(type, shingle);

      }

      return res;
   }

//*********************************************************************************************************************************************
//                                                 TStorageDataItemSerialization
//*********************************************************************************************************************************************

   void TStorageDataItemSerialization::Deserialize( nosql::HashMap& hash, TStorageDataItem& data )
   {
       kday_t last_day( ( unsigned long )hash[ FIELD_LASTDAY ].Long() );

       i32 ham = 0, spam85 = 0, spam100 = 0, sdtype = SDT_END;
       TString source = "";

       source = hash[ FIELD_SOURCE ].String();
       AssignValue( sdtype, hash[ FIELD_TYPE ].Long() );
       AssignValue( ham, hash[ FIELD_HAM ].Long() );
       AssignValue( spam85, hash[ FIELD_SPAM85 ].Long() );
       AssignValue( spam100, hash[ FIELD_SPAM100 ].Long() );

       data = TStorageDataItem(static_cast<TStorageDataType>(sdtype), source, last_day, ham, spam85, spam100);
   }

   void TStorageDataItemSerialization::Serialize( const TStorageDataItem& data, nosql::HashMap& sets )
   {
       SetElementWOCheck( sets, FIELD_LASTDAY, static_cast<ui32>(data.m_lastday) );
       SetElementWOCheck( sets, FIELD_TYPE,    data.m_stordata_type );
       SetElementWOCheck( sets, FIELD_SOURCE,  TString(data.m_data_sources) );
       SetElementWOCheck( sets, FIELD_HAM,     data.m_ham );
       SetElementWOCheck( sets, FIELD_SPAM85,  data.m_spam85 );
       SetElementWOCheck( sets, FIELD_SPAM100, data.m_spam100 );
   }

   TString TStorageDataItemSerialization::ConvertToId( const TKIPv6& ip )
   {
       return ip.AsShingle128();
   }

   TKIPv6 TStorageDataItemSerialization::IdToKey( const TString& id )
   {
       TKIPv6 ip;
       ip.FromShingle128( id );
       return ip;
   }

}

//*********************************************************************************************************************************************
