#pragma once

#include "util/generic/hash.h"
#include "util/string/util.h"
#include "ktypes.h"
#include "tstoragetypes.h"
#include "stato.h"
#include "tpackets.h"
#include "tpasswdchangeipstat.h"
#include "tshortipstorage.h"
#include "tsummarydata.h"
#include "tmachinelearning.h"
#include "tclustclt.h"
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/so-common/serializehelper.h>
#include <mail/so/spamstop/tools/so-clients/ktime.h>
#include <mail/so/spamstop/sp/sptypes.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include <mail/so/spamstop/tools/so-common/local_cache_template.h>
#include <mail/so/spamstop/tools/so-common/tpddclientobj.h>
#include <mail/so/spamstop/tools/so-common/trblhostclass.h>
#include <mail/so/spamstop/tools/so-common/tspamstatclient.h>

enum TKTypeSpam { KHAM0,
                  KSPAM85,
                  KSPAM100 };

enum TPassportRequestType { TP_UNKNOWN,
                            TP_LIGHTREGISTER,
                            TP_REGONE,
                            TP_REGISTER,
                            TP_ADMSOCIALREG,
                            TP_ADMIMPORTREG,
                            TP_ADMREG,
                            TP_CHANGEPASS_BASE,
                            TP_SIMPLEREG,
                            TP_POSTREGISTRATION,
                            TP_PHONEREG,
                            TP_ALTERNATIVEPHONE,
                            TP_ALTERNATIVEHINT,
                            TP_UNCOMPLEATESETPASWD,
                            TP_CHANGE_PASSWORD_FORCE,
                            TP_CHANGE_PASSWORD_STRONG,
                            TP_CHANGE_PASSWORD,
                            TP_CHANGE_PASSWORD_VOLUNTARILY,
                            TP_REQTYPE_COMPLETE,
                            TP_COMPLEATE_PDD,
                            TP_DIRECTORYREG,
                            TP_CHANGE_FLUSHED_PASSWORD,
                            TP_KINOPOISK_REG };

TString TPassportRequestTypeToTString(TPassportRequestType type, const TString& action_source);
bool IsChangePass(TPassportRequestType type);

struct TRequestInfo {
    ui32 regrime;                      //����� ����������� (�� �������)
    TString mainlogin;                 //�����, � ������� ������ ������ �� �����������
    TString uid;                       //uid ������������
    TPassportRequestType passpreqtype; //��� �����������
    TString passpreqtype_s;            //��� ����������� � ���� �������� ������
    TString ip;                        //ip, � �������� ������ ������
    TString ip_log;                    //ip, � �������� ������ ������ (� ������ �������)
    TString host;                      //����, � �������� ������ ������
    TString geo;                       //�������, � ������� ������ ������
    TExpList SpamList;                 //�������� ������ (� ������ ��������� ���������)
    TString messnumb;                  //������������� �������
    ui8 weigth;                        //��� ��������� (mainlogin) ������

    TRequestInfo() {
        regrime = 0;
        mainlogin = "";
        uid = "-";
        passpreqtype = TP_UNKNOWN;
        passpreqtype_s = "?";
        ip = "";
        ip_log = "";
        host = "";
        geo = "";
        SpamList.clear();
        messnumb = "-";
        weigth = 0;
    }
};

TKIPv6 TStringToTKIPv6(const TString& text);

namespace frodo_st {
    enum TStorageDataType { SDT_IPADDRESS,
                            SDT_INAME,
                            SDT_FNAME,
                            SDT_IFNAME,
                            SDT_PHONE,
                            SDT_END };

    TString TStorageDataTypeToTString(TStorageDataType type);
    TKIPv6 TStringToTKIPv6FST(TStorageDataType type, const TString& text);

    //*********************************************************************************************************************************************
    //                                                 TStorageDataItem
    //*********************************************************************************************************************************************

    struct TStorageDataItem {
        TStorageDataType m_stordata_type;
        char m_data_sources[151]{};
        kday_t m_lastday;
        ui32 m_ham{};
        ui32 m_spam85{};
        ui32 m_spam100{};
        bool is_collision{};

        Y_SAVELOAD_DEFINE(m_stordata_type, m_data_sources, m_lastday, m_ham, m_spam85, m_spam100, is_collision)

        TStorageDataItem() {
            Clear();
        }

        TStorageDataItem(TStorageDataType type, const TString& source, kday_t last_day, i32 ham, i32 spam85, i32 spam100) {
            Clear();

            m_stordata_type = type;
            if (source.length() > 0) {
                if (source.length() > (sizeof(m_data_sources) - 1))
                    memcpy(m_data_sources, source.c_str(), sizeof(m_data_sources) - 1);
                else
                    memcpy(m_data_sources, source.c_str(), source.length());

                m_data_sources[sizeof(m_data_sources) - 1] = 0x00;
            }
            m_lastday = last_day;
            m_ham = static_cast<ui32>(ham);
            m_spam85 = static_cast<ui32>(spam85);
            m_spam100 = static_cast<ui32>(spam100);
        }

        void Clear() {
            m_stordata_type = SDT_END;
            memset(m_data_sources, 0, sizeof(m_data_sources));
            m_lastday = kday_t((unsigned long)0);
            m_ham = 0;
            m_spam85 = 0;
            m_spam100 = 0;
            is_collision = false;
        }

        bool IsCollision() {
            return is_collision;
        }

        bool Empty() {
            bool res = false;

            if (m_stordata_type == SDT_END)
                res = true;
            if ((m_ham == 0) && (m_spam85 == 0) && (m_spam100 == 0))
                res = true;
            if (static_cast<ui32>(m_lastday) == 0)
                res = true;

            return res;
        }

        TString GetSource() {
            TString res = "";

            m_data_sources[sizeof(m_data_sources) - 1] = 0x00;
            res = TString(m_data_sources);
            CGIUnescape(res);

            return res;
        }
    };

    typedef THashMap<ui64, TStorageDataItem> TStorageDataItemHash;
    typedef TStorageDataItemHash::iterator TStorageDataItemHashIt;

    //*********************************************************************************************************************************************
    //                                                       TStorageDataItemExt
    //*********************************************************************************************************************************************

    struct TStorageDataItemExt {
        ui64 m_rec_shingle{};
        TStorageDataType m_rec_stordata_type = SDT_END;
        TKIPv6 m_rec_data;
        TString m_rec_source;
        TStorageDataItem m_stordata;
        TNoSqlItem nosqldata;
        bool m_err{};
        ui32 m_tick{};
        bool m_in_cache{};

        TStorageDataItemExt() {
            Clear();
        }

        TStorageDataItemExt(TKIPv6 data, TStorageDataType type, const TString& source) {
            Clear();

            m_rec_data = data;
            m_rec_stordata_type = type;

            if (source.length() > 50)
                m_rec_source = source.substr(0, 50);
            else
                m_rec_source = source;
            CGIEscape(m_rec_source);

            if (!data.Undefined()) {
                TString tstr = "";

                switch (m_rec_stordata_type) {
                    case SDT_IPADDRESS:
                        tstr = "ipaddr_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_INAME:
                        tstr = "iname_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_FNAME:
                        tstr = "fname_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_IFNAME:
                        tstr = "ifname_" + m_rec_data.IPv6AddressStr();
                        break;
                    case SDT_PHONE:
                        tstr = "phone_" + m_rec_data.IPv6AddressStr();
                        break;
                    default:
                        break;
                }

                if (!tstr.empty()) {
                    char sshingle[32];

                    memset(sshingle, 0, sizeof(sshingle));
                    calc_strcrc64(tstr.c_str(), tstr.size(), sshingle);
                    sscanf(sshingle, "%lx", &m_rec_shingle);
                }
            }
        }

        void Clear() {
            m_rec_shingle = 0;
            m_rec_stordata_type = SDT_END;
            m_rec_data = TKIPv6();
            m_rec_source = "";
            m_stordata.Clear();
            nosqldata.clear();
            m_err = false;
            m_tick = 0;
            m_in_cache = false;
        }
    };

    //*********************************************************************************************************************************************
    //                                                          TStorageData
    //*********************************************************************************************************************************************

    struct TStorageData {
        TStorageDataItemExt m_data[SDT_END];

        TStorageData() {
            Clear();
        }

        void Init(const TStorageDataItemExt& ipaddr, const TStorageDataItemExt& iname, const TStorageDataItemExt& fname, const TStorageDataItemExt& ifname, const TStorageDataItemExt& phone) {
            Clear();

            m_data[SDT_IPADDRESS] = ipaddr;
            m_data[SDT_INAME] = iname;
            m_data[SDT_FNAME] = fname;
            m_data[SDT_IFNAME] = ifname;
            m_data[SDT_PHONE] = phone;
        }

        void Clear() {
            for (auto& i : m_data)
                i.Clear();
        }
    };

    //*********************************************************************************************************************************************
    //                                                      TLongDataRqstInfo
    //*********************************************************************************************************************************************

    struct TLongDataRqstInfo {
        bool use[SDT_END]{};
        bool empty[SDT_END]{};
        bool is_cache[SDT_END]{};

        TLongDataRqstInfo() {
            Clear();
        }

        void Clear() {
            memset(use, 0, sizeof(use));
            memset(empty, 0, sizeof(empty));
            memset(is_cache, 0, sizeof(is_cache));
        }
    };

    //*********************************************************************************************************************************************
    //                                                 TStorageDataItemSerialization
    //*********************************************************************************************************************************************

#define FIELD_ID "id"
#define FIELD_LASTDAY "last_day"
#define FIELD_TYPE "type"
#define FIELD_SOURCE "src"
#define FIELD_HAM "ham"
#define FIELD_SPAM85 "spam85"
#define FIELD_SPAM100 "spam100"

    class TStorageDataItemSerialization {
    public:
        static void Deserialize(nosql::HashMap& hash, TStorageDataItem& data);
        static void Serialize(const TStorageDataItem& data, nosql::HashMap& sets);
        static TString ConvertToId(const TKIPv6& ip);
        static TKIPv6 IdToKey(const TString& id);
    };

    //*********************************************************************************************************************************************
    //                                                 correct login weigth
    //*********************************************************************************************************************************************

    typedef NCache::TCacheBase<ui64, ui8, 2> TCorrLoginWeigthClass;

    //*********************************************************************************************************************************************
} // namespace frodo_st

class TRCPTSData {
private:
    TString flogin;
    TString fweight;
    time_t ft{};
    TPassportRequestType fpasspreqtype = TP_UNKNOWN; //��� �����������
    TString fpasspreqtype_s;                         // ��� ����������� � ���� ������
    ui32 fsendcount{};

public:
    TRCPTSData() = default;

    TRCPTSData(const TString& loginA, const TString& weightA, const time_t tA, const TPassportRequestType passpreqtypeA, const TString& passpreqtype_sA, const ui32 sendcountA) {
        flogin = loginA;
        fweight = weightA;
        ft = tA;
        fpasspreqtype = passpreqtypeA;
        fpasspreqtype_s = passpreqtype_sA;
        fsendcount = sendcountA;
    }

    TString login() {
        return flogin;
    }
    TString weight() {
        return fweight;
    }
    time_t t() {
        return ft;
    }
    TPassportRequestType type() {
        return fpasspreqtype;
    }
    TString type_s() {
        return fpasspreqtype_s;
    }
    ui32 sendcount() {
        return fsendcount;
    }
};

enum TRqstFindDataTypeBB { RFTBB_NONE,
    RFTBB_CACHE,
    RFTBB_QUEUE,
    RFTBB_DIRECTLY };

struct TBBoxStructN {
    bool m_est_data;                     //true - ���� ������
    ui32 m_last_update;                  //�����, ����� ������ ���� �������� �� ��������
    TRqstFindDataTypeBB m_rqsttype_data; //���, ��� �������� ������
    TString m_email;                     //��� �����, �� �������� ������ ������ � ��������
    TString m_uid;                       //uid �� ���������
    ui32 m_karma;                        //karma �� ���������
    ui32 m_karma_status{};
    TString m_status;                    //status �� ������ ���������
    TString m_error;                     //error �� ������ ���������

    TBBoxStructN() {
        Clear();
    }

    void Clear() {
        m_est_data = false;
        m_rqsttype_data = RFTBB_NONE;
//m_email           = "";
        m_last_update = 0;
        m_uid = "";
        m_karma = 0;
        m_karma_status = 0;
        m_status = "";
        m_error = "";
    }

    TString toLog() {
        TString res = "";

        switch (m_rqsttype_data) {
            case RFTBB_NONE:
                res = res + "N, ";
                break;
            case RFTBB_CACHE:
                res = res + "L, ";
                break;
            case RFTBB_QUEUE:
                res = res + "Q, ";
                break;
            case RFTBB_DIRECTLY:
                res = res + "D, ";
                break;
        };
        res = res + "est_data=" + BoolToStroka2(m_est_data) + ", ";
        res = res + "email='" + m_email + "', ";
        res = res + "uid='" + m_uid + "', ";
        res = res + "karma='" + IntToStroka(m_karma) + "', ";
        res = res + "karma_status='" + IntToStroka(m_karma_status) + "', ";
        res = res + "status='" + m_status + "', ";
        res = res + "error='" + m_error + "'";

        return res;
    }
};


struct TOData {
    TOData() = default;
    TString messnumb;                               //message number
    TString remote_uid;                             //remote uid for debug
    TString langstr;                                //язык
    TPassportRequestType passpreqtype = TP_UNKNOWN; //тип регистрации
    TString passpreqtype_source;                    //тип регистрации (из запроса, поле "action")
    time_t regtime{};                               //время регистрации
    TString login;                                  //логин
    TString login_src;                              //����� �� �������������� utf
    TString login_src_domen;                        //����� ������ �� �������������� utf
    TString login_src_domen_puny;                   //����� ������ �� �������������� utf (punycode)
    bool login_corr_exists{};                       //����� ������� � ���� ��������� ���� (�������� �� �������� ��� ������, ���� �� ������, ��� ��� �����)
    ui8 login_corr_weigth{};                        //���, ������� ����� � ����
    TString iname;                                  //фамилия
    TString fname;                                  //имя
    TString nickname;                               //ник
    TString email;                                  //e-mail
    ui8 in_inamelist{};                             //находится в списке фамилий
    ui8 in_fnamelist{};                             //находится в списке имен
    ui8 in_inamelist_cmp{};                         //есть совпадение с записью в списке фамилий
    TString s_inamelist_cmp;                        //имя в транскрипции, которое нашлось
    ui8 in_fnamelist_cmp{};                         //есть совпадение с записью в списке имен
    TString s_fnamelist_cmp;                        //фамилия в транскрипции, которая нашлась
    bool cmp_ifname{};                              //совпадают непустые имя и фамилия
    TString social_provider;                        //имя социального сервиса
    TKIPv6 iplong;                                  //представление как IPv6
    ui64 iplong_shingle{};                          //shingle ip
    TKIPv6 iname_ipv6;                              //представление iname как IPv6
    ui64 iname_ipv6_shingle{};                      //shingle iname
    TKIPv6 fname_ipv6;                              //представление fname как IPv6
    ui64 fname_ipv6_shingle{};                      //shingle fname
    TKIPv6 ifname_ipv6;                             //представление iname+fname как IPv6
    ui64 ifname_ipv6_shingle{};                     //shingle iname+fname
    TKIPv6 phone_ipv6;                              //представление phone как IPv6
    ui64 phone_ipv6_shingle{};                      //shingle phone
    TString ip_isx;                                 //ip до корректировки
    bool is_corrected{};                            //true - адрес скорректирован в соотвествии со списком группировки
    ui32 dublicat_login_count{};                    //кол-во дубликатов логина

    bool blackip{};              //находится в черном списке ip
    TString blacknet_source;     //сеть, в которую попал ip
    bool whiteip{};              //находится в белом списке ip
    TString whitenet_source;     //сеть, в которую попал ip
    bool trustip{};              //находится в списке trust ip
    TString trustnet_source;     //сеть, в которую попал ip
    bool gruppedip{};            //находится в списке группировки
    TString gruppednet_source;   //сеть, в которую попал ip
    bool ungruppedip{};          //находится в списке разгруппировки
    TString ungruppednet_source; //сеть, в которую попал ip

    bool whiteip_so{};              //находится в белом списке ip
    TString whitenet_so_source;     //сеть, в которую попал ip
    bool intranetzoneip_so{};       //находится в intranetzone списке ip
    TString intranetzone_so_source; //сеть, в которую попал ip
    bool trustedzoneip_so{};        //находится в trustedzone списке ip
    TString trustedzone_so_source;  //сеть, в которую попал ip
    bool localzoneip_so{};          //находится в localzone списке ip
    TString localzone_so_source;    //сеть, в которую попал ip

    TString login_prefix;      //префикс логина
    TString first_nsymb_login; //несколько первых символов логина

    TString passwhint_s;       //хинт пароля в виде строки
    ui32 passwhint{};          //хинт пароля
    TString passwhint_sm;      //модифицированный хинт пароля в виде строки
    ui32 passwhint_m{};        //модифицированный хинт пароля
    TString passwdex_s;        //расширенный хинт пароля в виде строки
    ui32 passwdex{};           //расширенный хинт пароля
    TString passwdex_sm;       //модифицированный расширенный хинт пароля в виде строки
    ui32 passwdex_m{};         //модифицированный расширенный хинт пароля
    TPackHint passwdhintall;   //упакованные хинты пароля (обычный и расширенный)
    TPackHint passwdhintall_m; //упакованные модифицированные хинты пароля (обычный и расширенный)

    TString questhint_s;  //хинт вопроса в виде строки
    ui64 questhint{};     //хинт вопроса
    TString questhint_sm; //модифицированный хинт вопроса в виде строки
    ui64 questhint_m{};   //модифицированный хинт вопроса
    TString hintqex_s;    //расширенный хинт вопроса в виде строки
    ui64 hintqex{};       //расширенный хинт вопроса
    TString hintqex_sm;   //модифицированный расширенный хинт вопроса в виде строки
    ui64 hintqex_m{};     //модифицированный расширенный хинт вопроса
    TPackHint qhintall;   //упакованные хинты вопроса (обычный и расширенный)
    TPackHint qhintall_m; //упакованные модифицированные хинты вопроса (обычный и расширенный)
    ui32 hintqid{};       //id хинта вопроса
    TString hintqid_s;    //id хинта вопроса в виде строки

    TString answerhint_s;  //хинт ответа в виде строки
    ui64 answerhint{};     //хинт ответа
    TString answerhint_sm; //модифицированный хинт ответа в виде строки
    ui64 answerhint_m{};   //модифицированный хинт ответа
    TString hintaex_s;     //расширенный хинт ответа в виде строки
    ui64 hintaex{};        //расширенный хинт ответа
    TPackHint ahintall;    //упакованные хинты ответа (обычный и расширенный)
    TPackHint ahintall_m;  //упакованные модифицированные хинты ответа (обычный и расширенный)
    TString hintaex_sm;    //модифицированный расширенный хинт ответа в виде строки
    ui64 hintaex_m{};      //модифицированный расширенный хинт ответа

    TString valkey;             //ключ значений
    TString from_s = "-";       //from
    bool from_pdd{};            //pdd регистрация
    TString phonenumber_s;      //телефон
    ui32 yandexuid_timestamp{}; //таймстамп из яндексового уида
    ui32 user_kuka{};           //время жизни куки у пользователя
    TString useragent_s;        //агент пользователя
    ui32 step1time{};           //длительность первого шага регистрации
    ui32 step2time{};           //длительность второго шага регистрации
    ui32 captchareq{};
    ui32 captchacount{}; //кол-во попыток ввода капчи
    ui32 lcheck{};
    TString utime_s;
    ui32 geodata{};                         //старые геоданные (не используются)
    ui16 login_length{};                    //длина логина
    ui16 vowels_serial_count{};             //макс. число последовательных гласных в логине
    ui16 digits_count{};                    //число цифр в логине
    ui16 constanants_serial_count{};        //макс. число последовательных согласных в логине
    ui16 prefix_login_length{};             //длина префикса логина
    ui16 constanants_digits_serial_count{}; //макс. число последовательных согласных и цифр
    ui16 cvpairs{};                         //число пар гласные-согласные
    float divpaircv{};                      //отношение числа пар гласные-согласные к половине длины логина
    float divdigits{};                      //отношение кол-ва цифр к длине логина
    //TRemoteIpInfo         spamstat_ipinfo;     //данные со спамстата

    ui16 constanants_serial_count_iname{}; //макс. число последовательных согласных в iname
    ui16 vowels_serial_count_iname{};      //макс. число последовательных гласных в iname
    ui16 digital_count_iname{};            //число цифр в iname
    ui16 constanants_serial_count_fname{}; //макс. число последовательных согласных в fname
    ui16 vowels_serial_count_fname{};      //макс. число последовательных гласных в fname
    ui16 digital_count_fname{};            //число цифр в fname

    TStatAvr snow;   //часовая статистика по хаму-спаму-ошибкам
    TStatAvr savr;   //часовая статистика по хаму-спаму-ошибкам
    float savr_oa{}; //часовая статистика всего
    float savr_os{}; //часовая статистика по спаму
    float savr_oe{}; //часовая статистика по ошибкам
    float savr_oh{}; //часовая статистика по хаму

    bool cmp_iname{};    //совпадение логина с iname
    bool cmp_fname{};    //совпадение логина с fname
    bool cmp_names{};    //совпадение логина с iname или с fname
    TString cmp_names_s; //печать в лог

    TString fuid;        //"рекламный" uid (рекламная кука, могут быть разные логины с одной кукой)
    ui32 fuidcount{};    //счетчик fuid
    TPacket pack1;       //сборка 1
    ui32 packet1count{}; //счетчик сборки 1
    TPacket pack2;       //сборка 2
    ui32 packet2count{}; //счетчик сборки 2
    TPacket3 pack3;      //сборка 3
    ui32 packet3count{}; //счетчик сборки 3
    TPacket4 pack4;      //сборка 4
    ui32 packet4count{}; //счетчик сборки 4
    TPacket2 pack5;      //сборка 5
    ui32 packet5count{}; //счетчик сборки 5

    TIPStat ipstate;            //статистика ip (короткоживущая)
    float otnosh_spam_ip{};     //процент спама от общего числа регистраций
    ui32 geostatcountcountry{}; //счетчик по гео (страна)
    ui32 geostatcount{};        //счетчик по гео (страна + город)
    ui32 geostatascount{};      //счетчик по гео (AS)

    ui32 hoststat_domen2level{}; //счетчик по хостам (по домену 2 уровня)
    ui32 hoststat_domen3level{}; //счетчик по хостам (по домену 3 уровня)

    ui32 ipv4maskaC{}; //счетчик по ipv4 maska net C (24)
    ui32 ipv6maska1{}; //счетчик по ipv6 maska 1
    ui32 ipv6maska2{}; //счетчик по ipv6 maska 2
    ui32 ipv6maska3{}; //счетчик по ipv6 maska 3

    TString logindomen;    //домен, если в логине есть @
    ui32 domenstat{};      //счетчик по домену
    TPDDStructN pddinfo;   //информация по домену для логинов с @
    TBBoxStructN bboxinfo; //информация по админскому логину ПДД, если проверяемый логин относится к ПДД

    TLTCSum ltcs; //статистика за последние 300 и 1200 сек

    frodo_st::TStorageData storage_long_data; //долговременная статистика из базы

    ui32 ipb_day{};       //статистика по ip (долговременное хранилище) - дней в базе
    ui32 ipb_ham{};       //статистика по ip (долговременное хранилище) - хама
    ui32 ipb_spam85{};    //статистика по ip (долговременное хранилище) - спама
    ui32 ipb_spam100{};   //статистика по ip (долговременное хранилище) - малика
    float ipb_spamrate{}; //статистика по ip (долговременное хранилище) - процент спама
    ui32 ipb_all{};       //статистика по ip (долговременное хранилище) - всего
    ui32 ipb_spamall{};   //статистика по ip (долговременное хранилище) - всего спама

    ui32 inameb_day{};       //статистика по iname (долговременное хранилище) - дней в базе
    ui32 inameb_ham{};       //статистика по iname (долговременное хранилище) - хама
    ui32 inameb_spam85{};    //статистика по iname (долговременное хранилище) - спама
    ui32 inameb_spam100{};   //статистика по iname (долговременное хранилище) - малика
    float inameb_spamrate{}; //статистика по iname (долговременное хранилище) - процент спама
    ui32 inameb_all{};       //статистика по iname (долговременное хранилище) - всего
    ui32 inameb_spamall{};   //статистика по iname (долговременное хранилище) - всего спама

    ui32 fnameb_day{};       //статистика по fname (долговременное хранилище) - дней в базе
    ui32 fnameb_ham{};       //статистика по fname (долговременное хранилище) - хама
    ui32 fnameb_spam85{};    //статистика по fname (долговременное хранилище) - спама
    ui32 fnameb_spam100{};   //статистика по fname (долговременное хранилище) - малика
    float fnameb_spamrate{}; //статистика по fname (долговременное хранилище) - процент спама
    ui32 fnameb_all{};       //статистика по fname (долговременное хранилище) - всего
    ui32 fnameb_spamall{};   //статистика по fname (долговременное хранилище) - всего спама

    ui32 ifnameb_day{};       //статистика по iname+fname (долговременное хранилище) - дней в базе
    ui32 ifnameb_ham{};       //статистика по iname+fname (долговременное хранилище) - хама
    ui32 ifnameb_spam85{};    //статистика по iname+fname (долговременное хранилище) - спама
    ui32 ifnameb_spam100{};   //статистика по iname+fname (долговременное хранилище) - малика
    float ifnameb_spamrate{}; //статистика по iname+fname (долговременное хранилище) - процент спама
    ui32 ifnameb_all{};       //статистика по iname+fname (долговременное хранилище) - всего
    ui32 ifnameb_spamall{};   //статистика по iname+fname (долговременное хранилище) - всего спама

    ui32 phoneb_day{};       //статистика по v2_phonenumber_hash (долговременное хранилище) - дней в базе
    ui32 phoneb_ham{};       //статистика по v2_phonenumber_hash (долговременное хранилище) - хама
    ui32 phoneb_spam85{};    //статистика по v2_phonenumber_hash (долговременное хранилище) - спама
    ui32 phoneb_spam100{};   //статистика по v2_phonenumber_hash (долговременное хранилище) - малика
    float phoneb_spamrate{}; //статистика по v2_phonenumber_hash (долговременное хранилище) - процент спама
    ui32 phoneb_all{};       //статистика по v2_phonenumber_hash (долговременное хранилище) - всего
    ui32 phoneb_spamall{};   //статистика по v2_phonenumber_hash (долговременное хранилище) - всего спама

    bool malic{}; //malic spam (по правилу "MALICIOUS")

    TPasswdChangeStat passwdchangestat; //статистика по запросам типа "смена пароля"
    bool allowuser{};                   //доверенный пользователь (для режима типа смена пароля)

    TString uid; //uid пользователя пока только для запросов смены пароля

    int timezone_diff = -1;
    bool is_night{};
    TString geos_as;
    TString geos_tor;
    ui32 v2_cookie_l_timestamp{};
    bool v2_cookie_l_timestamp_define{};
    ui32 v2_cookie_l_timestamp_diff{};
    TString v2_cookie_l_login;
    bool v2_cookie_l_login_rate{};
    TString v2_cookie_l_uid;
    bool v2_cookie_l_uid_rate{};
    int v2_password_validation_last_call{};
    int v2_password_validation_first_call{};
    int v2_sanitize_phone_last_call{};
    int v2_sanitize_phone_first_call{};
    int v2_track_created{};
    int v2_captcha_generated_at{};
    int v2_captcha_checked_at{};
    int v2_login_validation_last_call{};
    int v2_login_validation_first_call{};
    int v2_suggest_login_last_call{};
    int v2_suggest_login_first_call{};
    TString v2_account_timezone;
    bool v2_account_timezone_define{};

    TString v2_phonenumber_hash;
    bool v2_phonenumber_hash_define{};

    int tm1{};
    int tm2{};
    int tm3{};
    int tm4{};
    int tm5{};
    int tm6{};
    bool tm1_exists{};
    bool tm2_exists{};
    bool tm3_exists{};
    bool tm4_exists{};
    bool tm5_exists{};
    bool tm6_exists{};
    bool v2_password_validation_last_call_define{};
    bool v2_password_validation_first_call_define{};
    bool v2_sanitize_phone_last_call_define{};
    bool v2_sanitize_phone_first_call_define{};
    bool v2_track_created_define{};
    bool v2_captcha_generated_at_define{};
    bool v2_captcha_checked_at_define{};
    bool v2_login_validation_last_call_define{};
    bool v2_login_validation_first_call_define{};
    bool v2_suggest_login_last_call_define{};
    bool v2_suggest_login_first_call_define{};
    TRBLHostClass::TRBLWorkRuleList rbl_rulelist;

    TSPSTDataRes spst_answer;

    mlcl::TMLData ml_data;      //machine learning data
    mlcl::TMLDataRes ml_answer; //machine learning answer

    TClustDataRes clust_data_answer_local;

    NJson::TJsonValue AfResponse;
};

typedef THashMap<ui64, TRCPTSData> TRPCHash;
typedef TRPCHash::iterator TRPCHashIt;
