#include "tgeneralobject.h"

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

TGeneralObject::TGeneralObject() {
    LogsGroup = NULL;
    config = NULL;
    server_id = "";
    last_write_mondata = time(NULL);
    m_async_check = NULL;
    m_last_write_console_stat = static_cast<ui32>(time(NULL));
    m_last_read_console_stat = static_cast<ui32>(time(NULL));
    m_last_write_dump = static_cast<ui32>(time(NULL));
    m_PushStorBusy = false;
    m_obrab_upstream_version = false;
    m_return_upstream_version = false;
    m_major_request_count = 0;
    m_minor_request_count = 0;
    m_use_async_check_mode = false;
    m_correct_login_enable = true;
    m_last_update_stat_to_database = static_cast<ui32>(time(NULL));
}

TGeneralObject::~TGeneralObject() {
    if (m_async_check != NULL) {
        delete m_async_check;
        m_async_check = NULL;
    }
}

TLogsGroup* TGeneralObject::GetLogsGroup() {
    return (TLogsGroup*)LogsGroup;
}

bool TGeneralObject::InitBeforeFork(const TString& server_idA, TLogsGroupBase* LogsGroupA, TKConfig* configA) {
    TLogClass* log = NULL;

    LogsGroup = LogsGroupA;
    config = configA;
    server_id = server_idA;

    m_StoragePool.InitBeforeFork(LogsGroup, config, GetServerHostName(), GetServerCode(), GetServerStartTime(), GetServerVersion());
    //pStorNoSql = (TStorageNoSql *)(m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN).storage);

    if (GetLogsGroup() != NULL)
        log = GetLogsGroup()->GetServerLog();

    if (config != NULL) {
        bool limit_disable = config->ReadBool("rqst_limit", "disable", false);
        ui32 check_perc = config->ReadInteger("rqst_limit", "check", 85);
        ui32 rcvrcpt_perc = config->ReadInteger("rqst_limit", "rcvrcpt_perc", 5);
        ui32 corrlongstat_perc = config->ReadInteger("rqst_limit", "corrlongstat", 5);
        ui32 interface_perc = config->ReadInteger("rqst_limit", "interface", 5);

        LimitObj.Init(config, limit_disable);
        LimitObj.AddItem(TMakeRequestLimit::CHECK, check_perc);
        LimitObj.AddItem(TMakeRequestLimit::RCVRCPT, rcvrcpt_perc);
        LimitObj.AddItem(TMakeRequestLimit::CORRLONGSTAT, corrlongstat_perc);
        LimitObj.AddItem(TMakeRequestLimit::INTERFACE, interface_perc);

        //rate object
        int critical_serial_diap_min = config->ReadInteger("rate", "critical_serial_diap_min", 30);
        int critical_summary_diap_min = config->ReadInteger("rate", "critical_summary_diap_min", 120);
        TString type_instance = config->ReadStroka("rate", "exttype_instance", "");

        RateObj.Init(LogsGroup, critical_serial_diap_min, critical_summary_diap_min, type_instance);

        //receipt
        bool enb_receipt = config->ReadBool("receipt", "enb_receipt", true);
        RCP.SetReceiptMode(enb_receipt);
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "Enable receipt mode - %s", BoolToStroka2(enb_receipt).c_str());

        //filter
        m_filter.InitBeforeFork(config, GetLogsGroup());

        //async mode check
        m_use_async_check_mode = config->ReadBool("async_check", "enable", false);
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "USE ASYNC CHECK MODE - %s", BoolToStroka2(m_use_async_check_mode).c_str());

        //correct login cache
        m_correct_login_enable = config->ReadBool("corr_answer_weigth", "enable", true);
        int correct_login_period = config->ReadInteger("corr_answer_weigth", "period_sec", 86400 * 3);
        if (m_correct_login_enable)
            m_LoginWeightObj.Init(TDuration::Seconds(correct_login_period));
    }

    m_check_tc.Init(10000, 20000, true);
    m_loginrcpt_tc.Init(10000, 20000, true);
    m_corrlongstat_tc.Init(10000, 20000, true);
    m_reserv_tc.Init(10000, 20000, true);

    traccert_stat.Init();
    traccert_stat_forecast.Init();
    traccert_stat_debug.Init();
    traccert_stat_fulltick.Init();

    return true;
}

bool TGeneralObject::InitAfterFork() {
    m_StoragePool.InitAfterFork();
    auto pStorNoSql = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN).storage;

    if (m_use_async_check_mode) {
        m_async_check = new TAsyncCheck();
        if (m_async_check != NULL)
            m_async_check->Init(this, GetConfigObject(), GetLogsGroup());
    }

    m_filter.InitAfterFork(std::move(pStorNoSql));

    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
        GetLogsGroup()->GetServerLog()->FFlush();

    return true;
}

bool TGeneralObject::Midnight() {
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetLogTraccertDays() != NULL)) {
        TString trassert_days = GetTraccertStatWeb();
        GetLogsGroup()->GetLogTraccertDays()->WriteMessageBUFF(trassert_days.c_str(), trassert_days.length());
    }

    LimitObj.Midnight();
    traccert_stat.Midnight();
    traccert_stat_forecast.Midnight();
    traccert_result_stat.Midnight();
    traccert_stat_debug.Midnight();
    traccert_stat_fulltick.Midnight();

    if (GetLogsGroup() != NULL)
        GetLogsGroup()->TruncLog();

    m_StoragePool.Midnight();

    if (m_async_check != NULL)
        m_async_check->Midnight();

    m_check_tc.Midnight();
    m_loginrcpt_tc.Midnight();
    m_corrlongstat_tc.Midnight();
    m_reserv_tc.Midnight();
    RCP.Midnight();

    m_SetMinorStatusMutex.Acquire();
    m_major_request_count = 0;
    m_minor_request_count = 0;
    m_SetMinorStatusMutex.Release();

    m_filter.Midnight();

    return true;
}

bool TGeneralObject::Shutdown() {
    m_StoragePool.Shutdown();

    m_filter.Shutdown();

    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
        GetLogsGroup()->GetServerLog()->FFlush();

    return true;
}

void TGeneralObject::EventTick() {
    m_check_tc.CalcCPS();
    m_loginrcpt_tc.CalcCPS();
    m_corrlongstat_tc.CalcCPS();
    m_reserv_tc.CalcCPS();

    GetServersStatistikAuto();

    if (m_correct_login_enable)
        m_LoginWeightObj.EventTick();

    m_StoragePool.EventTick();

    m_filter.EventTick();

    WriteConsoleStatToStorage();
    WriteDump();

    WriteStatToLog();
}

bool TGeneralObject::Close() {
    m_StoragePool.Close();
    m_filter.Close();
    return true;
}

void TGeneralObject::AddINTick(const TMakeRqstDelays& work_delays) {
    traccert_stat_fulltick.AddTick("FULLTICK1_FULL", work_delays.m_fulltick);
    traccert_stat_fulltick.AddTick("FULLTICK2_GETSTDIN", work_delays.m_gstdin);
    traccert_stat_fulltick.AddTick("FULLTICK3_FILLHEADERS", work_delays.m_fillheaders);
    traccert_stat_fulltick.AddTick("FULLTICK4_REPLY", work_delays.m_reply);
    traccert_stat_fulltick.AddTick("FULLTICK5_PARSEGETPOST", work_delays.m_parse_getpost);
}

void TGeneralObject::WriteStatToLog() {
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetMonLog())) {
        ui32 last_write_mondata_diff = time(NULL) - last_write_mondata;

        if (last_write_mondata_diff >= 60) {
            TString mon_text = "";
            TStorageInfoExt si;

            //server code "<SCODE: server_code>"
            mon_text += "<SCODE: " + GetServerCode() + ">";

            //input statistik
            mon_text += LimitObj.GetMonStatistik();

            //storage statistik
            mon_text += GetStorageMonStatistik();

            GetLogsGroup()->GetMonLog()->WriteMessageAndData("%s", mon_text.c_str());
            GetLogsGroup()->GetMonLog()->FFlush();

            last_write_mondata = time(NULL);
        }
    }
}

void TGeneralObject::GetStorageStat(TStorageNameStatList& statlist) {
    NStorageStats::TStorageStat rec;

    statlist.clear();
    m_StoragePool.GetStorageStat(statlist);
}

TStorageNameStat TGeneralObject::GetStat(int index, bool& notfound) {
    TStorageNameStat res;

    notfound = true;
    res = m_StoragePool.GetStat(index, notfound);

    return res;
}

TStorageRequestNameStat TGeneralObject::GetRequestStat(int index, bool& notfound) {
    TStorageRequestNameStat res;

    notfound = true;
    res = m_StoragePool.GetRequestStat(index, notfound);

    return res;
}

TStorageQuantileStat TGeneralObject::GetQuantileStat(int index, bool& notfound) {
    notfound = true;
    return m_StoragePool.GetQuantileStat(index, notfound);
}

TStorageInfoFull TGeneralObject::GetStorageFullInfo(int index, bool& notfound) {
    return m_StoragePool.GetStorageFullInfo(index, notfound);
}

TString TGeneralObject::GetPutQueueProperties() {
    return m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN).storage->GetPutQueueProperties();
}

TString TGeneralObject::GetStorageIdent() {
    return m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN).storage->GetStorageIdent();
    ;
}

TString TGeneralObject::GetDriverProperties() {
    return m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN).storage->ReturnDriverProp();
}

TString TGeneralObject::GetStorageWebStatistik() {
    TString res = "";

    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        NStorageStats::TStorageStatVector stat;

        stat = (storobj.storage)->GetWebStatistik();
        res = stat.PrintDataWEB(false, false, false);

        //live time thread in postgree driver (master)
        res += (storobj.storage)->GetLiveRqstData(true) + "<br>";
        res += (storobj.storage)->GetLiveRqstData(false) + "<br>";
    }

    return res;
}

TString TGeneralObject::GetStorageTraccertStatistik() {
    TString res = "";

    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        res += "<i><b>Traccert request to storage:</b></i><br>";
        res += (storobj.storage)->GetTraccertStat() + "<br>";
    }

    return res;
}

TString TGeneralObject::GetStorageMonStatistik() {
    TString res = "";

    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        NStorageStats::TStorageStatVector stat;

        stat = (storobj.storage)->GetMonStatistik();
        res = stat.PrintDataLog();

        res += (storobj.storage)->GetPutQueueMonStatistik();
    }

    return res;
}

TString TGeneralObject::GetUpdateQueueWebStatistik() {
    TString res = "";

    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage)
        res = (storobj.storage)->GetUpdateQueueWebStatistik();

    return res;
}

TConsoleStatDataItem GetLocalConsoleStatItem(TTrafficControl& tc_obj) {
    TConsoleStatDataItem res;

    snprintf(res.m_cps, sizeof(res.m_cps) - 1, "%s", tc_obj.GetStatistMin().c_str());
    res.m_today_rqst = tc_obj.GetTodayRequest();
    res.m_lost_rqst = tc_obj.GetTodayUserValue1Request();
    res.m_yesterday_rqst = tc_obj.GetYesterdayRequest();
    res.m_yesterday_lost = tc_obj.GetYesterdayUserValue1Request();

    return res;
}

TConsoleStatData TGeneralObject::GetLocalConsoleStat() {
    TConsoleStatData res;
    qustat::TDriverRqstPoolStatFour putqueue_stat;

    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage)
        putqueue_stat = (storobj.storage)->GetConsoleStat();

    res.m_lastdate = time(NULL);

    snprintf(res.m_serverhostname, sizeof(res.m_serverhostname) - 1, "%s", GetServerHostName().c_str());
    snprintf(res.m_servercode, sizeof(res.m_servercode) - 1, "%s", GetServerCode().c_str());
    snprintf(res.m_serverstarttime, sizeof(res.m_serverstarttime) - 1, "%s", GetServerStartTime().c_str());
    snprintf(res.m_serverversion, sizeof(res.m_serverversion) - 1, "%s", GetServerVersion().c_str());

    TString rate_mode = "";

    rate_mode += IntToStroka(m_major_request_count) + " / " + IntToStroka(m_minor_request_count);
    rate_mode += " [";
    if (m_obrab_upstream_version)
        rate_mode += "obr+";
    else
        rate_mode += "obr-";
    if (m_return_upstream_version)
        rate_mode += "answ+";
    else
        rate_mode += "answ-";
    rate_mode += ";" + InstanceTypeToStroka(RateObj.GetTypeInstance()) + "]";
    snprintf(res.m_rate_mode, sizeof(res.m_rate_mode) - 1, "%s", rate_mode.c_str());

    res.m_data[0] = GetLocalConsoleStatItem(m_check_tc);
    res.m_data[0].m_today_putqueue_count = putqueue_stat.m_today_fastput.GetCount();
    res.m_data[0].m_today_putqueue_lost = putqueue_stat.m_today_fastput.GetInputLost();
    res.m_data[0].m_yesterday_putqueue_count = putqueue_stat.m_yesterday_fastput.GetCount();
    res.m_data[0].m_yesterday_putqueue_lost = putqueue_stat.m_yesterday_fastput.GetInputLost();

    res.m_data[1] = GetLocalConsoleStatItem(m_loginrcpt_tc);
    res.m_data[2] = GetLocalConsoleStatItem(m_corrlongstat_tc);
    res.m_data[3] = GetLocalConsoleStatItem(m_reserv_tc);

    return res;
}

void TGeneralObject::WriteConsoleStatToStorage() {
    ui32 currenttime = static_cast<ui32>(time(NULL));
    ui32 t_diff = 0;

    if (currenttime > m_last_write_console_stat)
        t_diff = currenttime - m_last_write_console_stat;

    if (t_diff >= 15) {
        TString srv_code = GetServerCode();

        if (!srv_code.empty()) {
            nosql::HashMap sets;
            TConsoleStatData c_stat;
            ui64 id = 0;

            if (sscanf(srv_code.c_str(), "%lx", &id) != 1)
                id = ShingleFromStroka(srv_code);
            c_stat = GetLocalConsoleStat();

            c_stat.CreateStorageRequest(sets);

            auto& storobj = m_StoragePool.GetStorageInfo(0, 0, id, AT_UNKNOWN);
            if (storobj.storage)
                (storobj.storage)->WriteConsoleDataToStorage(id, sets);
        }

        m_last_write_console_stat = currenttime;
    }
}

void TGeneralObject::WriteDump() {
}

ui32 TGeneralObject::GetServersStatistik(TConsoleStatDataList& servers_stats) {
    TConsoleStatData local;
    TString local_s = "LOCAL";
    TConsoleStatDataList servers_stats_ext;
    TConsoleStatDataListIt it;
    TString marker = "***";
    TString tstr = "";
    ui32 tick = 0;

    local = GetLocalConsoleStat();
    memset(local.m_serverhostname, 0, sizeof(local.m_serverhostname));
    snprintf(local.m_serverhostname, sizeof(local.m_serverhostname) - 1, "%s", local_s.c_str());

    tick = CShingleTime::GetMs();
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage)
        (storobj.storage)->ReadConsoleDataFromStorage(servers_stats_ext);
    tick = CShingleTime::GetMs() - tick;

    servers_stats.push_back(local);
    it = servers_stats_ext.begin();
    while (it != servers_stats_ext.end()) {
        tstr = TString((*it).m_servercode);
        if (tstr == TString(local.m_servercode))
            snprintf((*it).m_servercode, sizeof((*it).m_servercode) - 1, "%s%s", marker.c_str(), tstr.c_str());

        servers_stats.push_back(*it);

        ++it;
    }

    return tick;
}

TString TGeneralObject::GetServersStatistikText(ui32& stor_tick) {
    TString res = "";
    TConsoleStatDataList servers_stats;

    stor_tick = GetServersStatistik(servers_stats);
    res = PrintServersStatistik(servers_stats);

    {
        //last update statistik to BD (PGaaS)
        for (size_t i = 0; i < servers_stats.size(); i++) {
            if (strstr(servers_stats[i].m_servercode, "***") != NULL) {
                m_last_update_stat_to_database = servers_stats[i].m_lastdate;
            }
        }

        m_last_read_console_stat = static_cast<ui32>(time(NULL));
    }

    return res;
}

void TGeneralObject::GetServersStatistikAuto() {
    ui32 currenttime = static_cast<ui32>(time(NULL));
    ui32 t_diff = 0;

    if (currenttime > m_last_read_console_stat)
        t_diff = currenttime - m_last_read_console_stat;

    if (t_diff > 30) {
        TConsoleStatDataList servers_stats;

        GetServersStatistik(servers_stats);

        //last update statistik to BD (PGaaS)
        for (size_t i = 0; i < servers_stats.size(); i++) {
            if (strstr(servers_stats[i].m_servercode, "***") != NULL) {
                m_last_update_stat_to_database = servers_stats[i].m_lastdate;
            }
        }

        m_last_read_console_stat = currenttime;
    }
}

bool TGeneralObject::StorageInitStatus(TString& status) {
    bool res = false;

    status = "";
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage)
        res = (storobj.storage)->StorageInitStatus(status);

    return res;
}

i64 TGeneralObject::GetStorageSize() {
    i64 res = 0;

    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage)
        res = (storobj.storage)->GetStorageSize();

    return res;
}

TString TGeneralObject::HTTP_200_OK_TextXMLUTF8(float rating, TRateSrvc::TTypeInstance type_instance, ui8 hash_one, ui64 hash_two) {
    TString text = "";

    text = text + "Status: 200 OK\r\n";
    //text = text + "Server: " + m_servername + "\r\n";
    text = text + "Server: " + GetServerVersion() + "\r\n";
    text = text + "Content-type: text/xml; charset=utf-8\r\n";
    text = text + "Rate: " + FloatToStr0(rating) + "\r\n";
    text = text + "TYPEINST: " + InstanceTypeToStroka(type_instance) + "\r\n";
    text = text + "HashOne: " + IntToStroka(hash_one) + "\r\n";
    text = text + "HashTwo: " + ShingleToStroka2(hash_two) + "\r\n";
    text = text + "SrvCode: " + GetServerCode() + "\r\n";
    text = text + "\r\n";

    return text;
}

void TGeneralObject::LoginRCPT(TReqParams* m_ReqParams, const TString& /*NumbRequest*/, bool is_upstream_request, const TString& requrl) {
    if (m_ReqParams != NULL) {
        TReqParams::iterator par_it;
        TString login = "";
        TString weight = "";
        const char* p = NULL;
        bool is_changepass = false;
        TString st = "";

        par_it = m_ReqParams->begin();
        while (par_it != m_ReqParams->end()) {
            st = (*par_it).first;
            login = DecodeLoginFromUTF8((*par_it).first);
            weight = (*par_it).second[0];

            if (!weight.empty()) {
                p = strchr(weight.c_str(), '-');
                if (p != NULL)
                    is_changepass = true;
                else
                    is_changepass = false;
            } else
                is_changepass = false;

            if (GetRCP() != NULL)
                GetRCP()->RemoveLogin(login, is_changepass);

            ++par_it;
        }

        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSendAnswerLog(is_upstream_request) != NULL))
            GetLogsGroup()->GetSendAnswerLog(is_upstream_request)->WriteMessageAndData("%s", requrl.c_str());
    }
}

void TGeneralObject::AddTraccertData(const TDelayClass& delays) {
    traccert_stat.AddTick("*CHK (full check direct or async items)", delays.check_delay);

    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV", delays.check_delay - delays.resolv_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RBLRUL", delays.check_delay - delays.rblrule_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo SPST", delays.check_delay - delays.spamstat_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo LONGSTOR", delays.check_delay - delays.longstorage_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & RBLRUL", delays.check_delay - delays.resolv_delay - delays.rblrule_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & SPST", delays.check_delay - delays.resolv_delay - delays.spamstat_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & LONGSTOR", delays.check_delay - delays.resolv_delay - delays.longstorage_delay);
    traccert_stat_forecast.AddTick("*DEBUG: CHK wo RSLV & RBLRUL & SPST & LONGSTOR", delays.check_delay - delays.resolv_delay - delays.rblrule_delay - delays.spamstat_delay - delays.longstorage_delay);

    if (delays.is_changepass)
        traccert_stat.AddTick("*REQTYPE (change password / register) <b>[CNT]</b>", 0);
    else
        traccert_stat.AddTick("*REQTYPE (change password / register) <b>[CNT]</b>", 3);

    if (delays.is_ipv6)
        traccert_stat.AddTick("*IPTYPE (ipv6 / ipv4) <b>[CNT]</b>", 0);
    else
        traccert_stat.AddTick("*IPTYPE (ipv6 / ipv4) <b>[CNT]</b>", 3);

    traccert_stat.AddTick("FW:FLTRGET", delays.filterget_delay);
    traccert_stat.AddTick("FW:FLTRWRK1 (wo ML)", delays.filterwork_delay1step);
    traccert_stat.AddTick("FW:FLTRWRK2 (with MO)", delays.filterwork_delay2step);
    traccert_stat.AddTick("FW:WRTDLV (write dlv-log)", delays.writedlvlog_delay);

    if (delays.spamstat_delay_pr) {
        traccert_stat.AddTick("SPST01_FULLTIME", delays.spamstat_delay);
        traccert_stat.AddTick("SPST02_WAITITEM", delays.spamstat_delay_wait_item);
        traccert_stat.AddTick("SPST03_CONNECT", delays.spamstat_delay_connect);
        traccert_stat.AddTick("SPST04_REQUEST", delays.spamstat_delay_request);
        traccert_stat.AddTick("SPST05_WRITELOG", delays.spamstat_delay_writelog);
        if (delays.spamstat_badrequest)
            traccert_stat.AddTick("SPST07_(bad request) <b>[CNT]</b>", 0);

        if (delays.spamstat_delay_exist)
            traccert_stat.AddTick("SPST08_(exist_data) <b>[CNT]</b>", 0);
        if (delays.spamstat_today_ban)
            traccert_stat.AddTick("SPST09_(today_ban) <b>[CNT]</b>", 0);
        if (delays.spamstat_yesterday_ban)
            traccert_stat.AddTick("SPST10_(yesterday_ban) <b>[CNT]</b>", 0);
        if (delays.spamstat_exist_host)
            traccert_stat.AddTick("SPST11_(exist_host) <b>[CNT]</b>", 0);
        if (delays.spamstat_exist_geo)
            traccert_stat.AddTick("SPST12_(exist_geo) <b>[CNT]</b>", 0);
    }
    if (delays.cluster_was_request) {
        traccert_stat.AddTick("CLUST1_FULLTIME", delays.cluster_delay);
        traccert_stat.AddTick("CLUST2_WAITITEM", delays.cluster_delay_wait_item);
        traccert_stat.AddTick("CLUST3_CONNECT", delays.cluster_delay_connect);
        traccert_stat.AddTick("CLUST4_REQUEST", delays.cluster_delay_request);
        traccert_stat.AddTick("CLUST5_WRITELOG", delays.cluster_delay_writelog);
        if (delays.cluster_delay_exist)
            traccert_stat.AddTick("CLUST6_(exist_data) <b>[CNT]</b>", 0);
        if (delays.cluster_badrequest)
            traccert_stat.AddTick("CLUST7_(bad request) <b>[CNT]</b>", 0);
    }
    if (delays.geo_delay_pr)
        traccert_stat.AddTick("GEO", delays.geo_delay);
    if (delays.geo_delay_ok)
        traccert_stat.AddTick("GEO_OK <b>[CNT]</b>", 0);
    if (delays.geo_delay_ru)
        traccert_stat.AddTick("GEO_RU <b>[CNT]", 0);

    if (delays.pdd_delay_pr)
        traccert_stat.AddTick("PDD", delays.pdd_delay);
    if (delays.bbox_delay_pr)
        traccert_stat.AddTick("BBOX", delays.bbox_delay);

    if (delays.rblrule_delay_pr)
        traccert_stat.AddTick("RBLRUL", delays.rblrule_delay);
    std::list<TString>::const_iterator rit = delays.rblrule_list.begin();
    while (rit != delays.rblrule_list.end()) {
        traccert_stat.AddTick("RBLRUL_" + (*rit) + " <b>[CNT]</b>", 0);

        ++rit;
    }

    if (delays.resolv_delay_pr)
        traccert_stat.AddTick("RSLV", delays.resolv_delay);
    if (delays.resolv_delay_ok)
        traccert_stat.AddTick("RSLV OK <b>[CNT]</b>", 0);
    if (delays.host_from_tycache)
        traccert_stat.AddTick("RSLV (HOST_FROM_TYCACHE) <b>[CNT]</b>", 0);

    traccert_stat.AddTick("LST", delays.lst_delay);
    if (delays.is_black_login)
        traccert_stat.AddTick("LST_BLACKIP <b>[CNT]</b>", 0);
    if (delays.is_white_login)
        traccert_stat.AddTick("LST_WHITEIP <b>[CNT]</b>", 0);
    if (delays.is_trust_login)
        traccert_stat.AddTick("LST_TRUSTIP <b>[CNT]</b>", 0);
    if (delays.is_whiteso_login)
        traccert_stat.AddTick("LST_WHITESOIP <b>[CNT]</b>", 0);
    if (delays.is_intranetzone_login)
        traccert_stat.AddTick("LST_INTRANETZONEIP <b>[CNT]</b>", 0);
    if (delays.is_trustedzone_login)
        traccert_stat.AddTick("LST_TRUSTEDZONEIP <b>[CNT]</b>", 0);
    if (delays.is_localzone_login)
        traccert_stat.AddTick("LST_LOCALZONEIP <b>[CNT]</b>", 0);
    if (delays.is_grupped_ip)
        traccert_stat.AddTick("LST_GRUPPEDIP <b>[CNT]</b>", 0);
    if (delays.is_ungrupped_ip)
        traccert_stat.AddTick("LST_UNGRUPPEDIP <b>[CNT]</b>", 0);

    if (delays.nameslst_delay_pr) {
        traccert_stat.AddTick("NAMES_LST", delays.nameslst_delay);
        if (delays.nameslst_inamenum > 0)
            traccert_stat.AddTick("NAMES_LST (find iname) <b>[CNT]</b>", 0);
        if (delays.nameslst_fnamenum > 0)
            traccert_stat.AddTick("NAMES_LST (find fname) <b>[CNT]</b>", 0);
    }

    traccert_stat.AddTick("LONGSTORAGE_GET", delays.longstorage_delay);
    traccert_stat.AddTick("SHORTSTOR_GET", delays.getshortstorage_delay);
    traccert_stat.AddTick("SUMMARY (count by last 300 and 1200 sec)", delays.summary_delay);

    if (delays.backalg_delay_pr)
        traccert_stat.AddTick("BACKALG", delays.backalg_delay);
    if (delays.backalg_LoginResemblance)
        traccert_stat.AddTick("BACKALG(1)_LoginResemblance <b>[CNT]</b>", 0);
    if (delays.backalg_HintPasswAnswer)
        traccert_stat.AddTick("BACKALG(2)_HintPasswAnswer <b>[CNT]</b>", 0);
    if (delays.backalg_3min)
        traccert_stat.AddTick("BACKALG(4)_3min <b>[CNT]</b>", 0);
    if (delays.backalg_PacketTwo)
        traccert_stat.AddTick("BACKALG(5)_PacketTwo <b>[CNT]</b>", 0);
    if (delays.backalg_CompareIFNames)
        traccert_stat.AddTick("BACKALG(6)_CompareIFNames <b>[CNT]</b>", 0);

    if (delays.upd_longstorage_delay_pr)
        traccert_stat.AddTick("LONGSTORAGE_UPDATE", delays.upd_longstorage_delay);

    traccert_stat.AddTick("ML1_FULLTIME (request to ML-server)", delays.ml_delay);
    traccert_stat.AddTick("ML2_WAITITEM", delays.ml_delay_wait_item);
    traccert_stat.AddTick("ML3_CONNECT", delays.ml_delay_connect);
    traccert_stat.AddTick("ML4_REQUEST", delays.ml_delay_request);
    traccert_stat.AddTick("ML5_WRITELOG", delays.ml_delay_writelog);
    if (delays.ml_delay_err)
        traccert_stat.AddTick("ML7_(bad request) <b>[CNT]</b>", 0);

    traccert_stat.AddTick("MLYT (write mlyt-log)", delays.mlyt_delay);
    if (delays.dublicat_delay_pr)
        traccert_stat.AddTick("*DUBLICAT_LOGIN", delays.dublicat_delay);

    if (delays.packet1notnull)
        traccert_stat.AddTick("PACKETS NOT NULL (1,2,3,4,5) <b>[CNT]</b>", 0);
    if (delays.packet2notnull)
        traccert_stat.AddTick("PACKETS NOT NULL (1,2,3,4,5) <b>[CNT]</b>", 3);
    if (delays.packet3notnull)
        traccert_stat.AddTick("PACKETS NOT NULL (1,2,3,4,5) <b>[CNT]</b>", 7);
    if (delays.packet4notnull)
        traccert_stat.AddTick("PACKETS NOT NULL (1,2,3,4,5) <b>[CNT]</b>", 15);
    if (delays.packet5notnull)
        traccert_stat.AddTick("PACKETS NOT NULL (1,2,3,4,5) <b>[CNT]</b>", 30);

    traccert_result_stat.AddStatusWoML(delays.result_woml_spam);
    traccert_result_stat.AddStatusWithML(delays.result_ml_spam);
    traccert_result_stat.AddStatusFinal(delays.result_spam);

    if (delays.set_ham_to_spam_by_ml)
        traccert_result_stat.AddStatusHamToSpamByML(0);
    if (delays.set_malic_to_spam_by_ml)
        traccert_result_stat.AddStatusMalicToSpamByML(0);
    if (delays.set_spam_to_ham_by_ml)
        traccert_result_stat.AddStatusSpamToHamByML(0);
    if (delays.set_malic_to_ham_by_ml)
        traccert_result_stat.AddStatusMalicToHamByML(0);

    if (delays.set_ham_to_spam_finalres)
        traccert_result_stat.AddStatusHamToSpamFinal(0);
    if (delays.set_ham_to_malic_finalres)
        traccert_result_stat.AddStatusHamToMalicFinal(0);
    if (delays.set_spam_to_ham_finalres)
        traccert_result_stat.AddStatusSpamToHamFinal(0);
    if (delays.set_spam_to_malic_finalres)
        traccert_result_stat.AddStatusSpamToMalicFinal(0);
    if (delays.set_malic_to_ham_finalres)
        traccert_result_stat.AddStatusMalicToHamFinal(0);
    if (delays.set_malic_to_spam_finalres)
        traccert_result_stat.AddStatusMalicToSpamFinal(0);

    //debug
    traccert_stat_debug.AddTick("01.FW:FLTRGET", delays.filterget_delay);
    if (delays.filterwork_check_field_tick)
        traccert_stat_debug.AddTick("02.FW:CHECK_FIELD (wo ML)", delays.filterwork_check_field_tick_ms);
    if (delays.filterwork_prepare)
        traccert_stat_debug.AddTick("03.FW:PREPARE (wo ML)", delays.filterwork_prepare_ms);
    if (delays.filterwork_check_message_tick)
        traccert_stat_debug.AddTick("04.FW:CHECK_MESSAGE (wo ML)", delays.filterwork_check_message_tick_ms);
    traccert_stat_debug.AddTick("05.FW:FLTRWRK1 (wo ML)", delays.filterwork_delay1step);
    auto it = delays.sp_traccert.begin();
    while (it != delays.sp_traccert.end()) {
        traccert_stat_debug.AddTick("06.FW:CHECK_MESSAGE_TRACCERT_" + IntToStroka2(it->m_index), it->m_delay_ms);
        ++it;
    }

    if (delays.filterwork_check_field_tick_ml)
        traccert_stat_debug.AddTick("11.FW:CHECK_FIELD (with MO)", delays.filterwork_check_field_tick_ml_ms);
    if (delays.filterwork_prepare_ml)
        traccert_stat_debug.AddTick("12.FW:PREPARE (with MO)", delays.filterwork_prepare_ml_ms);
    if (delays.filterwork_check_message_tick_ml)
        traccert_stat_debug.AddTick("13F.W:CHECK_MESSAGE (with MO)", delays.filterwork_check_message_tick_ml_ms);
    traccert_stat_debug.AddTick("14.FW:FLTRWRK2 (with MO)", delays.filterwork_delay2step);
    auto itml = delays.sp_traccert_ml.begin();
    while (itml != delays.sp_traccert_ml.end()) {
        traccert_stat_debug.AddTick("15.FW:CHECK_MESSAGE_TRACCERT_ML_" + IntToStroka2(itml->m_index), itml->m_delay_ms);
        ++itml;
    }
}

TResStruct TGeneralObject::CheckAsync(TReqParams* pReqParams, const TString& Numbrequest, bool& is_upstream_requestA, const TString& source_request, TSpamonLogStruct& monlogdata) {
    TResStruct res = TResStruct();

    TString headerslog = "";
    TString answ = "";
    TString answ_log = "";
    float srvc_rating = 0;
    ui8 main_weight = 0;
    int addlogincount = 0;
    ui64 responce_hash = 0;
    TRateSrvc::TTypeInstance type_instance = TRateSrvc::TI_STANDART;

    if (GetRateObj() != NULL) {
        srvc_rating = GetRateObj()->AddRequest1();

        type_instance = GetRateObj()->GetTypeInstance();

        switch (type_instance) {
            case TRateSrvc::TI_STANDART:
                if (is_upstream_requestA) {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = true;
                    m_return_upstream_version = true;
                    m_SetMinorStatusMutex.Release();

                } else {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = false;
                    m_return_upstream_version = false;
                    m_SetMinorStatusMutex.Release();
                }
                break;
            case TRateSrvc::TI_MINOR_FOREVER:
                srvc_rating = 0;
                is_upstream_requestA = false;

                m_SetMinorStatusMutex.Acquire();
                m_obrab_upstream_version = false;
                m_return_upstream_version = false;
                m_SetMinorStatusMutex.Release();
                break;
            case TRateSrvc::TI_DEBUG:
                srvc_rating = 0;
                is_upstream_requestA = false;

                m_SetMinorStatusMutex.Acquire();
                m_obrab_upstream_version = true;
                m_return_upstream_version = false;
                m_SetMinorStatusMutex.Release();
                break;
            case TRateSrvc::TI_READONLY:
                if (is_upstream_requestA) {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = false;
                    m_return_upstream_version = true;
                    m_SetMinorStatusMutex.Release();

                } else {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = false;
                    m_return_upstream_version = false;
                    m_SetMinorStatusMutex.Release();
                }
                break;
        };
    }

    m_SetMinorStatusMutex.Acquire();
    if (m_obrab_upstream_version || m_return_upstream_version)
        m_major_request_count = IncMax32(m_major_request_count, 1);
    else
        m_minor_request_count = IncMax32(m_minor_request_count, 1);
    m_SetMinorStatusMutex.Release();

    if (m_async_check != NULL)
        m_async_check->AddCheck(TAsyncCheckStruct(pReqParams, Numbrequest, /*is_upstream_request*/ m_obrab_upstream_version, /*is_upstream_request*/ m_return_upstream_version, CShingleTime::GetMs()), source_request, monlogdata);

    headerslog = headerslog + "RATE: " + FloatToStr0(srvc_rating);
    headerslog = headerslog + ", TYPEINST: " + InstanceTypeToStroka(type_instance);
    headerslog = headerslog + ", HASHONE: " + IntToStroka(main_weight);
    headerslog = headerslog + ", HASHTWO: " + ShingleToStroka2(responce_hash);

    addlogincount = 40; //��������� ����� ����������� ��������, �� ������� �� ���� ��������� (������ ��� ��������, ����� �� ������� ����� ����� ��������)
    if ((/*is_upstream_request*/ m_return_upstream_version) && (GetRCP() != NULL) && (GetRCP()->EnableReceipt()) && (addlogincount > 0)) {
        KRCPClass::DoubleTString ws = GetRCP()->GetLogins(addlogincount);
        answ = answ + EncodeLoginToUTF8(ws.m_answer);
        answ_log = answ_log + ws.m_log;
    }

    answ_log = "<spamlist>" + answ_log + "</spamlist>";
    answ = "<spamlist>" + answ + "</spamlist>";

    res.m_code = 200;
    res.m_result_str = HTTP_200_OK_TextXMLUTF8(srvc_rating, type_instance, main_weight, responce_hash) + answ;

    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSendAnswerLog(m_return_upstream_version) != NULL))
        GetLogsGroup()->GetSendAnswerLog(m_return_upstream_version)->WriteMessageAndDataStatus(KMESSAGE, "%s %s %s", Numbrequest.c_str(), answ_log.c_str(), headerslog.c_str());

    return res;
}

TResStruct TGeneralObject::CheckAsyncDo(TAsyncCheckStruct& data_from_queue) {
    ui32 mr_asynccheck_tick = CShingleTime::GetMs();
    TResStruct res = TResStruct();
    ui32 get_queue_tick = 0;
    TSpamonLogStruct monlogdata;
    ui32 tick = 0;
    TSpamonLogStruct::TError err_type = TSpamonLogStruct::UNKNOWN;

    tick = CShingleTime::GetMs();
    monlogdata.Init(GetServerHostName(), data_from_queue.Numbrequest);

    get_queue_tick = CShingleTime::GetMs() - data_from_queue.createtime;
    err_type = TSpamonLogStruct::OK;
    monlogdata.AddTag("FRODO", "QG", err_type, get_queue_tick);

    TReqParams* pReqParams = &data_from_queue.ReqParams;
    TString Numbrequest = data_from_queue.Numbrequest;
    bool obrab_upstream_request = data_from_queue.is_obrab_upstream_request;
    bool return_upstream_request = data_from_queue.is_return_upstream_request;
    TRulesList m_RulesList;
    ui32 ttt = 0;
    TDelayClass delays;
    TRequestInfo ReqInfo;
    bool Spam = false;
    bool allowuser = false;
    TString loginlistlog = "";
    TString answ_log = "";
    ui8 main_weight = 0;

    ui32 ttt_full = CShingleTime::GetMs();

    ReqInfo.messnumb = Numbrequest;
    ttt = CShingleTime::GetMs();

    if (m_filter.Check(1, pReqParams, m_RulesList, Spam, delays, ReqInfo, allowuser, Numbrequest, obrab_upstream_request, res.m_longdatarqstinfo, monlogdata, m_correct_login_enable, m_LoginWeightObj)) {
        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayCheck(ttt);

        //correct logins weigth
        CorrectLoginsWeight(Numbrequest, ReqInfo);

        //next
        AddTraccertData(delays); //traccert

        loginlistlog = loginlistlog + "LOGINS: ";
        if (ReqInfo.SpamList.size() == 0) {
            loginlistlog = loginlistlog + "'" + ReqInfo.mainlogin + "'=" + IntToStroka(ReqInfo.weigth);

            WriteKPIData(ReqInfo.mainlogin, ReqInfo.uid, ReqInfo.weigth, 0, ReqInfo.ip, ReqInfo.passpreqtype, ReqInfo.passpreqtype_s, Numbrequest);

        } else {
            TPassportRequestType reqtype = ReqInfo.passpreqtype;

            TExpList::iterator it = ReqInfo.SpamList.begin();
            while (it != ReqInfo.SpamList.end()) {
                if (IsChangePass(reqtype)) {
                    answ_log = answ_log + "<change_pass login=\"" + (*it).login() + "\" weight=\"" + (*it).weights() + "\"" + (*it).pdds() + " />";

                } else {
                    answ_log = answ_log + "<spam_user login=\"" + (*it).login() + "\" weight=\"" + (*it).weights() + "\"" + (*it).pdds() + " />";
                }

                if (it == ReqInfo.SpamList.begin())
                    loginlistlog = loginlistlog + "'" + (*it).login() + "'=" + (*it).weights() + "(" + IntToStroka((*it).backalg()) + ")";
                else
                    loginlistlog = loginlistlog + ", '" + (*it).login() + "'=" + (*it).weights() + "(" + IntToStroka((*it).backalg()) + ")";

                if ((return_upstream_request) && (GetRCP() != NULL) && (GetRCP()->EnableReceipt())) //��������� ����� ������ ��� ��������, ����� �� ������� ����� ����� ��������
                    GetRCP()->AddLogin((*it).login(), (*it).weights(), reqtype, ReqInfo.passpreqtype_s);

                if ((*it).backalg() == 0)
                    WriteKPIData((*it).login(), IntToStroka((*it).uid()), (*it).weight(), (*it).backalg(), ReqInfo.ip, ReqInfo.passpreqtype, ReqInfo.passpreqtype_s, Numbrequest);
                else
                    WriteKPIData((*it).login(), IntToStroka((*it).uid()), (*it).weight(), (*it).backalg(), ReqInfo.ip, TP_UNKNOWN, "-", "-");

                ++it;
            }
        }

        main_weight = ReqInfo.weigth;

        loginlistlog = loginlistlog + ", ";
        loginlistlog = loginlistlog + "REQTYPE: " + TPassportRequestTypeToTString(ReqInfo.passpreqtype, ReqInfo.passpreqtype_s) + ", ";
        if (allowuser)
            loginlistlog = loginlistlog + "ALLOW, ";
        loginlistlog = loginlistlog + "IP: " + ReqInfo.ip + " (HOST='" + ReqInfo.host + "', GEO='" + ReqInfo.geo + "'), ";
        loginlistlog = loginlistlog + "MESSNUMB: " + ReqInfo.messnumb;

        ReqInfo.SpamList.clear();

        ttt_full = CShingleTime::GetMs() - ttt_full;
        delays.SetDelayFull(ttt_full);

        answ_log = "<spamlist>" + answ_log + "</spamlist>";

        res.m_code = 200;
        res.m_result_str = "";

        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetAsyncSendAnswerLog(return_upstream_request) != NULL))
            GetLogsGroup()->GetAsyncSendAnswerLog(return_upstream_request)->WriteMessageAndDataStatus(KMESSAGE, "%s %s %s", ReqInfo.messnumb.c_str(), answ_log.c_str(), delays.GetReport2().c_str());

        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetIPHistoryLog() != NULL))
            GetLogsGroup()->GetIPHistoryLog()->WriteMessageAndData("%s", loginlistlog.c_str());

        if ((IsChangePass(ReqInfo.passpreqtype)) && (GetLogsGroup() != NULL) && (GetLogsGroup()->ChangePasswdLog(data_from_queue.is_return_upstream_request) != NULL))
            GetLogsGroup()->ChangePasswdLog(data_from_queue.is_return_upstream_request)->WriteMessage("%10u %10s %18s %40s %6d   %s\n", ReqInfo.regrime, ReqInfo.uid.c_str(), ReqInfo.ip_log.c_str(), ReqInfo.mainlogin.c_str(), ReqInfo.weigth, ReqInfo.messnumb.c_str());

    } else {
        res.m_code = 400;
        res.m_result_str = "";
        traccert_stat.AddTick("*CODE_400", ttt);

        tick = CShingleTime::GetMs() - tick;
        err_type = TSpamonLogStruct::CODE400;
        monlogdata.AddTag("FRODO", "ACHK", err_type, tick);
    }

    mr_asynccheck_tick = CShingleTime::GetMs() - mr_asynccheck_tick;
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSpamonLog(data_from_queue.is_return_upstream_request) != NULL))
        GetLogsGroup()->GetSpamonLog(data_from_queue.is_return_upstream_request)->WriteMessage("%s\n", monlogdata.GetDataLog(mr_asynccheck_tick).c_str());

    return res;
}

TResStruct TGeneralObject::Check(TReqParams* pReqParams, const TString& Numbrequest, bool& is_upstream_request, const TString& source_request, TSpamonLogStruct& monlogdata) {
    TResStruct res = TResStruct();

    ui32 ttt = CShingleTime::GetMs();

    if (UseAsyncCheckMode())
        res = CheckAsync(pReqParams, Numbrequest, is_upstream_request, source_request, monlogdata);
    else
        res = CheckDirect(pReqParams, Numbrequest, is_upstream_request, monlogdata);

    ttt = CShingleTime::GetMs() - ttt;
    traccert_stat.AddTick("*AAA(FULL_CHECK)", ttt);

    return res;
}

void TGeneralObject::CorrLW(const TString& NumbRequest, const TString& login, ui8& weigth) {
    ui64 login_shingle = 0;
    ui8 val = 0;

    if (m_correct_login_enable) {
        if (!login.empty()) {
            login_shingle = ShingleFromStroka(login);
            if (login_shingle != 0) {
                val = 0;
                if (m_LoginWeightObj.Get(login_shingle, val)) {
                    if (weigth < val) {
                        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s CWL: '%s' %d->%d", NumbRequest.c_str(), login.c_str(), weigth, val);

                        weigth = val;
                        //ReqInfo.weigth_corr = true;
                    } else if (weigth > val) {
                        m_LoginWeightObj.Remove(login_shingle);
                        m_LoginWeightObj.Add(login_shingle, weigth);
                    }
                } else {
                    m_LoginWeightObj.Add(login_shingle, weigth);
                }
            }
        }
    }
}

void TGeneralObject::CorrectLoginsWeight(const TString& NumbRequest, TRequestInfo& ReqInfo) {
    if (m_correct_login_enable) {
        if (!IsChangePass(ReqInfo.passpreqtype)) {
            //main login
            CorrLW(NumbRequest, ReqInfo.mainlogin, ReqInfo.weigth);

            //others logins
            auto it = ReqInfo.SpamList.begin();
            while (it != ReqInfo.SpamList.end()) {
                CorrLW(NumbRequest, (*it).login(), (*it).fweight);

                ++it;
            }
        }
    }
}


TResStruct TGeneralObject::CheckDirect(TReqParams* pReqParams, const TString& Numbrequest, bool& is_upstream_requestA, TSpamonLogStruct& monlogdata) {
    TResStruct res = TResStruct();

    ui32 ttt = 0;
    TDelayClass delays;
    TRequestInfo ReqInfo;
    TString loginlistlog = "";
    TString headerslog = "";
    TString answ = "";
    TString answ_log = "";
    float srvc_rating = 0;
    ui8 main_weight = 0;
    bool Spam = false;
    bool allowuser = false;
    int addlogincount = 0;
    ui64 responce_hash = 0;
    TRulesList m_RulesList;
    TRateSrvc::TTypeInstance type_instance = TRateSrvc::TI_STANDART;
    ui32 check_tick = CShingleTime::GetMs();

    if (GetRateObj() != NULL) {
        srvc_rating = GetRateObj()->AddRequest1();

        type_instance = GetRateObj()->GetTypeInstance();

        switch (type_instance) {
            case TRateSrvc::TI_STANDART:
                if (is_upstream_requestA) {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = true;
                    m_return_upstream_version = true;
                    m_SetMinorStatusMutex.Release();

                } else {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = false;
                    m_return_upstream_version = false;
                    m_SetMinorStatusMutex.Release();
                }
                break;
            case TRateSrvc::TI_MINOR_FOREVER:
                srvc_rating = 0;
                is_upstream_requestA = false;

                m_SetMinorStatusMutex.Acquire();
                m_obrab_upstream_version = false;
                m_return_upstream_version = false;
                m_SetMinorStatusMutex.Release();
                break;
            case TRateSrvc::TI_DEBUG:
                srvc_rating = 0;
                is_upstream_requestA = false;

                m_SetMinorStatusMutex.Acquire();
                m_obrab_upstream_version = true;
                m_return_upstream_version = false;
                m_SetMinorStatusMutex.Release();
                break;
            case TRateSrvc::TI_READONLY:
                if (is_upstream_requestA) {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = false;
                    m_return_upstream_version = true;
                    m_SetMinorStatusMutex.Release();

                } else {
                    m_SetMinorStatusMutex.Acquire();
                    m_obrab_upstream_version = false;
                    m_return_upstream_version = false;
                    m_SetMinorStatusMutex.Release();
                }
                break;
        };
    }

    ui32 ttt_full = CShingleTime::GetMs();

    ReqInfo.messnumb = Numbrequest;
    ttt = CShingleTime::GetMs();

    m_SetMinorStatusMutex.Acquire();
    if (m_obrab_upstream_version || m_return_upstream_version)
        m_major_request_count = IncMax32(m_major_request_count, 1);
    else
        m_minor_request_count = IncMax32(m_minor_request_count, 1);
    m_SetMinorStatusMutex.Release();

    if (m_filter.Check(1, pReqParams, m_RulesList, Spam, delays, ReqInfo, allowuser, Numbrequest, /*is_upstream_request*/ m_obrab_upstream_version, res.m_longdatarqstinfo, monlogdata, m_correct_login_enable, m_LoginWeightObj)) {
        ttt = CShingleTime::GetMs() - ttt;
        delays.SetDelayCheck(ttt);

        //correct logins weigth
        CorrectLoginsWeight(Numbrequest, ReqInfo);

        //next
        AddTraccertData(delays); //traccert

        loginlistlog = loginlistlog + "LOGINS: ";
        if (ReqInfo.SpamList.size() == 0) {
            loginlistlog = loginlistlog + "'" + ReqInfo.mainlogin + "'=" + IntToStroka(ReqInfo.weigth);

            WriteKPIData(ReqInfo.mainlogin, ReqInfo.uid, ReqInfo.weigth, 0, ReqInfo.ip, ReqInfo.passpreqtype, ReqInfo.passpreqtype_s, Numbrequest);

        } else {
            TPassportRequestType reqtype = ReqInfo.passpreqtype;

            TExpList::iterator it = ReqInfo.SpamList.begin();
            while (it != ReqInfo.SpamList.end()) {
                if (IsChangePass(reqtype)) {
                    answ = answ + "<change_pass login=\"" + EncodeLoginToUTF8((*it).login()) + "\" weight=\"" + (*it).weights() + "\"" + (*it).pdds() + " />";
                    answ_log = answ_log + "<change_pass login=\"" + (*it).login() + "\" weight=\"" + (*it).weights() + "\"" + (*it).pdds() + " />";
                } else {
                    answ = answ + "<spam_user login=\"" + EncodeLoginToUTF8((*it).login()) + "\" weight=\"" + (*it).weights() + "\"" + (*it).pdds() + " />";
                    answ_log = answ_log + "<spam_user login=\"" + (*it).login() + "\" weight=\"" + (*it).weights() + "\"" + (*it).pdds() + " />";
                }

                if (it == ReqInfo.SpamList.begin())
                    loginlistlog = loginlistlog + "'" + (*it).login() + "'=" + (*it).weights() + "(" + IntToStroka((*it).backalg()) + ")";
                else
                    loginlistlog = loginlistlog + ", '" + (*it).login() + "'=" + (*it).weights() + "(" + IntToStroka((*it).backalg()) + ")";

                if ((/*is_upstream_request*/ m_return_upstream_version) && (GetRCP() != NULL) && (GetRCP()->EnableReceipt())) //��������� ����� ������ ��� ��������, ����� �� ������� ����� ����� ��������
                    GetRCP()->AddLogin((*it).login(), (*it).weights(), reqtype, ReqInfo.passpreqtype_s);

                if ((*it).backalg() == 0)
                    WriteKPIData((*it).login(), IntToStroka((*it).uid()), (*it).weight(), (*it).backalg(), ReqInfo.ip, ReqInfo.passpreqtype, ReqInfo.passpreqtype_s, Numbrequest);
                else
                    WriteKPIData((*it).login(), IntToStroka((*it).uid()), (*it).weight(), (*it).backalg(), ReqInfo.ip, TP_UNKNOWN, "-", "-");

                ++it;
            }
        }

        main_weight = ReqInfo.weigth;
        if (!answ.empty()) {
            char sshingle[32];
            TString stemp = answ;

            memset(sshingle, 0, sizeof(sshingle));
            calc_strcrc64(stemp.c_str(), stemp.size(), sshingle);
            sscanf(sshingle, "%lx", &responce_hash);
        }
        headerslog = headerslog + "RATE: " + FloatToStr0(srvc_rating);
        headerslog = headerslog + ", TYPEINST: " + InstanceTypeToStroka(type_instance);
        headerslog = headerslog + ", HASHONE: " + IntToStroka(main_weight);
        headerslog = headerslog + ", HASHTWO: " + ShingleToStroka2(responce_hash);

        loginlistlog = loginlistlog + ", ";
        loginlistlog = loginlistlog + "REQTYPE: " + TPassportRequestTypeToTString(ReqInfo.passpreqtype, ReqInfo.passpreqtype_s) + ", ";
        if (allowuser)
            loginlistlog = loginlistlog + "ALLOW, ";
        loginlistlog = loginlistlog + "IP: " + ReqInfo.ip + " (HOST='" + ReqInfo.host + "', GEO='" + ReqInfo.geo + "'), ";
        loginlistlog = loginlistlog + "MESSNUMB: " + ReqInfo.messnumb;

        //answ_log = answ;
        addlogincount = 40 - ReqInfo.SpamList.size(); //��������� ����� ����������� ��������, �� ������� �� ���� ��������� (������ ��� ��������, ����� �� ������� ����� ����� ��������)
        if ((/*is_upstream_request*/ m_return_upstream_version) && (GetRCP() != NULL) && (GetRCP()->EnableReceipt()) && (addlogincount > 0)) {
            KRCPClass::DoubleTString ws = GetRCP()->GetLogins(addlogincount);
            answ = answ + EncodeLoginToUTF8(ws.m_answer);
            answ_log = answ_log + ws.m_log;
        }

        ReqInfo.SpamList.clear();

        ttt_full = CShingleTime::GetMs() - ttt_full;
        delays.SetDelayFull(ttt_full);

        answ_log = "<spamlist>" + answ_log + "</spamlist>";
        answ = "<spamlist>" + answ + "</spamlist>";

        res.m_code = 200;
        res.m_result_str = HTTP_200_OK_TextXMLUTF8(srvc_rating, type_instance, main_weight, responce_hash) + answ;

        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSendAnswerLog(m_return_upstream_version) != NULL))
            GetLogsGroup()->GetSendAnswerLog(m_return_upstream_version)->WriteMessageAndDataStatus(KMESSAGE, "%s %s %s %s", ReqInfo.messnumb.c_str(), answ_log.c_str(), delays.GetReport2().c_str(), headerslog.c_str());

        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetIPHistoryLog() != NULL))
            GetLogsGroup()->GetIPHistoryLog()->WriteMessageAndData("%s", loginlistlog.c_str());

        if ((IsChangePass(ReqInfo.passpreqtype)) && (GetLogsGroup() != NULL) && (GetLogsGroup()->ChangePasswdLog(m_return_upstream_version) != NULL))
            GetLogsGroup()->ChangePasswdLog(m_return_upstream_version)->WriteMessage("%10u %10s %18s %40s %6d   %s\n", ReqInfo.regrime, ReqInfo.uid.c_str(), ReqInfo.ip_log.c_str(), ReqInfo.mainlogin.c_str(), ReqInfo.weigth, ReqInfo.messnumb.c_str());

    } else {
        res.m_code = 400;
        res.m_result_str = "";
        traccert_stat.AddTick("*CODE_400", ttt);
    }

    check_tick = CShingleTime::GetMs() - check_tick;
    if ((LogsGroup != NULL) && (check_tick >= (ui32)LogsGroup->GetLongrequestTreshold()) && (LogsGroup->GetServerLog() != NULL))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "LONGCHK %u %s %s", check_tick, ReqInfo.messnumb.c_str(), delays.GetReport2().c_str());

    return res;
}

void TGeneralObject::WriteKPIData(const TString& login, const TString& uid, int weight, int backalg, const TString& ips, TPassportRequestType reqtype, const TString& reqtype_s, const TString& messnumb) {
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetAllReqstLog() != NULL)) {
        char buff[512];
        TString reqtype_fin = "";
        TString weight_fin = "";
        TString uid_fin = "";

        if (uid == "0")
            uid_fin = "-";
        else
            uid_fin = uid;

        reqtype_fin = TPassportRequestTypeToTString(reqtype, reqtype_s);

        if (weight != 0)
            weight_fin = IntToStroka(weight) + "(" + IntToStroka(backalg) + ")";
        else
            weight_fin = "0";

        snprintf(buff, sizeof(buff) - 1, "%50s %20s %16s %20s %50s %45s", login.c_str(), uid_fin.c_str(), weight_fin.c_str(), reqtype_fin.c_str(), ips.c_str(), messnumb.c_str());

        GetLogsGroup()->GetAllReqstLog()->WriteMessageAndData("%s", buff);
    }
}

TString TGeneralObject::EncodeLoginToUTF8(const TString& login) {
    TString res = "";

    if (!login.empty())
        res = Recode(CODES_WIN, CODES_UTF8, login);

    return res;
}

TString TGeneralObject::DecodeLoginFromUTF8(const TString& login) {
    TString res = "";

    if (!login.empty())
        res = Recode(CODES_UTF8, CODES_WIN, login);

    return res;
}

TSummaryStatistik TGeneralObject::GetStatistic() {
    TSummaryStatistik res;

    //res.trafficctrl_stat = TrafficControl.GetConsoleStat();

    //res.delays_stat = DelayObj.GetStat();

    if (GetFilter().GetFilterPool() != NULL)
        res.renginepool = GetFilter().GetFilterPool()->GetStat();

    GetFilter().GetStat(res.storage_counters);

    res.allow_user_count = GetFilter().AllowUserCount();

    if ((GetRCP() != NULL) && (GetRCP()->EnableReceipt()))
        res.rcpstat = GetRCP()->GetStat();
    else
        res.rcpstat = "disabled";

    return res;
}

TString TGeneralObject::GetLongStorCacheStatS() {
    TString res = "";

    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage)
        res = (storobj.storage)->GetLongStorCacheStatS();

    return res;
}

void TGeneralObject::GetLongStatAsFltr(frodo_st::TStorageDataType reqtype, TKIPv6 ip, ui64& shingle, TString& source, bool& stor_err, kday_t& day, i32& ham, i32& spam, i32& malic) {
    TGetStorStat storstat;
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageData storage_long_data;
        frodo_st::TStorageDataItemExt ipv = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IPADDRESS, "");
        frodo_st::TStorageDataItemExt iname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_INAME, "");
        frodo_st::TStorageDataItemExt fname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_FNAME, "");
        frodo_st::TStorageDataItemExt ifname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IFNAME, "");
        frodo_st::TStorageDataItemExt phone_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_PHONE, "");

        ham = 0;
        spam = 0;
        malic = 0;

        switch (reqtype) {
            case frodo_st::SDT_END:
                break;
            case frodo_st::SDT_IPADDRESS:
                ipv = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_INAME:
                iname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_FNAME:
                fname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_IFNAME:
                ifname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_PHONE:
                phone_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
        };

        storage_long_data.Init(ipv, iname_v, fname_v, ifname_v, phone_v);

        (storobj.storage)->GetLongDataFltr(storage_long_data, "-", storstat);

        stor_err = storage_long_data.m_data[reqtype].m_err;
        shingle = storage_long_data.m_data[reqtype].m_rec_shingle;
        source = storage_long_data.m_data[reqtype].m_stordata.GetSource();
        day = storage_long_data.m_data[reqtype].m_stordata.m_lastday;
        ham = storage_long_data.m_data[reqtype].m_stordata.m_ham;
        spam = storage_long_data.m_data[reqtype].m_stordata.m_spam85;
        malic = storage_long_data.m_data[reqtype].m_stordata.m_spam100;
    }
}

void TGeneralObject::GetLongStatStorage(frodo_st::TStorageDataType reqtype, TKIPv6 ip, ui64& shingle, TString& source, bool& stor_err, kday_t& day, i32& ham, i32& spam, i32& malic) {
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageData storage_long_data;
        frodo_st::TStorageDataItemExt ipv = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IPADDRESS, "");
        frodo_st::TStorageDataItemExt iname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_INAME, "");
        frodo_st::TStorageDataItemExt fname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_FNAME, "");
        frodo_st::TStorageDataItemExt ifname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IFNAME, "");
        frodo_st::TStorageDataItemExt phone_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_PHONE, "");

        ham = 0;
        spam = 0;
        malic = 0;

        switch (reqtype) {
            case frodo_st::SDT_END:
                break;
            case frodo_st::SDT_IPADDRESS:
                ipv = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_INAME:
                iname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_FNAME:
                fname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_IFNAME:
                ifname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_PHONE:
                phone_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
        };

        storage_long_data.Init(ipv, iname_v, fname_v, ifname_v, phone_v);

        (storobj.storage)->GetLongDataStorage(storage_long_data, "-");

        stor_err = storage_long_data.m_data[reqtype].m_err;
        shingle = storage_long_data.m_data[reqtype].m_rec_shingle;
        source = storage_long_data.m_data[reqtype].m_stordata.GetSource();
        day = storage_long_data.m_data[reqtype].m_stordata.m_lastday;
        ham = storage_long_data.m_data[reqtype].m_stordata.m_ham;
        spam = storage_long_data.m_data[reqtype].m_stordata.m_spam85;
        malic = storage_long_data.m_data[reqtype].m_stordata.m_spam100;
    }
}

void TGeneralObject::GetLongStatCache(frodo_st::TStorageDataType reqtype, TKIPv6 ip, ui64& shingle, TString& source, bool& stor_err, kday_t& day, i32& ham, i32& spam, i32& malic) {
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageData storage_long_data;
        frodo_st::TStorageDataItemExt ipv = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IPADDRESS, "");
        frodo_st::TStorageDataItemExt iname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_INAME, "");
        frodo_st::TStorageDataItemExt fname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_FNAME, "");
        frodo_st::TStorageDataItemExt ifname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IFNAME, "");
        frodo_st::TStorageDataItemExt phone_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_PHONE, "");

        ham = 0;
        spam = 0;
        malic = 0;

        switch (reqtype) {
            case frodo_st::SDT_END:
                break;
            case frodo_st::SDT_IPADDRESS:
                ipv = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_INAME:
                iname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_FNAME:
                fname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_IFNAME:
                ifname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_PHONE:
                phone_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
        };

        storage_long_data.Init(ipv, iname_v, fname_v, ifname_v, phone_v);

        (storobj.storage)->GetLongDataCache(storage_long_data, "-");

        stor_err = storage_long_data.m_data[reqtype].m_err;
        shingle = storage_long_data.m_data[reqtype].m_rec_shingle;
        source = storage_long_data.m_data[reqtype].m_stordata.GetSource();
        day = storage_long_data.m_data[reqtype].m_stordata.m_lastday;
        ham = storage_long_data.m_data[reqtype].m_stordata.m_ham;
        spam = storage_long_data.m_data[reqtype].m_stordata.m_spam85;
        malic = storage_long_data.m_data[reqtype].m_stordata.m_spam100;
    }
}

void TGeneralObject::CorrectLongStatIncr(frodo_st::TStorageDataType reqtype, TKIPv6 ip, const TString& source, bool& stor_err, kday_t day, i32 ham, i32 spam, i32 malic) {
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageData storage_long_data;
        frodo_st::TStorageDataItemExt ipv = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IPADDRESS, "");
        frodo_st::TStorageDataItemExt iname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_INAME, "");
        frodo_st::TStorageDataItemExt fname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_FNAME, "");
        frodo_st::TStorageDataItemExt ifname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IFNAME, "");
        frodo_st::TStorageDataItemExt phone_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_PHONE, "");

        switch (reqtype) {
            case frodo_st::SDT_END:
                break;
            case frodo_st::SDT_IPADDRESS:
                ipv = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_INAME:
                iname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_FNAME:
                fname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_IFNAME:
                ifname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_PHONE:
                phone_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
        };

        storage_long_data.Init(ipv, iname_v, fname_v, ifname_v, phone_v);

        (storobj.storage)->UpdateLongDataDirect(true, storage_long_data, "-", day, ham, spam, malic); //������, ����� �� �������������� �����!?

        switch (reqtype) {
            case frodo_st::SDT_END:
                break;
            case frodo_st::SDT_IPADDRESS:
                stor_err = ipv.m_err;
                break;
            case frodo_st::SDT_INAME:
                stor_err = iname_v.m_err;
                break;
            case frodo_st::SDT_FNAME:
                stor_err = fname_v.m_err;
                break;
            case frodo_st::SDT_IFNAME:
                stor_err = ifname_v.m_err;
                break;
            case frodo_st::SDT_PHONE:
                stor_err = phone_v.m_err;
                break;
        };
    }
}

void TGeneralObject::CorrectLongStatSet(frodo_st::TStorageDataType reqtype, TKIPv6 ip, const TString& source, bool& stor_err, kday_t day, i32 ham, i32 spam, i32 malic) {
    //if (m_filter != NULL)
    //   m_filter.CorrectLongDataSet(reqtype, ip, source, stor_err, day, ham, spam, malic);
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageData storage_long_data;
        frodo_st::TStorageDataItemExt ipv = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IPADDRESS, "");
        frodo_st::TStorageDataItemExt iname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_INAME, "");
        frodo_st::TStorageDataItemExt fname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_FNAME, "");
        frodo_st::TStorageDataItemExt ifname_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_IFNAME, "");
        frodo_st::TStorageDataItemExt phone_v = frodo_st::TStorageDataItemExt(TKIPv6(), frodo_st::SDT_PHONE, "");

        switch (reqtype) {
            case frodo_st::SDT_END:
                break;
            case frodo_st::SDT_IPADDRESS:
                ipv = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_INAME:
                iname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_FNAME:
                fname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_IFNAME:
                ifname_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
            case frodo_st::SDT_PHONE:
                phone_v = frodo_st::TStorageDataItemExt(ip, reqtype, source);
                break;
        };

        storage_long_data.Init(ipv, iname_v, fname_v, ifname_v, phone_v);

        (storobj.storage)->UpdateLongDataDirect(false, storage_long_data, "-", day, ham, spam, malic); //������, ����� �� �������������� �����!?

        switch (reqtype) {
            case frodo_st::SDT_END:
                break;
            case frodo_st::SDT_IPADDRESS:
                stor_err = ipv.m_err;
                break;
            case frodo_st::SDT_INAME:
                stor_err = iname_v.m_err;
                break;
            case frodo_st::SDT_FNAME:
                stor_err = fname_v.m_err;
                break;
            case frodo_st::SDT_IFNAME:
                stor_err = ifname_v.m_err;
                break;
            case frodo_st::SDT_PHONE:
                stor_err = phone_v.m_err;
                break;
        };
    }
}

void TGeneralObject::GetLongDataByShingleStorage(ui64 shingle, frodo_st::TStorageDataType& reqtype, TString& source, kday_t& day, i32& ham, i32& spam85, i32& spam100) {
    //if (m_filter != NULL)
    //   m_filter.GetLongDataByShingle(shingle, reqtype, source, day, ham, spam85, spam100);
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageDataItemExt value;

        reqtype = frodo_st::SDT_END;
        source = "";
        day = kday_t(static_cast<unsigned long>(0));
        ham = 0;
        spam85 = 0;
        spam100 = 0;

        if (shingle != 0) {
            (storobj.storage)->GetLongDataByShingleStorage(shingle, value, "-");
            //if (!value.m_stordata.Empty())
            {
                reqtype = value.m_stordata.m_stordata_type;
                source = TString(value.m_stordata.GetSource());
                day = value.m_stordata.m_lastday;
                ham = value.m_stordata.m_ham;
                spam85 = value.m_stordata.m_spam85;
                spam100 = value.m_stordata.m_spam100;
            }
        }
    }
}

void TGeneralObject::GetLongDataByShingleCache(ui64 shingle, frodo_st::TStorageDataType& reqtype, TString& source, kday_t& day, i32& ham, i32& spam85, i32& spam100) {
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageDataItemExt value;

        reqtype = frodo_st::SDT_END;
        source = "";
        day = kday_t(static_cast<unsigned long>(0));
        ham = 0;
        spam85 = 0;
        spam100 = 0;

        if (shingle != 0) {
            (storobj.storage)->GetLongDataByShingleCache(shingle, value, "-");
            //if (!value.m_stordata.Empty())
            {
                reqtype = value.m_stordata.m_stordata_type;
                source = TString(value.m_stordata.GetSource());
                day = value.m_stordata.m_lastday;
                ham = value.m_stordata.m_ham;
                spam85 = value.m_stordata.m_spam85;
                spam100 = value.m_stordata.m_spam100;
            }
        }
    }
}

void TGeneralObject::UpdateLongDataByShingle(ui64 shingle, frodo_st::TStorageDataType& reqtype, TString& source, kday_t day, i32 ham, i32 spam85, i32 spam100) {
    //if (m_filter != NULL)
    //   m_filter.UpdateLongDataByShingle(shingle, reqtype, source, day, ham, spam85, spam100);
    auto& storobj = m_StoragePool.GetStorageInfo(0, 0, 0, AT_UNKNOWN);
    if (storobj.storage) {
        frodo_st::TStorageDataItemExt value;

        if (shingle != 0) {
            value = frodo_st::TStorageDataItemExt(TKIPv6(), reqtype, source);
            value.m_rec_shingle = shingle;

            (storobj.storage)->UpdateLongDataByShingle(value, "-", day, ham, spam85, spam100);
        }
    }
}

bool TGeneralObject::PushToStorage() {
    bool res = false;
    bool busy = false;
    ui32 tick = 0;
    TString stat_str = "";
    pushbs::TPushDataToBasa* push_obj = NULL;

    m_PushStorMutex.Acquire();
    if (m_PushStorBusy) {
        busy = true;
        res = true;

    } else {
        busy = false;
        res = false;
        m_PushStorBusy = true;
    }
    m_PushStorMutex.Release();

    if (!busy) {
        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL)) {
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "LONGSTAT: start read dump!");
            GetLogsGroup()->GetServerLog()->FFlush();
        }

        push_obj = new pushbs::TPushDataToBasa();
        if (push_obj != NULL) {
            tick = CShingleTime::GetMs();

            push_obj->Init(this, GetLogsGroup(), config);

            tick = CShingleTime::GetMs() - tick;

            push_obj->Wait();

            stat_str = push_obj->GetStat();

            delete push_obj;
            push_obj = NULL;

            m_PushStorMutex.Acquire();
            m_PushStorBusy = false;
            m_PushStorMutex.Release();
        }

        if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL)) {
            GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "LONGSTAT: read dump compleate to %u msec (%s)!", tick, stat_str.c_str());
            GetLogsGroup()->GetServerLog()->FFlush();
        }
    }

    return res;
}

TResetResponce TGeneralObject::Reset() {
    TResetResponce res;

    res = m_filter.Reset();

    return res;
}

TString TGeneralObject::GetTraccertStatWeb() {
    TString res = "";

    res += "Create report: " + TimeToStr(time(NULL)) + "<br><br>";

    res += "<i><b>Forecast:</b></i>";
    res += traccert_stat_forecast.GetWebData();
    res += "<br>";

    res += "<i><b>Full tick:</b></i>";
    res += traccert_stat_fulltick.GetWebData();
    res += "<br>";

    res += "<i><b>Reality:</b></i>";
    res += traccert_stat.GetWebData();
    res += "<br>";

    res += "<b><i>Result statistik:</i><b><br>";
    res += traccert_result_stat.GetWebStat();
    res += "<br>";

    res += "<b><i>SP traccert statistik:</i><b><br>";
    res += traccert_stat_debug.GetWebData();
    res += "<br>";

    return res;
}

TString TGeneralObject::CorrLoginWeigthSize() {
    TString res = "";
    NCache::TStat stat;

    if (m_correct_login_enable) {
        stat = m_LoginWeightObj.GetStat();
        res = "cnt=" + IntToStroka(stat.GetLocalCount()) + " / prev_cnt=" + IntToStroka(stat.GetPrevLocalCount()) + " / remain=" + GetTimePeriod(stat.GetRemainTime());
    } else {
        res = "disabled";
    }

    return res;
}

//******************************************************************************************************************************************
