#pragma once

#include <mail/so/spamstop/tools/fcgiserver_base/tgeneralserviceobject.h>
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/tools/fcgiserver_base/tratesrvc.h>
#include <mail/so/spamstop/tools/fcgiserver_base/sotypes.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tlogsgroup.h"
#include "tstoragenosql.h"
#include "trqstlimit.h"
#include "tconsolestat.h"
#include "tstoragepool.h"
#include "trcptclass.h"
#include "tpushdatatobasa.h"
#include "tasynccheck.h"
#include "tspamonlog.h"
#include "ttraccert_fd_stat.h"
#include <util/stream/file.h>

//******************************************************************************************************************************************
//                                                       TGeneralObject
//******************************************************************************************************************************************

struct TResStruct {
    ui32 m_code;
    TString m_result_str;
    frodo_st::TLongDataRqstInfo m_longdatarqstinfo;

    TResStruct() {
        Clear();
    }

    void Clear() {
        m_code = 0;
        m_result_str = "";
        m_longdatarqstinfo.Clear();
    }
};

class TGeneralObject: public TGeneralServiceObject {
private:
    TLogsGroupBase* LogsGroup;
    TKConfig* config;
    TString server_id;
    TStoragePool m_StoragePool;
    TAsyncCheck* m_async_check;
    TMakeRequestLimit LimitObj;
    trcstat::TTraccertStat traccert_stat_forecast;
    trcstat::TTraccertStat traccert_stat;
    trcstat::TTraccertStat traccert_stat_debug;
    trcstat_fd::TTraccertResultStat traccert_result_stat;
    ui32                    m_last_update_stat_to_database;
    trcstat::TTraccertStat traccert_stat_fulltick;

    TLogsGroup* GetLogsGroup();
    TKConfig* GetConfigObject() {
        return config;
    }

    TTrafficControl m_check_tc;
    TTrafficControl m_loginrcpt_tc;
    TTrafficControl m_corrlongstat_tc;
    TTrafficControl m_reserv_tc;
    KRCPClass RCP; //������ �������, ��������� ��������� � ��������
    CSoFilter m_filter;

    TRateSrvc RateObj; //������� ���������� �������
    TMutex m_SetMinorStatusMutex;
    bool m_obrab_upstream_version;
    bool m_return_upstream_version;
    ui32 m_major_request_count;
    ui32 m_minor_request_count;

    TMutex m_PushStorMutex;
    bool m_PushStorBusy;

    ui32 last_write_mondata;
    void WriteStatToLog();

    ui32 m_last_write_console_stat;
    ui32 m_last_read_console_stat;
    ui32 m_last_write_dump;

    bool m_use_async_check_mode;

    bool m_correct_login_enable;
    frodo_st::TCorrLoginWeigthClass m_LoginWeightObj;
    void CorrLW(const TString& NumbRequest, const TString& login, ui8& weigth);
    void CorrectLoginsWeight(const TString& NumbRequest, TRequestInfo& ReqInfo);

public:
    Y_SAVELOAD_DEFINE(m_filter, m_LoginWeightObj, m_StoragePool)
    TGeneralObject();
    ~TGeneralObject() override;

    bool InitBeforeFork(const TString& server_idA, TLogsGroupBase* LogsGroupA, TKConfig* configA) override;
    bool InitAfterFork() override;

    bool Midnight() override;
    bool Shutdown() override;
    void EventTick() override;
    bool Close() override;

    void AddINTick(const TMakeRqstDelays &work_delays) override;

    bool UseAsyncCheckMode() {
        return (m_use_async_check_mode && (m_async_check != NULL));
    }
    TAsyncCheck* GetAsyncCheckObj() {
        return m_async_check;
    }

    TStoragePool* GetStoragePool() {
        return &m_StoragePool;
    }
    TMakeRequestLimit* GetLimitObj() {
        return &LimitObj;
    }

    void                    GetStorageStat(TStorageNameStatList& statlist);
    TStorageNameStat        GetStat(int index, bool& notfound);
    TStorageRequestNameStat GetRequestStat(int index, bool& notfound);
    TStorageQuantileStat    GetQuantileStat(int index, bool& notfound);
    TStorageInfoFull        GetStorageFullInfo(int index, bool& notfound);
    TString                 GetPutQueueProperties();

    TString             GetStorageIdent();
    TString             GetDriverProperties();
    TString             GetStorageWebStatistik();
    TString             GetStorageTraccertStatistik();
    TString             GetStorageMonStatistik();
    TString             GetUpdateQueueWebStatistik();
    TConsoleStatData    GetLocalConsoleStat();
    void                WriteConsoleStatToStorage();
    void                WriteDump();
    ui32                GetServersStatistik(TConsoleStatDataList& servers_stats);
    TString             GetServersStatistikText(ui32& stor_tick);
    void                GetServersStatistikAuto();
    ui32                GetLastUpdateStatistikToBD() { return m_last_update_stat_to_database; }

    bool StorageInitStatus(TString& status);
    i64 GetStorageSize();

    TTrafficControl* GetCheckTC() {
        return &m_check_tc;
    }
    TTrafficControl* GetLoginRcptTC() {
        return &m_loginrcpt_tc;
    }
    TTrafficControl* GetCorrLongStatTC() {
        return &m_corrlongstat_tc;
    }
    TTrafficControl* GetReservTC() {
        return &m_reserv_tc;
    }

    TRateSrvc* GetRateObj() {
        return &RateObj;
    }
    KRCPClass* GetRCP() {
        return &RCP;
    }
    CSoFilter& GetFilter() {
        return m_filter;
    }
    void WriteKPIData(const TString& login, const TString& uid, int weight, int backalg, const TString& ips, TPassportRequestType reqtype, const TString& reqtype_s, const TString& messnumb);
    TString EncodeLoginToUTF8(const TString& login);
    TString DecodeLoginFromUTF8(const TString& login);
    TString HTTP_200_OK_TextXMLUTF8(float rating, TRateSrvc::TTypeInstance type_instance, ui8 hash_one, ui64 hash_two);

    void LoginRCPT(TReqParams* m_ReqParams, const TString& NumbRequest, bool is_upstream_request, const TString& requrl);
    TResStruct Check(TReqParams* pReqParams, const TString& Numbrequest, bool& is_upstream_request, const TString& source_request, TSpamonLogStruct& monlogdata);
    TResStruct CheckDirect(TReqParams* pReqParams, const TString& Numbrequest, bool& is_upstream_requestA, TSpamonLogStruct& monlogdata);
    TResStruct CheckAsync(TReqParams* pReqParams, const TString& Numbrequest, bool& is_upstream_requestA, const TString& source_request, TSpamonLogStruct& monlogdata);
    TResStruct CheckAsyncDo(TAsyncCheckStruct& data_from_queue);

    TSummaryStatistik GetStatistic();
    TString GetTraccertStatWeb();
    void AddTraccertData(const TDelayClass& delays);

    TString GetLongStorCacheStatS();

    void GetLongStatAsFltr(frodo_st::TStorageDataType reqtype, TKIPv6 ip, ui64& shingle, TString& source, bool& stor_err, kday_t& day, i32& ham, i32& spam, i32& malic);
    void GetLongStatStorage(frodo_st::TStorageDataType reqtype, TKIPv6 ip, ui64& shingle, TString& source, bool& stor_err, kday_t& day, i32& ham, i32& spam, i32& malic);
    void GetLongStatCache(frodo_st::TStorageDataType reqtype, TKIPv6 ip, ui64& shingle, TString& source, bool& stor_err, kday_t& day, i32& ham, i32& spam, i32& malic);
    void CorrectLongStatIncr(frodo_st::TStorageDataType reqtype, TKIPv6 ip, const TString& source, bool& stor_err, kday_t day, i32 ham, i32 spam, i32 malic);
    void CorrectLongStatSet(frodo_st::TStorageDataType reqtype, TKIPv6 ip, const TString& source, bool& stor_err, kday_t day, i32 ham, i32 spam, i32 malic);

    void GetLongDataByShingleStorage(ui64 shingle, frodo_st::TStorageDataType& reqtype, TString& source, kday_t& day, i32& ham, i32& spam85, i32& spam100);
    void GetLongDataByShingleCache(ui64 shingle, frodo_st::TStorageDataType& reqtype, TString& source, kday_t& day, i32& ham, i32& spam85, i32& spam100);
    void UpdateLongDataByShingle(ui64 shingle, frodo_st::TStorageDataType& reqtype, TString& source, kday_t day, i32 ham, i32 spam85, i32 spam100);

    bool PushToStorage();

    TResetResponce Reset();

    TString CorrLoginWeigthSize();
};

//******************************************************************************************************************************************
