#include "tkclasses.h"

#include <utility>
#include <util/string/split.h>

//******************************************************************************
//                              TBaseTClass
//******************************************************************************

TMaxAnalizDelay::TMaxAnalizDelay() {
    memset(delay, 0, sizeof(delay));
    block_counter = 0;
}

void TMaxAnalizDelay::Midnight() {
    m_Mutex.Acquire();

    delay[6] = delay[5];
    delay[5] = delay[4];
    delay[4] = delay[3];
    delay[3] = delay[2];
    delay[2] = delay[1];
    delay[1] = delay[0];
    delay[0] = 0;

    m_Mutex.Release();
}

ui32 TMaxAnalizDelay::GetDelay(int day) {
    ui32 res = 0;

    m_Mutex.Acquire();

    if ((day >= 0) && (day < 7))
        res = delay[day];

    m_Mutex.Release();

    return res;
}

void TMaxAnalizDelay::AddDelay(ui32 delayv) {
    m_Mutex.Acquire();

    if (block_counter > 0)
        block_counter--;
    if (block_counter == 0) {
        if (delayv > delay[0])
            delay[0] = delayv;
    }

    m_Mutex.Release();
}

void TMaxAnalizDelay::SetBlockCounter(ui32 value) {
    m_Mutex.Acquire();

    block_counter = value;

    m_Mutex.Release();
}

TString TMaxAnalizDelay::GetStat() {
    TString res;

    res = IntToStroka(GetDelay(0)) + ", " + IntToStroka(GetDelay(1)) + ", " + IntToStroka(GetDelay(2)) + ", " + IntToStroka(GetDelay(3)) + ", " + IntToStroka(GetDelay(4)) + ", " + IntToStroka(GetDelay(5)) + ", " + IntToStroka(GetDelay(6));

    return res;
}

//*****************************************************************************
//                               TBackSpam
//*****************************************************************************

TBackSpam::TBackSpam() {
    LogsGroup = nullptr;
}

bool TBackSpam::Init(TString algos, TLogsGroup* LogsGroupA) {
    Algos = {};
    for(const auto tok : StringSplitter(algos).SplitBySet(" \t,;").SkipEmpty()) {
        Algos.emplace(FromString(tok.Token()));
    }
    if(!Algos) {
        Algos = {1, 2, 3, 5, 6};
    }
    LogsGroup = LogsGroupA;
    return Reload();
}

bool TBackSpam::Reload() {
    bool res = false;

    TWriteGuard g(m_Mutex);

    TString tolog = "";
    bool first = true;

    if (Algos.empty()) {
        tolog = "all";
    } else {
        for(const auto& alg : Algos) {
            if (first) {
                tolog = tolog + IntToStroka(alg);
                first = false;
            } else {
                tolog = tolog + ", " + IntToStroka(alg);
            }
        }
    }
    if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "BACKSPAMALG: enable algorithm: %s", tolog.c_str());

    return res;
}

TString TBackSpam::GetEnableAlgorithmList() {
    TString res = "";
    bool first = true;

    TReadGuard g(m_Mutex);
    if (Algos.empty()) {
        res = "all";
    } else {
        for(const auto& alg : Algos) {
            if (first) {
                res = res + IntToStroka(alg);
                first = false;
            } else {
                res = res + ", " + IntToStroka(alg);
            }
        }
    }

    return res;
}

bool TBackSpam::GetEnableAlgorithm(ui16 n) const{
    TReadGuard g(m_Mutex);
    return Algos.contains(n);
}

//******************************************************************************
//                            TNamesList
//******************************************************************************

TNamesList::TNamesList(TLogsGroup* LogsGroupA, const TString& filenameA) {
    list = nullptr;
    extlist = nullptr;
    LogsGroup = LogsGroupA;
    filename = filenameA;
    last_loading_msec = 0;
}

TNamesList::~TNamesList() {
    if (extlist != nullptr) {
        extlist->clear();
        delete extlist;
        extlist = nullptr;
    }
    if (list != nullptr) {
        list->clear();
        delete list;
        list = nullptr;
    }
}

void TNamesList::Lock() {
    m_Mutex.Acquire();
}

void TNamesList::UnLock() {
    m_Mutex.Release();
}

bool TNamesList::LoadA(const TString& filenameA) {
    ui32 bmsec = CShingleTime::GetMs();
    bool res = true;
    ui32 count = 0;

    if (list != nullptr) {
        FILE* fhandle = nullptr;
        char buff[256];
        int error = 0;
        char name[256];
        char* s = nullptr;
        ui8 type = 0;
        TString names = "";
        TNamesRecordIt it;

        fhandle = fopen(filenameA.c_str(), "rb");
        if (fhandle != nullptr) {
            while (error == 0) {
                memset(buff, 0, sizeof(buff));
                s = fgets(buff, sizeof(buff) - 1, fhandle);
                if (s == nullptr) {
                    if (feof(fhandle))
                        error = 2;
                    else {
                        error = 1;
                        res = false;
                    }
                } else {
                    memset(name, 0, sizeof(name));
                    if (sscanf(buff, " %s ", name)) {
                        if (name[0] == '#') {
                            type = atoi(name + 1);
                        } else {
                            if (name[0] == 0x00)
                                continue;
                            if (type > 0) {
                                names.assign(name);
                                to_lower_k(names);

                                it = list->find(names);
                                if (it != list->end()) {
                                    if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
                                        LogsGroup->GetListLog()->WriteMessageAndDataStatus(KERROR, "NAMES_LIST: dublicat record %s.", names.c_str());
                                } else {
                                    (*list)[names] = type;
                                    count++;
                                }
                            } else {
                                if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
                                    LogsGroup->GetListLog()->WriteMessageAndDataStatus(KERROR, "NAMES_LIST: bad structure file.");
                                res = false;
                                list->clear();
                                break;
                            }
                        }
                    }
                }
            }
            fclose(fhandle);
        } else {
            if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
                LogsGroup->GetListLog()->WriteMessageAndDataStatus(KERROR, "NAMES_LIST: error open file: %s.", filenameA.c_str());
            res = false;
        }

    } else {
        res = false;
    }

    bmsec = CShingleTime::GetMs() - bmsec;
    last_loading_msec = bmsec;

    if (res) {
        if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
            LogsGroup->GetListLog()->WriteMessageAndDataStatus(KMESSAGE, "NAMES_LIST: loading compleate in %lu msec (count = %u).", bmsec, count);
    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
            LogsGroup->GetListLog()->WriteMessageAndDataStatus(KMESSAGE, "NAMES_LIST: loading failed.");
    }

    return res;
}

bool TNamesList::LoadTextA(const TString& data) {
    ui32 bmsec = CShingleTime::GetMs();
    bool res = true;
    ui32 count = 0;

    if (list != nullptr) {
        ui32 m_buff_pos = 0;
        char tbuff[65500];
        const char* sourcebuff = nullptr;
        size_t sourcebuffsize = 0;
        ui32 strlength = 0;
        TString restxt = "";
        bool valid_str = false;
        char name[256];
        ui8 type = 0;
        TString names = "";
        TNamesRecordIt it;

        sourcebuff = data.c_str();
        sourcebuffsize = data.length();
        m_buff_pos = 0;
        while (m_buff_pos < sourcebuffsize) {
            strlength = GetStr(sourcebuff + m_buff_pos, sourcebuffsize - m_buff_pos, tbuff, sizeof(tbuff));
            if (strlength > 0) {
                m_buff_pos += strlength;

                valid_str = false;
                for (size_t i = 0; i < strlength; i++) {
                    if ((tbuff[i] < 0) || (tbuff[i] > ' ')) {
                        valid_str = true;
                        break;
                    }
                }

                if (valid_str) {
                    memset(name, 0, sizeof(name));
                    if (sscanf(tbuff, " %s ", name)) {
                        if (name[0] == '#') {
                            type = atoi(name + 1);
                        } else {
                            if (name[0] == 0x00)
                                continue;
                            if (type > 0) {
                                names.assign(name);
                                to_lower_k(names);
                                it = list->find(names);
                                if (it != list->end()) {
                                    if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
                                        LogsGroup->GetListLog()->WriteMessageAndDataStatus(KERROR, "NAMES_LIST: dublicat record %s.", names.c_str());
                                } else {
                                    (*list)[names] = type;
                                    count++;
                                }
                            } else {
                                if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
                                    LogsGroup->GetListLog()->WriteMessageAndDataStatus(KERROR, "NAMES_LIST: bad structure file.");
                                res = false;
                                list->clear();
                                break;
                            }
                        }
                    }
                }

            } else
                break;
        }

    } else {
        res = false;
    }

    bmsec = CShingleTime::GetMs() - bmsec;
    last_loading_msec = bmsec;

    if (res) {
        if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
            LogsGroup->GetListLog()->WriteMessageAndDataStatus(KMESSAGE, "NAMES_LIST: loading compleate in %lu msec (count = %u).", bmsec, count);
    } else {
        if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
            LogsGroup->GetListLog()->WriteMessageAndDataStatus(KMESSAGE, "NAMES_LIST: loading failed.");
    }

    return res;
}

ui8 TNamesList::Get(const TString& login, const TString& lang) {
    Lock();

    ui8 res = 0;

    if (list != nullptr) {
        TNamesRecordIt it;
        TString loginn = login, login2 = "";
        //TString         stest = "";

        //to lower symbols
        to_lower_k(loginn);
        //erase other symbol
        login2 = GetOnlySymbols1251(loginn, lang);

        /*ittest = list->begin();
      while (ittest != list->end())
      {
         stest = (*ittest).first;

         ++ittest;
      }*/

        it = list->find(login2);
        if (it != list->end())
            res = (*it).second;
    }

    UnLock();

    return res;
}

TString TNamesList::GetCompareTRSC(const TString& svalue, ui8& index) {
    TString res = "";

    index = 0;
    if (extlist != nullptr) {
        TKFuncStrokaList flist;
        TKFuncStrokaListIt fit;
        TString skey;
        TNamesRecordIt it;

        CreateTranslitList(svalue, flist);

        Lock();

        fit = flist.begin();
        while (fit != flist.end()) {
            skey = (*fit);
            if (!skey.empty()) {
                it = extlist->find(skey);
                if (it != extlist->end()) {
                    index = (*it).second;
                    res = skey;
                    break;
                }
            }

            ++fit;
        }

        UnLock();
    }

    return res;
}

ui32 TNamesList::GetRecordCount() {
    ui32 res = 0;

    Lock();

    if (list != nullptr)
        res = list->size();

    UnLock();

    return res;
}

ui32 TNamesList::GetLastLoadingMSec() {
    ui32 res = 0;

    res = last_loading_msec;
    return res;
}

void TNamesList::ExpandList() {
    TNamesRecordIt it, it2;
    TKFuncStrokaList flist;
    TKFuncStrokaListIt fit;
    TString keyitem;
    ui8 valueitem = 0;
    TString s;
    ui32 delay_t = 0;
    TString textlist = "";
    ui32 dublicat = 0;
    ui32 itemcount = 0;

    if ((list != nullptr) && (extlist != nullptr)) {
        if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
            LogsGroup->GetListLog()->WriteMessageAndDataStatus(KMESSAGE, "Start creating expand list...");

        delay_t = CShingleTime::GetMs();

        it = list->begin();
        while (it != list->end()) {
            keyitem = (*it).first;
            valueitem = (*it).second;

            flist.clear();
            CreateTranslitList(keyitem, flist);
            fit = flist.begin();
            while (fit != flist.end()) {
                s = *fit;

                it2 = extlist->find(s);
                if (it2 == extlist->end()) {
                    (*extlist)[s] = valueitem;
                } else {
                    (*it2).second = valueitem;
                    if (dublicat < 0xFFFFFFFF)
                        dublicat++;
                    if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
                        LogsGroup->GetListLog()->WriteMessageAndDataStatus(KERROR, "Dublicat record: '%s', replace.", s.c_str());
                }

                ++fit;
            }

            ++it;
        }

        delay_t = CShingleTime::GetMs() - delay_t;

        it = extlist->begin();
        while (it != extlist->end()) {
            textlist = textlist + (*it).first + " (" + IntToStroka((*it).second) + ")\n";

            ++it;
        }
        itemcount = extlist->size();
        if ((LogsGroup != nullptr) && (LogsGroup->GetListLog() != nullptr))
            LogsGroup->GetListLog()->WriteMessageAndDataStatus(KMESSAGE, "Creating expand list compleate to %u msec (record=%u, dublicat=%u). In detail:\n%s", delay_t, itemcount, dublicat, textlist.c_str());
    }
}

void TNamesList::ReloadFileList() {
    Lock();

    if (list != nullptr) {
        delete list;
        list = nullptr;
    }
    if (list == nullptr)
        list = new TNamesRecord();

    if (extlist != nullptr) {
        delete extlist;
        extlist = nullptr;
    }
    if (extlist == nullptr)
        extlist = new TNamesRecord();

    LoadA(filename);
    ExpandList();

    UnLock();
}

void TNamesList::ReloadMemList(const TString& data) {
    Lock();

    if (list != nullptr) {
        delete list;
        list = nullptr;
    }
    if (list == nullptr)
        list = new TNamesRecord();

    if (extlist != nullptr) {
        delete extlist;
        extlist = nullptr;
    }
    if (extlist == nullptr)
        extlist = new TNamesRecord();

    LoadTextA(data);
    ExpandList();

    UnLock();
}

ui32 TNamesList::GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size) {
    long pos = -1;
    ui32 res = 0;
    ui8 dob = 0;

    for (ui32 i = 0; i < source_size; i++) {
        if ((source[i] == 0x0D) && ((i + 1) < source_size) && (source[i + 1] == 0x0A)) {
            pos = i;
            dob = 1;
            break;
        }
        if (source[i] == 0x0A) {
            pos = i;
            dob = 0;
            break;
        }
    }
    res = pos + 1 + dob;
    if (res == 0)
        res = source_size;
    if (res > 0) {
        memset(destination, 0, destination_size);
        if (res <= (destination_size - 1)) {
            memcpy(destination, source, res);
        } else {
            memcpy(destination, source, destination_size - 1);
        }
    }
    return res;
}

//********************************************************************************************************************
