#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "util/generic/hash_set.h"
#include <util/generic/vector.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include <util/string/builder.h>
#include <mail/so/spamstop/sp/sptypes.h>
#include "ktypes.h"
#include "tlogsgroup.h"

//***********************************************************************************************************************
//                                               TRuleInfo
//***********************************************************************************************************************

struct TRuleInfo {
    ui32 fulltime;
    ui32 count;

    TRuleInfo() {
        fulltime = 0;
        count = 0;
    }

    TRuleInfo(ui32 countA, ui32 fulltimeA) {
        fulltime = fulltimeA;
        count = countA;
    }

    void AppendTime(ui32 addtimeA) {
        fulltime = IncMax32(fulltime, addtimeA);
        count = IncMax32(count, 1);
    }
};

typedef THashMap<TString, TRuleInfo> TRuleInfoHash;
typedef TRuleInfoHash::iterator TRuleInfoHashIt;

struct TSpTraccertItem {
    ui32 m_index;
    ui32 m_delay_ms;

    TSpTraccertItem() {
        Clear();
    }

    TSpTraccertItem(ui32 index, ui32 delay_ms) {
        m_index = index;
        m_delay_ms = delay_ms;
    }

    void Clear() {
        m_index = 0;
        m_delay_ms = 0;
    }
};

//****************************************************************************************
//                              TDelayClass
//****************************************************************************************

class TDelayClass {
public:
    ui32 start;
    bool is_black_login;
    bool is_white_login;
    bool is_trust_login;

    bool is_whiteso_login;
    bool is_intranetzone_login;
    bool is_trustedzone_login;
    bool is_localzone_login;

    bool is_grupped_ip;
    bool is_ungrupped_ip;

    TString login;
    TString service;
    TRuleInfoHash ruleshash;

    ui32 geo_delay; //����� ��������� ������ �� ���
    bool geo_delay_pr;
    bool geo_delay_ok;
    bool geo_delay_ru;
    ui32 pdd_delay; //����� ��������� ������ �� pdd
    bool pdd_delay_pr;

    ui32 ml_delay; //����� ��������� � ������� ML
    bool ml_delay_err;
    ui32 ml_delay_wait_item;
    ui32 ml_delay_connect;
    ui32 ml_delay_request;
    ui32 ml_delay_writelog;

    ui32 mlyt_delay; //����� ������ ���� mlyt
    ui32 bbox_delay; //����� ��������� ������ �� ���������
    bool bbox_delay_pr;
    ui32 rblrule_delay; //����� ��������� ������ �� udns �������� �� ����������
    bool rblrule_delay_pr;
    std::list<TString> rblrule_list;

    ui32 writedlvlog_delay;

    ui32 spamstat_delay; //����� ������� ������ �� ���������
    bool spamstat_delay_pr;
    ui32 spamstat_delay_wait_item;
    ui32 spamstat_delay_connect;
    ui32 spamstat_delay_request;
    ui32 spamstat_delay_writelog;
    bool spamstat_delay_exist;
    bool spamstat_today_ban;
    bool spamstat_yesterday_ban;
    bool spamstat_exist_host;
    bool spamstat_exist_geo;
    bool spamstat_badrequest;

    ui32 resolv_delay; //����� ����������
    bool resolv_delay_pr;
    bool resolv_delay_ok;
    bool host_from_tycache;
    ui32 filterwork_delay1step; //����� ������ rengine
    ui32 filterwork_delay2step; //����� ������ rengine (with ML)
    ui32 filterget_delay;       //����� ��������� rengine
    ui32 check_delay;           //����� ���������� �-�� check
    ui32 full_delay;            //������ ����� (��������� ������, check � �����)
    ui32 lst_delay;             //�������� �� ������ (white, black, grupped, ungrupped)
    ui32 nameslst_delay;        //�������� �� names �����
    bool nameslst_delay_pr;
    ui32 nameslst_inamenum;
    ui32 nameslst_fnamenum;
    ui32 longstorage_delay;     //������ ������ �� ��������������� ��������� �� ip
    ui32 getshortstorage_delay; //������ ������ �� ���������������� ��������� �� ip
    ui32 summary_delay;         //��������� ��������� �� 300 � 1200 ���
    bool summary_delay_pr;
    ui32 backalg_delay; //������� �������� ���������
    bool backalg_delay_pr;
    bool backalg_LoginResemblance;
    bool backalg_HintPasswAnswer;
    bool backalg_3min;
    bool backalg_PacketTwo;
    bool backalg_CompareIFNames;


    TDuration AddCalcIPStatistDelay{}, AddGeoToIPDelay{}, AddHostnameDelay{}, AddElementPasswdChangeDelay{};

    ui32 upd_longstorage_delay; //��������� �������������� ���� �� ip
    bool upd_longstorage_delay_pr;
    ui32 dublicat_delay; //����� ������ �������� ��������� ������
    bool dublicat_delay_pr;

    ui32 result_spam;
    ui32 result_ml_spam;
    ui32 result_woml_spam;

    bool set_ham_to_spam_by_ml;
    bool set_malic_to_spam_by_ml;
    bool set_spam_to_ham_by_ml;
    bool set_malic_to_ham_by_ml;

    bool set_ham_to_spam_finalres;
    bool set_ham_to_malic_finalres;
    bool set_spam_to_ham_finalres;
    bool set_spam_to_malic_finalres;
    bool set_malic_to_ham_finalres;
    bool set_malic_to_spam_finalres;

    bool is_changepass;
    bool is_ipv6;

    bool packet1notnull;
    bool packet2notnull;
    bool packet3notnull;
    bool packet4notnull;
    bool packet5notnull;

    bool cluster_was_request;
    ui32 cluster_delay;
    ui32 cluster_delay_wait_item;
    ui32 cluster_delay_connect;
    ui32 cluster_delay_request;
    ui32 cluster_delay_writelog;
    bool cluster_delay_exist;
    bool cluster_badrequest;

    bool filterwork_prepare;
    ui32 filterwork_prepare_ms;
    bool filterwork_check_field_tick;
    ui32 filterwork_check_field_tick_ms;
    bool filterwork_check_message_tick;
    ui32 filterwork_check_message_tick_ms;

    bool filterwork_prepare_ml;
    ui32 filterwork_prepare_ml_ms;
    bool filterwork_check_field_tick_ml;
    ui32 filterwork_check_field_tick_ml_ms;
    bool filterwork_check_message_tick_ml;
    ui32 filterwork_check_message_tick_ml_ms;

    std::vector<TSpTraccertItem> sp_traccert;
    std::vector<TSpTraccertItem> sp_traccert_ml;

public:
    TDelayClass() {
        Clear();
    };
    ~TDelayClass(){};

    void Init() {
        Clear();
    }

    void Clear() {
        start = CShingleTime::GetMs();
        is_black_login = false;
        is_white_login = false;
        is_trust_login = false;
        is_whiteso_login = false;
        is_intranetzone_login = false;
        is_trustedzone_login = false;
        is_localzone_login = false;
        is_grupped_ip = false;
        is_ungrupped_ip = false;
        login = "";
        service = "";

        geo_delay = 0;
        geo_delay_pr = false;
        geo_delay_ok = false;
        geo_delay_ru = false;
        pdd_delay = 0;
        pdd_delay_pr = false;

        ml_delay = 0;
        ml_delay_err = false;
        ml_delay_wait_item = 0;
        ml_delay_connect = 0;
        ml_delay_request = 0;
        ml_delay_writelog = 0;

        mlyt_delay = 0;
        bbox_delay = 0;
        bbox_delay_pr = false;
        rblrule_delay = 0;
        rblrule_delay_pr = false;
        rblrule_list.clear();
        writedlvlog_delay = 0;
        spamstat_delay = 0;
        spamstat_delay_pr = false;
        spamstat_delay_wait_item = false;
        spamstat_delay_connect = false;
        spamstat_delay_request = false;
        spamstat_delay_writelog = false;
        spamstat_delay_exist = false;
        spamstat_today_ban = false;
        spamstat_yesterday_ban = false;
        spamstat_exist_host = false;
        spamstat_exist_geo = false;
        spamstat_badrequest = false;
        resolv_delay = 0;
        resolv_delay_pr = false;
        resolv_delay_ok = false;
        host_from_tycache = false;
        filterwork_delay1step = 0;
        filterwork_delay2step = 0;
        filterget_delay = 0;
        check_delay = 0;
        full_delay = 0;
        lst_delay = 0;
        nameslst_delay = 0;
        nameslst_delay_pr = false;
        nameslst_inamenum = 0;
        nameslst_fnamenum = 0;
        longstorage_delay = 0;
        getshortstorage_delay = 0;
        summary_delay = 0;
        summary_delay_pr = false;
        backalg_delay = 0;
        backalg_delay_pr = false;
        backalg_LoginResemblance = false;
        backalg_HintPasswAnswer = false;
        backalg_3min = false;
        backalg_PacketTwo = false;
        backalg_CompareIFNames = false;
        upd_longstorage_delay = 0;
        upd_longstorage_delay_pr = false;
        dublicat_delay = 0;
        dublicat_delay_pr = false;

        result_spam = 0;
        result_ml_spam = 0;
        result_woml_spam = 0;

        set_ham_to_spam_by_ml = false;
        set_malic_to_spam_by_ml = false;
        set_spam_to_ham_by_ml = false;
        set_malic_to_ham_by_ml = false;

        is_changepass = false;
        is_ipv6 = false;

        packet1notnull = false;
        packet2notnull = false;
        packet3notnull = false;
        packet4notnull = false;
        packet5notnull = false;

        cluster_was_request = false;
        cluster_delay = 0;
        cluster_delay_wait_item = 0;
        cluster_delay_connect = 0;
        cluster_delay_request = 0;
        cluster_delay_writelog = 0;
        cluster_delay_exist = false;
        cluster_badrequest = false;

        set_ham_to_spam_finalres = false;
        set_ham_to_malic_finalres = false;
        set_spam_to_ham_finalres = false;
        set_spam_to_malic_finalres = false;
        set_malic_to_ham_finalres = false;
        set_malic_to_spam_finalres = false;

        filterwork_prepare = false;
        filterwork_prepare_ms = 0;
        filterwork_check_field_tick = false;
        filterwork_check_field_tick_ms = 0;
        filterwork_check_message_tick = false;
        filterwork_check_message_tick_ms = 0;

        filterwork_prepare_ml = false;
        filterwork_prepare_ml_ms = 0;
        filterwork_check_field_tick_ml = false;
        filterwork_check_field_tick_ml_ms = 0;
        filterwork_check_message_tick_ml = false;
        filterwork_check_message_tick_ml_ms = 0;

        sp_traccert.clear();
        sp_traccert_ml.clear();
    }

    void SetBlackLogin() {
        is_black_login = true;
    }
    void SetWhiteLogin() {
        is_white_login = true;
    }
    void SetTrustLogin() {
        is_trust_login = true;
    }

    void SetWhiteSOLogin() {
        is_whiteso_login = true;
    }
    void SetIntranetZoneSOLogin() {
        is_intranetzone_login = true;
    }
    void SetTrustedZoneSOLogin() {
        is_trustedzone_login = true;
    }
    void SetLocalZoneSOLogin() {
        is_localzone_login = true;
    }

    void SetGruppedIP() {
        is_grupped_ip = true;
    }
    void SetUngruppedIP() {
        is_ungrupped_ip = true;
    }

    void SetLogin(const TString& loginA) {
        login = loginA;
    }

    TString GetReport2() {
        TString res = "";
        TRuleInfoHashIt it;
        bool first_record = true;

        res = res + IntToStroka4D(full_delay) + " : '" + login + "'/'" + service + "' - ";
        if (is_black_login)
            res = res + "bl ";
        if (is_white_login)
            res = res + "wl ";
        if (is_trust_login)
            res = res + "tl ";
        if (is_whiteso_login)
            res = res + "wls";
        if (is_intranetzone_login)
            res = res + "izs";
        if (is_trustedzone_login)
            res = res + "tzs";
        if (is_localzone_login)
            res = res + "lzs";
        res = res + "CHK=" + IntToStroka(check_delay) + ", ";
        res = res + "FW:FLTRWRK1=" + IntToStroka(filterwork_delay1step) + ", ";
        res = res + "FW:FLTRWRK2=" + IntToStroka(filterwork_delay2step) + ", ";
        res = res + "FW:FLTRGET=" + IntToStroka(filterget_delay) + ", ";
        res = res + "FW:PREPARE1=" + IntToStroka(filterwork_prepare_ms) + ", ";
        res = res + "FW:CHECK_FIELD1=" + IntToStroka(filterwork_check_field_tick_ms) + ", ";
        res = res + "FW:CHECK_MESSAGE1=" + IntToStroka(filterwork_check_message_tick_ms) + ", ";
        res = res + "FW:PREPARE2=" + IntToStroka(filterwork_prepare_ml_ms) + ", ";
        res = res + "FW:CHECK_FIELD2=" + IntToStroka(filterwork_check_field_tick_ml_ms) + ", ";
        res = res + "FW:CHECK_MESSAGE2=" + IntToStroka(filterwork_check_message_tick_ml_ms) + ", ";

        if (spamstat_delay_pr)
            res = res + "SPST=" + IntToStroka(spamstat_delay) + "(exist=" + BoolToStroka2(spamstat_delay_exist) + ")" + ", ";
        else
            res = res + "SPST=-, ";

        if (geo_delay_pr)
            res = res + "GEO=" + IntToStroka(geo_delay) + ", ";
        else
            res = res + "GEO=-, ";

        if (pdd_delay_pr)
            res = res + "PDD=" + IntToStroka(pdd_delay) + ", ";
        else
            res = res + "PDD=-, ";

        res = res + "ML=" + IntToStroka(ml_delay) + ", ";
        res = res + "MLYT=" + IntToStroka(mlyt_delay) + ", ";
        res = res + "WRTDLVLOG=" + IntToStroka(writedlvlog_delay) + ", ";

        if (bbox_delay_pr)
            res = res + "BBOX=" + IntToStroka(bbox_delay) + ", ";
        else
            res = res + "BBOX=-, ";

        if (rblrule_delay_pr)
            res = res + "RBLRUL=" + IntToStroka(rblrule_delay) + ", ";
        else
            res = res + "RBLRUL=-, ";

        if (resolv_delay_pr)
            res = res + "RSLV=" + IntToStroka(resolv_delay) + ", ";
        else
            res = res + "RSLV=-, ";

        res = res + "LST=" + IntToStroka(lst_delay) + ", ";

        if (nameslst_delay_pr)
            res = res + "NLST=" + IntToStroka(nameslst_delay) + ", ";
        else
            res = res + "NLST=-, ";

        if (summary_delay_pr)
            res = res + "SUM=" + IntToStroka(summary_delay) + ", ";
        else
            res = res + "SUM=-, ";

        if (backalg_delay_pr)
            res = res + "BACKALG=" + IntToStroka(backalg_delay) + ", ";
        else
            res = res + "BACKALG=-, ";

        res += "LSTOR=" + IntToStroka(longstorage_delay) + ", ";
        res += TStringBuilder{} << "GSHSTOR=" << getshortstorage_delay
                                << '('
                                << LabeledOutput(AddCalcIPStatistDelay, AddGeoToIPDelay, AddHostnameDelay,AddElementPasswdChangeDelay)
                                << "),";

        if (upd_longstorage_delay_pr)
            res += "UPLSTOR=" + IntToStroka(upd_longstorage_delay) + ", ";

        if (ruleshash.size() > 0) {
            first_record = true;
            it = ruleshash.begin();
            while (it != ruleshash.end()) {
                if ((*it).second.fulltime >= 250) {
                    if (first_record) {
                        first_record = false;
                        res = res + "RULES[count,time]:{";
                        res = res + (*it).first + "[" + IntToStroka((*it).second.count) + "," + IntToStroka((*it).second.fulltime) + "]";
                    } else
                        res = res + ", " + (*it).first + "[" + IntToStroka((*it).second.count) + "," + IntToStroka((*it).second.fulltime) + "]";
                }

                ++it;
            }
            if (!first_record)
                res = res + "}";
        }

        TString sptrc = "";
        auto it_s = sp_traccert.begin();
        while (it_s != sp_traccert.end()) {
            sptrc += IntToStroka2(it_s->m_index) + "=" + IntToStroka(it_s->m_delay_ms) + ",";

            ++it_s;
        }
        res += "SPTRC(" + sptrc + "), ";

        TString sptrc_ml = "";
        auto itml = sp_traccert_ml.begin();
        while (itml != sp_traccert_ml.end()) {
            sptrc_ml += IntToStroka2(itml->m_index) + "=" + IntToStroka(itml->m_delay_ms) + ",";

            ++itml;
        }
        res += "SPTRC_ML(" + sptrc_ml + "), ";

        return res;
    }

    void SetService(const TString& serviceA) {
        service = serviceA;
    }

    void SetDelayGEO(ui32 delay, bool ok) {
        geo_delay = delay;
        geo_delay_pr = true;
        geo_delay_ok = ok;
    }

    void SetDelayGEORU() {
        geo_delay_ru = true;
    }

    void SetDelayPDD(ui32 delay) {
        pdd_delay = delay;
        pdd_delay_pr = true;
    }

    void SetDelayML(ui32 delay, bool err, ui32 delay_wait_item, ui32 delay_connect, ui32 delay_request, ui32 delay_writelog) {
        ml_delay = delay;
        ml_delay_err = err;

        ml_delay_wait_item = delay_wait_item;
        ml_delay_connect = delay_connect;
        ml_delay_request = delay_request;
        ml_delay_writelog = delay_writelog;
    }

    void SetDelayFilterWorkPrepare(ui32 delay) {
        filterwork_prepare_ms = delay;
        filterwork_prepare = true;
    }

    void SetDelayFilterWorkCheckField(ui32 delay) {
        filterwork_check_field_tick_ms = delay;
        filterwork_check_field_tick = true;
    }

    void SetDelayFilterWorkCheckMessage(ui32 delay) {
        filterwork_check_message_tick_ms = delay;
        filterwork_check_message_tick = true;
    }

    void SetDelayFilterWorkPrepareML(ui32 delay) {
        filterwork_prepare_ml_ms = delay;
        filterwork_prepare_ml = true;
    }

    void SetDelayFilterWorkCheckFieldML(ui32 delay) {
        filterwork_check_field_tick_ml_ms = delay;
        filterwork_check_field_tick_ml = true;
    }

    void SetDelayFilterWorkCheckMessageML(ui32 delay) {
        filterwork_check_message_tick_ml_ms = delay;
        filterwork_check_message_tick_ml = true;
    }

    void SetDelayMLYT(ui32 delay) {
        mlyt_delay = delay;
    }

    void SetDelayWriteDeliveryLog(ui32 delay) {
        writedlvlog_delay = delay;
    }

    void SetDelayBBox(ui32 delay) {
        bbox_delay = delay;
        bbox_delay_pr = true;
    }

    void SetDelayPackets(ui32 packet1count, ui32 packet2count, ui32 packet3count, ui32 packet4count, ui32 packet5count) {
        if (packet1count > 0)
            packet1notnull = true;
        if (packet2count > 0)
            packet2notnull = true;
        if (packet3count > 0)
            packet3notnull = true;
        if (packet4count > 0)
            packet4notnull = true;
        if (packet5count > 0)
            packet5notnull = true;
    }

    void SetDelayRBLRule(ui32 delay, const TVector<TString>& rblrulelist) {
        rblrule_delay = delay;
        rblrule_delay_pr = true;

        TVector<TString>::const_iterator it;
        it = rblrulelist.begin();
        while (it != rblrulelist.end()) {
            if (!(*it).empty())
                rblrule_list.push_back(*it);

            ++it;
        }
    }

    void SetDelaySpamstat(ui32 delay, bool exist_data, bool today_ban, bool yesterday_ban, bool exist_host, bool exist_geo, ui32 delay_wait_item, ui32 delay_connect, ui32 delay_request, ui32 delay_writelog, bool badrequest) {
        spamstat_delay = delay;
        spamstat_delay_pr = true;
        spamstat_delay_exist = exist_data;

        spamstat_delay_wait_item = delay_wait_item;
        spamstat_delay_connect = delay_connect;
        spamstat_delay_request = delay_request;
        spamstat_delay_writelog = delay_writelog;

        spamstat_today_ban = today_ban;
        spamstat_yesterday_ban = yesterday_ban;
        spamstat_exist_host = exist_host;
        spamstat_exist_geo = exist_geo;

        spamstat_badrequest = badrequest;
    }

    void SetDelayCluster(bool cluster_was_requestA, ui32 delay, ui32 delay_wait_item, ui32 delay_connect, ui32 delay_request, ui32 delay_writelog, bool exist_data, bool badrequest) {
        cluster_was_request = cluster_was_requestA;
        cluster_delay = delay;
        cluster_delay_wait_item = delay_wait_item;
        cluster_delay_connect = delay_connect;
        cluster_delay_request = delay_request;
        cluster_delay_writelog = delay_writelog;
        cluster_delay_exist = exist_data;
        cluster_badrequest = badrequest;
    }

    void SetDelayResolv(ui32 delay, bool ok) {
        resolv_delay = delay;
        resolv_delay_pr = true;
        resolv_delay_ok = ok;
    }

    void SetDelayHostFromTYCache() {
        host_from_tycache = true;
    }

    void SetDelayFilterWork1step(ui32 delay) {
        filterwork_delay1step = delay;
    }

    void SetDelayFilterWork2step(ui32 delay) {
        filterwork_delay2step = delay;
    }

    void SetDelayFilterGet(ui32 delay) {
        filterget_delay = delay;
    }

    void SetDelayCheck(ui32 delay) {
        check_delay = delay;
    }

    void SetDelayFull(ui32 delay) {
        full_delay = delay;
    }

    void SetDelayLst(ui32 delay) {
        lst_delay = delay;
    }

    void SetDelayNamesLst(ui32 delay, ui32 inamenum, ui32 fnamenum) {
        nameslst_delay = delay;
        nameslst_delay_pr = true;
        nameslst_inamenum = inamenum;
        nameslst_fnamenum = fnamenum;
    }

    void SetDelayLongStorage(ui32 delay) {
        longstorage_delay = delay;
    }

    void SetDelayGetShortStorage(ui32 delay) {
        getshortstorage_delay = delay;
    }

    void SetDelaySummaryData(ui32 delay) {
        summary_delay = delay;
        summary_delay_pr = true;
    }

    void SetDelayBackAlg(ui32 delay) {
        backalg_delay = delay;
        backalg_delay_pr = true;
    }

    void SetDelayBackAlg_LoginResemblance() {
        backalg_LoginResemblance = true;
    }

    void SetDelayBackAlg_HintPasswAnswer() {
        backalg_HintPasswAnswer = true;
    }

    void SetDelayBackAlg_3min() {
        backalg_3min = true;
    }

    void SetDelayBackAlg_PacketTwo() {
        backalg_PacketTwo = true;
    }

    void SetDelayBackAlg_CompareIFNames() {
        backalg_CompareIFNames = true;
    }

    void SetDelayUpdateLongStorage(ui32 delay) {
        upd_longstorage_delay = delay;
        upd_longstorage_delay_pr = true;
    }

    void SetDelayDublicatLogin(ui32 delay) {
        dublicat_delay = delay;
        dublicat_delay_pr = true;
    }

    void SetResult(ui32 spam) {
        result_spam = spam;
    }

    void SetMLResult(ui32 mlspam) {
        result_ml_spam = mlspam;
    }

    void SetWOMLResult(ui32 womlspam) {
        result_woml_spam = womlspam;
    }

    void SetHamToSpamByML() {
        set_ham_to_spam_by_ml = true;
    }

    void SetMalicToSpamByML() {
        set_malic_to_spam_by_ml = true;
    }

    void SetSpamToHamByML() {
        set_spam_to_ham_by_ml = true;
    }

    void SetMalicToHamByML() {
        set_malic_to_ham_by_ml = true;
    }

    void SetRequestType(bool is_changepassA) {
        is_changepass = is_changepassA;
    }

    void SetIPType(bool is_ipv6A) {
        is_ipv6 = is_ipv6A;
    }

    TRuleInfoHash* GetRuleHash() {
        return &ruleshash;
    }

    void SetHamToSpamFinalres() {
        set_ham_to_spam_finalres = true;
    }
    void SetHamToMalicFinalres() {
        set_ham_to_malic_finalres = true;
    }
    void SetSpamToHamFinalres() {
        set_spam_to_ham_finalres = true;
    }
    void SetSpamToMalicFinalres() {
        set_spam_to_malic_finalres = true;
    }
    void SetMalicToHamFinalres() {
        set_malic_to_ham_finalres = true;
    }
    void SetMalicToSpamFinalres() {
        set_malic_to_spam_finalres = true;
    }
};

//***********************************************************************************
//                                      TDelays
//***********************************************************************************

struct TDelays {
    time_t processingtime;
    ui32 tprocessing[16];
    ui32 ttract[9];
    TString login;

    TDelays() {
        processingtime = 0;
        memset(tprocessing, 0, sizeof(tprocessing));
        memset(ttract, 0, sizeof(ttract));
        login = "";
    }
};

//*************************************************************************************
//                                        TBaseTClass
//*************************************************************************************

class TBaseTClass {
private:
    virtual void Lock() = 0;
    virtual void UnLock() = 0;
    //virtual void               Lock() const    = 0;
    //virtual void               UnLock() const  = 0;

public:
    virtual ~TBaseTClass() = default;

    virtual size_t size() const = 0;
};

//****************************************************************************************
//                                  TSpeedQuery
//****************************************************************************************

/*class TSpeedQuery
{
private:
      TMutex            m_Mutex;
      float             querypersec;
      float             querypersecmax;
      ui32              lasttick;
      ui64              lastquerycount;
      ui64              allquerycount;
public:
      TSpeedQuery();
      ~TSpeedQuery();

      void   AddRequest();
      TString GetQueryPerSec();
};*/

//****************************************************************************************
//                                 TBlockClass
//****************************************************************************************

class TBlockClass {
private:
    bool fblock;
    TMutex m_Mutex;

public:
    TBlockClass() {
    }
    ~TBlockClass(){};

    void Init(bool block) {
        fblock = block;
    }

    void SetBlock(bool block) {
        m_Mutex.Acquire();
        fblock = block;
        m_Mutex.Release();
    }

    bool GetBlock() {
        return fblock;
    }
};

//*****************************************************************************************
//                              TMaxAnalizDelay
//*****************************************************************************************

class TMaxAnalizDelay {
private:
    ui32 delay[7]{};
    TMutex m_Mutex;
    volatile ui32 block_counter;

public:
    TMaxAnalizDelay();

    void Midnight();

    ui32 GetDelay(int day);
    void AddDelay(ui32 delayv);
    void SetBlockCounter(ui32 value);
    TString GetStat();
};

//*****************************************************************************************
//                              TBlockIncrement
//*****************************************************************************************

class TBlockIncrement {
private:
    volatile ui32 count;
    TMutex m_Mutex;

public:
    TBlockIncrement() {
        count = 0;
    }
    ~TBlockIncrement(){};

    void Set(ui32 countA) {
        m_Mutex.Acquire();
        count = countA;
        m_Mutex.Release();
    }

    void Reset() {
        m_Mutex.Acquire();
        count = 0;
        m_Mutex.Release();
    }

    void Increment() {
        m_Mutex.Acquire();
        if (count < 0xFFFFFFFF)
            count++;
        m_Mutex.Release();
    }

    ui32 Decrement() {
        ui32 res = 0;

        m_Mutex.Acquire();
        if (count > 0)
            count--;
        res = count;
        m_Mutex.Release();

        return res;
    }
};

//******************************************************************************************************************
//                     TBackSpam - ���������� (���������/���������� ����������� ���������)
//******************************************************************************************************************

typedef THashMap<ui16, ui8> TBackSpamData;
typedef TBackSpamData::iterator TBackSpamDataIt;

class TBackSpam {
private:
    TRWMutex m_Mutex;
    THashSet<int> Algos;
    TLogsGroup* LogsGroup;

public:
    TBackSpam();

    bool Init(TString algos, TLogsGroup* LogsGroupA);

    bool Reload();
    TString GetEnableAlgorithmList();
    bool GetEnableAlgorithm(ui16 n) const;
};

//******************************************************************************
//                            TLoginList - ������ � ������� � ���������
//******************************************************************************

typedef THashMap<TString, ui8> TNamesRecord;
typedef TNamesRecord::iterator TNamesRecordIt;

class TNamesList {
private:
    TNamesRecord* list;
    TNamesRecord* extlist;
    TMutex m_Mutex;
    TString filename;
    ui32 last_loading_msec;
    TLogsGroup* LogsGroup;

    void Lock();
    void UnLock();
    bool LoadA(const TString& filenameA);
    bool LoadTextA(const TString& data);
    void ExpandList();
    static ui32 GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size);

public:
    TNamesList(TLogsGroup* LogsGroupA, const TString& filenameA);
    ~TNamesList();

    ui8 Get(const TString& login, const TString& lang);
    TString GetCompareTRSC(const TString& value, ui8& index);
    ui32 GetRecordCount();
    ui32 GetLastLoadingMSec();

    void ReloadFileList();
    void ReloadMemList(const TString& data);
};

//********************************************************************************************************************
