#include "tlogsgroup.h"

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

TLogsGroup::TLogsGroup()
{
   iniobj                  = nullptr;
   m_debug_mode            = false;
   m_ServerLog             = nullptr;
   m_InputLog              = nullptr;
   m_LongRequestLog        = nullptr;
   m_DebugInfoLog          = nullptr;
   m_MonLog                = nullptr;
   m_StorageLog            = nullptr;

   m_longrequest_treshold  = 195;

   m_IOLog                 = nullptr;
   m_IPHistoryLog          = nullptr;
   m_SendAnswerLog         = nullptr;
   m_SendAnswerLogMinor    = nullptr;
   m_ChangePasswdLog       = nullptr;
   m_ChangePasswdLogMinor  = nullptr;
   m_AllReqstLog           = nullptr;
   m_ListLog               = nullptr;
   m_FilterLog             = nullptr;

   m_ControlLog            = nullptr;
   m_LogPDD                = nullptr;
   m_LogBBox               = nullptr;
   m_LogSpamBack           = nullptr;
   m_LogTrace              = nullptr;

   m_LogTraccertDays       = nullptr;
   m_LogMoveML             = nullptr;

   m_AuthPhoneLog          = nullptr;

   m_AsyncCheckLostLog       = nullptr;
   m_AsyncCheckLostLogMinor  = nullptr;
   m_AsyncSendAnswerLog      = nullptr;
   m_AsyncSendAnswerLogMinor = nullptr;

   m_SpamonLog             = nullptr;
   m_SpamonLogMinor        = nullptr;

   m_CriticalEventLog = nullptr;
}

TLogsGroup::~TLogsGroup()
{
    DeleteLog(m_SpamonLog);
    DeleteLog(m_SpamonLogMinor);
    DeleteLog(m_AsyncSendAnswerLog);
    DeleteLog(m_AsyncSendAnswerLogMinor);
    DeleteLog(m_AsyncCheckLostLog);
    DeleteLog(m_AsyncCheckLostLogMinor);
    DeleteLog(m_StorageLog);
    DeleteLog(m_MonLog);
    DeleteLog(m_DebugInfoLog);
    DeleteLog(m_LongRequestLog);
    DeleteLog(m_InputLog);
    DeleteLog(m_ServerLog);
    DeleteLog(m_IOLog);
    DeleteLog(m_AllReqstLog);
    DeleteLog(m_ChangePasswdLogMinor);
    DeleteLog(m_ChangePasswdLog);
    DeleteLog(m_SendAnswerLogMinor);
    DeleteLog(m_SendAnswerLog);
    DeleteLog(m_IPHistoryLog);
    DeleteLog(m_ListLog);
    DeleteLog(m_FilterLog);
    DeleteLog(m_LogBBox);
    DeleteLog(m_LogPDD);
    DeleteLog(m_ControlLog);
    DeleteLog(m_LogTrace);
    DeleteLog(m_LogSpamBack);
    DeleteLog(m_LogTraccertDays);
    DeleteLog(m_LogMoveML);
    DeleteLog(m_AuthPhoneLog);
    DeleteLog(m_CriticalEventLog);
}

bool TLogsGroup::IsMinorRequest(const TString &Numbrequest)
{
   bool    res  = false;
   TString  subs = "";

   if (Numbrequest.length() > 3)
   {
      subs = Numbrequest.substr(0, 3);
      if (subs == "##P")
         res = true;
   }

   return res;
}

bool TLogsGroup::Init(TKConfig *iniobjA)
{
   bool   res                    = true;
   TString serverlog_name         = "";
   TString inputlog_name          = "";
   TString longrequest_name       = "";
   TString debuginfo_name         = "";
   TString monlog_name            = "";
   TString storage_name           = "";
   bool   enable_fflush          = false;

   TString iologname              = "";
   TString allreqstlog            = "";
   TString sendanswerlog          = "";
   TString sendanswerlog_minor    = "";
   TString changepasswdlog        = "";
   TString changepasswdlog_minor  = "";
   TString iphistorylog           = "";
   TString listlog                = "";
   TString deliverylog            = "";
   TString deliverylog_minor      = "";
   TString filterlog              = "";
   TString controllog             = "";
   TString pddlog                 = "";
   TString bboxlog                = "";
   TString logspamback            = "";
   TString tracelog               = "";
   TString mllog                  = "";
   TString mllog_minor            = "";
   TString traccertdayslog        = "";
   TString movemllog              = "";
   TString authphonelog           = "";
   TString asyncchecklostlog        = "";
   TString asyncchecklostlog_minor  = "";
   TString asyncsendanswerlog       = "";
   TString asyncsendanswerlog_minor = "";
   TString spamonlog              = "";
   TString spamonlog_minor        = "";

   iniobj = iniobjA;
   if (iniobj != nullptr)
   {
      m_debug_mode            = iniobj->ReadBool("logs", "debug_mode", false);
      enable_fflush           = iniobj->ReadBool("logs", "fflush", false);
      m_longrequest_treshold  = iniobj->ReadInteger("logs", "longrequest_treshold", 195);
      m_longrequest_mode      = iniobj->ReadInteger("logs", "longrequest_mode", 0);

      serverlog_name          = iniobj->ReadStroka("logs",     "serverlog",            "");
      inputlog_name           = iniobj->ReadStroka("logs",     "inputlog",             "");
      debuginfo_name          = iniobj->ReadStroka("logs",     "debuginfo",            "");
      monlog_name             = iniobj->ReadStroka("logs",     "monlog",               "");
      storage_name            = iniobj->ReadStroka("logs",     "storage_name",         "");
      longrequest_name        = iniobj->ReadStroka("logs",     "longrequest",          "");
      iologname               = iniobj->ReadStroka("logs",     "iolog",                "");
      allreqstlog             = iniobj->ReadStroka("logs",     "allreqst",             "");
      sendanswerlog           = iniobj->ReadStroka("logs",     "sendanswer",           "");
      sendanswerlog_minor     = iniobj->ReadStroka("logs",     "sendanswer_minor",     sendanswerlog);
      changepasswdlog         = iniobj->ReadStroka("logs",     "changepasswd",         "");
      changepasswdlog_minor   = iniobj->ReadStroka("logs",     "changepasswd_minor",   changepasswdlog);
      iphistorylog            = iniobj->ReadStroka("logs",     "iphistory",            "");
      listlog                 = iniobj->ReadStroka("logs",     "list",                 "");
      deliverylog             = iniobj->ReadStroka("logs",     "delivery",             "");
      deliverylog_minor       = iniobj->ReadStroka("logs",     "delivery_minor",       deliverylog);
      filterlog               = iniobj->ReadStroka("logs",     "filter",               "");
      controllog              = iniobj->ReadStroka("logs",     "control",              "");
      pddlog                  = iniobj->ReadStroka("logs",     "pdd",                  "");
      bboxlog                 = iniobj->ReadStroka("logs",     "bbox",                 "");
      logspamback             = iniobj->ReadStroka("logs",     "spamback",             "");
      tracelog                = iniobj->ReadStroka("logs",     "trace",                "");
      mllog                   = iniobj->ReadStroka("mlpool",   "ytlog",                "");
      mllog_minor             = iniobj->ReadStroka("mlpool",   "ytlog_minor",          "");
      traccertdayslog         = iniobj->ReadStroka("logs",     "traccertdays",         "");
      movemllog               = iniobj->ReadStroka("logs",     "moveml",               "");
      authphonelog            = iniobj->ReadStroka("logs",     "authphone",            "");
      asyncchecklostlog        = iniobj->ReadStroka("logs",     "asyncchecklostlog",        "");
      asyncchecklostlog_minor  = iniobj->ReadStroka("logs",     "asyncchecklostlog_minor",  asyncchecklostlog);
      asyncsendanswerlog       = iniobj->ReadStroka("logs",     "asyncsendanswerlog",       "");
      asyncsendanswerlog_minor = iniobj->ReadStroka("logs",     "asyncsendanswerlog_minor", asyncsendanswerlog);
      spamonlog               = iniobj->ReadStroka("logs",     "spamonlog",            "");
      spamonlog_minor         = iniobj->ReadStroka("logs",     "spamonlog_minor",      spamonlog);

      if (!serverlog_name.empty())
      {
         m_ServerLog = new TLogClass(serverlog_name, false);
         if (m_ServerLog != nullptr)
         {
             m_ServerLog->EnableWrite();
             m_ServerLog->SetDisableFFlush(!enable_fflush);
         }
      }

      if (!inputlog_name.empty())
      {
         m_InputLog = new TLogClass(inputlog_name, false);
         if (m_InputLog != nullptr)
         {
             m_InputLog->EnableWrite();
             m_InputLog->SetDisableFFlush(!enable_fflush);
         }
      }

      if (!debuginfo_name.empty())
      {
         m_DebugInfoLog = new TLogClass(debuginfo_name, false);
         if (m_DebugInfoLog != nullptr)
         {
             m_DebugInfoLog->EnableWrite();
             m_DebugInfoLog->SetDisableFFlush(!enable_fflush);
         }
      }

      if (!monlog_name.empty())
      {
         m_MonLog = new TLogClass(monlog_name, false, "#<SCODE: server_code><LIMIT: FULL=okcount-avg_ok-skeepcount-avg_skeep-max,0_10-10_20-20_30-30_50-50_100-50_100-150_190-190_500-more500 FASTGET=... FASTPUT=... ><DBNameTable: [UPdate: good-bad,0_10-10_20-20_50-50_100-100_150-150_190-190_500-more500][FindOne: ...][Erase: ...][SiZe: ...][Multiaction: ...][Find: ..][CLeaR: ...][FindandModify: ...] >\n");
         if (m_MonLog != nullptr)
         {
             m_MonLog->EnableWrite();
             m_MonLog->SetDisableFFlush(!enable_fflush);
         }
      }

      if (!storage_name.empty())
      {
         m_StorageLog = new TLogClass(storage_name, false);
         if (m_StorageLog != nullptr)
         {
             m_StorageLog->EnableWrite();
             m_StorageLog->SetDisableFFlush(!enable_fflush);
         }
      }

      if (!longrequest_name.empty())
      {
         m_LongRequestLog = new TLogClass(longrequest_name, false);
         if (m_LongRequestLog != nullptr)
         {
             m_LongRequestLog->EnableWrite();
             m_LongRequestLog->SetDisableFFlush(!enable_fflush);
         }
      }

      if (!allreqstlog.empty())
      {
         char     buff[1024];
         TString   f0 = "DATA:";
         TString   f1 = "LOGIN:";
         TString   f2 = "UID:";
         TString   f3 = "WEIGHT(BACKALG):";
         TString   f4 = "REQTYPE:";
         TString   f5 = "IP:";
         TString   f6 = "#";
         TString   f7 = "MESSNUMB:";

         for (int i = 0; i < 227; i++)
            f6 += "-";
         memset(buff, 0, sizeof(buff));
         snprintf(buff, sizeof(buff) - 1, "%s\n#%20s %50s %20s %16s %20s %50s %45s\n%s\n", f6.c_str(), f0.c_str(), f1.c_str(), f2.c_str(), f3.c_str(), f4.c_str(), f5.c_str(), f7.c_str(), f6.c_str());

         m_AllReqstLog = new TLogClass(allreqstlog, false, buff);
         if (m_AllReqstLog != nullptr)
         {
            m_AllReqstLog->EnableWrite();
            m_AllReqstLog->SetDisableFFlush(!enable_fflush);
         }

      }

      if (!iologname.empty())
      {
         m_IOLog = new TLogClass(iologname, false);
         if (m_IOLog != nullptr)
         {
            m_IOLog->EnableWrite();
            m_IOLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!sendanswerlog.empty())
      {
         m_SendAnswerLog = new TLogClass(sendanswerlog, false);
         if (m_SendAnswerLog != nullptr)
         {
            m_SendAnswerLog->EnableWrite();
            m_SendAnswerLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!sendanswerlog_minor.empty())
      {
         m_SendAnswerLogMinor = new TLogClass(sendanswerlog_minor, false);
         if (m_SendAnswerLogMinor != nullptr)
         {
            m_SendAnswerLogMinor->EnableWrite();
            m_SendAnswerLogMinor->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!changepasswdlog.empty())
      {
         m_ChangePasswdLog = new TLogClass(changepasswdlog, false, "#\n#-------------------------------------------------------------------------------------------------------------------------------\n#     TIME        UID                 IP                                    LOGIN WEIGHT                                MESSNUMB\n#-------------------------------------------------------------------------------------------------------------------------------\n");
         if (m_ChangePasswdLog != nullptr)
         {
            m_ChangePasswdLog->EnableWrite();
            m_ChangePasswdLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!changepasswdlog_minor.empty())
      {
         m_ChangePasswdLogMinor = new TLogClass(changepasswdlog_minor, false, "#\n#-------------------------------------------------------------------------------------------------------------------------------\n#     TIME        UID                 IP                                    LOGIN WEIGHT                                MESSNUMB\n#-------------------------------------------------------------------------------------------------------------------------------\n");
         if (m_ChangePasswdLogMinor != nullptr)
         {
            m_ChangePasswdLogMinor->EnableWrite();
            m_ChangePasswdLogMinor->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!iphistorylog.empty())
      {
         m_IPHistoryLog = new TLogClass(iphistorylog, false);
         if (m_IPHistoryLog != nullptr)
         {
            m_IPHistoryLog->EnableWrite();
            m_IPHistoryLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!listlog.empty())
      {
         m_ListLog = new TLogClass(listlog, false);
         if (m_ListLog != nullptr)
         {
            m_ListLog->EnableWrite();
            m_ListLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (deliverylog) {
          DeliveryLog.ResetBackend(CreateOwningThreadedLogBackend(deliverylog));
      }

       if (deliverylog_minor) {
           DeliveryLogMinor.ResetBackend(CreateOwningThreadedLogBackend(deliverylog_minor));
       }

      if (!filterlog.empty())
      {
         m_FilterLog = new TLogClass(filterlog, false);
         if (m_FilterLog != nullptr)
         {
            m_FilterLog->EnableWrite();
            m_FilterLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!controllog.empty())
      {
         m_ControlLog = new TLogClass(controllog, false);
         if (m_ControlLog != nullptr)
         {
            m_ControlLog->EnableWrite();
            m_ControlLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!pddlog.empty())
      {
         m_LogPDD = new TLogClass(pddlog, false);
         if (m_LogPDD != nullptr)
         {
            m_LogPDD->EnableWrite();
            m_LogPDD->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!bboxlog.empty())
      {
         m_LogBBox = new TLogClass(bboxlog, false);
         if (m_LogBBox != nullptr)
         {
            m_LogBBox->EnableWrite();
            m_LogBBox->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!logspamback.empty())
      {
         m_LogSpamBack = new TLogClass(logspamback, false, "#-----------------------------------------------------------------------------------------------------------------------------------------------\n#                                     IP                     LOGIN                              DATE ALG                                MESSNUMB\n#-----------------------------------------------------------------------------------------------------------------------------------------------\n");
         if (m_LogSpamBack != nullptr)
         {
            m_LogSpamBack->EnableWrite();
            m_LogSpamBack->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!tracelog.empty())
      {
         m_LogTrace = new TLogClass(tracelog, false);
         if (m_LogTrace != nullptr)
         {
            m_LogTrace->EnableWrite();
            m_LogTrace->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!mllog.empty())
      {
          MlLog.ResetBackend(CreateOwningThreadedLogBackend(mllog));
      }

      if (!mllog_minor.empty())
      {
          MlLogMinor.ResetBackend(CreateOwningThreadedLogBackend(mllog_minor));
      }

      if (!traccertdayslog.empty())
      {
         m_LogTraccertDays = new TLogClass(traccertdayslog, false);
         if (m_LogTraccertDays != nullptr)
         {
            m_LogTraccertDays->EnableWrite();
            m_LogTraccertDays->SetDisableFFlush(!enable_fflush);

         }
      }


      if (!movemllog.empty())
      {
         m_LogMoveML = new TLogClass(movemllog, false);
         if (m_LogMoveML != nullptr)
         {
            m_LogMoveML->EnableWrite();
            m_LogMoveML->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!authphonelog.empty())
      {
         m_AuthPhoneLog = new TLogClass(authphonelog, false);
         if (m_AuthPhoneLog != nullptr)
         {
            m_AuthPhoneLog->EnableWrite();
            m_AuthPhoneLog->SetDisableFFlush(!enable_fflush);
         }
      }

      if (!asyncchecklostlog.empty())
      {
         m_AsyncCheckLostLog = new TLogClass(asyncchecklostlog, false);
         if (m_AsyncCheckLostLog != nullptr)
         {
            m_AsyncCheckLostLog->EnableWrite();
            m_AsyncCheckLostLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!asyncchecklostlog_minor.empty())
      {
         m_AsyncCheckLostLogMinor = new TLogClass(asyncchecklostlog_minor, false);
         if (m_AsyncCheckLostLogMinor != nullptr)
         {
            m_AsyncCheckLostLogMinor->EnableWrite();
            m_AsyncCheckLostLogMinor->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!asyncsendanswerlog.empty())
      {
         m_AsyncSendAnswerLog = new TLogClass(asyncsendanswerlog, false);
         if (m_AsyncSendAnswerLog != nullptr)
         {
            m_AsyncSendAnswerLog->EnableWrite();
            m_AsyncSendAnswerLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!asyncsendanswerlog_minor.empty())
      {
         m_AsyncSendAnswerLogMinor = new TLogClass(asyncsendanswerlog_minor, false);
         if (m_AsyncSendAnswerLogMinor != nullptr)
         {
            m_AsyncSendAnswerLogMinor->EnableWrite();
            m_AsyncSendAnswerLogMinor->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!spamonlog.empty())
      {
         m_SpamonLog = new TLogClass(spamonlog, false);
         if (m_SpamonLog != nullptr)
         {
            m_SpamonLog->EnableWrite();
            m_SpamonLog->SetDisableFFlush(!enable_fflush);

         }
      }

      if (!spamonlog_minor.empty())
      {
         m_SpamonLogMinor = new TLogClass(spamonlog_minor, false);
         if (m_SpamonLogMinor != nullptr)
         {
            m_SpamonLogMinor->EnableWrite();
            m_SpamonLogMinor->SetDisableFFlush(!enable_fflush);

         }
      }

      m_CriticalEventLog = CreateLog(iniobj->ReadStroka("logs", "criticallog", ""));

   }

   return res;
}

bool TLogsGroup::TruncLog()
{
   bool res = true;

   if (m_ServerLog != nullptr)
      if (!m_ServerLog->TruncLog())
         res = false;

   if (m_InputLog != nullptr)
      if (!m_InputLog->TruncLog())
         res = false;

   if (m_DebugInfoLog != nullptr)
      if (!m_DebugInfoLog->TruncLog())
         res = false;

   if (m_MonLog != nullptr)
      if (!m_MonLog->TruncLog())
         res = false;

   if (m_StorageLog != nullptr)
      if (!m_StorageLog->TruncLog())
         res = false;

   if (m_LongRequestLog != nullptr)
      if (!m_LongRequestLog->TruncLog())
         res = false;

   if (m_AllReqstLog != nullptr)
      if (!m_AllReqstLog->TruncLog())
         res = false;

   if (m_IOLog != nullptr)
      if (!m_IOLog->TruncLog())
         res = false;

   if (m_SendAnswerLog != nullptr)
      if (!m_SendAnswerLog->TruncLog())
         res = false;

   if (m_SendAnswerLogMinor != nullptr)
      if (!m_SendAnswerLogMinor->TruncLog())
         res = false;

   if (m_ChangePasswdLog != nullptr)
      if (!m_ChangePasswdLog->TruncLog())
         res = false;

   if (m_ChangePasswdLogMinor != nullptr)
      if (!m_ChangePasswdLogMinor->TruncLog())
         res = false;

   if (m_IPHistoryLog != nullptr)
      if (!m_IPHistoryLog->TruncLog())
         res = false;

   if (m_ListLog != nullptr)
      if (!m_ListLog->TruncLog())
         res = false;

    DeliveryLog.ReopenLog();
    DeliveryLogMinor.ReopenLog();

   if (m_FilterLog != nullptr)
      if (!m_FilterLog->TruncLog())
         res = false;

   if (m_ControlLog != nullptr)
      if (!m_ControlLog->TruncLog())
         res = false;

   if (m_LogPDD != nullptr)
      if (!m_LogPDD->TruncLog())
         res = false;

   if (m_LogBBox != nullptr)
      if (!m_LogBBox->TruncLog())
         res = false;

   if (m_LogSpamBack != nullptr)
      if (!m_LogSpamBack->TruncLog())
         res = false;

   if (m_LogTrace != nullptr)
      if (!m_LogTrace->TruncLog())
         res = false;

   MlLog.ReopenLog();
   MlLogMinor.ReopenLog();

   if (m_LogTraccertDays != nullptr)
      if (!m_LogTraccertDays->TruncLog())
         res = false;

   if (m_LogMoveML != nullptr)
      if (!m_LogMoveML->TruncLog())
         res = false;

   if (m_AuthPhoneLog != nullptr)
      if (!m_AuthPhoneLog->TruncLog())
         res = false;

   if (m_AsyncCheckLostLog != nullptr)
      if (!m_AsyncCheckLostLog->TruncLog())
         res = false;

   if (m_AsyncCheckLostLogMinor != nullptr)
      if (!m_AsyncCheckLostLogMinor->TruncLog())
         res = false;

   if (m_AsyncSendAnswerLog != nullptr)
      if (!m_AsyncSendAnswerLog->TruncLog())
         res = false;

   if (m_AsyncSendAnswerLogMinor != nullptr)
      if (!m_AsyncSendAnswerLogMinor->TruncLog())
         res = false;

   if (m_SpamonLog != nullptr)
      if (!m_SpamonLog->TruncLog())
         res = false;

   if (m_SpamonLogMinor != nullptr)
      if (!m_SpamonLogMinor->TruncLog())
         res = false;

   if (m_CriticalEventLog != nullptr)
       if (!m_CriticalEventLog->TruncLog())
           res = false;

   return res;
}

void TLogsGroup::DisableFFlush(bool dsb)
{
   if (m_ServerLog != nullptr)
      m_ServerLog->SetDisableFFlush(dsb);

   if (m_InputLog != nullptr)
      m_InputLog->SetDisableFFlush(dsb);

   if (m_DebugInfoLog != nullptr)
      m_DebugInfoLog->SetDisableFFlush(dsb);

   if (m_MonLog != nullptr)
      m_MonLog->SetDisableFFlush(dsb);

   if (m_StorageLog != nullptr)
      m_StorageLog->SetDisableFFlush(dsb);

   if (m_LongRequestLog != nullptr)
      m_LongRequestLog->SetDisableFFlush(dsb);

   if (m_AllReqstLog != nullptr)
      m_AllReqstLog->SetDisableFFlush(dsb);

   if (m_IOLog != nullptr)
      m_IOLog->SetDisableFFlush(dsb);

   if (m_SendAnswerLog != nullptr)
      m_SendAnswerLog->SetDisableFFlush(dsb);

   if (m_SendAnswerLogMinor != nullptr)
      m_SendAnswerLogMinor->SetDisableFFlush(dsb);

   if (m_ChangePasswdLog != nullptr)
      m_ChangePasswdLog->SetDisableFFlush(dsb);

   if (m_ChangePasswdLogMinor != nullptr)
      m_ChangePasswdLogMinor->SetDisableFFlush(dsb);

   if (m_IPHistoryLog != nullptr)
      m_IPHistoryLog->SetDisableFFlush(dsb);

   if (m_ListLog != nullptr)
      m_ListLog->SetDisableFFlush(dsb);

   if (m_FilterLog != nullptr)
      m_FilterLog->SetDisableFFlush(dsb);

   if (m_ControlLog != nullptr)
      m_ControlLog->SetDisableFFlush(dsb);

   if (m_LogPDD != nullptr)
      m_LogPDD->SetDisableFFlush(dsb);

   if (m_LogBBox != nullptr)
      m_LogBBox->SetDisableFFlush(dsb);

   if (m_LogSpamBack != nullptr)
      m_LogSpamBack->SetDisableFFlush(dsb);

   if (m_LogTrace != nullptr)
      m_LogTrace->SetDisableFFlush(dsb);

   if (m_LogTraccertDays != nullptr)
      m_LogTraccertDays->SetDisableFFlush(dsb);

   if (m_LogMoveML != nullptr)
      m_LogMoveML->SetDisableFFlush(dsb);

   if (m_AuthPhoneLog != nullptr)
      m_AuthPhoneLog->SetDisableFFlush(dsb);

   if (m_AsyncCheckLostLog != nullptr)
      m_AsyncCheckLostLog->SetDisableFFlush(dsb);

   if (m_AsyncCheckLostLogMinor != nullptr)
      m_AsyncCheckLostLogMinor->SetDisableFFlush(dsb);

   if (m_AsyncSendAnswerLog != nullptr)
      m_AsyncSendAnswerLog->SetDisableFFlush(dsb);

   if (m_AsyncSendAnswerLogMinor != nullptr)
      m_AsyncSendAnswerLogMinor->SetDisableFFlush(dsb);

   if (m_SpamonLog != nullptr)
      m_SpamonLog->SetDisableFFlush(dsb);

   if (m_SpamonLogMinor != nullptr)
      m_SpamonLogMinor->SetDisableFFlush(dsb);

   if (m_CriticalEventLog != nullptr)
       m_CriticalEventLog->SetDisableFFlush(dsb);
}

TLogClass *TLogsGroup::GetSendAnswerLog(bool is_upstream_request /*const TString &Numbrequest*/)
{
   TLogClass *res = nullptr;

   //if (IsMinorRequest(Numbrequest))
   if (!is_upstream_request)
      res = m_SendAnswerLogMinor;
   else
      res = m_SendAnswerLog;

   return res;
}

TLogClass *TLogsGroup::ChangePasswdLog(bool is_upstream_request /*const TString &Numbrequest*/)
{
   TLogClass *res = nullptr;

   //if (IsMinorRequest(Numbrequest))
   if (!is_upstream_request)
      res = m_ChangePasswdLogMinor;
   else
      res = m_ChangePasswdLog;

   return res;
}

const TLog& TLogsGroup::GetLogML(bool is_upstream_request /*const TString &Numbrequest*/) const
{
   if (!is_upstream_request)
      return MlLogMinor;
   else
      return MlLog;
}


const TLog& TLogsGroup::GetDeliveryLog(bool is_upstream_request /*const TString &Numbrequest*/) const
{
    if (!is_upstream_request)
        return DeliveryLogMinor;
    else
        return DeliveryLog;
}

TLogClass *TLogsGroup::GetAsyncCheckLostLog(bool is_upstream_request  /*const TString &Numbrequest*/)
{
   TLogClass *res = nullptr;

   //if (IsMinorRequest(Numbrequest))
   if (!is_upstream_request)
      res = m_AsyncCheckLostLogMinor;
   else
      res = m_AsyncCheckLostLog;

   return res;
}

TLogClass *TLogsGroup::GetAsyncSendAnswerLog(bool is_upstream_request  /*const TString &Numbrequest*/)
{
   TLogClass *res = nullptr;

   //if (IsMinorRequest(Numbrequest))
   if (!is_upstream_request)
      res = m_AsyncSendAnswerLogMinor;
   else
      res = m_AsyncSendAnswerLog;

   return res;
}

TLogClass *TLogsGroup::GetSpamonLog(bool is_upstream_request /*const TString &Numbrequest*/)
{
   TLogClass *res = nullptr;

   //if (IsMinorRequest(Numbrequest))
   if (!is_upstream_request)
      res = m_SpamonLogMinor;
   else
      res = m_SpamonLog;

   return res;
}

//****************************************************************************************************************************************
//                                              ��������� TLogsGroup
//****************************************************************************************************************************************

TLogsGroupFake::TLogsGroupFake()
{
   m_ServerLog   = nullptr;
   m_DeliveryLog = nullptr;
   m_FilterLog   = nullptr;
}

TLogsGroupFake::~TLogsGroupFake()
= default;

bool TLogsGroupFake::Init(TBaseLogClass *ServerLogA, TBaseLogClass *DeliveryLogA, TBaseLogClass *FilterLogA)
{
   m_ServerLog   = ServerLogA;
   m_DeliveryLog = DeliveryLogA;
   m_FilterLog   = FilterLogA;

   return true;
}

//******************************************************************************************************************************************
