#pragma once

#include <util/generic/string.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/tlogsgroupbase.h>

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

class TLogsGroup: public TLogsGroupBase
{
private:
         TKConfig       *iniobj;
         TLogClass      *m_ServerLog;
         TLogClass      *m_InputLog;
         TLogClass      *m_LongRequestLog;
         TLogClass      *m_DebugInfoLog;
         TLogClass      *m_MonLog;
         TLogClass      *m_StorageLog;

         TLogClass      *m_IOLog;
         TLogClass      *m_SendAnswerLog;
         TLogClass      *m_SendAnswerLogMinor;
         TLogClass      *m_ChangePasswdLog;
         TLogClass      *m_ChangePasswdLogMinor;
         TLogClass      *m_IPHistoryLog;
         TLogClass      *m_AllReqstLog;
         TLogClass      *m_ListLog;
         TLogClass      *m_FilterLog;
         TLogClass      *m_ControlLog;
         TLogClass      *m_LogPDD;
         TLogClass      *m_LogBBox;
         TLogClass      *m_LogSpamBack;
         TLogClass      *m_LogTrace;
         TLog        MlLog;
         TLog        MlLogMinor;
         TLog        DeliveryLog;
         TLog        DeliveryLogMinor;
         TLogClass      *m_LogTraccertDays;
         TLogClass      *m_LogMoveML;
         TLogClass      *m_AuthPhoneLog;
         TLogClass      *m_AsyncCheckLostLog;
         TLogClass      *m_AsyncCheckLostLogMinor;
         TLogClass      *m_AsyncSendAnswerLog;
         TLogClass      *m_AsyncSendAnswerLogMinor;
         TLogClass      *m_SpamonLog;
         TLogClass      *m_SpamonLogMinor;
         TLogClass      *m_CriticalEventLog;

         static bool           IsMinorRequest(const TString &Numbrequest);
public:
         TLogsGroup();
         ~TLogsGroup();

         bool Init(TKConfig *iniobjA);

         TLogClass      *GetServerLog()         { return m_ServerLog;            }
         TLogClass      *GetInputLog()          { return m_InputLog;             }
         TLogClass      *GetLongRequestLog()    { return m_LongRequestLog;       }
         TLogClass      *GetDebugInfoLog()      { return m_DebugInfoLog;         }
         TLogClass      *GetMonLog()            { return m_MonLog;               }
         TLogClass      *GetStorageLog()        { return m_StorageLog;           }
         TLogClass      *GetErrorLog()          { return m_StorageLog;           }

         TLogClass      *GetIOLog()             { return m_IOLog;                }
         TLogClass      *GetIPHistoryLog()      { return m_IPHistoryLog;         }
         TLogClass      *GetSendAnswerLog(bool is_upstream_request);
         TLogClass      *ChangePasswdLog(bool is_upstream_request);
         TLogClass      *GetAllReqstLog()       { return m_AllReqstLog;          }
         TLogClass      *GetListLog()           { return m_ListLog;              }
         TLogClass      *GetFilterLog()         { return m_FilterLog;            }

         TLogClass      *GetControlLog()        { return m_ControlLog;           }
         TLogClass      *GetLogPDD()            { return m_LogPDD;               }
         TLogClass      *GetLogBBox()           { return m_LogBBox;              }
         TLogClass      *GetLogSpamBack()       { return m_LogSpamBack;          }
         TLogClass      *GetLogTrace()          { return m_LogTrace;             }
    const TLog&           GetLogML(bool is_upstream_request) const;
    const TLog&           GetDeliveryLog(bool is_upstream_request) const;

         TLogClass      *GetLogTraccertDays()   { return m_LogTraccertDays;      }
         TLogClass      *GetLogMoveML()         { return m_LogMoveML;            }

         TLogClass      *GetAuthPhoneLog()      { return m_AuthPhoneLog;         }
         TLogClass      *GetAsyncCheckLostLog(bool is_upstream_request);
         TLogClass      *GetAsyncSendAnswerLog(bool is_upstream_request);

         TLogClass      *GetSpamonLog(bool is_upstream_request);

         TLogClass      *GetCriticalEventLog()  { return m_CriticalEventLog;     }

         bool           TruncLog();
         void           DisableFFlush(bool dsb);
};

//****************************************************************************************************************************************
//                                              ��������� TLogsGroup
//****************************************************************************************************************************************

class TLogsGroupFake
{
private:
         TBaseLogClass      *m_ServerLog;
         TBaseLogClass      *m_DeliveryLog;
         TBaseLogClass      *m_FilterLog;
public:
         TLogsGroupFake();
         ~TLogsGroupFake();

         bool Init(TBaseLogClass *ServerLogA, TBaseLogClass *DeliveryLogA, TBaseLogClass *FilterLogA);

         TBaseLogClass  *GetServerLog()    { return m_ServerLog;    }
         TBaseLogClass  *GetDeliveryLog()  { return m_DeliveryLog;  }
         TBaseLogClass  *GetFilterLog()    { return m_FilterLog;    }
};

//******************************************************************************************************************************************


