#include <mail/so/spamstop/tools/so-common/color_scheme.h>
#include "tlongbasacache.h"

//****************************************************************************************************************************************
//                                                          TLongBasaCache
//****************************************************************************************************************************************

TLongBasaCache::TLongBasaCache() {
    m_enable = true;
    m_mode = CM_BYERR;
    LogsGroup = NULL;
#ifndef USE_NCACHE
    data = MakeHolder<frodo_st::TStorageDataItemHash>();
    data_prev = MakeHolder<frodo_st::TStorageDataItemHash>();
#endif
    m_last_swap_cache = time(NULL);
}

void TLongBasaCache::Init(bool enable, TLogsGroup* LogsGroupA, TKConfig* configA) {
    m_enable = enable;
    LogsGroup = LogsGroupA;
    if (configA != NULL) {
        m_live_period = configA->ReadInteger("storcache", "live_period", DEFAULT_LIVE_PERIOD_SEC);
        m_max_record_in_cache = configA->ReadInteger("storcache", "max_record_in_cache", DEFAULT_MAX_RECORD_IN_CACHE);

        TString mode_s = TString{Trim(configA->ReadStroka("storcache", "mode", "by_err"))};
        to_lower(mode_s);
        if (mode_s == "all")
            m_mode = CM_ALL;
        else
            m_mode = CM_BYERR;
    }

#ifdef USE_NCACHE
    data_cache.Init(m_live_period);
#endif
}

TString TLongBasaCache::TCacheModeToTString(TCacheMode mode) {
    TString res = "";

    if (mode == CM_BYERR)
        res = "By error";
    else
        res = "All";

    return res;
}

void TLongBasaCache::EventTick() {
#ifdef USE_NCACHE
    data_cache.EventTick();
#else //USE_NCACHE
    ui32 current_time = time(NULL);

    if ((current_time > m_last_swap_cache) && ((current_time - m_last_swap_cache) >= m_live_period)) {
        m_Mutex.Acquire();

        data_prev = std::exchange(data, {});

        m_last_swap_cache = current_time;

        m_Mutex.Release();
    }
#endif
}

void TLongBasaCache::Midnight() {
    m_Mutex.Acquire();

    m_inout_stat.Midnight();

    m_Mutex.Release();
}

TLongBasaCache::TLongBasaCacheStat TLongBasaCache::GetStat() {
    TLongBasaCache::TLongBasaCacheStat res;

    m_Mutex.Acquire();

    res.enable = m_enable;
    res.mode = m_mode;
    res.live_period = m_live_period;
    res.max_record_in_cache = m_max_record_in_cache;

    if (data)
        res.data_size = data->size();

    if (data_prev)
        res.data_prev_size = data_prev->size();

    res.last_swap_time = m_last_swap_cache;

    res.inoutstat = m_inout_stat;

    m_Mutex.Release();

    return res;
}

void TLongBasaCache::Add(ui64 shingle, const frodo_st::TStorageDataItem& datacnt) {
    if (m_enable) {
        ui32 current_time = time(NULL);

        if ((current_time > m_last_swap_cache) && ((current_time - m_last_swap_cache) > 2 * m_live_period))
            EventTick();

        //add
        frodo_st::TStorageDataItemHashIt it;

        m_Mutex.Acquire();

        m_inout_stat.m_today.m_add_all = IncMax32(m_inout_stat.m_today.m_add_all, 1);

        if (data) {
            it = data->find(shingle);
            if (it == data->end()) {
                (*data)[shingle] = datacnt;
                m_inout_stat.m_today.m_add_new = IncMax32(m_inout_stat.m_today.m_add_new, 1);

            } else {
                (*it).second = datacnt;
            }
        }

        m_Mutex.Release();
    }
}

frodo_st::TStorageDataItem TLongBasaCache::Get(ui64 shingle, bool& exists) {
    frodo_st::TStorageDataItem res;

    exists = false;
    if (m_enable) {
        frodo_st::TStorageDataItemHashIt it;

        m_Mutex.Acquire();

        m_inout_stat.m_today.m_get_all = IncMax32(m_inout_stat.m_today.m_get_all, 1);

        if (!exists) {
            if (data) {
                it = data->find(shingle);
                if (it != data->end()) {
                    res = (*it).second;
                    exists = true;
                }
            }
        }

        if (!exists) {
            if (data_prev) {
                it = data_prev->find(shingle);
                if (it != data_prev->end()) {
                    res = (*it).second;
                    exists = true;
                }
            }
        }

        if (exists)
            m_inout_stat.m_today.m_get_exists = IncMax32(m_inout_stat.m_today.m_get_exists, 1);

        m_Mutex.Release();
    }

    return res;
}

TString TLongBasaCache::GetCacheStatistic() {
    TString res = "";
    TLongBasaCacheStat stat;
    ui32 curr_time = time(NULL);

    stat = GetStat();

    res += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(color_table_default) + ">";
    res += "<tr><td width='25%'>Enable</td><td colspan='2'>" + BoolToStroka2(stat.enable) + "</td></tr>";
    res += "<tr><td width='25%'>Mode</td><td colspan='2'>" + TCacheModeToTString(stat.mode) + "</td></tr>";
    res += "<tr><td width='25%'>Live period</td><td colspan='2'>" + IntToStroka(stat.live_period) + " sec</td></tr>";
    res += "<tr><td width='25%'>Max recod in cache</td><td colspan='2'>" + IntToStroka(stat.max_record_in_cache) + "</td></tr>";
    res += "<tr><td width='25%'>Data size</td><td colspan='2'>" + IntToStroka(stat.data_size) + "</td></tr>";
    res += "<tr><td width='25%'>Prev data size</td><td colspan='2'>" + IntToStroka(stat.data_prev_size) + "</td></tr>";
    res += "<tr><td width='25%'>Last swap time (elapsed)</td><td colspan='2'>" + TimeToStr(stat.last_swap_time) + " (" + IntToHourMinSec(curr_time - stat.last_swap_time) + ")</td></tr>";
    res += "<tr bgcolor='" + TString(color_table_shap) + "'><td width='25%'>&nbsp;</td><td width='37%'><b>TODAY</b></td><td width='38%'><b>YESTERDAY</b></td></tr>";
    res += "<tr><td width='25%'>Get, all</td><td>" + IntToStroka(stat.inoutstat.m_today.m_get_all) + "</td><td>" + IntToStroka(stat.inoutstat.m_yesterday.m_get_all) + "</td></tr>";
    res += "<tr><td width='25%'>Get, exists</td><td>" + IntToStroka(stat.inoutstat.m_today.m_get_exists) + "</td><td>" + IntToStroka(stat.inoutstat.m_yesterday.m_get_exists) + "</td></tr>";
    res += "<tr><td width='25%'>Add, all</td><td>" + IntToStroka(stat.inoutstat.m_today.m_add_all) + "</td><td>" + IntToStroka(stat.inoutstat.m_yesterday.m_add_all) + "</td></tr>";
    res += "<tr><td width='25%'>Add, new</td><td>" + IntToStroka(stat.inoutstat.m_today.m_add_new) + "</td><td>" + IntToStroka(stat.inoutstat.m_yesterday.m_add_new) + "</td></tr>";
    res += "</table>";

    return res;
}

//****************************************************************************************************************************************
