#pragma once

#include "util/datetime/systime.h"
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "tlogsgroup.h"
#include "tfrodotypes.h"
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-common/local_cache_template.h>

//****************************************************************************************************************************************
//                                                          TLongBasaCache
//****************************************************************************************************************************************

//#define USE_NCACHE

struct TInOutStat
{
   ui32 m_add_all;
   ui32 m_add_new;
   ui32 m_get_all;
   ui32 m_get_exists;

   TInOutStat()
   {
      Clear();
   }

   void Clear()
   {
      m_add_all     = 0;
      m_add_new     = 0;
      m_get_all     = 0;
      m_get_exists  = 0;
   }
};

struct TInOutStatTY
{
   TInOutStat m_today;
   TInOutStat m_yesterday;

   TInOutStatTY()
   {
      Clear();
   }

   void Clear()
   {
      m_today.Clear();
      m_yesterday.Clear();
   }

   void Midnight()
   {
      m_yesterday = m_today;
      m_today.Clear();
   }
};

class TLongBasaCache
{
private:
         static const ui32 DEFAULT_LIVE_PERIOD_SEC     = 60;
         static const ui32 DEFAULT_MAX_RECORD_IN_CACHE = 10000000;
public:
         enum TCacheMode {CM_ALL, CM_BYERR};

         TString TCacheModeToTString(TCacheMode mode);

         struct TLongBasaCacheStat
         {
            bool           enable;
            TCacheMode     mode;
            ui32           live_period;
            ui32           max_record_in_cache;
            ui32           data_size;
            ui32           data_prev_size;
            ui32           last_swap_time;
            TInOutStatTY   inoutstat;

            TLongBasaCacheStat()
            {
               Clear();
            }

            void Clear()
            {
               enable               = false;
               mode                 = CM_BYERR;
               live_period          = 0;
               max_record_in_cache  = 0;
               data_size            = 0;
               data_prev_size       = 0;
               last_swap_time       = 0;
               inoutstat.Clear();
            }
         };
private:
         bool        m_enable;
         TCacheMode  m_mode;

#ifdef USE_NCACHE
         NCache::TCacheBase<ui64, frodo_st::TStorageDataItem> data_cache;
#else  //USE_NCACHE
         THolder<frodo_st::TStorageDataItemHash> data;
         THolder<frodo_st::TStorageDataItemHash> data_prev;
#endif
         TLogsGroup     *LogsGroup;
         ui32           m_live_period;
         ui32           m_max_record_in_cache;
         ui32           m_last_swap_cache;
         TMutex         m_Mutex;

         TInOutStatTY   m_inout_stat;
public:
         TLongBasaCache();

         void                       Init(bool enable, TLogsGroup *LogsGroupA, TKConfig *configA);
         void                       EventTick();
         void                       Midnight();
         TLongBasaCacheStat         GetStat();
         TCacheMode                 GetCacheMode(){ return m_mode; }

         void                       Add(ui64 shingle, const frodo_st::TStorageDataItem &datacnt);
         frodo_st::TStorageDataItem Get(ui64 shingle, bool &exists);

         TString                     GetCacheStatistic();

};

//****************************************************************************************************************************************


