#pragma once

#include <util/generic/string.h>
#include <mail/so/spamstop/tools/so-common/tpoolhttpclients.h>

namespace mlcl
{
//****************************************************************************************************************************************
//                                                    TMLDataRes
//****************************************************************************************************************************************

struct TMLDataRes
{
   bool                    m_exists_data;
   poolhttpcl::TReqError   m_err;
   ui32                    m_err_code;
   ui64                    m_cluster_number;
   bool                    m_spam;
   ui32                    m_weight;

   TMLDataRes()
   {
      Clear();
   }

   TMLDataRes(bool spam, ui32 weight)
   {
      Clear();

      m_exists_data  = true;
      m_spam         = spam;
      m_weight       = weight;
   }

   void Clear()
   {
      m_exists_data      = false;
      m_err              = poolhttpcl::KNONEERROR;
      m_err_code         = 0;
      m_spam             = false;
      m_weight           = 0;
   }

};

//*********************************************************************************************************************
//                                           TMLData
//*********************************************************************************************************************

class TMLData: public poolhttpcl::THttpBase
{
private:
         TMLDataRes    ParseResponce(const TString &text);

public:
         TMLData();
         ~TMLData();

         TMLDataRes    ReturnData();

};

//*********************************************************************************************************************

}


