#include "tmakerequest.h"
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>
#include <util/string/reverse.h>

//*******************************************************************************************************************************************
//                                                             TMakeRequest
//*******************************************************************************************************************************************

TString TSQLTypeKToTString(TSQLTypeK value) {
    TString res = "";

    switch (value) {
        case ST_UNKNOWN:
            res = "UNKNOWN";
            break;
        case ST_SQL:
            res = "SQL";
            break;
        case ST_NOSQL:
            res = "NOSQL";
            break;
    };

    return res;
}

TString TShardTypeToTString(TShardType value) {
    TString res = "";

    switch (value) {
        case SHT_UNKNOWN:
            res = "UNKNOWN";
            break;
        case SHT_SKEEP:
            res = "SKEEP";
            break;
        case SHT_NUMBER:
            res = "NUMBER";
            break;
    };

    return res;
}

TMakeRequest::TMakeRequest(TServiceObjectBase& srvcobjA, void* serverA)
    : TMakeRequestBase(srvcobjA, serverA) {
    //команда запроса берется до символа '?', если её нет в указанном ниже списке, то команда берется из поля action запроса, если же поля action нет, то командой запроса считается console
    AllowList.push_back("loginrcpt");
    AllowList.push_back("check");
    AllowList.push_back("info");
    AllowList.push_back("showweight");
    AllowList.push_back("favicon.ico");
    AllowList.push_back("corrlgipstat");
    AllowList.push_back("allrulesreset");
    AllowList.push_back("phoneauth");
    AllowList.push_back("ml_rqst");
    AllowList.push_back("getclust");
    AllowList.push_back("status");
    AllowList.push_back("rotatelogs");
    AllowList.push_back("doshutdown");
}

TMakeRequest::~TMakeRequest() = default;

void TMakeRequest::Midnight(const TString& id, TReqParams* /*m_ReqParams*/) {
    TString text = "";

    if ((srvcobj.GetGeneralObject() != NULL)) {
        srvcobj.GetGeneralObject()->Midnight();

        text = text + "Midnight command accepted<br>";
        text = text + "<A href='" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>Console</A>";
        SendToClient(SO_LOG_MESSAGE, 200, text, id);
    }
}

void TMakeRequest::Shutdown(const TString& id, TReqParams* /*m_ReqParams*/) {
    TString text = "";

    srvcobj.GetGeneralObject()->Shutdown();

    text = text + "<html><head>";
    text = text + "<meta http-equiv='refresh' content='3; url=" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'>";
    text = text + "</head><body bgcolor=palegoldenrod>\n";
    text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
    text = text + "<tr><td valign='top'>Shutdown command accepted.</td></tr>";
    text = text + "</table></body></html>";

    SendToClient(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::ConsoleA(const TString& id, TReqParams* /*m_ReqParams*/, bool short_view) {
    char CurTime[CShingleTime::MAX_TIME_SIZE];
    CShingleTime::GetTimeStr(CurTime);
    const char* table_color = "'#ffffcc'";
    TString text = "";
    TString reloadlink = "";
    TString debugtxt = "";
    TTrafficCtrlStat inputstat;
    ui32 getstat_tick = 0;
    ui32 storsize_tick = 0;
    ui32 allstorstat_tick = 0;
    ui32 cachestat_tick = 0;
    TSummaryStatistik stat;

    getstat_tick = CShingleTime::GetMs();
    if (GetGeneralObject() != NULL)
        stat = GetGeneralObject()->GetStatistic();
    getstat_tick = CShingleTime::GetMs() - getstat_tick;

    text = text + "<i><b>Server control:</b></i>&nbsp;&nbsp;";
    text = text + "<A href='" + GetHost() + GetModuleName("askshutdown") + GetActionOneParam("askshutdown") + "'>Shutdown</A> &nbsp; ";
    text = text + "<A href='" + GetHost() + GetModuleName("askmidnight") + GetActionOneParam("askmidnight") + "'>Midnight</A> &nbsp; ";
    text = text + "<A href='" + GetHost() + GetModuleName("trunclogs") + GetActionOneParam("trunclogs") + "'>Trunc_logs</A> &nbsp;";
    text = text + "<A href='" + GetHost() + GetModuleName("askreload") + GetActionOneParam("askreload") + "' target='_blank'>Reload (rules, black list, white list)</A> &nbsp; ";

    if (short_view)
        text = text + "<A href='" + GetHost() + GetModuleName("askpushtostor") + GetActionOneParam("askpushtostor") + "' target='_blank'>Push_data_to_storage</A> &nbsp;";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Version</td><td>" + m_servername + "</td></tr>";
    if ((GetServiceObject().GetNumberRequest() != NULL))
        text = text + "<tr valign='top'><td valign='left' width='25%'>Host name (code)</td><td>" + GetServiceObject().GetNumberRequest()->GetHostName() + " (" + GetServiceObject().GetNumberRequest()->GetHostCode() + ")</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Port</td><td>" + srvcobj.Port() + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Start time</td><td>" + m_StartTime + "</td></tr>";
    text = text + "<tr valign='top'><td valign='left' width='25%'>Current time</td><td>" + TString(CurTime) + "</td></tr>";
    //text = text + "<tr valign='top'><td valign='left' width='25%'>Pool type</td><td>" + pooltypelink + "</td></tr>";
    if (GetLogsGroup()->GetDebugMode())
        debugtxt = "yes (<A href='" + GetHost() + GetModuleName("dsbdbgmode") + GetActionOneParam("dsbdbgmode") + "'>disable</A>)";
    else
        debugtxt = "no (<A href='" + GetHost() + GetModuleName("enbdbgmode") + GetActionOneParam("enbdbgmode") + "'>enable</A>)";
    text = text + "<tr valign='top'><td align='left' width='25%'>Debug mode</td><td>" + debugtxt + " &nbsp </td></tr>";
    text = text + "</table>";

    TString view_uid_storage_form = "<br><form action='" + GetHost() + GetModuleName("viewuidstor") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; uid= <input type='text' size='20' name='uid' value=''> &nbsp; " + GetActionFormParam("viewuidstor") + "<input type='submit' size='10' value='view storinfo'></form>";
    TString rqstlimit_s = "<A href='" + GetHost() + GetModuleName("rqstlimit") + GetActionOneParam("rqstlimit") + "' target='_blank'>View requests limit</A>";
    TString storstat_s = "<A href='" + GetHost() + GetModuleName("getstorstat") + GetActionOneParam("getstorstat") + "' target='_blank'>Storage statistik</A>";
    TString tracestat_s = "<A href='" + GetHost() + GetModuleName("tracestat") + GetActionOneParam("tracestat") + "' target='_blank'>Traccert statistik</A>";
    text = text + "<br><i><b>Storage:</b></i>&nbsp;&nbsp;" + rqstlimit_s + " &nbsp; &nbsp; " + storstat_s + " &nbsp; &nbsp; " + tracestat_s + " &nbsp; &nbsp; ";
    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    TString storage_status = "";
    if (GetGeneralObject()->StorageInitStatus(storage_status))
        text = text + "<tr valign='top'><td align='left' width='25%'>Storage: basa name (type)</td><td width='75%'>" + GetGeneralObject()->GetStorageIdent() + ": " + storage_status + " &nbsp </td></tr>";
    else
        text = text + "<tr valign='top'><td align='left' width='25%'>Storage: basa name (type)</td><td width='75%' bgcolor='red'>" + GetGeneralObject()->GetStorageIdent() + ": " + storage_status + " &nbsp </td></tr>";
    if (!short_view) {
        i64 storsizei = 0;

        storsize_tick = CShingleTime::GetMs();
        storsizei = GetGeneralObject()->GetStorageSize();
        storsize_tick = CShingleTime::GetMs() - storsize_tick;

        text = text + "<tr valign='top'><td align='left' width='25%'>Storage size</td><td width='75%'>" + UI64ToStroka(static_cast<ui64>(storsizei)) + " &nbsp </td></tr>";
    }
    //text = text + "<tr valign='top'><td align='left' width='25%'>Local cache size</td><td width='75%'>" + UI64ToStroka(cache_size) + " (~ " + UI64ToStroka(full_cache_size) + " byte) &nbsp </td></tr>";
    text = text + "</table>";

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->UseAsyncCheckMode()))
        text += GetGeneralObject()->GetAsyncCheckObj()->GetWebStat();

    if (!short_view) {
        text = text + "<br><i><b>Servers:</b></i>&nbsp;&nbsp;";
        if (GetGeneralObject() != NULL)
            text += GetGeneralObject()->GetServersStatistikText(allstorstat_tick);
    }

    if (!short_view) {
        text = text + "<br><i><b>Input statistics:</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        //text = text + "<tr valign='top'><td valign='left' width='25%'>RequestPerSec</td><td valign='left'>" + stat.trafficctrl_stat.cps_stat + " &nbsp; </td></tr>";
        //text = text + "<tr valign='top'><td valign='left' width='25%'>Request count (today / yesterday)</td><td valign='left'>" + UI64ToStroka(stat.trafficctrl_stat.today_request) + " / " + UI64ToStroka(stat.trafficctrl_stat.yesterday_request) + " </td></tr>";
        //text = text + "<tr valign='top'><td valign='left' width='25%'>Lost request (today / yesterday)</td><td valign='left'>" + UI64ToStroka(stat.trafficctrl_stat.today_lost) + " / " + UI64ToStroka(stat.trafficctrl_stat.yesterday_lost) + " </td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='25%'>RCPT statistik (count / all / lost)</td><td width='75%'>" + stat.rcpstat + "&nbsp; &nbsp;";
        text = text + "<A href='" + GetHost() + GetModuleName("clrreceipt") + GetActionOneParam("clrreceipt") + "'>clear</A> &nbsp; &nbsp;";
        text = text + "<A href='" + GetHost() + GetModuleName("writercpthash") + GetActionOneParam("writercpthash") + "'>print</A> &nbsp; &nbsp;";
        text = text + "</td></tr>\n";
        text = text + "</table>";
    }

    if (!short_view) {
        //long stat bases
        TString shinglebasarequest = "<form action='" + GetHost() + GetModuleName("corrlgshinglestat") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("corrlgshinglestat") + "<input type='submit' size='10' value='query by shingle'></form>";
        TString ipbasarequest = "<form action='" + GetHost() + GetModuleName("corrlgipstat") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("corrlgipstat") + "<input type='submit' size='10' value='query ip'></form>";
        TString inamebasarequest = "<form action='" + GetHost() + GetModuleName("corrlginamestat") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("corrlginamestat") + "<input type='submit' size='10' value='query iname'></form>";
        TString fnamebasarequest = "<form action='" + GetHost() + GetModuleName("corrlgfnamestat") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("corrlgfnamestat") + "<input type='submit' size='10' value='query fname '></form>";
        TString ifnamebasarequest = "<form action='" + GetHost() + GetModuleName("corrlgifnamestat") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("corrlgifnamestat") + "<input type='submit' size='10' value='query iname + fname'></form>";
        TString phonebasarequest = "<form action='" + GetHost() + GetModuleName("corrlgphonestat") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("corrlgphonestat") + "<input type='submit' size='10' value='query phone'></form>";

        text = text + "<br><i><b>Long basa statistik:</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        text = text + "<tr valign='top'><td align='left' width='25%'>By shingle stat</td><td width='75%' colspan='2'>" + shinglebasarequest + " &nbsp </td></tr>";
        text = text + "<tr valign='top'><td align='left' width='25%'>IP stat</td><td width='75%' colspan='2'>" + ipbasarequest + " &nbsp </td></tr>";
        text = text + "<tr valign='top'><td align='left' width='25%'>IName stat</td><td width='75%' colspan='2'>" + inamebasarequest + " &nbsp </td></tr>";
        text = text + "<tr valign='top'><td align='left' width='25%'>FName stat</td><td width='75%' colspan='2'>" + fnamebasarequest + " &nbsp </td></tr>";
        text = text + "<tr valign='top'><td align='left' width='25%'>Iname + FName stat</td><td width='75%' colspan='2'>" + ifnamebasarequest + " &nbsp </td></tr>";
        text = text + "<tr valign='top'><td align='left' width='25%'>Phone stat</td><td width='75%' colspan='2'>" + phonebasarequest + " &nbsp </td></tr>";
        text = text + "</table>";
    }

    if (!short_view) {
        TString sallowuser = "<form action='" + GetHost() + GetModuleName("getallowuser") + "' method='GET' enctype='text/plain'>login: &nbsp; <input type='text' size='25' name='login' value=''>" + GetActionFormParam("getallowuser") + "<input type='submit' size='10' value='view'></form>";
        TString udnsipform = "<form action='" + GetHost() + GetModuleName("getudnssrvcdt") + "' method='GET' enctype='text/plain' target='_blank'>ip: &nbsp; <input type='text' size='25' name='ip' value=''>" + GetActionFormParam("getudnssrvcdt") + "<input type='submit' size='10' value='view'></form>";
        TString pddform = "<form action='" + GetHost() + GetModuleName("viewpddhost") + "' method='GET' enctype='text/plain' target='_blank'>ip: &nbsp; <input type='text' size='25' name='host' value=''>" + GetActionFormParam("viewpddhost") + "<input type='submit' size='10' value='view'></form>";
        TString bboxform = "<form action='" + GetHost() + GetModuleName("viewbboxhost") + "' method='GET' enctype='text/plain' target='_blank'>ip: &nbsp; <input type='text' size='25' name='host' value=''>" + GetActionFormParam("viewbboxhost") + "<input type='submit' size='10' value='view'></form>";

        //text = text + "<i><b>Allow (trusted) users:</b></i>&nbsp;&nbsp;";
        text = text + "<br><i><b>Services:</b></i>&nbsp;&nbsp;";
        text = text + "<A href='" + GetHost() + GetModuleName("viewpddstat") + GetActionOneParam("viewpddstat") + "' target='_blank'>View PDD statistik</A> &nbsp; ";
        text = text + "<A href='" + GetHost() + GetModuleName("viewbboxstat") + GetActionOneParam("viewbboxstat") + "' target='_blank'>View BlackBox statistik</A> &nbsp; ";
        text = text + "<A href='" + GetHost() + GetModuleName("viewresolvstat") + GetActionOneParam("viewresolvstat") + "' target='_blank'>View Resolv statistik</A> &nbsp; ";

        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Allow (trusted) user count</td><td>" + IntToStroka(stat.allow_user_count) + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='25%'>View allow (trusted) user</td><td>" + sallowuser + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='25%'>IP info by udns services (resolv, geo, ...)</td><td><br>" + udnsipform + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='25%'>View PDD host info</td><td><br>" + pddform + "</td></tr>";
        text = text + "<tr valign='top'><td valign='left' width='25%'>View BlackBox host info</td><td><br>" + bboxform + "</td></tr>";
        text = text + "</table>";
    }

    if (!short_view) {
        text = text + "<br><i><b>Storage counters:</b></i>&nbsp;&nbsp;";
        text = text + "<A href='" + GetHost() + GetModuleName("writedump") + GetActionOneParam("writedump") + "'>Write dump</A> &nbsp; ";
        text = text + "<A href='" + GetHost() + GetModuleName("readdump") + GetActionOneParam("readdump") + "'>Read dump</A> &nbsp; ";
        text = text + "<A href='" + GetHost() + GetModuleName("listdump") + GetActionOneParam("listdump") + "'>List dump</A> &nbsp; ";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        text = text + "<tr valign='top'><td valign='left' width='25%'>&nbsp;</td><td width='38%' align='center'><b>TODAY</b></td><td width='37%' align='center'><b>YESTERDAY</b></td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>IPs</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_IpsSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_IpsSize - stat.storage_counters.m_IpsSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>FUID</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_FUIDSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_FUIDSize - stat.storage_counters.m_FUIDSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Pack1</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_Pack1SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_Pack1Size - stat.storage_counters.m_Pack1SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Pack2</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_Pack2SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_Pack2Size - stat.storage_counters.m_Pack2SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Pack3</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_Pack3SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_Pack3Size - stat.storage_counters.m_Pack3SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Pack4</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_Pack4SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_Pack4Size - stat.storage_counters.m_Pack4SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Pack5</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_Pack5SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_Pack5Size - stat.storage_counters.m_Pack5SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>GEO (country)</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_GeoStatCountrySizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_GeoStatCountrySize - stat.storage_counters.m_GeoStatCountrySizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>GEO (country + city)</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_GeoStatSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_GeoStatSize - stat.storage_counters.m_GeoStatSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>GEO (AS)</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_GeoStatASSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_GeoStatASSize - stat.storage_counters.m_GeoStatASSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Host (domen level 2)</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_Host2LevelSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_Host2LevelSize - stat.storage_counters.m_Host2LevelSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Host (domen level 3)</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_Host3LevelSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_Host3LevelSize - stat.storage_counters.m_Host3LevelSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Domen (from login)</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_DomenSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_DomenSize - stat.storage_counters.m_DomenSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>Login count</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_LoginSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_LoginSize - stat.storage_counters.m_LoginSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>DublicatLogin</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_DublicatLoginSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_DublicatLoginSize - stat.storage_counters.m_DublicatLoginSizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>IPv6 mask 1</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_IPv6Maska1SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_IPv6Maska1Size - stat.storage_counters.m_IPv6Maska1SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>IPv6 mask 2</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_IPv6Maska2SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_IPv6Maska2Size - stat.storage_counters.m_IPv6Maska2SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>IPv6 mask 3</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_IPv6Maska3SizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_IPv6Maska3Size - stat.storage_counters.m_IPv6Maska3SizeToday) + "</td></tr>\n";
        text = text + "<tr valign='top'><td valign='left' width='25%'>IPv4 mask net C</td><td width='38%'>" + IntToStroka(stat.storage_counters.m_IPv4MaskaCSizeToday) + "</td><td width='37%'>" + IntToStroka(stat.storage_counters.m_IPv4MaskaCSize - stat.storage_counters.m_IPv4MaskaCSizeToday) + "</td></tr>\n";
        text = text + "</table>";
    }

    if (!short_view) {
        text = text + "<br><i><b>Correct weigth login cache staticstik:</b></i>&nbsp;&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
        text = text + "<tr valign='top'><td valign='left' width='25%'>IPv4 mask net C</td><td>" + GetGeneralObject()->CorrLoginWeigthSize() + "<td></tr>\n";
        text = text + "</table>";
    }

    if (!short_view) {
        cachestat_tick = CShingleTime::GetMs();

        text += "<br><i><b>Storage long data cache (read from storage):</b></i>&nbsp;&nbsp;";
        if (GetGeneralObject() != NULL)
            text += GetGeneralObject()->GetLongStorCacheStatS();

        cachestat_tick = CShingleTime::GetMs() - cachestat_tick;
    }

    text += "<br><i>storsize=" + IntToStroka(storsize_tick) + " ms; storstat=" + IntToStroka(allstorstat_tick) + " ms</i>";

    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL))
        GetLogsGroup()->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "TRACCERT: console=%u-%u-%u-%u", getstat_tick, storsize_tick, allstorstat_tick, cachestat_tick);

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, id);
}

void TMakeRequest::Console(const TString& id, TReqParams* m_ReqParams) {
    ui32 full_tick = CShingleTime::GetMs();
    bool skeep = false;

    if (GetGeneralObject()->GetLimitObj()->AddThread(TMakeRequestLimit::INTERFACE)) {
        skeep = false;

        ConsoleA(id, m_ReqParams, false);

        GetGeneralObject()->GetLimitObj()->ReturnThread(TMakeRequestLimit::INTERFACE);

    } else {
        skeep = true;

        SendToClientWithShap(SO_LOG_MESSAGE, 200, "Limit is exceeded the connection!", id);
    }

    full_tick = CShingleTime::GetMs() - full_tick;
    GetGeneralObject()->GetLimitObj()->AddTick(TMakeRequestLimit::INTERFACE, full_tick, skeep);
}

void TMakeRequest::ExtConsole(const TString& id, TReqParams* m_ReqParams) {
    ConsoleA(id, m_ReqParams, true);
}

bool TMakeRequest::ActionWOParse(const TString& /*Ident*/, TRequestDopData& /*data*/, const TString& /*InRequest*/, const TString& /*NumbRequest*/, const TString& /*request_source*/, int /*thread_index*/) {
    bool res = false;
    return res;
}

bool TMakeRequest::ActionParse(const TString& Ident, TRequestDopData& /*data*/, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl, int thread_index) {
    bool res = false;

    if (Ident == "check") {
        FrodoOboronaCheck(thread_index, m_ReqParams, NumbRequest, requrl, work_delays);
        res = true;

    } else if (Ident == "loginrcpt") {
        LoginRCPT(thread_index, m_ReqParams, NumbRequest, requrl);
        res = true;

    } else if (Ident == "domaininfo") //debug
    {
        TestPDDInfo("-", m_ReqParams);
        res = true;

    } else if (Ident == "blackbox") //debug
    {
        TestBBoxInfo("-", m_ReqParams);
        res = true;

    } else if (Ident == "getforfrodo") //debug
    {
        TestGetForFrodo(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "getforfrod2") //debug
    {
        TestGetForFrodo2(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "ml_rqst") {
        TestMLRcvData(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "getclust") {
        TestClustRcvData(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "tools/ml/frodocf") {
        TestMLRcvData(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "remcorrlogin") {
        CorrectLogin("-", m_ReqParams);
        res = true;

    } else if (Ident == "addallowuser") {
        AddAllowUser("-", m_ReqParams);
        res = true;

    } else if (Ident == "getallowuser") {
        GetAllowUser("-", m_ReqParams);
        res = true;

    } else if (Ident == "remallowuser") {
        RemoveAllowUser("-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgipstat") {
        CorrectLongStat(CLT_IP, "", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlginamestat") {
        CorrectLongStat(CLT_FIELD, "iname", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgfnamestat") {
        CorrectLongStat(CLT_FIELD, "fname", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgifnamestat") {
        CorrectLongStat(CLT_FIELD, "ifname", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgphonestat") {
        CorrectLongStat(CLT_FIELD, "phone", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgiprob") {
        CorrectLongStatRobot(CLT_FIELD, "ip", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlginamerob") {
        CorrectLongStatRobot(CLT_FIELD, "iname", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgfnamerob") {
        CorrectLongStatRobot(CLT_FIELD, "fname", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgifnamerob") {
        CorrectLongStatRobot(CLT_FIELD, "ifname", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgphonerob") {
        CorrectLongStatRobot(CLT_FIELD, "phone", "-", m_ReqParams);
        res = true;

    } else if (Ident == "corrlgshinglestat") {
        CorrectLongStat(CLT_SHINGLE, "", "-", m_ReqParams);
        res = true;

    } else if (Ident == "allrulesreset") {
        DoRulesReload("-");
        res = true;

    } else if (Ident == "showweight") {
        ShowWeight("-", m_ReqParams);
        res = true;

    } else if (Ident == "phoneauth") {
        AuthPhone(NumbRequest, m_ReqParams);
        res = true;

    } else if (Ident == "favicon.ico") {
        SendToClientRAW(HTTP_200_OK(NumbRequest));
        res = true;

    } else if (Ident == "rslvipfromcache") {
        RslvIPFromCache("-", m_ReqParams);
        res = true;

    } else if (Ident == "status") {
        Status(NumbRequest, m_ReqParams);
        res = true;
    }

    if ((!res)) //с админскими правами
    {
        if (Ident == "reloadprop") {
            //ReloadProperties("");
            res = true;

        } else if (Ident == "askreload") {
            AskRulesReload("-");
            res = true;

        } else if (Ident == "doreload") {
            DoRulesReload("-");
            res = true;
        }
    }

    if ((!res)) //с правами обычного пользователя
    {
        if (Ident == "fullstorstat") {
            ViewStorageStatistikFull(m_ReqParams, NumbRequest);
            res = true;

        } else if (Ident == "storageinfo") {
            StorageInfo(m_ReqParams, NumbRequest);
            res = true;

        } else if (Ident == "viewuidstor") {
            ViewUIDStorage(m_ReqParams, NumbRequest);
            res = true;

        } else if (Ident == "allstorbyindex") {
            ViewAllDriversByIndex();
            res = true;

        } else if (Ident == "rqstlimit") {
            ViewRequestLimit();
            res = true;

        } else if (Ident == "getstorstat") {
            ViewStorStat();
            res = true;

        } else if (Ident == "correctlogin") {
            CorrectLogin("-", m_ReqParams);
            res = true;

        } else if (Ident == "getudnssrvcdt") {
            GetUDNSServices("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewpddstat") {
            ViewPDDStat();
            res = true;

        } else if (Ident == "viewpddhost") {
            ViewPDDHost("-", m_ReqParams);
            res = true;

        } else if (Ident == "viewresolvstat") {
            ViewResolvStat();
            res = true;

        } else if (Ident == "reloadpddprop") {
            ReloadPDDProperties();
            res = true;

        } else if (Ident == "viewbboxstat") {
            ViewBBoxStat();
            res = true;

        } else if (Ident == "viewbboxhost") {
            ViewBBoxHost("-", m_ReqParams);
            res = true;

        } else if (Ident == "reloadbboxprop") {
            ReloadBBoxProperties();
            res = true;

        } else if (Ident == "clrreceipt") {
            ClearRCPT("-", m_ReqParams);
            res = true;

        } else if (Ident == "writercpthash") {
            WriteReceipHash("-", m_ReqParams);
            res = true;
        } else if (Ident == "trunclogs") {
            TruncLogs("-");
            res = true;

        } else if (Ident == "tracestat") {
            TraccertStat("-");
            res = true;

        } else if (Ident == "askpushtostor") {
            AskPushToStorage("-");
            res = true;

        } else if (Ident == "dopushtostor") {
            DoPushToStorage("-");
            res = true;
        }
    }

    return res;
}

void TMakeRequest::AskRulesReload(const TString& id) {
    TString text = "";

    text = text + HTTP_200_OK(id);
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Reload rules & lists?')) {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("doreload") + GetActionOneParam("doreload") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequest::DoRulesReload(const TString& /*id*/) {
    if (GetGeneralObject() != NULL) {
        TResetResponce rr;

        rr = GetGeneralObject()->Reset();
        if (rr.flag_ok) {
            SendToClientWithShap(SO_LOG_MESSAGE, 200, rr.filterres, "-");
        } else {
            SendToClient(SO_LOG_ERROR, 501, "Reload rules & lists - FAILED.", "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error!", "-");
    }
}

void TMakeRequest::ViewStorageStatistikFull(TReqParams* m_ReqParams, const TString& NumbRequest) {
    TReqParams::iterator par_it;
    int index = -1;
    TString text = "";
    TStorageNameStat storstat;
    bool notfound = true;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("index");
        if (par_it != m_ReqParams->end()) {
            index = atoi(Trim(par_it->second[0]).data());
            if (GetGeneralObject() != NULL) {
                storstat = GetGeneralObject()->GetStat(index, notfound);
                //if (!notfound)
                //   text = text + PrintStorageStatistik(storstat);
            }
        }

        if (notfound)
            text = text + "Not found.";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, NumbRequest);

    } else
        SendToClientWithShap(SO_LOG_ERROR, 500, text, NumbRequest);
}

void TMakeRequest::StorageInfo(TReqParams* m_ReqParams, const TString& /*NumbRequest*/) {
    TString text = "";
    TReqParams::iterator par_it;
    const char* table_color = "'#ffffcc'";
    int index = -1;
    bool notfound = true;
    TStorageInfoFull data;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("index");
        if (par_it != m_ReqParams->end()) {
            index = atoi(Trim(par_it->second[0]).data());
            if (GetGeneralObject() != NULL) {
                data = GetGeneralObject()->GetStorageFullInfo(index, notfound);
                if (!notfound) {
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                    text = text + "<tr align='right'><td width='25%' align='left'>SQL type</td><td width='70%' align='left'>" + TSQLTypeKToTString(data.info.m_sql_type) + "</td><tr>";
                    text = text + "<tr align='right'><td width='25%' align='left'>Shard type</td><td width='70%' align='left'>" + TShardTypeToTString(data.info.m_shard_type) + "</td><tr>";
                    text = text + "<tr align='right'><td width='25%' align='left'>Shard number</td><td width='70%' align='left'>" + IntToStroka(data.info.m_shar_number) + "</td><tr>";
                    //               text = text + "<tr align='right'><td width='25%' align='left'>Change time localcache</td><td width='70%' align='left'>" + IntToStroka(data.change_time_localcache) + "</td><tr>";
                    //               text = text + "<tr align='right'><td width='25%' align='left'>Disable localcache</td><td width='70%' align='left'>" + BoolToStroka(data.disable_localcache) + "</td><tr>";
                    //               text = text + "<tr align='right'><td width='25%' align='left'>Localcache add empty record</td><td width='70%' align='left'>" + BoolToStroka(data.localcache_add_empty_record) + "</td><tr>";
                    text = text + "<tr align='right'><td width='25%' align='left'>Type name</td><td width='70%' align='left'>" + data.basatypename + "</td><tr>";
                    text = text + "<tr align='right'><td width='25%' align='left'>Storage ident</td><td width='70%' align='left'>" + data.storageident + "</td><tr>";
                    //               text = text + "<tr align='right'><td width='25%' align='left'>Other</td><td width='70%' align='left'>" + data.other_data + "</td><tr>";
                    text = text + "</table>";
                }
            }
        }
    }

    if (notfound)
        text = text + "notfound";

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");
}

void TMakeRequest::ViewUIDStorage(TReqParams* m_ReqParams, const TString& /*NumbRequest*/) {
    TString text = "";
    TReqParams::iterator par_it;
    const char* table_color = "'#ffffcc'";
    ui32 uid = 0;
    bool notfound = true;
    TStorageNameStat data;
    TString storage_link = "";

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("uid");
        if (par_it != m_ReqParams->end()) {
            uid = atoi(Trim(par_it->second[0]).data());
            if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetStoragePool() != NULL)) {
                data = GetGeneralObject()->GetStoragePool()->GetStatByUID(uid, notfound);
                if (!notfound) {
                    if (data.m_index == 0) //SKEEP STORAGE
                        storage_link = data.m_storname;
                    else
                        storage_link = "<A href='" + GetHost() + GetModuleName("storageinfo") + "?" + GetActionMultiParam("storageinfo") + "index=" + IntToStroka(data.m_index) + "'>" + data.m_storname + "</a>";

                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
                    text = text + "<tr valign='top'><td valign='left' width='25%'>UID </td><td>" + UI64ToStroka(uid) + "</td></tr>";
                    text = text + "<tr valign='top'><td valign='left' width='25%'>Storage </td><td>" + storage_link + " (index=" + IntToStroka(data.m_index) + ")</td></tr>";
                    text = text + "</table>";
                }
            }
        }
    }

    if (notfound)
        text = text + "notfound";

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");
}

void TMakeRequest::ViewAllDriversByIndex() {
    TString text = "";
    std::list<TString> str_list;
    std::list<TString>::iterator it;
    ui32 index = 0;
    const char* table_color = "'#ffffcc'";
    const char* cell_color = "PaleGoldenrod";
    TString pooltype = "";

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetStoragePool() != NULL)) {
        GetGeneralObject()->GetStoragePool()->GetAllDrivers(str_list);
        pooltype = GetGeneralObject()->GetStoragePool()->GetPoolType();
    }

    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";
    text = text + "<tr valign='top' align='left'><td width='25%'>Pool type</td><td width='75%'>" + pooltype + "</td></tr>";
    text = text + "<tr valign='top' align='left' bgcolor='" + TString(cell_color) + "'><td width='100%' colspan='2'>&nbsp;</td></tr>";
    text = text + "<tr valign='top' align='center'><td width='25%'><b>INDEX</b></td><td width='75%'><b>STORAGE</b></td></tr>";
    it = str_list.begin();
    while (it != str_list.end()) {
        text = text + "<tr valign='top' align='left'><td valign='left' width='25%'>" + IntToStroka(index) + "</td><td>" + (*it) + "</td></tr>";
        index = IncMax32(index, 1);

        ++it;
    }
    text = text + "</table>";

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");
}

void TMakeRequest::ViewRequestLimit() {
    if (GetGeneralObject() != NULL) {
        TString text = "";

        if (GetGeneralObject() != NULL) {
            text = GetGeneralObject()->GetLimitObj()->GetWebStatistik();
            text += GetGeneralObject()->GetUpdateQueueWebStatistik();

            text += "<br><i><b>Statistik for long data cache (read from storage):</b></i>&nbsp;&nbsp;";
            text += GetGeneralObject()->GetLongStorCacheStatS();
        }

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

void TMakeRequest::ViewStorStat() {
    if (GetGeneralObject() != NULL) {
        TString text = "";
        TString prop1 = "";
        TString prop2 = "";

        prop1 = GetGeneralObject()->GetDriverProperties();
        prop2 = GetGeneralObject()->GetPutQueueProperties();

        text += "<table border='0' width='100%' cellspacing='0' cellpadding='4'>";
        text += "<tr>";
        text += "<td width='25%' valign='top'><i><b>Driver properties:</b></i>&nbsp;&nbsp;<br><br>" + prop1 + "</td>";
        text += "<td width='25%' valign='top'><i><b>Put queue properties:</b></i>&nbsp;&nbsp;<br><br>" + prop2 + "</td>";
        text += "<td width='25%' valign='top'>&nbsp;</td>";
        text += "<td width='25%' valign='top'>&nbsp;</td>";
        text += "</tr>";
        text += "</table><hr><br>";

        text += GetGeneralObject()->GetStorageWebStatistik();
        text += GetGeneralObject()->GetStorageTraccertStatistik();
        if (text.empty())
            text = "<br>Empty";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

void TMakeRequest::AddAllowUser(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString login = "";
    TString lifetime_s = "";
    int lifetime = 0;
    bool res = false;

    if (GetGeneralObject() != NULL) {
        par_it = m_ReqParams->find("login");
        if (par_it != m_ReqParams->end())
            login = Trim(par_it->second[0].c_str());

        par_it = m_ReqParams->find("lifetime");
        if (par_it != m_ReqParams->end()) {
            lifetime_s = Trim(par_it->second[0].c_str());
            lifetime = atoi(lifetime_s.c_str());
        } else {
            lifetime = 86400;
        }

        if ((!login.empty()) && (lifetime > 0)) {
            res = GetGeneralObject()->GetFilter().AddAllowUserLogin(login, lifetime);

            if (res) {
                text = text + "Add login: " + login + " succesfully.";
                SendToClient(SO_LOG_MESSAGE, 200, text, "-");
            } else {
                SendToClient(SO_LOG_ERROR, 501, "Add login failed.", "-");
            }

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'login' parameter or lifetime equal 0\n", "-");
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::GetAllowUser(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString login = "";
    TAllowUserData res;
    time_t currenttime = time(NULL);

    if (GetGeneralObject() != NULL) {
        par_it = m_ReqParams->find("login");
        if (par_it != m_ReqParams->end())
            login = Trim(par_it->second[0].c_str());

        if (!login.empty()) {
            res = GetGeneralObject()->GetFilter().GetAllowUser(login);

            if (!res.m_login.empty()) {
                text = text + "<br><table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
                text = text + "<tr><td width='20%'><b>LOGIN</b></td><td width='20%'><b>CREATE</b></td><td width='20%'><b>LIFETIME</b></td><td width='20%'><b>REMAIN</b></td><td width='20%'>&nbsp;</td></tr>";
                text = text + "<tr><td>" + res.m_login + "</td><td>" + TimeToStr(res.m_add_time) + "</td><td>" + IntToHourMinSec(res.m_lifetime) + "</td><td>" + IntToHourMinSec(res.m_lifetime - (currenttime - res.m_add_time)) + "</td><td><A href='" + GetHost() + "remallowuser?login=" + res.m_login + "'>delete</A></td></tr>";
                text = text + "</table><br>";

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
            } else {
                text = text + "login: " + login + " not found.";
                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
            }

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'login' parameter\n", "-");
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::RemoveAllowUser(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString login = "";
    bool res = false;

    if (GetGeneralObject() != NULL) {
        par_it = m_ReqParams->find("login");
        if (par_it != m_ReqParams->end())
            login = Trim(par_it->second[0].c_str());

        if (!login.empty()) {
            res = GetGeneralObject()->GetFilter().RemoveAllowUserLogin(login);

            if (res) {
                text = text + "Remove login: " + login + " succesfully.";
                SendToClient(SO_LOG_MESSAGE, 200, text, "-");
            } else {
                SendToClient(SO_LOG_ERROR, 501, "Remove login failed.", "-");
            }

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request - no 'login' parameter\n", "-");
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

bool TMakeRequest::IsMinorRequest(const TString& Numbrequest) {
    bool res = false;
    TString subs = "";

    if (Numbrequest.length() > 3) {
        subs = Numbrequest.substr(0, 3);
        if (subs == "##P")
            res = true;
    }

    return res;
}

void TMakeRequest::LoginRCPT(int /*thread_index*/, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl) {
    ui32 mr_logincheck_tick = CShingleTime::GetMs();
    bool is_upstream_request = true; //запрос, который отдаст ответ паспорту
    bool skeep = false;
    TSpamonLogStruct monlogdata;
    ui32 tick = 0;
    TSpamonLogStruct::TError err_type = TSpamonLogStruct::UNKNOWN;

    if (IsMinorRequest(NumbRequest))
        is_upstream_request = false;

    tick = CShingleTime::GetMs();
    monlogdata.Init(GetServiceObject().GetNumberRequest()->GetHostName(), NumbRequest);

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL)) {
        if (GetGeneralObject()->GetLoginRcptTC() != NULL)
            GetGeneralObject()->GetLoginRcptTC()->Skeep();

        ui32 full_tick = CShingleTime::GetMs();

        if (m_ReqParams != NULL) {
            TResStruct resdata = TResStruct();

            if (GetGeneralObject()->GetLimitObj()->AddThread(TMakeRequestLimit::RCVRCPT)) {
                GetGeneralObject()->LoginRCPT(m_ReqParams, NumbRequest, is_upstream_request, requrl);

                skeep = false;
                resdata.m_code = 200;

                GetGeneralObject()->GetLimitObj()->ReturnThread(TMakeRequestLimit::RCVRCPT);

            } else {
                skeep = true;
                resdata.m_code = 509;
            }

            //GetGeneralObject()->GetLimitObj()->AddResStatus(TMakeRequestLimit::RCVRCPT, cntdata.m_source, cntdata.m_empty);

            switch (resdata.m_code) {
                case 200:
                    err_type = TSpamonLogStruct::OK;
                    SendToClientRAW(HTTP_200_OK(NumbRequest));
                    break;
                case 400:
                    err_type = TSpamonLogStruct::CODE400;
                    SendToClientRAW(HTTP_400_BAD_REQUEST(NumbRequest));
                    break;
                case 500:
                    err_type = TSpamonLogStruct::CODE500;
                    SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
                    break;
                case 509:
                    err_type = TSpamonLogStruct::LMT;
                    SendToClientRAW(HTTP_509_BANDWIDTH_LIMIT_EXCEEDED());
                    break;
                default:
                    err_type = TSpamonLogStruct::UNKNOWN;
                    SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
            };

            tick = CShingleTime::GetMs() - tick;
            if (tick >= (ui32)GetLogsGroup()->GetLongrequestTreshold())
                err_type = TSpamonLogStruct::RT;
            monlogdata.AddTag("FRODO", "LRCPT", err_type, tick);

            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetIOLog() != NULL)) {
                TString upstream_s = "";

                if (is_upstream_request)
                    upstream_s = "upstr";
                else
                    upstream_s = "minor";

                ui32 obr_tick = CShingleTime::GetMs() - full_tick;

                GetLogsGroup()->GetIOLog()->WriteMessageAndData("LRCPT %s % 4u % 3u %s", upstream_s.c_str(), obr_tick, resdata.m_code, NumbRequest.c_str());
            }

        } else {
            tick = CShingleTime::GetMs() - tick;
            err_type = TSpamonLogStruct::CODE500;
            monlogdata.AddTag("FRODO", "LRCPT", err_type, tick);

            SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
        }

        full_tick = CShingleTime::GetMs() - full_tick;
        GetGeneralObject()->GetLimitObj()->AddTick(TMakeRequestLimit::RCVRCPT, full_tick, skeep);

    } else {
        tick = CShingleTime::GetMs() - tick;
        err_type = TSpamonLogStruct::CODE500;
        monlogdata.AddTag("FRODO", "LRCPT", err_type, tick);

        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }

    mr_logincheck_tick = CShingleTime::GetMs() - mr_logincheck_tick;
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSpamonLog(is_upstream_request) != NULL))
        GetLogsGroup()->GetSpamonLog(is_upstream_request)->WriteMessage("%s\n", monlogdata.GetDataLog(mr_logincheck_tick).c_str());
}

void TMakeRequest::FrodoOboronaCheck(int /*thread_index*/, TReqParams* m_ReqParams, const TString& NumbRequest, const TString& requrl, TMakeRqstDelays* /*work_delays*/) {
    ui32 mr_check_tick = CShingleTime::GetMs();
    bool is_upstream_request = true; //запрос, который отдаст ответ паспорту
    bool skeep = false;
    TSpamonLogStruct monlogdata;
    ui32 tick = 0;
    TSpamonLogStruct::TError err_type = TSpamonLogStruct::UNKNOWN;

    if (IsMinorRequest(NumbRequest))
        is_upstream_request = false;

    tick = CShingleTime::GetMs();
    monlogdata.Init(GetServiceObject().GetNumberRequest()->GetHostName(), NumbRequest);

    if (GetGeneralObject() != NULL) {
        if (GetGeneralObject()->GetCheckTC() != NULL)
            GetGeneralObject()->GetCheckTC()->Skeep();

        ui32 full_tick = CShingleTime::GetMs();

        TString answer = "";
        TString text = "";
        TResStruct resdata = TResStruct();

        if (m_ReqParams != NULL) {
            if (GetGeneralObject()->GetLimitObj()->AddThread(TMakeRequestLimit::CHECK)) {
                skeep = false;
                resdata = GetGeneralObject()->Check(m_ReqParams, NumbRequest, is_upstream_request, requrl, monlogdata);

                GetGeneralObject()->GetLimitObj()->ReturnThread(TMakeRequestLimit::CHECK);

            } else {
                skeep = true;
                resdata.m_code = 509;
            }

            for (size_t k = 0; k < frodo_st::SDT_END; k++) {
                if (resdata.m_longdatarqstinfo.use[k]) {
                    if (resdata.m_longdatarqstinfo.is_cache[k])
                        GetGeneralObject()->GetLimitObj()->AddResStatus(TMakeRequestLimit::CHECK, TDelayTick::SRC_CACHE, resdata.m_longdatarqstinfo.empty[k]);
                    else
                        GetGeneralObject()->GetLimitObj()->AddResStatus(TMakeRequestLimit::CHECK, TDelayTick::SRC_STORAGE, resdata.m_longdatarqstinfo.empty[k]);
                }
            }

            switch (resdata.m_code) {
                case 200:
                    err_type = TSpamonLogStruct::OK;
                    PushSignal(TStringBuilder{} << "frodo" << "_2xx");
                    SendToClientRAW(resdata.m_result_str);
                    break;
                case 400:
                    err_type = TSpamonLogStruct::CODE400;
                    PushSignal(TStringBuilder{} << "frodo" << "_4xx");
                    SendToClientRAW(HTTP_400_BAD_REQUEST(NumbRequest));
                    break;
                case 500:
                    err_type = TSpamonLogStruct::CODE500;
                    PushSignal(TStringBuilder{} << "frodo" << "_5xx");
                    SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
                    break;
                case 509:
                    PushSignal(TStringBuilder{} << "frodo" << "_509");
                    err_type = TSpamonLogStruct::LMT;
                    SendToClientRAW(HTTP_509_BANDWIDTH_LIMIT_EXCEEDED());
                    break;
                default:
                    PushSignal(TStringBuilder{} << "frodo" << "_unk");
                    err_type = TSpamonLogStruct::UNKNOWN;
            };

            tick = CShingleTime::GetMs() - tick;
            if (tick >= (ui32)GetLogsGroup()->GetLongrequestTreshold())
                err_type = TSpamonLogStruct::RT;
            monlogdata.AddTag("FRODO", "INCHK", err_type, tick);

            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetIOLog() != NULL)) {
                TString upstream_s = "";

                if (is_upstream_request)
                    upstream_s = "upstr";
                else
                    upstream_s = "minor";

                ui32 obr_tick = CShingleTime::GetMs() - full_tick;

                GetLogsGroup()->GetIOLog()->WriteMessageAndData("CHECK %s % 4u % 3u %s", upstream_s.c_str(), obr_tick, resdata.m_code, NumbRequest.c_str());
            }

        } else {
            tick = CShingleTime::GetMs() - tick;
            err_type = TSpamonLogStruct::CODE500;
            monlogdata.AddTag("FRODO", "INCHK", err_type, tick);

            PushSignal(TStringBuilder{} << "frodo" << "_5xx");

            SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
        }

        full_tick = CShingleTime::GetMs() - full_tick;
        GetGeneralObject()->GetLimitObj()->AddTick(TMakeRequestLimit::CHECK, full_tick, skeep);

    } else {
        tick = CShingleTime::GetMs() - tick;
        err_type = TSpamonLogStruct::CODE500;
        monlogdata.AddTag("FRODO", "INCHK", err_type, tick);

        PushSignal(TStringBuilder{} << "frodo" << "_5xx");

        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }

    mr_check_tick = CShingleTime::GetMs() - mr_check_tick;
    if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetSpamonLog(is_upstream_request) != NULL))
        GetLogsGroup()->GetSpamonLog(is_upstream_request)->WriteMessage("%s\n", monlogdata.GetDataLog(mr_check_tick).c_str());
}

void TMakeRequest::CorrectLogin(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();
    TString login_s = "";
    TString karma_s = "";
    ui32 karma = 0;
    TString loginlistlog = "";

    if ((GetGeneralObject() != NULL)) {
        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ip_s = Trim(par_it->second[0]);
            ip = TKIPv6(ip_s.c_str());
        }

        par_it = m_ReqParams->find("login");
        if (par_it != m_ReqParams->end()) {
            login_s = Trim(par_it->second[0]);
        }

        par_it = m_ReqParams->find("karma");
        if (par_it != m_ReqParams->end()) {
            karma_s = Trim(par_it->second[0]);
            karma = atoi(karma_s.c_str());
        }

        if ((!login_s.empty()) && ((karma == KPHAM) || (karma == KPSPAM) || (karma == KPMALIC))) {
            text = GetGeneralObject()->GetFilter().CorrectLogins(ip, login_s, karma);

            loginlistlog = "corr: '" + login_s + "'=" + IntToStroka(karma);
            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetIPHistoryLog() != NULL))
                GetLogsGroup()->GetIPHistoryLog()->WriteMessageAndData("%s", loginlistlog.c_str());

            SendToClient(SO_LOG_MESSAGE, 200, text, "-");
        } else {
            if (login_s.empty())
                SendToClient(SO_LOG_ERROR, 400, "field not found or empty: login.", "-");
            else if ((karma != KPHAM) && (karma != KPSPAM) && (karma != KPMALIC))
                SendToClient(SO_LOG_ERROR, 400, "unknown value: karma.", "-");
            else
                SendToClient(SO_LOG_ERROR, 500, "", "-");
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::CorrectLongIPStat(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();
    TString cip_s = "";
    TKIPv6 cip = TKIPv6();
    TString ham_s = "";
    TString spam_s = "";
    TString malic_s = "";
    i32 ham = 0;
    i32 spam = 0;
    i32 malic = 0;
    i32 ham_old = 0;
    i32 spam_old = 0;
    i32 malic_old = 0;
    kday_t day_old = kday_t(static_cast<unsigned long>(0));
    i32 ham_old1 = 0;
    i32 spam_old1 = 0;
    i32 malic_old1 = 0;
    kday_t day_old1 = kday_t(static_cast<unsigned long>(0));
    bool est_ham = false;
    bool est_spam = false;
    bool est_malic = false;
    ui32 last_days = 0;
    ui32 last_days1 = 0;
    TString ident_ip = "ip";
    TString rec_s = "";
    std::list<TString> iplist;
    std::list<TString> iplist2;
    std::list<TString>::iterator iplist_it;
    TString viewip = "";
    ui32 viewipcount = 0;
    kipv6::TWhiteNetv6 netobj; // = kipv6::TWhiteNetv6(/*"netobj"*/);
    kipv6::TWhiteNetv6::TRecordType addr_type;
    kipv6::TWIPv6 value = kipv6::TWIPv6();
    bool max = false;
    TKIPv6 fip = TKIPv6();
    TKIPv6 nip = TKIPv6();
    ui64 get_shingle = 0;
    ui64 get_shingle1 = 0;
    TString get_source = "";
    TString get_source1 = "";
    TString dop_info = "";
    bool read_err = false;
    bool read_err1 = false;
    bool update_err = false;

    if (GetGeneralObject() != NULL) {
        netobj.Init("", NULL);
        //ip
        par_it = m_ReqParams->begin();
        while (par_it != m_ReqParams->end()) {
            rec_s = (*par_it).first;
            if ((rec_s.length() >= ident_ip.length()) && (!memcmp(rec_s.c_str(), ident_ip.c_str(), ident_ip.length()))) {
                ip_s = Trim(par_it->second[0]);
                addr_type = netobj.GetAddresses(ip_s, value);
                switch (addr_type) {
                    case kipv6::TWhiteNetv6::TUNDEF:
                    case kipv6::TWhiteNetv6::THOST:
                        break;
                    case kipv6::TWhiteNetv6::TIPNET:
                    case kipv6::TWhiteNetv6::TIPRANGE:
                        fip = value.ip1;
                        do {
                            if (!fip.Undefined()) {
                                iplist.push_back(fip.toStroka());
                                if (iplist.size() > MAX_BAN_IP_COUNT) {
                                    max = true;
                                    break;
                                }
                                fip = fip.GetNextIP();
                            } else
                                break;
                        } while (fip <= value.ip2);
                        iplist2.push_back(ip_s);
                        break;
                    case kipv6::TWhiteNetv6::TIPADDRESS:
                        iplist.push_back(value.ip1.toStroka());
                        if (iplist.size() > MAX_BAN_IP_COUNT)
                            max = true;
                        iplist2.push_back(ip_s);
                        break;
                };
                if (max)
                    break;
            }

            ++par_it;
        }

        par_it = m_ReqParams->find("cip");
        if (par_it != m_ReqParams->end()) {
            cip_s = Trim(par_it->second[0]);
            cip = TKIPv6(cip_s.c_str());
            iplist.push_front(cip_s);
            iplist2.push_front(cip_s);
        }

        par_it = m_ReqParams->find("ham");
        if (par_it != m_ReqParams->end()) {
            ham_s = Trim(par_it->second[0]);
            ham = atoi(ham_s.c_str());
            est_ham = true;
        }

        par_it = m_ReqParams->find("spam");
        if (par_it != m_ReqParams->end()) {
            spam_s = Trim(par_it->second[0]);
            spam = atoi(spam_s.c_str());
            est_spam = true;
        }

        par_it = m_ReqParams->find("malic");
        if (par_it != m_ReqParams->end()) {
            malic_s = Trim(par_it->second[0]);
            malic = atoi(malic_s.c_str());
            est_malic = true;
        }

        if ((iplist.size() > 0)) {
            if (!cip.Undefined()) {
                GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_IPADDRESS, cip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                if (static_cast<ui32>(day_old) == 0)
                    day_old = kday_t(time(NULL));
                GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_IPADDRESS, cip, cip.toStroka(), update_err, day_old, ham, spam, malic);

                iplist2.sort();
                iplist2.unique();

                iplist_it = iplist2.begin();
                while (iplist_it != iplist2.end()) {
                    ip_s = *iplist_it;
                    viewipcount++;

                    if (iplist_it == iplist2.begin())
                        viewip = viewip + "ip" + IntToStroka3(viewipcount) + "=" + ip_s;
                    else
                        viewip = viewip + "&ip" + IntToStroka3(viewipcount) + "=" + ip_s;

                    iplist_it++;
                }

                text = text + HTTP_200_OK(id);
                text = text + "<html><head>";
                text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("corrlgipstat") + GetActionOneParam("corrlgipstat") + "&" + viewip + "'>";
                text = text + "</head><body bgcolor=palegoldenrod>\n";
                text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
                text = text + "<tr><td valign='top'>Increment counters successfully.</td></tr>";
                text = text + "</table></body></html>";

                SendToClientRAW(text);

            } else {
                iplist.sort();
                iplist.unique();

                iplist2.sort();
                iplist2.unique();

                iplist_it = iplist2.begin();
                while (iplist_it != iplist2.end()) {
                    ip_s = *iplist_it;
                    viewipcount++;

                    viewip = viewip + "<input type='hidden' size='10' name='ip" + IntToStroka3(viewipcount) + "' value='" + ip_s + "'>";

                    iplist_it++;
                }

                if (iplist.size() > 1) {
                    text = text + "<center><i><b>CORRECT LONG 'ip' BASA:</b></i></center><br>";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
                    text = text + "<tr align='center' bgcolor='Moccasin'><td width='28%'><b>IP</b></td><td width='8%'><b>LAST DAYS</b></td><td width='18%' colspan='2'><b>HAM</b></td><td width='18%' colspan='2'><b>SPAM</b></td><td width='18%' colspan='2'><b>MALIC</b></td><td width='10%'>&nbsp;</td><tr>";

                    iplist_it = iplist.begin();
                    while (iplist_it != iplist.end()) {
                        ip_s = *iplist_it;
                        ip = TKIPv6(ip_s.c_str());

                        GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_IPADDRESS, ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                        last_days = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old);

                        dop_info = " (" + ShingleToStroka(get_shingle) + ", " + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_IPADDRESS) + ", '" + get_source + "')";

                        text = text + "<form action='" + GetHost() + GetModuleName("corrlgipstat") + "' method='GET' enctype='text/plain'>";
                        text = text + "<tr>";
                        text = text + "<td><A href='" + GetHost() + GetModuleName("corrlgipstat") + GetActionOneParam("corrlgipstat") + "&ip=" + ip_s + "' target='_blank'>" + ip_s + "</A>" + dop_info + "</td>";
                        text = text + "<td>" + IntToStroka(static_cast<ui32>(day_old)) + " (" + IntToStroka(last_days) + ")<input type='hidden' size='10' name='cip' value='" + ip_s + "'>" + viewip + "</td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(ham_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='ham' value=''></td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(spam_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='spam' value=''></td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(malic_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='malic' value=''></td>";
                        text = text + "<td align='center'><input type='submit' size='10' value='apply'></td>";
                        text = text + "</tr>";
                        text = text + GetActionFormParam("corrlgipstat") + "</form>";

                        iplist_it++;
                    }

                    text = text + "</table>";

                } else {
                    iplist_it = iplist.begin();
                    if (iplist_it != iplist.end()) {
                        ip_s = *iplist_it;
                        ip = TKIPv6(ip_s.c_str());

                        GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_IPADDRESS, ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                        last_days = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old);

                        GetGeneralObject()->GetLongStatCache(frodo_st::SDT_IPADDRESS, ip, get_shingle1, get_source1, read_err1, day_old1, ham_old1, spam_old1, malic_old1);
                        last_days1 = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old1);

                        dop_info = "shingle=" + ShingleToStroka(get_shingle) + ", type=" + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_IPADDRESS) + ", source='" + get_source + "'";

                        text = text + "<center><i><b>CORRECT LONG 'ip' BASA (<A href='" + GetHost() + "corrlgipstat?ip=" + ip_s + "'>" + ip_s + "</A>, " + dop_info + "):</b></i></center><br>";
                        text = text + "<form action='" + GetHost() + GetModuleName("corrlgipstat") + "' method='GET' enctype='text/plain'>";
                        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
                        text = text + "<tr align='center' bgcolor='Moccasin'><td><b>FIELD</b></td><td><b>CACHE</b></td><td><b>STORAGE</b></td><td><b>ACTION</b></td></tr>";
                        text = text + "<tr align='center'><td>Record type</td><td colspan='3' align='center'><b><font color='green'>" + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_IPADDRESS) + "</font></b></td></tr>";
                        text = text + "<tr align='center'><td>last days (elapsed)</td><td>" + IntToStroka(static_cast<ui32>(day_old1)) + " (" + IntToStroka(last_days1) + ")</td><td>" + IntToStroka(static_cast<ui32>(day_old)) + " (" + IntToStroka(last_days) + ")</td><td><input type='hidden' size='10' name='cip' value='" + ip_s + "'>&nbsp;</td></tr>";
                        text = text + "<tr align='center'><td>ham</td><td bgcolor='Seashell'>" + IntToStroka(ham_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(ham_old) + "</td><td>+&nbsp;<input type='text' size='10' name='ham' value=''></td></tr>";
                        text = text + "<tr align='center'><td>spam</td><td bgcolor='Seashell'>" + IntToStroka(spam_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(spam_old) + "</td><td>+&nbsp;<input type='text' size='10' name='spam' value=''></td></tr>";
                        text = text + "<tr align='center'><td>malic</td><td bgcolor='Seashell'>" + IntToStroka(malic_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(malic_old) + "</td><td>+&nbsp;<input type='text' size='10' name='malic' value=''></td></tr>";
                        text = text + "<tr align='center'><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td><input type='submit' size='10' value='apply'></td></tr>";
                        text = text + "</table>";
                        text = text + GetActionFormParam("corrlgipstat") + "</form>";
                    }
                }

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
            }
        } else {
            if (ip.Undefined())
                SendToClient(SO_LOG_ERROR, 400, "field not found or empty: ip.", "-");
            else
                SendToClient(SO_LOG_ERROR, 500, "", "-");
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

struct TKIPv6Ext {
    TKIPv6 m_ip;
    TString m_source;

    TKIPv6Ext() {
        Clear();
    }

    TKIPv6Ext(const TString& source) {
        m_ip = TStringToTKIPv6(source);
        m_source = source;
    }

    void Clear() {
        m_ip = TKIPv6();
        m_source = "";
    }
};

void TMakeRequest::CorrectLongFieldsStat(const TString& ident, const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString ip_s = "";
    TKIPv6Ext ip = TKIPv6Ext();
    TString cip_s = "";
    TKIPv6Ext cip = TKIPv6Ext();
    TString ham_s = "";
    TString spam_s = "";
    TString malic_s = "";
    i32 ham = 0;
    i32 spam = 0;
    i32 malic = 0;
    i32 ham_old = 0;
    i32 spam_old = 0;
    i32 malic_old = 0;
    kday_t day_old = kday_t(static_cast<unsigned long>(0));
    i32 ham_old1 = 0;
    i32 spam_old1 = 0;
    i32 malic_old1 = 0;
    kday_t day_old1 = kday_t(static_cast<unsigned long>(0));
    bool est_ham = false;
    bool est_spam = false;
    bool est_malic = false;
    ui32 last_days = 0;
    ui32 last_days1 = 0;
    TString ident_ip = "ip";
    TString rec_s = "";
    std::list<TString> iplist;
    std::list<TString> iplist2;
    std::list<TString>::iterator iplist_it;
    TString viewip = "";
    ui32 viewipcount = 0;
    kipv6::TWIPv6 value = kipv6::TWIPv6();
    bool max = false;
    TKIPv6 fip = TKIPv6();
    TKIPv6 nip = TKIPv6();
    ui64 get_shingle = 0;
    ui64 get_shingle1 = 0;
    TString get_source = "";
    TString get_source1 = "";
    TString dop_info = "";
    bool read_err = false;
    bool read_err1 = false;
    bool update_err = false;

    if (GetGeneralObject() != NULL) {
        //ip
        par_it = m_ReqParams->begin();
        while (par_it != m_ReqParams->end()) {
            rec_s = (*par_it).first;
            if ((rec_s.length() >= ident_ip.length()) && (!memcmp(rec_s.c_str(), ident_ip.c_str(), ident_ip.length()))) {
                ip_s = Trim(par_it->second[0]);
                iplist.push_back(ip_s);
                if (iplist.size() > MAX_BAN_IP_COUNT)
                    max = true;
                iplist2.push_back(ip_s);

                if (max)
                    break;
            }

            ++par_it;
        }

        par_it = m_ReqParams->find("cip");
        if (par_it != m_ReqParams->end()) {
            cip_s = Trim(par_it->second[0]);
            cip = TKIPv6Ext(cip_s);
            iplist.push_front(cip_s);
            iplist2.push_front(cip_s);
        }

        par_it = m_ReqParams->find("ham");
        if (par_it != m_ReqParams->end()) {
            ham_s = Trim(par_it->second[0]);
            ham = atoi(ham_s.c_str());
            est_ham = true;
        }

        par_it = m_ReqParams->find("spam");
        if (par_it != m_ReqParams->end()) {
            spam_s = Trim(par_it->second[0]);
            spam = atoi(spam_s.c_str());
            est_spam = true;
        }

        par_it = m_ReqParams->find("malic");
        if (par_it != m_ReqParams->end()) {
            malic_s = Trim(par_it->second[0]);
            malic = atoi(malic_s.c_str());
            est_malic = true;
        }

        if ((iplist.size() > 0)) {
            if (!cip.m_ip.Undefined()) {
                if (ident == "iname") {
                    GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_INAME, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));
                    GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_INAME, cip.m_ip, cip.m_source, update_err, day_old, ham, spam, malic);

                } else if (ident == "fname") {
                    GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_FNAME, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));
                    GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_FNAME, cip.m_ip, cip.m_source, update_err, day_old, ham, spam, malic);

                } else if (ident == "ifname") {
                    GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_IFNAME, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));
                    GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_IFNAME, cip.m_ip, cip.m_source, update_err, day_old, ham, spam, malic);

                } else if (ident == "phone") {
                    GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_PHONE, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));
                    GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_PHONE, cip.m_ip, cip.m_source, update_err, day_old, ham, spam, malic);
                }

                iplist2.sort();
                iplist2.unique();

                iplist_it = iplist2.begin();
                while (iplist_it != iplist2.end()) {
                    ip_s = *iplist_it;
                    viewipcount++;

                    if (iplist_it == iplist2.begin())
                        viewip = viewip + "ip" + IntToStroka3(viewipcount) + "=" + ip_s;
                    else
                        viewip = viewip + "&ip" + IntToStroka3(viewipcount) + "=" + ip_s;

                    iplist_it++;
                }

                text = text + HTTP_200_OK(id);
                text = text + "<html><head>";
                if (ident == "iname")
                    text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("corrlginamestat") + GetActionOneParam("corrlginamestat") + "&" + viewip + "'>";
                else if (ident == "fname")
                    text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("corrlgfnamestat") + GetActionOneParam("corrlgfnamestat") + "&" + viewip + "'>";
                else if (ident == "ifname")
                    text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("corrlgifnamestat") + GetActionOneParam("corrlgifnamestat") + "&" + viewip + "'>";
                else if (ident == "phone")
                    text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("corrlgphonestat") + GetActionOneParam("corrlgphonestat") + "&" + viewip + "'>";

                text = text + "</head><body bgcolor=palegoldenrod>\n";
                text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
                text = text + "<tr><td valign='top'>Increment counters successfully.</td></tr>";
                text = text + "</table></body></html>";

                SendToClientRAW(text);
            } else {
                iplist.sort();
                iplist.unique();

                iplist2.sort();
                iplist2.unique();

                iplist_it = iplist2.begin();
                while (iplist_it != iplist2.end()) {
                    ip_s = *iplist_it;
                    viewipcount++;

                    viewip = viewip + "<input type='hidden' size='10' name='ip" + IntToStroka3(viewipcount) + "' value='" + ip_s + "'>";

                    iplist_it++;
                }

                if (iplist.size() > 1) {
                    text = text + "<center><i><b>CORRECT LONG '" + ident + "' BASA:</b></i></center><br>";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
                    text = text + "<tr align='center' bgcolor='Moccasin'><td width='28%'><b>IP</b></td><td width='8%'><b>LAST DAYS</b></td><td width='18%' colspan='2'><b>HAM</b></td><td width='18%' colspan='2'><b>SPAM</b></td><td width='18%' colspan='2'><b>MALIC</b></td><td width='10%'>&nbsp;</td><tr>";

                    iplist_it = iplist.begin();
                    while (iplist_it != iplist.end()) {
                        ip_s = *iplist_it;
                        ip = TKIPv6Ext(ip_s);

                        if (ident == "iname") {
                            GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_INAME, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = " (" + ShingleToStroka(get_shingle) + ", " + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_INAME) + ", '" + get_source + "')";

                        } else if (ident == "fname") {
                            GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_FNAME, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = " (" + ShingleToStroka(get_shingle) + ", " + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_FNAME) + ", '" + get_source + "')";

                        } else if (ident == "ifname") {
                            GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_IFNAME, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = " (" + ShingleToStroka(get_shingle) + ", " + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_IFNAME) + ", '" + get_source + "')";

                        } else if (ident == "phone") {
                            GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_PHONE, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = " (" + ShingleToStroka(get_shingle) + ", " + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_PHONE) + ", '" + get_source + "')";
                        }

                        last_days = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old);

                        text = text + "<form action='" + GetHost() + GetModuleName("corrlg" + ident + "stat") + "' method='GET' enctype='text/plain'>";
                        text = text + "<tr>";
                        text = text + "<td><A href='" + GetHost() + GetModuleName("corrlg" + ident + "stat") + GetActionOneParam("corrlg" + ident + "stat") + "&ip=" + ip_s + "' target='_blank'>" + ip_s + "</A>" + dop_info + "</td>";
                        text = text + "<td>" + IntToStroka(static_cast<ui32>(day_old)) + " (" + IntToStroka(last_days) + ")<input type='hidden' size='10' name='cip' value='" + ip_s + "'>" + viewip + "</td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(ham_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='ham' value=''></td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(spam_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='spam' value=''></td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(malic_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='malic' value=''></td>";
                        text = text + "<td align='center'><input type='submit' size='10' value='apply'></td>";
                        text = text + "</tr>";
                        text = text + GetActionFormParam("corrlg" + ident + "stat") + "</form>";

                        iplist_it++;
                    }

                    text = text + "</table>";

                } else {
                    frodo_st::TStorageDataType rectp = frodo_st::SDT_END;

                    iplist_it = iplist.begin();
                    if (iplist_it != iplist.end()) {
                        ip_s = *iplist_it;
                        ip = TKIPv6Ext(ip_s);
                        rectp = frodo_st::SDT_END;

                        if (ident == "iname") {
                            rectp = frodo_st::SDT_INAME;
                            GetGeneralObject()->GetLongStatStorage(rectp, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = "shingle=" + ShingleToStroka(get_shingle) + ", type=" + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_INAME) + ", source='" + get_source + "'";

                            GetGeneralObject()->GetLongStatCache(rectp, ip.m_ip, get_shingle1, get_source1, read_err1, day_old1, ham_old1, spam_old1, malic_old1);

                        } else if (ident == "fname") {
                            rectp = frodo_st::SDT_FNAME;
                            GetGeneralObject()->GetLongStatStorage(rectp, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = "shingle=" + ShingleToStroka(get_shingle) + ", type=" + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_FNAME) + ", source='" + get_source + "'";

                            GetGeneralObject()->GetLongStatCache(rectp, ip.m_ip, get_shingle1, get_source1, read_err1, day_old1, ham_old1, spam_old1, malic_old1);

                        } else if (ident == "ifname") {
                            rectp = frodo_st::SDT_IFNAME;
                            GetGeneralObject()->GetLongStatStorage(rectp, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = "shingle=" + ShingleToStroka(get_shingle) + ", type=" + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_IFNAME) + ", source='" + get_source + "'";

                            GetGeneralObject()->GetLongStatCache(rectp, ip.m_ip, get_shingle1, get_source1, read_err1, day_old1, ham_old1, spam_old1, malic_old1);

                        } else if (ident == "phone") {
                            rectp = frodo_st::SDT_PHONE;
                            GetGeneralObject()->GetLongStatStorage(rectp, ip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);
                            dop_info = "shingle=" + ShingleToStroka(get_shingle) + ", type=" + frodo_st::TStorageDataTypeToTString(frodo_st::SDT_PHONE) + ", source='" + get_source + "'";

                            GetGeneralObject()->GetLongStatCache(rectp, ip.m_ip, get_shingle1, get_source1, read_err1, day_old1, ham_old1, spam_old1, malic_old1);
                        }

                        last_days = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old);
                        last_days1 = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old1);

                        text = text + "<center><i><b>CORRECT LONG '" + ident + "' BASA (<A href='" + GetHost() + "corrlg" + ident + "stat?ip=" + ip_s + "'>" + ip_s + "</A>, " + dop_info + "):</b></i></center><br>";
                        text = text + "<form action='" + GetHost() + GetModuleName("corrlg" + ident + "stat") + "' method='GET' enctype='text/plain'>";
                        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
                        text = text + "<tr align='center' bgcolor='Moccasin'><td><b>FIELD</b></td><td><b>CACHE</b></td><td><b>STORAGE</b></td><td><b>ACTION</b></td></tr>";
                        text = text + "<tr align='center'><td>Record type</td><td colspan='3' align='center'><b><font color='green'>" + frodo_st::TStorageDataTypeToTString(rectp) + "</font></b></td></tr>";
                        text = text + "<tr align='center'><td>last days (elapsed)</td><td>" + IntToStroka(static_cast<ui32>(day_old1)) + " (" + IntToStroka(last_days1) + ")</td><td>" + IntToStroka(static_cast<ui32>(day_old)) + " (" + IntToStroka(last_days) + ")</td><td><input type='hidden' size='10' name='cip' value='" + ip_s + "'>&nbsp;</td></tr>";
                        text = text + "<tr align='center'><td>ham</td><td bgcolor='Seashell'>" + IntToStroka(ham_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(ham_old) + "</td><td>+&nbsp;<input type='text' size='10' name='ham' value=''></td></tr>";
                        text = text + "<tr align='center'><td>spam</td><td bgcolor='Seashell'>" + IntToStroka(spam_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(spam_old) + "</td><td>+&nbsp;<input type='text' size='10' name='spam' value=''></td></tr>";
                        text = text + "<tr align='center'><td>malic</td><td bgcolor='Seashell'>" + IntToStroka(malic_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(malic_old) + "</td><td>+&nbsp;<input type='text' size='10' name='malic' value=''></td></tr>";
                        text = text + "<tr align='center'><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td><input type='submit' size='10' value='apply'></td></tr>";
                        text = text + "</table>";
                        text = text + GetActionFormParam("corrlg" + ident + "stat") + "</form>";
                    }
                }

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
            }
        } else {
            if (ip.m_ip.Undefined())
                SendToClient(SO_LOG_ERROR, 400, "field not found or empty: ip.", "-");
            else
                SendToClient(SO_LOG_ERROR, 500, "", "-");
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

i32 NormirIncrField(i32 prev_value, i32 incr_value) {
    i64 value_v = 0;
    i32 value_vs = 0;

    value_v = prev_value + incr_value;
    if (value_v < 0)
        value_vs = -1 * prev_value;
    else if (value_v > 2000000000)
        value_vs = 2000000000 - prev_value;
    else
        value_vs = incr_value;

    return value_vs;
}

i32 NormirSetField(i32 value) {
    i32 value_vs = 0;

    if (value < 0)
        value_vs = 0;
    else if (value > 2000000000)
        value_vs = 2000000000;
    else
        value_vs = value;

    return value_vs;
}

void TMakeRequest::CorrectLongFieldsStatRobot(const TString& ident, const TString& id, TReqParams* m_ReqParams) {
    //Warning, need add field: so_codes=utf8
    //127.0.0.1:8001/corrlgiprob?cip=213.176.233.14&so_codes=utf8&ham=77&spam=88&malic=99&set_mode=1
    //127.0.0.1:8001/corrlginamerob?cip=Anna&so_codes=utf8&ham=-10&spam=10&malic=10&set_mode=1
    //127.0.0.1:8001/corrlgfnamerob?cip=%D0%A2%D0%B5%D0%BB%D0%B5%D0%B3%D0%B8%D0%BD%D0%B0&so_codes=utf8&ham=7&spam=8&malic=9&set_mode=0
    //127.0.0.1:8001/corrlgifnamerob?cip=Anna-%D0%A2%D0%B5%D0%BB%D0%B5%D0%B3%D0%B8%D0%BD%D0%B0&so_codes=utf8&ham=-10&spam=10&malic=10&set_mode=1
    //127.0.0.1:8001/corrlgphonerob?cip=490a3c528a70783b3ed427c91d87286f&so_codes=utf8&ham=10&spam=11&malic=12&set_mode=1

    TReqParams::iterator par_it;
    TString text = "";
    TString cip_source = "";
    TString cip_corr = "";
    TString cip_corr_ue = "";
    TKIPv6Ext cip = TKIPv6Ext();
    TString ham_s = "";
    TString spam_s = "";
    TString malic_s = "";
    TString setmode_s = "";
    i32 ham = 0;
    i32 spam = 0;
    i32 malic = 0;
    i32 ham_old = 0;
    i32 spam_old = 0;
    i32 malic_old = 0;
    bool set_mode = false;
    kday_t day_old = kday_t(static_cast<unsigned long>(0));
    bool est_ham = false;
    bool est_spam = false;
    bool est_malic = false;
    ui64 get_shingle = 0;
    TString get_source = "";
    TString get_source_ue = "";
    TReqParams* pReqParamsNew = NULL;
    bool read_err = false;
    bool update_err = 0;

    if (GetGeneralObject() != NULL) {
        par_it = m_ReqParams->find("set_mode");
        if (par_it != m_ReqParams->end()) {
            setmode_s = Trim(par_it->second[0]);
            if (!setmode_s.empty())
                set_mode = static_cast<bool>(atoi(setmode_s.c_str()));
        }

        par_it = m_ReqParams->find("cip");
        if (par_it != m_ReqParams->end()) {
            cip_source = Trim(par_it->second[0]);
        }

        par_it = m_ReqParams->find("ham");
        if (par_it != m_ReqParams->end()) {
            ham_s = Trim(par_it->second[0]);
            ham = atoi(ham_s.c_str());
            est_ham = true;
        }

        par_it = m_ReqParams->find("spam");
        if (par_it != m_ReqParams->end()) {
            spam_s = Trim(par_it->second[0]);
            spam = atoi(spam_s.c_str());
            est_spam = true;
        }

        par_it = m_ReqParams->find("malic");
        if (par_it != m_ReqParams->end()) {
            malic_s = Trim(par_it->second[0]);
            malic = atoi(malic_s.c_str());
            est_malic = true;
        }

        pReqParamsNew = GetGeneralObject()->GetFilter().DecodeParams(id, m_ReqParams); //correct request
        if (pReqParamsNew != NULL) {
            par_it = pReqParamsNew->find("cip");
            if (par_it != pReqParamsNew->end()) {
                cip_corr = Trim(par_it->second[0]);
                if (!cip_corr.empty()) {
                    if (ident == "ip") {
                        cip.m_ip = TKIPv6(cip_corr.c_str());
                        cip.m_source = cip_corr;

                    } else {
                        cip = TKIPv6Ext(cip_corr);
                    }
                }
            }

            GetGeneralObject()->GetFilter().DeleteParams(pReqParamsNew);
        }

        if (!cip.m_ip.Undefined()) {
            if (ident == "ip") {
                GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_IPADDRESS, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);

                if ((!read_err) && (get_shingle != 0)) {
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));

                    if (set_mode) {
                        i32 ham_vs = NormirSetField(ham);
                        i32 spam_vs = NormirSetField(spam);
                        i32 malic_vs = NormirSetField(malic);

                        GetGeneralObject()->CorrectLongStatSet(frodo_st::SDT_IPADDRESS, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);

                    } else {
                        i32 ham_vs = NormirIncrField(ham_old, ham);
                        i32 spam_vs = NormirIncrField(spam_old, spam);
                        i32 malic_vs = NormirIncrField(malic_old, malic);

                        GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_IPADDRESS, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);
                    }
                }

            } else if (ident == "iname") {
                GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_INAME, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);

                if ((!read_err) && (get_shingle != 0)) {
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));

                    if (set_mode) {
                        i32 ham_vs = NormirSetField(ham);
                        i32 spam_vs = NormirSetField(spam);
                        i32 malic_vs = NormirSetField(malic);

                        GetGeneralObject()->CorrectLongStatSet(frodo_st::SDT_INAME, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);

                    } else {
                        i32 ham_vs = NormirIncrField(ham_old, ham);
                        i32 spam_vs = NormirIncrField(spam_old, spam);
                        i32 malic_vs = NormirIncrField(malic_old, malic);

                        GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_INAME, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);
                    }
                }

            } else if (ident == "fname") {
                GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_FNAME, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);

                if ((!read_err) && (get_shingle != 0)) {
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));

                    if (set_mode) {
                        i32 ham_vs = NormirSetField(ham);
                        i32 spam_vs = NormirSetField(spam);
                        i32 malic_vs = NormirSetField(malic);

                        GetGeneralObject()->CorrectLongStatSet(frodo_st::SDT_FNAME, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);

                    } else {
                        i32 ham_vs = NormirIncrField(ham_old, ham);
                        i32 spam_vs = NormirIncrField(spam_old, spam);
                        i32 malic_vs = NormirIncrField(malic_old, malic);

                        GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_FNAME, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);
                    }
                }

            } else if (ident == "ifname") {
                GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_IFNAME, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);

                if ((!read_err) && (get_shingle != 0)) {
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));

                    if (set_mode) {
                        i32 ham_vs = NormirSetField(ham);
                        i32 spam_vs = NormirSetField(spam);
                        i32 malic_vs = NormirSetField(malic);

                        GetGeneralObject()->CorrectLongStatSet(frodo_st::SDT_IFNAME, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);

                    } else {
                        i32 ham_vs = NormirIncrField(ham_old, ham);
                        i32 spam_vs = NormirIncrField(spam_old, spam);
                        i32 malic_vs = NormirIncrField(malic_old, malic);

                        GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_IFNAME, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);
                    }
                }

            } else if (ident == "phone") {
                GetGeneralObject()->GetLongStatStorage(frodo_st::SDT_PHONE, cip.m_ip, get_shingle, get_source, read_err, day_old, ham_old, spam_old, malic_old);

                if ((!read_err) && (get_shingle != 0)) {
                    if (static_cast<ui32>(day_old) == 0)
                        day_old = kday_t(time(NULL));

                    if (set_mode) {
                        i32 ham_vs = NormirSetField(ham);
                        i32 spam_vs = NormirSetField(spam);
                        i32 malic_vs = NormirSetField(malic);

                        GetGeneralObject()->CorrectLongStatSet(frodo_st::SDT_PHONE, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);

                    } else {
                        i32 ham_vs = NormirIncrField(ham_old, ham);
                        i32 spam_vs = NormirIncrField(spam_old, spam);
                        i32 malic_vs = NormirIncrField(malic_old, malic);

                        GetGeneralObject()->CorrectLongStatIncr(frodo_st::SDT_PHONE, cip.m_ip, cip.m_source, update_err, day_old, ham_vs, spam_vs, malic_vs);
                    }
                }
            }

            cip_corr_ue = cip_corr;
            CGIEscape(cip_corr_ue);

            get_source_ue = get_source;
            CGIEscape(get_source_ue);

            text += HTTP_200_OK_XML(id);
            text += "<corrlongfield>\n";
            text += "<req_type>" + ident + "</req_type>\n";
            text += "<src>" + cip_source + "</src>\n";
            text += "<corr_ue>" + cip_corr_ue + "</corr_ue>\n";
            text += "<stor_shingle>" + ShingleToStroka(get_shingle) + "</stor_shingle>\n";
            text += "<stor_readerr>" + BoolToStroka(read_err) + "</stor_readerr>\n";
            text += "<stor_upderr>" + BoolToStroka(update_err) + "</stor_upderr>\n";
            text += "<stor_src_ue>" + get_source_ue + "</stor_src_ue>\n";
            text += "<stor_day_old>" + IntToStroka(static_cast<ui32>(day_old)) + "</stor_day_old>\n";
            text += "<stor_ham_old>" + IntToStroka(ham_old) + "</stor_ham_old>\n";
            text += "<stor_spam_old>" + IntToStroka(spam_old) + "</stor_spam_old>\n";
            text += "<stor_malic_old>" + IntToStroka(malic_old) + "</stor_malic_old>\n";
            text += "</corrlongfield>";

            SendToClientRAW(text);

        } else {
            SendToClient(SO_LOG_ERROR, 400, "field not found or empty: ip.", "-");
        }

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::CorrectLongShingleStat(const TString& id, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString ip_s = "";
    TKIPv6Ext ip = TKIPv6Ext();
    TString cip_s = "";
    TKIPv6Ext cip = TKIPv6Ext();
    TString ham_s = "";
    TString spam_s = "";
    TString malic_s = "";
    i32 ham = 0;
    i32 spam = 0;
    i32 malic = 0;
    i32 ham_old = 0;
    i32 spam_old = 0;
    i32 malic_old = 0;
    i32 ham_old1 = 0;
    i32 spam_old1 = 0;
    i32 malic_old1 = 0;
    kday_t day_old = kday_t(static_cast<unsigned long>(0));
    kday_t day_old1 = kday_t(static_cast<unsigned long>(0));
    bool est_ham = false;
    bool est_spam = false;
    bool est_malic = false;
    ui32 last_days = 0;
    ui32 last_days1 = 0;
    TString ident_ip = "ip";
    TString rec_s = "";
    std::list<TString> iplist;
    std::list<TString> iplist2;
    std::list<TString>::iterator iplist_it;
    TString viewip = "";
    ui32 viewipcount = 0;
    kipv6::TWIPv6 value = kipv6::TWIPv6();
    bool max = false;
    TKIPv6 fip = TKIPv6();
    TKIPv6 nip = TKIPv6();
    ui64 shingle = 0;
    frodo_st::TStorageDataType c_reqtype = frodo_st::SDT_END;
    TString c_source = "";
    frodo_st::TStorageDataType c_reqtype1 = frodo_st::SDT_END;
    TString c_source1 = "";
    TString dop_info = "";

    if (GetGeneralObject() != NULL) {
        //ip
        par_it = m_ReqParams->begin();
        while (par_it != m_ReqParams->end()) {
            rec_s = (*par_it).first;
            if ((rec_s.length() >= ident_ip.length()) && (!memcmp(rec_s.c_str(), ident_ip.c_str(), ident_ip.length()))) {
                ip_s = Trim(par_it->second[0]);
                iplist.push_back(ip_s);
                if (iplist.size() > MAX_BAN_IP_COUNT)
                    max = true;
                iplist2.push_back(ip_s);

                if (max)
                    break;
            }

            ++par_it;
        }

        par_it = m_ReqParams->find("cip");
        if (par_it != m_ReqParams->end()) {
            cip_s = Trim(par_it->second[0]);
            shingle = 0;
            sscanf(cip_s.c_str(), "%lx", &shingle);
            cip.m_ip = TKIPv6(0, shingle);
            iplist.push_front(cip_s);
            iplist2.push_front(cip_s);
        }

        par_it = m_ReqParams->find("ham");
        if (par_it != m_ReqParams->end()) {
            ham_s = Trim(par_it->second[0]);
            ham = atoi(ham_s.c_str());
            est_ham = true;
        }

        par_it = m_ReqParams->find("spam");
        if (par_it != m_ReqParams->end()) {
            spam_s = Trim(par_it->second[0]);
            spam = atoi(spam_s.c_str());
            est_spam = true;
        }

        par_it = m_ReqParams->find("malic");
        if (par_it != m_ReqParams->end()) {
            malic_s = Trim(par_it->second[0]);
            malic = atoi(malic_s.c_str());
            est_malic = true;
        }

        if ((iplist.size() > 0)) {
            if (!cip.m_ip.Undefined()) {
                GetGeneralObject()->GetLongDataByShingleStorage(cip.m_ip.LowPart(), c_reqtype, c_source, day_old, ham_old, spam_old, malic_old);
                if (static_cast<ui32>(day_old) == 0)
                    day_old = kday_t(time(NULL));
                GetGeneralObject()->UpdateLongDataByShingle(cip.m_ip.LowPart(), c_reqtype, c_source, day_old, ham, spam, malic);

                iplist2.sort();
                iplist2.unique();

                iplist_it = iplist2.begin();
                while (iplist_it != iplist2.end()) {
                    ip_s = *iplist_it;
                    viewipcount++;

                    if (iplist_it == iplist2.begin())
                        viewip = viewip + "ip" + IntToStroka3(viewipcount) + "=" + ip_s;
                    else
                        viewip = viewip + "&ip" + IntToStroka3(viewipcount) + "=" + ip_s;

                    iplist_it++;
                }

                text = text + HTTP_200_OK(id);
                text = text + "<html><head>";
                text = text + "<meta http-equiv='refresh' content='1; url=" + GetHost() + GetModuleName("corrlgshinglestat") + GetActionOneParam("corrlgshinglestat") + "&" + viewip + "'>";
                text = text + "</head><body bgcolor=palegoldenrod>\n";
                text = text + "<table border='0' width='100%' height='100%' cellspacing='0' cellpadding='4'>";
                text = text + "<tr><td valign='top'>Increment counters successfully.</td></tr>";
                text = text + "</table></body></html>";

                SendToClientRAW(text);

            } else {
                iplist.sort();
                iplist.unique();

                iplist2.sort();
                iplist2.unique();

                iplist_it = iplist2.begin();
                while (iplist_it != iplist2.end()) {
                    ip_s = *iplist_it;
                    viewipcount++;

                    viewip = viewip + "<input type='hidden' size='10' name='ip" + IntToStroka3(viewipcount) + "' value='" + ip_s + "'>";

                    iplist_it++;
                }

                if (iplist.size() > 1) {
                    text = text + "<center><i><b>CORRECT LONG BASA BY SHINGLE:</b></i></center><br>";
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
                    text = text + "<tr align='center' bgcolor='Moccasin'><td width='28%'><b>IP</b></td><td width='8%'><b>LAST DAYS</b></td><td width='18%' colspan='2'><b>HAM</b></td><td width='18%' colspan='2'><b>SPAM</b></td><td width='18%' colspan='2'><b>MALIC</b></td><td width='10%'>&nbsp;</td><tr>";

                    iplist_it = iplist.begin();
                    while (iplist_it != iplist.end()) {
                        ip_s = *iplist_it;
                        shingle = 0;
                        sscanf(ip_s.c_str(), "%lx", &shingle);
                        ip.m_ip = TKIPv6(0, shingle);

                        GetGeneralObject()->GetLongDataByShingleStorage(ip.m_ip.LowPart(), c_reqtype, c_source, day_old, ham_old, spam_old, malic_old);
                        GetGeneralObject()->GetLongDataByShingleCache(ip.m_ip.LowPart(), c_reqtype1, c_source1, day_old1, ham_old1, spam_old1, malic_old1);

                        last_days = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old);
                        last_days1 = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old1);

                        dop_info = " (" + frodo_st::TStorageDataTypeToTString(c_reqtype) + ", '" + c_source + "')";

                        text = text + "<form action='" + GetHost() + GetModuleName("corrlgshinglestat") + "' method='GET' enctype='text/plain'>";
                        text = text + "<tr>";
                        text = text + "<td><A href='" + GetHost() + GetModuleName("corrlgshinglestat") + GetActionOneParam("corrlgshinglestat") + "&ip=" + ip_s + "' target='_blank'>" + ip_s + "</A>" + dop_info + "</td>";
                        text = text + "<td>" + IntToStroka(static_cast<ui32>(day_old)) + "(" + IntToStroka(last_days) + ")<input type='hidden' size='10' name='cip' value='" + ip_s + "'>" + viewip + "</td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(ham_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='ham' value=''></td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(spam_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='spam' value=''></td>";
                        text = text + "<td width='9%' bgcolor='Seashell'>" + IntToStroka(malic_old) + "</td>";
                        text = text + "<td width='9%'>&nbsp;<b>+</b>&nbsp;<input type='text' size='10' name='malic' value=''></td>";
                        text = text + "<td align='center'><input type='submit' size='10' value='apply'></td>";
                        text = text + "</tr>";
                        text = text + GetActionFormParam("corrlgshinglestat") + "</form>";

                        iplist_it++;
                    }

                    text = text + "</table>";

                } else {
                    iplist_it = iplist.begin();
                    if (iplist_it != iplist.end()) {
                        ip_s = *iplist_it;
                        shingle = 0;
                        sscanf(ip_s.c_str(), "%lx", &shingle);
                        ip.m_ip = TKIPv6(0, shingle);

                        GetGeneralObject()->GetLongDataByShingleStorage(ip.m_ip.LowPart(), c_reqtype, c_source, day_old, ham_old, spam_old, malic_old);
                        GetGeneralObject()->GetLongDataByShingleCache(ip.m_ip.LowPart(), c_reqtype1, c_source1, day_old1, ham_old1, spam_old1, malic_old1);

                        last_days = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old);
                        last_days1 = static_cast<ui32>(kday_t(time(NULL))) - static_cast<ui32>(day_old1);

                        dop_info = "type=" + frodo_st::TStorageDataTypeToTString(c_reqtype) + ", source='" + c_source + "'";

                        text = text + "<center><i><b>CORRECT LONG BASA BY SHINGLE: (<A href='" + GetHost() + "corrlgshinglestat?ip=" + ip_s + "'>" + ip_s + "</A>, " + dop_info + "):</b></i></center><br>";
                        text = text + "<form action='" + GetHost() + GetModuleName("corrlgshinglestat") + "' method='GET' enctype='text/plain'>";
                        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>";
                        text = text + "<tr align='center' bgcolor='Moccasin'><td><b>FIELD</b></td><td><b>CACHE</b></td><td><b>STORAGE</b></td><td><b>ACTION</b></td></tr>";
                        text = text + "<tr align='center'><td>Record type</td><td align='center'><b><font color='green'>" + frodo_st::TStorageDataTypeToTString(c_reqtype1) + "</font></b></td><td align='center'><b><font color='green'>" + frodo_st::TStorageDataTypeToTString(c_reqtype) + "</font></b></td><td>&nbsp;</td></tr>";
                        text = text + "<tr align='center'><td>last days (elapsed)</td><td>" + IntToStroka(static_cast<ui32>(day_old1)) + " (" + IntToStroka(last_days1) + ")</td><td>" + IntToStroka(static_cast<ui32>(day_old)) + " (" + IntToStroka(last_days) + ")</td><td><input type='hidden' size='10' name='cip' value='" + ip_s + "'>&nbsp;</td></tr>";
                        text = text + "<tr align='center'><td>ham</td><td bgcolor='Seashell'>" + IntToStroka(ham_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(ham_old) + "</td><td>+&nbsp;<input type='text' size='10' name='ham' value=''></td></tr>";
                        text = text + "<tr align='center'><td>spam</td><td bgcolor='Seashell'>" + IntToStroka(spam_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(spam_old) + "</td><td>+&nbsp;<input type='text' size='10' name='spam' value=''></td></tr>";
                        text = text + "<tr align='center'><td>malic</td><td bgcolor='Seashell'>" + IntToStroka(malic_old1) + "</td><td bgcolor='Seashell'>" + IntToStroka(malic_old) + "</td><td>+&nbsp;<input type='text' size='10' name='malic' value=''></td></tr>";
                        text = text + "<tr align='center'><td>&nbsp;</td><td>&nbsp;</td><td>&nbsp;</td><td><input type='submit' size='10' value='apply'></td></tr>";
                        text = text + "</table>";
                        text = text + GetActionFormParam("corrlgshinglestat") + "</form>";
                    }
                }

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
            }
        } else {
            if (ip.m_ip.Undefined())
                SendToClient(SO_LOG_ERROR, 400, "field not found or empty: ip.", "-");
            else
                SendToClient(SO_LOG_ERROR, 500, "", "-");
        }
    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::CorrectLongStat(TCorrectLongstatType clt, const TString& ident, const TString& id, TReqParams* m_ReqParams) {
    bool is_upstream_request = true; //������, ������� ������ ����� ��������
    bool skeep = false;

    if (IsMinorRequest(NumbRequest))
        is_upstream_request = false;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL)) {
        if (GetGeneralObject()->GetCorrLongStatTC() != NULL)
            GetGeneralObject()->GetCorrLongStatTC()->Skeep();

        ui32 full_tick = CShingleTime::GetMs();

        if (m_ReqParams != NULL) {
            TResStruct resdata = TResStruct();

            if (GetGeneralObject()->GetLimitObj()->AddThread(TMakeRequestLimit::CORRLONGSTAT)) {
                switch (clt) {
                    case CLT_IP:
                        CorrectLongIPStat(id, m_ReqParams);
                        break;
                    case CLT_FIELD:
                        CorrectLongFieldsStat(ident, id, m_ReqParams);
                        break;
                    case CLT_SHINGLE:
                        CorrectLongShingleStat(id, m_ReqParams);
                        break;
                };

                skeep = false;
                resdata.m_code = 200;

                GetGeneralObject()->GetLimitObj()->ReturnThread(TMakeRequestLimit::CORRLONGSTAT);

            } else {
                skeep = true;
                resdata.m_code = 509;

                SendToClientRAW(HTTP_509_BANDWIDTH_LIMIT_EXCEEDED());
            }

            //GetGeneralObject()->GetLimitObj()->AddResStatus(TMakeRequestLimit::CORRLONGSTAT, cntdata.m_source, cntdata.m_empty);

            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetIOLog() != NULL)) {
                TString upstream_s = "";

                if (is_upstream_request)
                    upstream_s = "upstr";
                else
                    upstream_s = "minor";

                ui32 obr_tick = CShingleTime::GetMs() - full_tick;

                GetLogsGroup()->GetIOLog()->WriteMessageAndData("CORRLONGSTAT(%u) %s % 4u % 3u %s", static_cast<ui32>(clt), upstream_s.c_str(), obr_tick, resdata.m_code, NumbRequest.c_str());
            }

        } else {
            SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
        }

        full_tick = CShingleTime::GetMs() - full_tick;
        GetGeneralObject()->GetLimitObj()->AddTick(TMakeRequestLimit::CORRLONGSTAT, full_tick, skeep);

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

void TMakeRequest::CorrectLongStatRobot(TCorrectLongstatType clt, const TString& ident, const TString& id, TReqParams* m_ReqParams) {
    bool is_upstream_request = true; //������, ������� ������ ����� ��������
    bool skeep = false;

    if (IsMinorRequest(NumbRequest))
        is_upstream_request = false;

    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL)) {
        if (GetGeneralObject()->GetCorrLongStatTC() != NULL)
            GetGeneralObject()->GetCorrLongStatTC()->Skeep();

        ui32 full_tick = CShingleTime::GetMs();

        if (m_ReqParams != NULL) {
            TResStruct resdata = TResStruct();

            if (GetGeneralObject()->GetLimitObj()->AddThread(TMakeRequestLimit::CORRLONGSTAT)) {
                switch (clt) {
                    default:
                        break;
                    case CLT_IP:
                    case CLT_FIELD:
                        CorrectLongFieldsStatRobot(ident, id, m_ReqParams);
                        break;
                        //case CLT_SHINGLE:
                        //                  CorrectLongShingleStat(id, m_ReqParams);
                        //                  break;
                };

                skeep = false;
                resdata.m_code = 200;

                GetGeneralObject()->GetLimitObj()->ReturnThread(TMakeRequestLimit::CORRLONGSTAT);

            } else {
                skeep = true;
                resdata.m_code = 509;

                SendToClientRAW(HTTP_509_BANDWIDTH_LIMIT_EXCEEDED());
            }

            //GetGeneralObject()->GetLimitObj()->AddResStatus(TMakeRequestLimit::CORRLONGSTAT, cntdata.m_source, cntdata.m_empty);

            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetIOLog() != NULL)) {
                TString upstream_s = "";

                if (is_upstream_request)
                    upstream_s = "upstr";
                else
                    upstream_s = "minor";

                ui32 obr_tick = CShingleTime::GetMs() - full_tick;

                GetLogsGroup()->GetIOLog()->WriteMessageAndData("CORRLONGROBT(%u) %s % 4u % 3u %s", static_cast<ui32>(clt), upstream_s.c_str(), obr_tick, resdata.m_code, NumbRequest.c_str());
            }

        } else {
            SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
        }

        full_tick = CShingleTime::GetMs() - full_tick;
        GetGeneralObject()->GetLimitObj()->AddTick(TMakeRequestLimit::CORRLONGSTAT, full_tick, skeep);

    } else {
        SendToClientRAW(HTTP_500_INTERNAL_SERVER_ERROR());
    }
}

void TMakeRequest::RslvIPFromCache(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString ips = "";
    TKIPv6 ip = TKIPv6();

    if ((GetGeneralObject() != NULL)) {
        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ips = Trim(par_it->second[0]);
            if (!ips.empty())
                ip = TKIPv6(ips.c_str());
        }

        if (!ip.Undefined()) {
            text += GetGeneralObject()->GetFilter().GetRslvIPFromCache(ip);

            SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::GetUDNSServices(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    const char* table_color = "'#ffffcc'";
    TString text = "";
    TString ips = "";
    TKIPv6 ip = TKIPv6();
    TSummDataUdnsList stat_list;
    TSummDataUdnsListIt it;

    if ((GetGeneralObject() != NULL)) {
        par_it = m_ReqParams->find("ip");
        if (par_it != m_ReqParams->end()) {
            ips = Trim(par_it->second[0]);
            if (!ips.empty())
                ip = TKIPv6(ips.c_str());
        }

        if (!ip.Undefined()) {
            GetGeneralObject()->GetFilter().GetUdnsServicesIPData("", ip, stat_list);

            text = text + "<i><b>UDNS result for ip='" + ip.toStroka() + "':</b></i>&nbsp;&nbsp;";
            text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">";

            text = text + "<tr align='center'>";
            text = text + "<td width='5%'><b>SERVICE</b></td>";
            text = text + "<td width='5%'><b>HOST:PORT</b></td>";
            text = text + "<td width='5%'><b>TIMEOUT</b></td>";
            text = text + "<td width='10%'><b>ZONE</b></td>";
            text = text + "<td width='5%'><b>TICK</b></td>";
            text = text + "<td width='70%'><b>RESULT</b></td>";
            text = text + "</tr>";

            it = stat_list.begin();
            while (it != stat_list.end()) {
                text = text + "<tr align='right'>";
                text = text + "<td align='left'>" + (*it).m_data.m_name + "</td>";
                if ((*it).m_prop.m_enable)
                    text = text + "<td>" + (*it).m_prop.m_host + ":" + IntToStroka((*it).m_prop.m_port) + "</td>";
                else
                    text = text + "<td>disabled (" + (*it).m_prop.m_host + ":" + IntToStroka((*it).m_prop.m_port) + ")</td>";
                text = text + "<td>" + IntToStroka((*it).m_prop.m_timeout) + "</td>";
                text = text + "<td>" + (*it).m_prop.m_zone + "</td>";
                text = text + "<td>" + IntToStroka((*it).m_data.m_tick) + "</td>";
                if ((*it).m_data.m_ok)
                    text = text + "<td>" + (*it).m_data.ToResultS() + "</td>";
                else
                    text = text + "<td>FAILED</td>";
                text = text + "</tr>";

                ++it;
            }
            text = text + "</table>";

            SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
        }

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::ClearRCPT(const TString& id, TReqParams* /*m_ReqParams*/) {
    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetRCP() != NULL)) {
        GetGeneralObject()->GetRCP()->Clear();
        SendToClient(SO_LOG_MESSAGE, 200, "Clear receipt - OK!", id);
    } else {
        SendToClient(SO_LOG_ERROR, 500, "internal server error", id);
    }
}

void TMakeRequest::WriteReceipHash(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TString filename = "";
    bool f_ok = false;
    const char* p = NULL;
    TString filename_t = "";

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetRCP() != NULL)) {
        par_it = m_ReqParams->find("file");
        if (par_it != m_ReqParams->end()) {
            filename = Trim(par_it->second[0]);
            CGIUnescape(filename);

        } else {
            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetServerLog() != NULL)) {
                filename_t = GetLogsGroup()->GetServerLog()->GetTekFilename();
                ReverseInPlace(filename_t);
                p = strchr(filename_t.c_str(), '/');
                if (p == NULL)
                    p = strchr(filename_t.c_str(), '\\');
                if (p != NULL) {
                    filename_t = TString(p);
                    ReverseInPlace(filename_t);
                    filename = filename_t + "rcptlist_content.txt";
                }
            }
        }

        if (!filename.empty()) {
            f_ok = GetGeneralObject()->GetRCP()->WriteData(filename);

            if (f_ok)
                SendToClient(SO_LOG_MESSAGE, 200, "Write receipt list to log '" + filename + "' - OK.", "-");
            else
                SendToClient(SO_LOG_ERROR, 501, "Write receipt list - FAILED.", "-");

        } else
            text = "No defined target filename.";

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::TraccertStat(const TString& /*id*/) {
    if (GetGeneralObject() != NULL) {
        TString text = "";

        text += "<i><b>Traccert statistik for 'check':</b></i><br>";
        text += GetGeneralObject()->GetTraccertStatWeb();

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text.c_str(), "-");

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::ViewPDDStat() {
    TString text = "";
    TSummaryStatPCN statdata;
    const char* table_color = "'#ffffcc'";
    const char* cell_color = "PaleGoldenrod";
    TString reloadlink = "";

    if ((GetGeneralObject() != NULL)) {
        statdata = GetGeneralObject()->GetFilter().GetStatPDD();

        text = text + "<b><i>Free mail statistic.</i></b>&nbsp;";
        text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>Enable</td><td width='80%' colspan='4'>" + BoolToStroka2(statdata.enable) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>threads work</td><td width='80%' colspan='4'>" + BoolToStroka2(statdata.enable_threads) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>Threads count</td><td width='80%' colspan='4'>" + IntToStroka(statdata.threads) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>Queue size</td><td width='80%' colspan='4'>" + IntToStroka(statdata.queue_size) + "</td></tr>\n";
        if (statdata.directly) {
            text = text + "<tr valign='top'><td align='left' width='20%'>Request mode</td><td width='80%' colspan='4'>directly</td></tr>\n";
            text = text + "<tr valign='top'><td align='left' width='20%'>Accessible clients</td><td width='80%' colspan='4'>" + IntToStroka(statdata.directly_accessible_clients) + "</td></tr>\n";

        } else {
            text = text + "<tr valign='top'><td align='left' width='20%'>Request mode</td><td width='80%' colspan='4'>queue</td></tr>\n";
        }
        text = text + "<tr valign='top'><td align='left' width='20%'>Storage type</td><td width='80%' colspan='4'>" + statdata.storage_type + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>Host update period</td><td width='80%' colspan='4'>" + IntToStroka(statdata.host_update_period) + "</td></tr>\n";
        reloadlink = "&nbsp;(<A href='" + GetHost() + GetModuleName("reloadpddprop") + GetActionOneParam("reloadpddprop") + "'>reload</A>)";
        text = text + "<tr valign='top'><td align='left' width='20%'>Example request url</td><td width='80%' colspan='4'>" + statdata.example_request + reloadlink + "</td></tr>\n";
        text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>&nbsp</td><td align='center' width='40%' colspan='2'><b>TODAY</b></td><td align='center' width='40%' colspan='2'><b>YESTERDAY</b></td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>All request count</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.all_request_count) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.all_request_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Connect error</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.connect_error) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.connect_error) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Connect timeout</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.connect_timeout) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.connect_timeout) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request ok (200)</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.request_200_count) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.request_200_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request with code 404</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.request_404_count) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.request_404_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request with code 400-499 exclude 404</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.request_400500_count) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.request_400500_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request with other code</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.request_other_count) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.request_other_count) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request error</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.request_error) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.request_error) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request timeout</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.request_timeout) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.request_timeout) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Request buffer overflow</td><td colspan='2'>" + IntToStroka(statdata.client_stat.today.request_buffer_overflow) + "</td><td colspan='2'>" + IntToStroka(statdata.client_stat.yesterday.request_buffer_overflow) + "</td></tr>\n";
        text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>&nbsp</td><td align='center' width='40%' colspan='2'><b>TODAY</b></td><td align='center' width='40%' colspan='2'><b>YESTERDAY</b></td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Queue input</td><td colspan='2'>" + IntToStroka(statdata.queue_stat.today.m_incount) + "</td><td colspan='2'>" + IntToStroka(statdata.queue_stat.yesterday.m_incount) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Queue count (size)</td><td colspan='2'>" + IntToStroka(statdata.queue_stat.today.m_inqueue) + "</td><td colspan='2'>" + IntToStroka(statdata.queue_stat.yesterday.m_inqueue) + "</td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Queue lost</td><td colspan='2'>" + IntToStroka(statdata.queue_stat.today.m_lost) + "</td><td colspan='2'>" + IntToStroka(statdata.queue_stat.yesterday.m_lost) + "</td></tr>\n";
        text = text + "<tr valign='top' bgcolor='" + TString(cell_color) + "'><td valign='left' width='100%' colspan='5'>&nbsp;</td></tr>\n";
        text = text + "<tr valign='top'><td align='left' width='20%'>&nbsp</td><td align='center' width='40%' colspan='2'><b>MINUTE</b></td><td align='center' width='40%' colspan='2'><b>HOUR</b></td></tr>\n";
        text = text + "<tr valign='top'><td align='left'>Send request by time</td><td colspan='2'>" + IntToStroka(statdata.count_min) + "</td><td colspan='2'>" + IntToStroka(statdata.count_hour) + "</td></tr>\n";

        text = text + "</table>";

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::ViewResolvStat() {
    TString text = "";

    if ((GetGeneralObject() != NULL)) {
        TString ipfromcache_form = "<b>Get IP info from cache: </b><form action='" + GetHost() + GetModuleName("rslvipfromcache") + "' method='GET' enctype='text/plain' target='_blank'> &nbsp; <input type='text' size='30' name='ip' value=''> &nbsp; " + GetActionFormParam("rslvipfromcache") + "<input type='submit' size='10' value='query by ip'></form>";

        text = GetGeneralObject()->GetFilter().ViewResolvWebStat(ipfromcache_form);

        SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::ViewPDDHost(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TSummaryStatPCN statdata;
    const char* table_color = "'#ffffcc'";
    TString reloadlink = "";
    TString host = "";
    bool f_ok = false;
    ui64 shingle = 0;
    TPDDStructN pdddata;

    if ((GetGeneralObject() != NULL)) {
        par_it = m_ReqParams->find("host");
        if (par_it != m_ReqParams->end()) {
            host = Trim(par_it->second[0]);
            if (!host.empty())
                CGIUnescape(host);
        }
        if (!host.empty()) {
            shingle = ShingleFromStroka(host);
            if (shingle != 0) {
                f_ok = GetGeneralObject()->GetFilter().GetPDDInfo(shingle, host, pdddata);
                if (f_ok) {
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                    text = text + "<tr valign='top'>host<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_host + "</td></tr>\n";
                    text = text + "<tr valign='top'>last update<td align='left' width='60%'></td><td width='40%'>" + IntToStroka(pdddata.m_last_update) + "</td></tr>\n";
                    text = text + "<tr valign='top'>first time<td align='left' width='60%'></td><td width='40%'>" + IntToStroka(pdddata.m_firsttime) + "</td></tr>\n";
                    text = text + "<tr valign='top'>mailbox count<td align='left' width='60%'></td><td width='40%'>" + IntToStroka(pdddata.m_mailbox_count) + "</td></tr>\n";
                    text = text + "<tr valign='top'>admin login<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_adm_login + "</td></tr>\n";
                    text = text + "<tr valign='top'>karma<td align='left' width='60%'></td><td width='40%'>" + IntToStroka(pdddata.m_karma) + "</td></tr>\n";
                    text = text + "<tr valign='top'>registration address<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_ip.toStroka() + "</td></tr>\n";
                    text = text + "<tr valign='top'>geo<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_geo + "</td></tr>\n";
                    text = text + "</table>";

                } else {
                    text = text + "Get info FAILED.";
                }

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

            } else {
                SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
            }
        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
        }
    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::ReloadPDDProperties() {
    bool f_ok = false;
    TString text = "";

    if ((GetGeneralObject() != NULL))
        f_ok = GetGeneralObject()->GetFilter().ReloadPDDProp();

    if (f_ok)
        text = "Reload PDD properties - OK.";
    else
        text = "Reload PDD properties - FAILED.";

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
}

void TMakeRequest::TestPDDInfo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TString admlogin = "";
    TString domaininfo = "";
    TReqParams::iterator par_it;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("domain");
        if (par_it != m_ReqParams->end()) {
            domaininfo = Trim(par_it->second[0]);
            if (!domaininfo.empty())
                CGIUnescape(domaininfo);
        }
    }

    admlogin = domaininfo;
    admlogin = Recode(CODES_WIN, CODES_UTF8, admlogin);
    text = text + "<pddinfo>";
    text = text + "<firsttime>" + IntToStroka(time(NULL) - 86400) + "</firsttime>";
    text = text + "<mailboxcnt>100</mailboxcnt>";
    text = text + "<freereg>1</freereg>";
    text = text + "<admlogin>" + admlogin + "</admlogin>";
    text = text + "<quota>101</quota>";
    text = text + "<manualreq>1</manualreq>";
    text = text + "<karma>85</karma>";
    text = text + "<ip>127.0.0.1</ip>";
    text = text + "<geo>RU Moscow</geo>";
    text = text + "</pddinfo>";

    SendToClientRAW(HTTP_200_OK(id) + text);
}

void TMakeRequest::ViewBBoxStat() {
    SendToClientWithShap(SO_LOG_MESSAGE, 200, "", "");
}

void TMakeRequest::ViewBBoxHost(const TString& /*id*/, TReqParams* m_ReqParams) {
    TReqParams::iterator par_it;
    TString text = "";
    TSummaryStatPCN statdata;
    const char* table_color = "'#ffffcc'";
    TString reloadlink = "";
    TString host = "";
    bool f_ok = false;
    ui64 shingle = 0;
    TBBoxStructN pdddata;

    if ((GetGeneralObject() != NULL)) {
        par_it = m_ReqParams->find("host");
        if (par_it != m_ReqParams->end()) {
            host = Trim(par_it->second[0]);
            if (!host.empty())
                CGIUnescape(host);
        }
        if (!host.empty()) {
            shingle = ShingleFromStroka(host);
            if (shingle != 0) {
                if (f_ok) {
                    text = text + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(table_color) + ">\n";
                    text = text + "<tr valign='top'>e-mail<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_email + "</td></tr>\n";
                    text = text + "<tr valign='top'>last update<td align='left' width='60%'></td><td width='40%'>" + TimeToStr(pdddata.m_last_update) + "</td></tr>\n";
                    text = text + "<tr valign='top'>uid<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_uid + "</td></tr>\n";
                    text = text + "<tr valign='top'>karma<td align='left' width='60%'></td><td width='40%'>" + IntToStroka(pdddata.m_karma) + "</td></tr>\n";
                    text = text + "<tr valign='top'>status<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_status + "</td></tr>\n";
                    text = text + "<tr valign='top'>error<td align='left' width='60%'></td><td width='40%'>" + pdddata.m_error + "</td></tr>\n";
                    text = text + "</table>";

                } else {
                    text = text + "Get info FAILED.";
                }

                SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "");

            } else {
                SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
            }
        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request", "-");
        }
    } else {
        SendToClient(SO_LOG_ERROR, 500, "Internal error", "-");
    }
}

void TMakeRequest::ReloadBBoxProperties() {
    bool f_ok = false;
    TString text = "";

    if (f_ok)
        text = "Reload BlackBox properties - OK.";
    else
        text = "Reload BlackBox properties - FAILED.";

    SendToClientWithShap(SO_LOG_MESSAGE, 200, text, "-");
}

void TMakeRequest::TestBBoxInfo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TString login = "";
    TReqParams::iterator par_it;
    bool notfound = false;

    if (m_ReqParams != NULL) {
        par_it = m_ReqParams->find("login");
        if (par_it != m_ReqParams->end()) {
            login = Trim(par_it->second[0]);
            if (!login.empty())
                CGIUnescape(login);
        }
    }

    all_headers = all_headers;

    if (!notfound) {
        text = text + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        text = text + "<doc>";
        text = text + "<uid hosted=\"1\" domid=\"1\" domain=\"okna.ru\" mx=\"0\">1130000000001344</uid>";
        text = text + "<login>pdd</login>";
        text = text + "<have_password>1</have_password>";
        text = text + "<have_hint>1</have_hint>";
        text = text + "<karma confirmed=\"0\">1</karma>";
        text = text + "<karma_status>6000</karma_status>";
        text = text + "<dbfield id=\"subscription.login.-\">" + login + "</dbfield>";
        text = text + "</doc>";

    } else {
        text = text + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        text = text + "<doc>";
        text = text + "<status id=\"2\">INVALID</status>";
        text = text + "<error>Login not found</error>";
        text = text + "</doc>";
    }

    SendToClientRAW(HTTP_200_OK(id) + text);
}

void TMakeRequest::TestGetForFrodo(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();

    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = par_it->second[0];
        CGIUnescape(ip_s);
        ip_s = Trim(ip_s);
        ip = TKIPv6(ip_s.c_str());

        if (!ip.Undefined()) {
            ui32 today_ham = 0;
            ui32 today_spam = 0;
            ui32 today_malic = 0;
            ui32 today_flags = 0;
            ui32 yesterday_ham = 0;
            ui32 yesterday_spam = 0;
            ui32 yesterday_malic = 0;
            ui32 yesterday_flags = 0;
            ui32 history_reject = 0;
            ui32 history_noreject = 0;
            ui32 history_ham = 0;
            ui32 history_spam = 0;
            char buff[2048];
            TString hostgeo = "";
            TString rdns = "";
            TString geo = "";

            today_ham = 1;
            today_spam = 0;
            today_malic = 0;
            today_flags = 0;

            yesterday_ham = 1;
            yesterday_spam = 0;
            yesterday_malic = 0;
            yesterday_flags = 0;

            history_reject = 0;
            history_noreject = 1;
            history_ham = 1;
            history_spam = 0;

            snprintf(buff, sizeof(buff) - 1, "ip=%s&empty=0&data=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u&host=%s&geo=%s", ip.toStroka().c_str(), today_ham, today_spam, today_malic, today_flags, yesterday_ham, yesterday_spam, yesterday_malic, yesterday_flags, history_reject, history_noreject, history_ham, history_spam, rdns.c_str(), geo.c_str());
            text = TString(buff);

            SendToClientRAW(HTTP_200_OK(id) + text);

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request (bad ip parameters).", id);
        }
    } else {
        SendToClient(SO_LOG_ERROR, 400, "Bad request (no ip parameters).", id);
    }
}

void TMakeRequest::TestGetForFrodo2(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString ip_s = "";
    TKIPv6 ip = TKIPv6();

    par_it = m_ReqParams->find("ip");
    if (par_it != m_ReqParams->end()) {
        ip_s = par_it->second[0];
        CGIUnescape(ip_s);
        ip_s = Trim(ip_s);
        ip = TKIPv6(ip_s.c_str());

        if (!ip.Undefined()) {
            ui32 today_ham = 0;
            ui32 today_spam = 0;
            ui32 today_malic = 0;
            ui32 today_flags = 0;
            ui32 yesterday_ham = 0;
            ui32 yesterday_spam = 0;
            ui32 yesterday_malic = 0;
            ui32 yesterday_flags = 0;
            ui32 history_reject = 0;
            ui32 history_noreject = 0;
            ui32 history_ham = 0;
            ui32 history_spam = 0;
            char buff[2048];
            TString hostgeo = "";
            bool ban = false;
            ui16 ban_hours = 0;
            ui8 ban_pr = 0;
            bool ban7 = false;
            ui16 ban7_hours = 0;
            ui8 ban7_pr = 0;
            TString ban_stat = "";
            TString ban7_stat = "";
            TString rdns = "";
            TString geo = "";

            //���������� ����
            //GetStatIPObject()->IsBanIpExt(ip, ban, ban_hours, ban_pr, ban7, ban7_hours, ban7_pr);
            ban_stat = BoolToStroka(ban) + "-" + IntToStroka(ban_hours) + "-" + IntToStroka(ban_pr);
            ban7_stat = BoolToStroka(ban7) + "-" + IntToStroka(ban7_hours) + "-" + IntToStroka(ban7_pr);

            //���������� �� ������
            today_ham = 1;
            today_spam = 0;
            today_malic = 0;
            today_flags = 0;

            yesterday_ham = 1;
            yesterday_spam = 0;
            yesterday_malic = 0;
            yesterday_flags = 0;

            history_reject = 0;
            history_noreject = 1;
            history_ham = 1;
            history_spam = 0;

            snprintf(buff, sizeof(buff) - 1, "ip=%s&empty=0&data=%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u-%u&host=%s&geo=%s&ban=%s&ban7=%s", ip.toStroka().c_str(), today_ham, today_spam, today_malic, today_flags, yesterday_ham, yesterday_spam, yesterday_malic, yesterday_flags, history_reject, history_noreject, history_ham, history_spam, rdns.c_str(), geo.c_str(), ban_stat.c_str(), ban7_stat.c_str());
            text = TString(buff);

            SendToClientRAW(HTTP_200_OK(id) + text);

        } else {
            SendToClient(SO_LOG_ERROR, 400, "Bad request (bad ip parameters).", id);
        }

    } else {
        SendToClient(SO_LOG_ERROR, 400, "Bad request (no ip parameters).", id);
    }
}

void TMakeRequest::TestMLRcvData(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString key = "";
    TString value = "";
    TString full_request = "";

    par_it = m_ReqParams->begin();
    while (par_it != m_ReqParams->end()) {
        key = par_it->first;
        value = par_it->second[0];

        full_request += key + "='" + value + "'\n";
        //printf("key=%s: value='%s'\n", key.c_str(), value.c_str());

        ++par_it;
    }

    if ((LogsGroup != NULL) && (LogsGroup->GetDebugInfoLog() != NULL))
        LogsGroup->GetDebugInfoLog()->WriteMessageAndData("ml_rqst:\n%s", full_request.c_str());

    text += "<weight>77</weight><spam>1</spam>";

    SendToClientRAW(HTTP_200_OK(id) + text);
}

void TMakeRequest::TestClustRcvData(const TString& id, TReqParams* m_ReqParams) {
    TString text = "";
    TReqParams::iterator par_it;
    TString key = "";
    TString value = "";
    TString full_request = "";

    par_it = m_ReqParams->begin();
    while (par_it != m_ReqParams->end()) {
        key = par_it->first;
        value = par_it->second[0];

        full_request += key + "='" + value + "'\n";
        printf("key=%s: value='%s'\n", key.c_str(), value.c_str());

        ++par_it;
    }

    if ((LogsGroup != NULL) && (LogsGroup->GetDebugInfoLog() != NULL))
        LogsGroup->GetDebugInfoLog()->WriteMessageAndData("clust_rqst:\n%s", full_request.c_str());

    text += "1234567890 1.5 1.9 0.7 0.33";
    //text += "-";

    SendToClientRAW(HTTP_200_OK(id) + text);
}

void TMakeRequest::AskPushToStorage(const TString& /*id*/) {
    TString text = "";

    text = text + HTTP_200_OK("-");
    text = text + "<SCRIPT LANGUAGE='Javascript'>\n";
    text = text + "if(true == confirm('Push data from file to storage (the old data will be overwritten)?')) {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("dopushtostor") + GetActionOneParam("dopushtostor") + "'\n";
    text = text + "} else {\n";
    text = text + "document.location = '" + GetHost() + GetModuleName("console") + GetActionOneParam("console") + "'}\n";
    text = text + "</SCRIPT>\n";
    SendToClientRAW(text);
}

void TMakeRequest::DoPushToStorage(const TString& /*id*/) {
    TString text = "";

    if (GetGeneralObject() != NULL) {
        if (GetGeneralObject()->PushToStorage())
            text += "Push data to storage - Busy";
        else
            text += "Push data to storage - OK";

        SendToClient(SO_LOG_MESSAGE, 200, text, "-");

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

TString TMakeRequest::HTTP_200_OK_PlainExt(float rating, ui8 hash_one, ui64 hash_two) {
    TString text = "";

    text = text + "Status: 200 OK\r\n";
    text = text + "Server: " + m_servername + "\r\n";
    text = text + "Content-type: text/plain\r\n";
    text = text + "Rate: " + FloatToStr0(rating) + "\r\n";
    text = text + "HashOne: " + IntToStroka(hash_one) + "\r\n";
    text = text + "HashTwo: " + ShingleToStroka2(hash_two) + "\r\n";
    text = text + "\r\n";

    return text;
}

void TMakeRequest::ShowWeight(const TString& /*id*/, TReqParams* /*m_ReqParams*/) {
    TString text = "";
    float srvc_rating = 0;

    if ((GetGeneralObject() != NULL) && (GetGeneralObject()->GetRateObj() != NULL)) {
        srvc_rating = GetGeneralObject()->GetRateObj()->GetLastRating();
        text = text + FloatToStr0(srvc_rating);

        SendToClientRAW(HTTP_200_OK_PlainExt(srvc_rating, 0, 0) + text);

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error.", "-");
    }
}

void TMakeRequest::AuthPhone(const TString& id, TReqParams* m_ReqParams) {
    if ((m_ReqParams != NULL) && (GetGeneralObject() != NULL)) {
        TReqParams::iterator par_it;
        TString login = "";
        TString ip_s = "";
        TString karma_s = "";
        TString date_s = "";
        TKIPv6 ip = TKIPv6();
        ui32 karma = 0;
        ui32 data = 0;
        int logininfo = KPUNKNOWN; //наша карма, если нашли в базе
        TString logininfo_s = "-";
        TString date_sr = "";
        time_t current_time = time(NULL);

        par_it = m_ReqParams->find("login");
        if (par_it != m_ReqParams->end())
            login = Trim((*par_it).second[0]);

        if (!login.empty()) {
            par_it = m_ReqParams->find("ip");
            if (par_it != m_ReqParams->end()) {
                ip_s = Trim((*par_it).second[0]);
                ip = TKIPv6(ip_s.c_str());
            } else
                ip_s = "-";

            par_it = m_ReqParams->find("karma");
            if (par_it != m_ReqParams->end()) {
                karma_s = Trim((*par_it).second[0]);
                karma = atol(karma_s.c_str());
            } else
                karma_s = "-";

            par_it = m_ReqParams->find("logindate");
            if (par_it != m_ReqParams->end()) {
                date_s = Trim((*par_it).second[0]);
                data = atol(date_s.c_str());
                date_sr = TimeToStrNoProbel((time_t)data);
            } else
                date_s = "-";

            if ((current_time - data) <= (2 * 86400)) {
                logininfo = GetGeneralObject()->GetFilter().GetLoginsInfo(ip, login);
                if (logininfo != KPUNKNOWN)
                    logininfo_s = IntToStroka(logininfo);
            }

            if ((GetLogsGroup() != NULL) && (GetLogsGroup()->GetAuthPhoneLog() != NULL))
                GetLogsGroup()->GetAuthPhoneLog()->WriteMessageAndData("login=%s, ip=%s, karma=%s, logindate=%s, linf=%s", login.c_str(), ip_s.c_str(), karma_s.c_str(), date_sr.c_str(), logininfo_s.c_str());

            SendToClient(SO_LOG_MESSAGE, 200, "", "-");
        } else {
            SendToClient(SO_LOG_ERROR, 400, "", "-");
        }

    } else {
        SendToClientWithShap(SO_LOG_ERROR, 500, "internal server error", id);
    }
}

void TMakeRequest::Status(const TString& /*id*/, TReqParams* /*m_ReqParams*/) {
    SendToClient(SO_LOG_MESSAGE, 200, "OK", "-");
}

//*******************************************************************************************************************************************
