#pragma once

#include "util/generic/hash.h"
#include <mail/so/spamstop/tools/fcgiserver_base/tserviceobjectbase.h>
#include <mail/so/spamstop/tools/fcgiserver_base/tmakerequestbase.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include "tserviceobject.h"
#include "tlogsgroup.h"
#include "tgeneralobject.h"
#include "tstoragetypes.h"
#include "tstoragepool.h"
#include "trqstlimit.h"
#include "tconsolestat.h"
#include "tspamonlog.h"

//*******************************************************************************************************************************************
//                                                             TMakeRequest
//*******************************************************************************************************************************************

class TMakeRequest: public TMakeRequestBase
{
private:
         static const int  MAX_BAN_IP_COUNT       = 1000;     //����� ��������
         //static const ui32 LONG_REQUEST_DEFAULT   = 200;      //���� ������, �� � ������� ������ RT
         enum TCorrectLongstatType {CLT_IP, CLT_FIELD, CLT_SHINGLE};
private:
         TServiceObject       &GetServiceObject()     { return dynamic_cast<TServiceObject&>(srvcobj);                                                 }
         TLogsGroup           *GetLogsGroup()         { return (TLogsGroup *)srvcobj.GetLogsGroup();          }
         TKConfig             *GetConfigObject()      { return srvcobj.GetConfigObject();                     }
         TGeneralObject       *GetGeneralObject()     { return (TGeneralObject *)srvcobj.GetGeneralObject();  }

         void     Midnight(const TString &id, TReqParams *m_ReqParams) override;
         void     Shutdown(const TString &id, TReqParams *m_ReqParams) override;
         void     Console(const TString &id, TReqParams *m_ReqParams) override;
         void     ExtConsole(const TString &id, TReqParams *m_ReqParams) override;

         bool     ActionWOParse(const TString &Ident, TRequestDopData &data, const TString &InRequest, const TString &NumbRequest, const TString &request_source, int thread_index) override;
         bool     ActionParse(const TString &Ident, TRequestDopData &data, TReqParams *m_ReqParams, const TString &NumbRequest, const TString &requrl, int thread_index) override;

         void     ConsoleA(const TString &id, TReqParams *m_ReqParams, bool short_view);

         void     AskRulesReload(const TString &id);
         void     DoRulesReload(const TString &id);

         void     ViewStorageStatistikFull(TReqParams *m_ReqParams, const TString &NumbRequest);
         void     StorageInfo(TReqParams *m_ReqParams, const TString &NumbRequest);
         void     ViewUIDStorage(TReqParams *m_ReqParams, const TString &NumbRequest);
         void     ViewAllDriversByIndex();

         void     ViewRequestLimit();
         void     ViewStorStat();

         void     CorrectLogin(const TString &id, TReqParams *m_ReqParams);

         void     CorrectLongIPStat(const TString &id, TReqParams *m_ReqParams);
         void     CorrectLongFieldsStat(const TString &ident, const TString &id, TReqParams *m_ReqParams);
         void     CorrectLongFieldsStatRobot(const TString &ident, const TString &id, TReqParams *m_ReqParams);
         void     CorrectLongShingleStat(const TString &id, TReqParams *m_ReqParams);
         void     CorrectLongStat(TCorrectLongstatType clt, const TString &ident, const TString &id, TReqParams *m_ReqParams);
         void     CorrectLongStatRobot(TCorrectLongstatType clt, const TString &ident, const TString &id, TReqParams *m_ReqParams);

         void     RslvIPFromCache(const TString &id, TReqParams *m_ReqParams);
         void     GetUDNSServices(const TString &id, TReqParams *m_ReqParams);

         void     ClearRCPT(const TString &id, TReqParams *m_ReqParams);
         void     WriteReceipHash(const TString &id, TReqParams *m_ReqParams);

         void     TraccertStat(const TString &id);

         void     ViewPDDStat();
         void     ViewPDDHost(const TString &id, TReqParams *m_ReqParams);
         void     ViewResolvStat();
         void     ReloadPDDProperties();
         void     TestPDDInfo(const TString &id, TReqParams *m_ReqParams);

         void     ViewBBoxStat();
         void     ViewBBoxHost(const TString &id, TReqParams *m_ReqParams);
         void     ReloadBBoxProperties();
         void     TestBBoxInfo(const TString &id, TReqParams *m_ReqParams);

         void     TestGetForFrodo(const TString &id, TReqParams *m_ReqParams);
         void     TestGetForFrodo2(const TString &id, TReqParams *m_ReqParams);
         void     TestMLRcvData(const TString &id, TReqParams *m_ReqParams);
         void     TestClustRcvData(const TString &id, TReqParams *m_ReqParams);

         void     AddAllowUser(const TString &id, TReqParams *m_ReqParams);
         void     GetAllowUser(const TString &id, TReqParams *m_ReqParams);
         void     RemoveAllowUser(const TString &id, TReqParams *m_ReqParams);

         bool     IsMinorRequest(const TString &Numbrequest);
         void     LoginRCPT(int thread_index, TReqParams *m_ReqParams, const TString &NumbRequest, const TString &requrl);
         void     FrodoOboronaCheck(int thread_index, TReqParams *m_ReqParams, const TString &NumbRequest, const TString &requrl, TMakeRqstDelays *work_delays);

         void     AskPushToStorage(const TString &id);
         void     DoPushToStorage(const TString &id); //push data from file to storage

         TString  HTTP_200_OK_PlainExt(float rating, ui8 hash_one, ui64 hash_two);
         void     ShowWeight(const TString &id, TReqParams *m_ReqParams);
         void     AuthPhone(const TString &id, TReqParams *m_ReqParams);

         void     Status(const TString& id, TReqParams* m_ReqParams);
public:
         TMakeRequest(TServiceObjectBase& srvcobjA, void *serverA);
         ~TMakeRequest() override;

};

//*******************************************************************************************************************************************

