#include "tpackets.h"

//******************************************************************************
//                                  TPacket
//******************************************************************************

TPacket::TPacket(TString loginA, TString inameA, TString fnameA, TPackHint passw_hintA, TPackHint quest_hintA, bool dop, bool compare_loginnames, ui32 hintqid, TString phonenumber, TString email, TString lang, ui8 req_typeA)
{
   memset(&data, 0, sizeof(TPacketStruct));

   if (strpbrk(loginA.c_str(), "0123456789") != NULL)
      data.login_digits = true;
   if (strstr(loginA.c_str(), "-") != NULL)
      data.login_defice = true;
   if (strstr(loginA.c_str(), " ") != NULL)
      data.login_probel = true;
   if (strstr(loginA.c_str(), "@") != NULL)
      data.login_sobaka = true;
   if (dop)
   {
      if (GetConstanantsSerialCountEng(loginA) >= 2)
         data.login_great_two_constan = true;
   }

   if (strpbrk(inameA.c_str(), "0123456789") != NULL)
      data.iname_digits = true;
   if (strstr(inameA.c_str(), "-") != NULL)
      data.iname_defice = true;
   if (strstr(inameA.c_str(), " ") != NULL)
      data.iname_probel = true;
   if (GetOnlySymbols1251(inameA, lang).size() > 1)
      data.iname_greate_one_symbol = true;

   if (strpbrk(fnameA.c_str(), "0123456789") != NULL)
      data.fname_digits = true;
   if (strstr(fnameA.c_str(), "-") != NULL)
      data.fname_defice = true;
   if (strstr(fnameA.c_str(), " ") != NULL)
      data.fname_probel = true;
   if (GetOnlySymbols1251(fnameA, lang).size() > 1)
      data.fname_greate_one_symbol = true;

   data.iname_type = GetTypeName1251(inameA, lang);
   data.fname_type = GetTypeName1251(fnameA, lang);

   data.passw_hint = passw_hintA;
   data.quest_hint = quest_hintA;

   data.compare_loginnames = compare_loginnames;

   data.hintqid = hintqid;
   if (!phonenumber.empty())
      data.est_phonenumber = true;
   if (!email.empty())
      data.est_email = true;

   data.req_type = req_typeA;
}

bool TPacket::operator==(const TPacket &value) const
{
   bool  res = false;

   if ((data.login_digits            == value.data.login_digits)            &&
       (data.login_defice            == value.data.login_defice)            &&
       (data.login_probel            == value.data.login_probel)            &&
       (data.login_sobaka            == value.data.login_sobaka)            &&
       (data.login_great_two_constan == value.data.login_great_two_constan) &&
       (data.iname_digits            == value.data.iname_digits)            &&
       (data.iname_defice            == value.data.iname_defice)            &&
       (data.iname_probel            == value.data.iname_probel)            &&
       (data.iname_greate_one_symbol == value.data.iname_greate_one_symbol) &&
       (data.fname_digits            == value.data.fname_digits)            &&
       (data.fname_defice            == value.data.fname_defice)            &&
       (data.fname_probel            == value.data.fname_probel)            &&
       (data.fname_greate_one_symbol == value.data.fname_greate_one_symbol) &&
       (data.iname_type              == value.data.iname_type)              &&
       (data.fname_type              == value.data.fname_type)              &&
       (data.passw_hint              == value.data.passw_hint)              &&
       (data.quest_hint              == value.data.quest_hint)              &&
       (data.compare_loginnames      == value.data.compare_loginnames)      &&
       (data.hintqid                 == value.data.hintqid)                 &&
       (data.est_phonenumber         == value.data.est_phonenumber)         &&
       (data.est_email               == value.data.est_email)               &&
       (data.req_type                == value.data.req_type)

       )

       res = true;


   return res;
}

TString TPacket::GetDecodeData(bool dop)
{
   TString res = "";

   res = res + BoolToStroka(data.login_digits) + " ";
   res = res + BoolToStroka(data.login_defice) + " ";
   res = res + BoolToStroka(data.login_probel) + " ";
   res = res + BoolToStroka(data.login_sobaka) + " ";
   res = res + BoolToStroka(data.iname_digits) + " ";
   res = res + BoolToStroka(data.iname_defice) + " ";
   res = res + BoolToStroka(data.iname_probel) + " ";
   res = res + BoolToStroka(data.iname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.iname_type) + " ";
   res = res + BoolToStroka(data.fname_digits) + " ";
   res = res + BoolToStroka(data.fname_defice) + " ";
   res = res + BoolToStroka(data.fname_probel) + " ";
   res = res + BoolToStroka(data.fname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.fname_type) + " ";
   res = res + data.passw_hint.GetStr() + " ";
   res = res + data.quest_hint.GetStr() + " ";
   res = res + BoolToStroka(data.compare_loginnames)+ " ";
   res = res + IntToStroka(data.hintqid) + " ";
   res = res + BoolToStroka(data.est_phonenumber) + " ";
   res = res + BoolToStroka(data.est_email) + " ";
   if (dop)
      res = res + " " + BoolToStroka(data.login_great_two_constan) + " ";
   res = res + IntToStroka(data.req_type) + " ";

   return res;
}

TString TPacket::GetDecodeData(bool dop) const
{
   TString res = "";

   res = res + BoolToStroka(data.login_digits) + " ";
   res = res + BoolToStroka(data.login_defice) + " ";
   res = res + BoolToStroka(data.login_probel) + " ";
   res = res + BoolToStroka(data.login_sobaka) + " ";
   res = res + BoolToStroka(data.iname_digits) + " ";
   res = res + BoolToStroka(data.iname_defice) + " ";
   res = res + BoolToStroka(data.iname_probel) + " ";
   res = res + BoolToStroka(data.iname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.iname_type) + " ";
   res = res + BoolToStroka(data.fname_digits) + " ";
   res = res + BoolToStroka(data.fname_defice) + " ";
   res = res + BoolToStroka(data.fname_probel) + " ";
   res = res + BoolToStroka(data.fname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.fname_type) + " ";
   res = res + data.passw_hint.GetStr() + " ";
   res = res + data.quest_hint.GetStr() + " ";
   res = res + BoolToStroka(data.compare_loginnames) + " ";
   res = res + IntToStroka(data.hintqid) + " ";
   res = res + BoolToStroka(data.est_phonenumber) + " ";
   res = res + BoolToStroka(data.est_email) + " ";
   if (dop)
      res = res + " " + BoolToStroka(data.login_great_two_constan) + " ";
   res = res + IntToStroka(data.req_type) + " ";

   return res;
}

//******************************************************************************
//                               TPacket2
//******************************************************************************

TPacket2::TPacket2(TString loginA, TString inameA, TString fnameA, TString emailA, TString nicknameA, ui32 regcountfromipA, bool cmp_iname3, bool cmp_fname3, TString lang, ui8 req_typeA)
{
   memset(&data, 0, sizeof(TPacketStruct2));
   if (nicknameA.size() > 0)
      data.est_nickname = true;
   if (emailA.size() > 0)
      data.est_email = true;

   if (strstr(loginA.c_str(), "@") != NULL)
      data.login_sobaka = true;
   data.login_otn_digits_to_size = GetOtnGigitsToSizeEng(loginA);
   data.login_cmpinames = cmp_iname3;
   data.login_cmpfnames = cmp_fname3;

   if (GetDigitsLoginCountEng(inameA) > 0)
      data.iname_digits = true;
   data.iname_othersymb = GetOtherSymbolsEng(inameA);
   if (GetOnlySymbols1251(inameA, lang).size() > 1)
      data.iname_greate_one_symbol = true;
   data.iname_type_ext = GetTypeExt(inameA, lang);

   if (GetDigitsLoginCountEng(fnameA) > 0)
      data.fname_digits = true;
   data.fname_othersymb = GetOtherSymbolsEng(fnameA);
   if (GetOnlySymbols1251(fnameA, lang).size() > 1)
      data.fname_greate_one_symbol = true;
   data.fname_type_ext = GetTypeExt(fnameA, lang);

   if (inameA == fnameA)
      data.dop_cmpifname = true;
   if ((inameA == fnameA) && (inameA == loginA))
      data.dop_cmpifnamelogin = true;
   CompareTranslit(inameA, loginA, 5, data.dop_cmp5inamelogin, lang);
   CompareTranslit(fnameA, loginA, 5, data.dop_cmp5fnamelogin, lang);
   if (regcountfromipA <= 3)
      data.dop_countfromip = 0;
   else if ((regcountfromipA > 3) && (regcountfromipA < 300))
      data.dop_countfromip = 1;
   else
      data.dop_countfromip = 2;
   data.req_type = req_typeA;
}

bool TPacket2::operator==(const TPacket2 &value) const
{
   bool res = false;

   if ((data.est_nickname             == value.data.est_nickname)             &&
       (data.est_email                == value.data.est_email)                &&
       (data.login_sobaka             == value.data.login_sobaka)             &&
       (data.login_otn_digits_to_size == value.data.login_otn_digits_to_size) &&
       (data.login_cmpinames          == value.data.login_cmpinames)          &&
       (data.login_cmpfnames          == value.data.login_cmpfnames)          &&
       (data.iname_digits             == value.data.iname_digits)             &&
       (data.iname_othersymb          == value.data.iname_othersymb)          &&
       (data.iname_greate_one_symbol  == value.data.iname_greate_one_symbol)  &&
       (data.iname_type_ext           == value.data.iname_type_ext)           &&
       (data.fname_digits             == value.data.fname_digits)             &&
       (data.fname_othersymb          == value.data.fname_othersymb)          &&
       (data.fname_greate_one_symbol  == value.data.fname_greate_one_symbol)  &&
       (data.fname_type_ext           == value.data.fname_type_ext)           &&
       (data.dop_cmpifname            == value.data.dop_cmpifname)            &&
       (data.dop_cmpifnamelogin       == value.data.dop_cmpifnamelogin)       &&
       (data.dop_cmp5inamelogin       == value.data.dop_cmp5inamelogin)       &&
       (data.dop_cmp5fnamelogin       == value.data.dop_cmp5fnamelogin)       &&
       (data.dop_countfromip          == value.data.dop_countfromip)          &&
       (data.req_type                 == value.data.req_type)
      )
      res = true;

   return res;
}

TString TPacket2::GetDecodeData(bool /*dop*/) const
{
   TString res = "";

   res = res + BoolToStroka(data.est_nickname) + " ";
   res = res + BoolToStroka(data.est_email) + " ";
   res = res + BoolToStroka(data.login_sobaka) + " ";
   res = res + IntToStroka(data.login_otn_digits_to_size) + " ";
   res = res + BoolToStroka(data.login_cmpinames) + " ";
   res = res + BoolToStroka(data.login_cmpfnames) + " ";
   res = res + BoolToStroka(data.iname_digits) + " ";
   res = res + BoolToStroka(data.iname_othersymb) + " ";
   res = res + BoolToStroka(data.iname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.iname_type_ext) + " ";
   res = res + BoolToStroka(data.fname_digits) + " ";
   res = res + BoolToStroka(data.fname_othersymb) + " ";
   res = res + BoolToStroka(data.fname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.fname_type_ext) + " ";
   res = res + BoolToStroka(data.dop_cmpifname) + " ";
   res = res + BoolToStroka(data.dop_cmpifnamelogin) + " ";
   res = res + BoolToStroka(data.dop_cmp5inamelogin) + " ";
   res = res + BoolToStroka(data.dop_cmp5fnamelogin) + " ";
   res = res + IntToStroka(data.dop_countfromip) + " ";
   res = res + IntToStroka(data.req_type) + " ";

   return res;
}

//******************************************************************************
//                               TPacket3
//******************************************************************************

TPacket3::TPacket3(TString loginA, TString emailA, TString phoneA, TString fromA, ui32 ccnt, ui32 lchk, ui32 st1t, ui32 st2t, ui32 yuid, ui32 ipcount2day, TString /*lang*/, ui8 req_typeA)
{
   memset(&data, 0, sizeof(TPacketStruct3));

   if (emailA.size() > 0)
      data.est_email = true;
   if (phoneA.size() > 0)
      data.est_phone = true;
   if (strstr(loginA.c_str(), "@") != NULL)
      data.login_sobaka = true;

   if (fromA.empty())
      data.from = 0;
   else if (fromA == "mail")
      data.from = 1;
   else if (fromA == "narod")
      data.from = 2;
   else
      data.from = 3;

   if (ccnt == 0)
      data.capt = 0;
   else if ((ccnt >= 1) && (ccnt <= 5))
      data.capt = 1;
   else if (ccnt >= 6)
      data.capt = 2;

   if (lchk == 1000)
      data.lchk = 0;
   else if ((lchk >= 1) && (lchk < 10))
      data.lchk = 1;
   else if ((lchk >= 10) && (lchk < 60))
      data.lchk = 2;
   else if (lchk >= 60)
      data.lchk = 3;

   if (st1t == 1000)
      data.stpt1 = 0;
   else if ((st1t >= 1) && (st1t <= 5))
      data.stpt1 = 1;
   else if ((st1t >= 6) && (st1t <= 60))
      data.stpt1 = 2;
   else if ((st1t >= 61) && (st1t < 120))
      data.stpt1 = 3;
   else if ( ((st1t >= 120) && (st1t <= 1999)) || ((st1t >= 2001) && (st1t <= 9999)) )
      data.stpt1 = 4;
   else if (st1t == 2000)
      data.stpt1 = 5;
   else if (st1t >= 10000)
      data.stpt1 = 6;

   if (st2t == 1000)
      data.stpt2 = 0;
   else if ((st2t >= 1) && (st2t <= 5))
      data.stpt2 = 1;
   else if ((st2t >= 6) && (st2t <= 60))
      data.stpt2 = 2;
   else if ((st2t >= 61) && (st2t < 120))
      data.stpt2 = 3;
   else if ( ((st2t >= 120) && (st2t <= 1999)) || ((st2t >= 2001) && (st2t <= 9999)) )
      data.stpt2 = 4;
   else if (st2t == 2000)
      data.stpt2 = 5;
   else if (st2t >= 10000)
      data.stpt2 = 6;

   if ((yuid >= 0) && (yuid < 100))
      data.yuid = 0;
   else if ((yuid >= 100) && (yuid <= 999))
      data.yuid = 1;
   else if (yuid >= 1000)
      data.yuid = 2;

   if ((ipcount2day >= 0) && (ipcount2day <= 3))
      data.ipcount2day = 0;
   else if ((ipcount2day > 3) && (ipcount2day < 10))
      data.ipcount2day = 1;
   else if ((ipcount2day >= 10) && (ipcount2day < 100))
      data.ipcount2day = 2;
   else if (ipcount2day >= 100)
      data.ipcount2day = 3;

   data.req_type = req_typeA;
}

bool TPacket3::operator==(const TPacket3 &value) const
{
   bool res = false;

   if ((data.est_email    == value.data.est_email)    &&
       (data.est_phone    == value.data.est_phone)    &&
       (data.login_sobaka == value.data.login_sobaka) &&
       (data.from         == value.data.from)         &&
       (data.capt         == value.data.capt)         &&
       (data.lchk         == value.data.lchk)         &&
       (data.stpt1        == value.data.stpt1)        &&
       (data.stpt2        == value.data.stpt2)        &&
       (data.yuid         == value.data.yuid)         &&
       (data.ipcount2day  == value.data.ipcount2day)  &&
       (data.req_type     == value.data.req_type)
      )
      res = true;

   return res;
}

TString TPacket3::GetDecodeData()
{
   TString res = "";

   res = res + BoolToStroka(data.est_email) + " ";
   res = res + BoolToStroka(data.est_phone) + " ";
   res = res + BoolToStroka(data.login_sobaka) + " ";
   res = res + IntToStroka(data.from) + " ";
   res = res + IntToStroka(data.capt) + " ";
   res = res + IntToStroka(data.lchk) + " ";
   res = res + IntToStroka(data.stpt1) + " ";
   res = res + IntToStroka(data.stpt2) + " ";
   res = res + IntToStroka(data.yuid) + " ";
   res = res + IntToStroka(data.ipcount2day) + " ";
   res = res + IntToStroka(data.req_type) + " ";

   return res;
}

TString TPacket3::GetDecodeData() const
{
   TString res = "";

   res = res + BoolToStroka(data.est_email) + " ";
   res = res + BoolToStroka(data.est_phone) + " ";
   res = res + BoolToStroka(data.login_sobaka) + " ";
   res = res + IntToStroka(data.from) + " ";
   res = res + IntToStroka(data.capt) + " ";
   res = res + IntToStroka(data.lchk) + " ";
   res = res + IntToStroka(data.stpt1) + " ";
   res = res + IntToStroka(data.stpt2) + " ";
   res = res + IntToStroka(data.yuid) + " ";
   res = res + IntToStroka(data.ipcount2day) + " ";
   res = res + IntToStroka(data.req_type) + " ";

   return res;
}

//******************************************************************************
//                               TPacket4
//******************************************************************************

TPacket4::TPacket4(TString loginA, TString emailA, TString phoneA, TString fromA, ui32 ccnt, ui32 lchk, ui32 st1t, ui32 st2t, ui32 yuid, ui32 ipcount2day, TString inameA, TString fnameA, bool compare_loginnames, TString lang, ui8 req_typeA)
{
   memset(&data, 0, sizeof(TPacketStruct4));

   if (emailA.size() > 0)
      data.est_email = true;
   if (phoneA.size() > 0)
      data.est_phone = true;
   if (strstr(loginA.c_str(), "@") != NULL)
      data.login_sobaka = true;

   if (fromA.empty())
      data.from = 0;
   else if (fromA == "mail")
      data.from = 1;
   else if (fromA == "narod")
      data.from = 2;
   else
      data.from = 3;

   if (ccnt == 0)
      data.capt = 0;
   else if ((ccnt >= 1) && (ccnt <= 5))
      data.capt = 1;
   else if (ccnt >= 6)
      data.capt = 2;

   if (lchk == 1000)
      data.lchk = 0;
   else if ((lchk >= 1) && (lchk < 10))
      data.lchk = 1;
   else if ((lchk >= 10) && (lchk < 60))
      data.lchk = 2;
   else if (lchk >= 60)
      data.lchk = 3;

   if (st1t == 1000)
      data.stpt1 = 0;
   else if ((st1t >= 1) && (st1t <= 5))
      data.stpt1 = 1;
   else if ((st1t >= 6) && (st1t <= 60))
      data.stpt1 = 2;
   else if ((st1t >= 61) && (st1t < 120))
      data.stpt1 = 3;
   else if ( ((st1t >= 120) && (st1t <= 1999)) || ((st1t >= 2001) && (st1t <= 9999)) )
      data.stpt1 = 4;
   else if (st1t == 2000)
      data.stpt1 = 5;
   else if (st1t >= 10000)
      data.stpt1 = 6;

   if (st2t == 1000)
      data.stpt2 = 0;
   else if ((st2t >= 1) && (st2t <= 5))
      data.stpt2 = 1;
   else if ((st2t >= 6) && (st2t <= 60))
      data.stpt2 = 2;
   else if ((st2t >= 61) && (st2t < 120))
      data.stpt2 = 3;
   else if ( ((st2t >= 120) && (st2t <= 1999)) || ((st2t >= 2001) && (st2t <= 9999)) )
      data.stpt2 = 4;
   else if (st2t == 2000)
      data.stpt2 = 5;
   else if (st2t >= 10000)
      data.stpt2 = 6;

   if ((yuid >= 0) && (yuid < 100))
      data.yuid = 0;
   else if ((yuid >= 100) && (yuid <= 999))
      data.yuid = 1;
   else if (yuid >= 1000)
      data.yuid = 2;

   if ((ipcount2day >= 0) && (ipcount2day <= 3))
      data.ipcount2day = 0;
   else if ((ipcount2day > 3) && (ipcount2day < 10))
      data.ipcount2day = 1;
   else if ((ipcount2day >= 10) && (ipcount2day < 100))
      data.ipcount2day = 2;
   else if (ipcount2day >= 100)
      data.ipcount2day = 3;

   if (strpbrk(loginA.c_str(), "0123456789") != NULL)
      data.login_digits = true;
   if (strstr(loginA.c_str(), "-") != NULL)
      data.login_defice = true;

   if (strpbrk(inameA.c_str(), "0123456789") != NULL)
      data.iname_digits = true;
   if (strstr(inameA.c_str(), "-") != NULL)
      data.iname_defice = true;
   if (strstr(inameA.c_str(), " ") != NULL)
      data.iname_probel = true;
   if (GetOnlySymbols1251(inameA, lang).size() > 1)
      data.iname_greate_one_symbol = true;
   data.iname_type = GetTypeName1251(inameA, lang);

   if (strpbrk(fnameA.c_str(), "0123456789") != NULL)
      data.fname_digits = true;
   if (strstr(fnameA.c_str(), "-") != NULL)
      data.fname_defice = true;
   if (strstr(fnameA.c_str(), " ") != NULL)
      data.fname_probel = true;
   if (GetOnlySymbols1251(fnameA, lang).size() > 1)
      data.fname_greate_one_symbol = true;
   data.fname_type = GetTypeName1251(fnameA, lang);

   data.compare_loginnames = compare_loginnames;

   data.req_type = req_typeA;
}

bool TPacket4::operator==(const TPacket4 &value) const
{
   bool res = false;

   if ((data.est_email                == value.data.est_email)     &&
       (data.est_phone                == value.data.est_phone)     &&
       (data.login_sobaka             == value.data.login_sobaka)  &&
       (data.from                     == value.data.from)          &&
       (data.capt                     == value.data.capt)          &&
       (data.lchk                     == value.data.lchk)          &&
       (data.stpt1                    == value.data.stpt1)         &&
       (data.stpt2                    == value.data.stpt2)         &&
       (data.yuid                     == value.data.yuid)          &&
       (data.ipcount2day              == value.data.ipcount2day)   &&
       (data.login_digits             == value.data.login_digits)  &&
       (data.login_defice             == value.data.login_defice)  &&
       (data.iname_digits             == value.data.iname_digits)  &&
       (data.iname_defice             == value.data.iname_defice)  &&
       (data.iname_probel             == value.data.iname_probel)  &&
       (data.iname_greate_one_symbol  == value.data.iname_greate_one_symbol)  &&
       (data.iname_type               == value.data.iname_type)    &&
       (data.fname_digits             == value.data.fname_digits)  &&
       (data.fname_defice             == value.data.fname_defice)  &&
       (data.fname_probel             == value.data.fname_probel)  &&
       (data.fname_greate_one_symbol  == value.data.fname_greate_one_symbol)  &&
       (data.fname_type               == value.data.fname_type)    &&
       (data.compare_loginnames       == value.data.compare_loginnames) &&
       (data.req_type                 == value.data.req_type)
      )
      res = true;

   return res;
}

TString TPacket4::GetDecodeData()
{
   TString res = "";

   res = res + BoolToStroka(data.est_email) + " ";
   res = res + BoolToStroka(data.est_phone) + " ";
   res = res + BoolToStroka(data.login_sobaka) + " ";
   res = res + IntToStroka(data.from) + " ";
   res = res + IntToStroka(data.capt) + " ";
   res = res + IntToStroka(data.lchk) + " ";
   res = res + IntToStroka(data.stpt1) + " ";
   res = res + IntToStroka(data.stpt2) + " ";
   res = res + IntToStroka(data.yuid) + " ";
   res = res + IntToStroka(data.ipcount2day) + " ";
   res = res + BoolToStroka(data.login_digits) + " ";
   res = res + BoolToStroka(data.login_defice) + " ";
   res = res + BoolToStroka(data.iname_digits) + " ";
   res = res + BoolToStroka(data.iname_defice) + " ";
   res = res + BoolToStroka(data.iname_probel) + " ";
   res = res + BoolToStroka(data.iname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.iname_type) + " ";
   res = res + BoolToStroka(data.fname_digits) + " ";
   res = res + BoolToStroka(data.fname_defice) + " ";
   res = res + BoolToStroka(data.fname_probel) + " ";
   res = res + BoolToStroka(data.fname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.fname_type) + " ";
   res = res + BoolToStroka(data.compare_loginnames) + " ";
   res = res + IntToStroka(data.req_type) + " ";

   return res;
}

TString TPacket4::GetDecodeData() const
{
   TString res = "";

   res = res + BoolToStroka(data.est_email) + " ";
   res = res + BoolToStroka(data.est_phone) + " ";
   res = res + BoolToStroka(data.login_sobaka) + " ";
   res = res + IntToStroka(data.from) + " ";
   res = res + IntToStroka(data.capt) + " ";
   res = res + IntToStroka(data.lchk) + " ";
   res = res + IntToStroka(data.stpt1) + " ";
   res = res + IntToStroka(data.stpt2) + " ";
   res = res + IntToStroka(data.yuid) + " ";
   res = res + IntToStroka(data.ipcount2day) + " ";
   res = res + BoolToStroka(data.login_digits) + " ";
   res = res + BoolToStroka(data.login_defice) + " ";
   res = res + BoolToStroka(data.iname_digits) + " ";
   res = res + BoolToStroka(data.iname_defice) + " ";
   res = res + BoolToStroka(data.iname_probel) + " ";
   res = res + BoolToStroka(data.iname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.iname_type) + " ";
   res = res + BoolToStroka(data.fname_digits) + " ";
   res = res + BoolToStroka(data.fname_defice) + " ";
   res = res + BoolToStroka(data.fname_probel) + " ";
   res = res + BoolToStroka(data.fname_greate_one_symbol) + " ";
   res = res + IntToStroka(data.fname_type) + " ";
   res = res + BoolToStroka(data.compare_loginnames) + " ";
   res = res + IntToStroka(data.req_type) + " ";

   return res;
}
