#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "util/generic/hash_set.h"
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "ktypes.h"

//******************************************************************************
//                                  TPacket
//******************************************************************************

struct TPacketStruct
{
   bool      login_digits;               //login: ������� � �� ���� (��\��� - 1\0)
   bool      login_defice;               //login: ������� � �� ������ (��\��� - 1\0)
   bool      login_probel;               //login: ������� � �� ������� (��\��� - 1\0)
   bool      login_great_two_constan;    //login: ������� ������ ���� ��������� (��\��� - 1\0)
   bool      login_sobaka;               //login: ������� @ � ������
   bool      iname_digits;               //iname: ������� � �� ���� (��\��� - 1\0)
   bool      iname_defice;               //iname: ������� � �� ������ (��\��� - 1\0)
   bool      iname_probel;               //iname: ������� � �� ������� (��\��� - 1\0)
   bool      iname_greate_one_symbol;    //iname: ��� �������� ������ ����� ����� (��\��� - 1\0)
   bool      fname_digits;               //fname: ������� � �� ���� (��\��� - 1\0)
   bool      fname_defice;               //fname: ������� � �� ������ (��\��� - 1\0)
   bool      fname_probel;               //fname: ������� � �� ������� (��\��� - 1\0)
   bool      fname_greate_one_symbol;    //fname: ������� �������� ������ ����� ����� (��\��� - 1\0)
   bool      compare_loginnames;         //cmpn:  ���������� ������ � ������/��������
   ui8       iname_type;                 //iname: ��� ����� (0-6);  (0- �� ��������� �� ���� �� ����������� ������)
   ui8       fname_type;                 //fname: ��� ������� (0-6);  (0- �� ��������� �� ���� �� ����������� ������)
   TPackHint passw_hint;            //���� ������
   TPackHint quest_hint;            //���� ������
   ui8       hintqid;                    //����� �������� �������
   bool      est_phonenumber;            //true - ���� �������, false - ��� ��������
   bool      est_email;                  //true - ���� email, false - ��� email
   ui8       req_type;                   //��� ����������� (�������, ����, ����� ������ � �.�.)
   Y_SAVELOAD_DEFINE(
       login_digits,
       login_defice,
       login_probel,
       login_great_two_constan,
       login_sobaka,
       iname_digits,
       iname_defice,
       iname_probel,
       iname_greate_one_symbol,
       fname_digits,
       fname_defice,
       fname_probel,
       fname_greate_one_symbol,
       compare_loginnames,
       iname_type,
       fname_type,
       passw_hint,
       quest_hint,
       hintqid,
       est_phonenumber,
       est_email,
       req_type
   )
};

class TPacket
{
private:
   TPacketStruct data;
public:
   Y_SAVELOAD_DEFINE(data)
   TPacket(){ memset(&data, 0, sizeof(TPacketStruct)); }
   TPacket(TString loginA, TString inameA, TString fnameA, TPackHint passw_hintA, TPackHint quest_hintA, bool dop, bool compare_loginnames, ui32 hintqid, TString phonenumber, TString email, TString lang, ui8 req_typeA);
   TPacket(char *BUFF, ui32 BuffSize)
   {
      //memset(&data, 0, sizeof(TPacketStruct));

      if (BuffSize >= sizeof(data))
         memcpy(&data, BUFF, sizeof(TPacketStruct));
   }

   bool operator==(const TPacket &value) const;
   operator size_t() const { return sizeof(TPacketStruct); }

   TString GetDecodeData(bool dop);
   TString GetDecodeData(bool dop) const;
   size_t size() const { return sizeof(data); }

   ui64 Shingle() const
   {
      ui64 res = 0;
      char sshingle[32];

      calc_strcrc64((const char *)&data, sizeof(data), sshingle);
      sscanf(sshingle, "%lx", &res);

      return res;
   }
};

//******************************************************************************
//                            TPacket2
//******************************************************************************

struct TPacketStruct2
{
   bool est_nickname;              //���� nickname
   bool est_email;                 //���� email
   bool login_sobaka;              //login: ������� @ � ������
   ui8  login_otn_digits_to_size;  //login: ��������� ����� ���� � ����� ������ (0- 0, 1 - �� 33%, 2 - 33-66%, 3 - 66-100%)
   bool login_cmpinames;           //login: ���������� 3 ���� ����� � ������
   bool login_cmpfnames;           //login: ���������� 3 ���� ������� � ������
   bool iname_digits;              //iname: ������� � �� ���� (��\��� - 1\0)
   bool iname_othersymb;           //iname: ������� ������ �������� ������ ����
   bool iname_greate_one_symbol;   //iname: ��� �������� ������ ����� ����� (��\��� - 1\0)
   ui8  iname_type_ext;            //iname: ��� ����� (���/��� - 1/2);  (����� ����������� �  ��������� �����  ����� ���� 4,5,6 ����� 1; 1,2,3 -  2; � �� ���� �� ��� - 0)
   bool fname_digits;              //fname: ������� � �� ���� (��\��� - 1\0)
   bool fname_othersymb;           //fname: ������� ������ �������� ������ ����
   bool fname_greate_one_symbol;   //fname: ��� �������� ������ ����� ����� (��\��� - 1\0)
   ui8  fname_type_ext;            //fname: ��� ����� (���/��� - 1/2);  (����� ����������� �  ��������� �����  ����� ���� 4,5,6 ����� 1; 1,2,3 -  2; � �� ���� �� ��� - 0)
   bool dop_cmpifname;             //dop:   ���������� ����� � �������
   bool dop_cmpifnamelogin;        //dop:   ���������� �����, ������� � ������
   bool dop_cmp5inamelogin;        //dop:   ���������� 5 ���� ����� � ������
   bool dop_cmp5fnamelogin;        //dop:   ���������� 5 ���� ������� � ������
   ui8  dop_countfromip;           //dop:   ���������� ����������� � IP (<=3 - 0; 3-300 - 1; >=300 - 2)  (��� ��������� �������������� ����, ������ IP � ������� �����)
   ui8  req_type;                  //��� ����������� (�������, ����, ����� ������ � �.�.)
};

class TPacket2
{
private:
   TPacketStruct2 data;
public:
   TPacket2(){ memset(&data, 0, sizeof(TPacketStruct2)); }
   TPacket2(TString loginA, TString inameA, TString fnameA, TString emailA, TString nicknameA, ui32 regcountfromipA, bool cmp_iname3, bool cmp_fname3, TString lang, ui8 req_typeA);

   bool operator==(const TPacket2 &value) const;
   operator size_t() const { return sizeof(TPacketStruct2); }

   TString GetDecodeData(bool dop) const;
   size_t size() const { return sizeof(data); }

   ui64 Shingle() const
   {
      ui64 res = 0;
      char sshingle[32];

      calc_strcrc64((const char *)&data, sizeof(data), sshingle);
      sscanf(sshingle, "%lx", &res);

      return res;
   }
};

//******************************************************************************
//                            TPacket3
//******************************************************************************

struct TPacketStruct3
{
   bool est_email;                 //���� email
   bool est_phone;                 //���� phone
   bool login_sobaka;              //login: ������� @ � ������
   ui8  from;                      //from: (������ - 0; mail - 1; narod - 2; ��������� - 3)
   ui8  capt;                      //ccnt: (0 - 0, 1-5 - 1, >=6 - 2)
   ui8  lchk;                      //lchk: (������/1000 - 0; 1-10 - 1; 10-60 - 2;  >=60 - 3)
   ui8  stpt1;                     //st1t: (������/1000 - 0; 1-5 - 1; 6-60 - 2 ; 61-120 - 3; 120-1999,2001-9999 - 4; 2000 - 5;  >=10000 -6)
   ui8  stpt2;                     //st2t: (������/1000 - 0; 1-5 - 1; 6-60 - 2 ; 61-120 - 3; 120-1999,2001-9999 - 4; 2000 - 5;  >=10000 -6)
   ui8  yuid;                      //yuid: (0-100 - 0; 100-999 - 1; >=1000 - 2)
   ui8  ipcount2day;               //����� ����������� � ip �� ��� ��� (<=3 � 0; 3�10 � 1; 10-100 - 2; >=100 � 3)
   ui8  req_type;                  //��� ����������� (�������, ����, ����� ������ � �.�.)
};

class TPacket3
{
private:
   TPacketStruct3 data;
public:
   TPacket3(){ memset(&data, 0, sizeof(TPacketStruct3)); }
   TPacket3(TString loginA, TString emailA, TString phoneA, TString fromA, ui32 ccnt, ui32 lchk, ui32 st1t, ui32 st2t, ui32 yuid, ui32 ipcount2day, TString lang, ui8 req_typeA);
   TPacket3(char *BUFF, ui32 BuffSize)
   {
      memset(&data, 0, sizeof(TPacketStruct3));
      if (BuffSize >= sizeof(data))
         memcpy(&data, BUFF, sizeof(data));
   }

   bool operator==(const TPacket3 &value) const;
   operator size_t() const { return sizeof(TPacketStruct3); }

   TString GetDecodeData();
   TString GetDecodeData() const;
   size_t size() const { return sizeof(data); }

   ui64 Shingle() const
   {
      ui64 res = 0;
      char sshingle[32];

      calc_strcrc64((const char *)&data, sizeof(data), sshingle);
      sscanf(sshingle, "%lx", &res);

      return res;
   }
};

//******************************************************************************
//                            TPacket4
//******************************************************************************

struct TPacketStruct4
{
   bool est_email;                 //���� email
   bool est_phone;                 //���� phone
   bool login_sobaka;              //login: ������� @ � ������
   ui8  from;                      //from: (������ - 0; mail - 1; narod - 2; ��������� - 3)
   ui8  capt;                      //ccnt: (0 - 0, 1-5 - 1, >=6 - 2)
   ui8  lchk;                      //lchk: (������/1000 - 0; 1-10 - 1; 10-60 - 2;  >=60 - 3)
   ui8  stpt1;                     //st1t: (������/1000 - 0; 1-5 - 1; 6-60 - 2 ; 61-120 - 3; 120-1999,2001-9999 - 4; 2000 - 5;  >=10000 -6)
   ui8  stpt2;                     //st2t: (������/1000 - 0; 1-5 - 1; 6-60 - 2 ; 61-120 - 3; 120-1999,2001-9999 - 4; 2000 - 5;  >=10000 -6)
   ui8  yuid;                      //yuid: (0-100 - 0; 100-999 - 1; >=1000 - 2)
   ui8  ipcount2day;               //����� ����������� � ip �� ��� ��� (<=3 � 0; 3�10 � 1; 10-100 - 2; >=100 � 3)
   bool login_digits;               //login: ������� � �� ���� (��\��� - 1\0)
   bool login_defice;               //login: ������� � �� ������ (��\��� - 1\0)
   bool iname_digits;               //iname: ������� � �� ���� (��\��� - 1\0)
   bool iname_defice;               //iname: ������� � �� ������ (��\��� - 1\0)
   bool iname_probel;               //iname: ������� � �� ������� (��\��� - 1\0)
   bool iname_greate_one_symbol;    //iname: ��� �������� ������ ����� ����� (��\��� - 1\0)
   ui8  iname_type;                 //iname: ��� ����� (0-6);  (0- �� ��������� �� ���� �� ����������� ������)
   bool fname_digits;               //fname: ������� � �� ���� (��\��� - 1\0)
   bool fname_defice;               //fname: ������� � �� ������ (��\��� - 1\0)
   bool fname_probel;               //fname: ������� � �� ������� (��\��� - 1\0)
   bool fname_greate_one_symbol;    //fname: ������� �������� ������ ����� ����� (��\��� - 1\0)
   ui8  fname_type;                 //fname: ��� ������� (0-6);  (0- �� ��������� �� ���� �� ����������� ������)
   bool compare_loginnames;         //cmpn:  ���������� ������ � ������/��������
   ui8  req_type;                   //��� ����������� (�������, ����, ����� ������ � �.�.)
};

class TPacket4
{
private:
   TPacketStruct4 data;
public:
   TPacket4(){ memset(&data, 0, sizeof(TPacketStruct4)); }
   TPacket4(TString loginA, TString emailA, TString phoneA, TString fromA, ui32 ccnt, ui32 lchk, ui32 st1t, ui32 st2t, ui32 yuid, ui32 ipcount2day, TString inameA, TString fnameA, bool compare_loginnames, TString lang, ui8 req_typeA);

   bool operator==(const TPacket4 &value) const;
   operator size_t() const { return sizeof(TPacketStruct4); }

   TString GetDecodeData();
   TString GetDecodeData() const;
   size_t size() const { return sizeof(data); }

   ui64 Shingle() const
   {
      ui64 res = 0;
      char sshingle[32];

      calc_strcrc64((const char *)&data, sizeof(data), sshingle);
      sscanf(sshingle, "%lx", &res);

      return res;
   }
};

//******************************************************************************************************************

