#include "tpasswdchangeipstat.h"

//**************************************************************************************************************
//                                      TPasswdChangeItem
//**************************************************************************************************************

TPasswdChangeItem::TPasswdChangeItem(const ui32& time, const TKIPv6& ip) {
    m_time = time;
    m_ip = ip;
}

//**************************************************************************************************************
//                                        TPasswdChange
//**************************************************************************************************************

void TPasswdChange::Lock() {
    m_Mutex.Acquire();
}

void TPasswdChange::UnLock() {
    m_Mutex.Release();
}

TPasswdChangeStat TPasswdChange::AddElement(ui32 currenttime, TKIPv6 ip) {
    TPasswdChangeStat res;
    bool del = false;
    TPasswdChangeListIt it;
    ui32 difftime = 0;
    bool thereip = false;

    Lock();

    m_del_counter++;
    if (m_del_counter >= 10) {
        del = true;
        m_del_counter = 0;
    }

    data.push_back(TPasswdChangeItem(currenttime, ip));
        it = data.begin();
    while (it != data.end()) {
        thereip = false;
        if ((!ip.Undefined()) && ((*it).Ip() == ip))
            thereip = true;

        if (currenttime > (*it).Time()) {
            difftime = currenttime - (*it).Time();
            if (difftime <= 300) {
                res.IncCountRecord300();
                res.IncCountRecord600();
                res.IncCountRecord1200();
                res.IncCountRecord3600();
                if (thereip) {
                    res.IncCountIPRecord300();
                    res.IncCountIPRecord600();
                    res.IncCountIPRecord1200();
                    res.IncCountIPRecord3600();
                }
            } else if (difftime <= 600) {
                res.IncCountRecord600();
                res.IncCountRecord1200();
                res.IncCountRecord3600();
                if (thereip) {
                    res.IncCountIPRecord600();
                    res.IncCountIPRecord1200();
                    res.IncCountIPRecord3600();
                }
            } else if (difftime <= 1200) {
                res.IncCountRecord1200();
                res.IncCountRecord3600();
                if (thereip) {
                    res.IncCountIPRecord1200();
                    res.IncCountIPRecord3600();
                }
            } else if (difftime <= 3600) {
                res.IncCountRecord3600();
                if (thereip)
                    res.IncCountIPRecord3600();

            } else if (del) {
                data.erase(it++);
                continue;
            }
        } else {
            res.IncCountRecord300();
            res.IncCountRecord600();
            res.IncCountRecord1200();
            res.IncCountRecord3600();
            if (thereip) {
                res.IncCountIPRecord300();
                res.IncCountIPRecord600();
                res.IncCountIPRecord1200();
                res.IncCountIPRecord3600();
            }
        }

        ++it;
    }

    UnLock();

    return res;
}

ui32 TPasswdChange::GetSize() {
    size_t res = 0;
    TPasswdChangeListIt it;

    Lock();

    res = data.size();

    UnLock();

    return res;
}

void TPasswdChange::Clear() {
    Lock();

    data.clear();

    UnLock();
}
