#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "util/generic/hash_set.h"
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "ktypes.h"
#include "tpackets.h"
#include "tlogsgroup.h"

//**************************************************************************************************************
//                                      TPasswdChangeItem
//**************************************************************************************************************

class TPasswdChangeItem {
private:
    ui32 m_time{};
    TKIPv6 m_ip;

public:
    Y_SAVELOAD_DEFINE(m_time, m_ip)

    TPasswdChangeItem() = default;
    TPasswdChangeItem(const ui32& time, const TKIPv6& ip);

    ui32 Time() {
        return m_time;
    }
    TKIPv6 Ip() {
        return m_ip;
    }

    [[nodiscard]] size_t size() const {
        return (sizeof(m_time) + sizeof(m_ip));
    }
};

//**************************************************************************************************************
//                                        TPasswdChange
//**************************************************************************************************************

struct TPasswdChangeStat {
    ui32 count_record300{};
    ui32 count_record600{};
    ui32 count_record1200{};
    ui32 count_record3600{};
    ui32 count_ip_record300{};
    ui32 count_ip_record600{};
    ui32 count_ip_record1200{};
    ui32 count_ip_record3600{};

    TPasswdChangeStat() = default;

    void IncCountRecord300() {
        count_record300 = IncMax32(count_record300, 1);
    }
    void IncCountRecord600() {
        count_record600 = IncMax32(count_record600, 1);
    }
    void IncCountRecord1200() {
        count_record1200 = IncMax32(count_record1200, 1);
    }
    void IncCountRecord3600() {
        count_record3600 = IncMax32(count_record3600, 1);
    }
    void IncCountIPRecord300() {
        count_ip_record300 = IncMax32(count_ip_record300, 1);
    }
    void IncCountIPRecord600() {
        count_ip_record600 = IncMax32(count_ip_record600, 1);
    }
    void IncCountIPRecord1200() {
        count_ip_record1200 = IncMax32(count_ip_record1200, 1);
    }
    void IncCountIPRecord3600() {
        count_ip_record3600 = IncMax32(count_ip_record3600, 1);
    }
};

typedef std::list<TPasswdChangeItem> TPasswdChangeList;
typedef TPasswdChangeList::iterator TPasswdChangeListIt;

class TPasswdChange {
private:
    TPasswdChangeList data;
    TMutex m_Mutex;
    ui32 m_del_counter{};

    void Lock();
    void UnLock();

public:
    Y_SAVELOAD_DEFINE(data)
    TPasswdChangeStat AddElement(ui32 currenttime, TKIPv6 ip);
    ui32 GetSize();
    void Clear();
};

//************************************************************************************************************
