#include "tpushdatatobasa.h"
#include "tgeneralobject.h"

namespace pushbs
{

//***************************************************************************************************************************
//                                                 TPushDataToBasa
//***************************************************************************************************************************

void DRCMThreadProc(void* par)
{
    bool            exit_pr = false;
    TPushDataToBasa *ss     = (TPushDataToBasa *)par;

    if (ss != NULL)
    {
      int threadnumber = ss->IncrementNumberThread();

      //printf("sth=%d\n", threadnumber);
      while( !ss->QueueThreadShouldStop() )
      {
         exit_pr = ss->ActionFunction(threadnumber);
         if (exit_pr)
            break;

      }

      ss->DecrementNumberThread();
    }
}

TPushDataToBasa::TPushDataToBasa()
{
   for (size_t i = 0; i < MAX_THREAD_WORK; i++)
      m_QueueThread[i] = NULL;
   use_threadcount         = 0;
   run_scan_thread         = false;
   m_StopQueueThread       = false;
   m_thread_count          = 1;
   m_handle                = NULL;
   m_general_obj_p         = NULL;
   LogsGroup               = NULL;
   m_all_readrecord        = 0;
   m_ip_count              = 0;
   m_iname_count           = 0;
   m_fname_count           = 0;
   m_ifname_count          = 0;
   m_phone_count           = 0;
   m_unknown_count         = 0;
   m_print_treshold        = PRINT_TRESHOLD;
}

TPushDataToBasa::~TPushDataToBasa()
{
   if (run_scan_thread)
   {
      StopQueueThread();
      while(!QueueThreadStopped())
         usleep(5000);

      for (size_t i = 0; i < MAX_THREAD_WORK; i++)
      {
         if (m_QueueThread[i] != NULL)
         {
            delete m_QueueThread[i];
            m_QueueThread[i] = NULL;
         }
      }
   }

   if (m_handle != NULL)
   {
      fclose(m_handle);
      m_handle = NULL;
   }
}

bool TPushDataToBasa::InitBase(void *general_obj_p, TLogsGroup *LogsGroupA, ui32 thread_count, const TString &dump_filename, ui32 print_treshold)
{
   bool res = true;

   m_general_obj_p   = general_obj_p;

   LogsGroup         = LogsGroupA;
   m_print_treshold  = print_treshold;

   m_all_readrecord   = 0;
   m_ip_count         = 0;
   m_iname_count      = 0;
   m_fname_count      = 0;
   m_ifname_count     = 0;
   m_phone_count      = 0;
   m_unknown_count    = 0;

   m_thread_count = thread_count;
   if (m_thread_count < 1)
      m_thread_count = 1;
   if (m_thread_count >= MAX_THREAD_WORK)
      m_thread_count = MAX_THREAD_WORK;

   m_dump_filename = dump_filename;
   if (!m_dump_filename.empty())
      m_handle = fopen(m_dump_filename.c_str(), "rb");

   StartQueueThread();

   return res;
}

bool TPushDataToBasa::Init(void *general_obj_p, TLogsGroup *LogsGroupA, TKConfig *configobjA)
{
   bool     res            = false;
   ui32     thread_count   = DEFAULT_THREAD_WORK;
   TString   dump_filename  = "";
   ui32     print_treshold = 0;

   if (configobjA != NULL)
   {
      thread_count   = configobjA->ReadInteger("push_data_stor", "thread_count", DEFAULT_THREAD_WORK);
      dump_filename  = configobjA->ReadStroka("push_data_stor", "filename", "");
      print_treshold = configobjA->ReadInteger("push_data_stor", "print_treshold", 100000);
   }

   res = InitBase(general_obj_p, LogsGroupA, thread_count, dump_filename, print_treshold);

   return res;
}

void TPushDataToBasa::StartQueueThread()
{
    m_QueueMutex.Acquire();

    m_StopQueueThread = false;

    for (size_t i = 0; i < m_thread_count; i++)
    {
       m_QueueThread[i] = new TThread((TThread::TThreadProc)&DRCMThreadProc, this);
       m_QueueThread[i]->Start();
    }
    run_scan_thread = true;

    m_QueueMutex.Release();

}

int TPushDataToBasa::IncrementNumberThread()
{
   int res = 0;

   m_QueueMutex.Acquire();

   use_threadcount++;
   res = use_threadcount;

   m_QueueMutex.Release();

   return res;
}

void TPushDataToBasa::DecrementNumberThread()
{
   m_QueueMutex.Acquire();

   if (use_threadcount > 0)
      use_threadcount--;

   m_QueueMutex.Release();
}

void TPushDataToBasa::StopQueueThread()
{
    m_QueueMutex.Acquire();
    m_StopQueueThread = true;
    m_QueueMutex.Release();

}

bool TPushDataToBasa::QueueThreadStopped()
{
    bool res = false;

    if (use_threadcount == 0)
       res = true;

    return res;
}

bool TPushDataToBasa::ActionFunction(int /*threadnumber*/)
{
   bool     res            = false;
   bool     needstop       = false;
   char     tbuff[4096];
   size_t   len            = 0;
   TString   id_ident       = "\"_id\"=\"";
   TString   lastday_ident  = "\"last_day\"=\"";
   TString   ham_ident      = "\"ham\"=\"";
   TString   spam85_ident   = "\"spam85\"=\"";
   TString   spam100_ident  = "\"spam100\"=\"";
   size_t   count          = 0;
   TString   datatype_s     = "";
   TString   id_s           = "";
   TString   lastday_s      = "";
   TString   ham_s          = "";
   TString   spam_s         = "";
   TString   malic_s        = "";
   const char *p1          = NULL;
   const char *p2          = NULL;
   frodo_st::TStorageDataType reqtype = frodo_st::SDT_END;
   kday_t                     lastday = kday_t((unsigned long)0);
   ui64                       high_part = 0, low_part = 0;
   TKIPv6                     id    = TKIPv6();
   ui32                       ham   = 0;
   ui32                       spam  = 0;
   ui32                       malic = 0;
   ui32                       tmpv  = 0;
   TString                     source = "";
   TString   err_text       = "";
   bool     stor_err       = false;

   TGeneralObject *genobj = ((TGeneralObject *)m_general_obj_p);

   if (m_handle != NULL)
   {
      if (fgets(tbuff, sizeof(tbuff), m_handle))
      {
         //printf("%s\n", tbuff);
         len = strlen(tbuff);
         if (len > 0)
         {

            m_StatMutex.Acquire();

            m_all_readrecord = IncMax32(m_all_readrecord, 1);
            if (m_print_treshold == 0)
               m_print_treshold = PRINT_TRESHOLD;
            if ((m_all_readrecord % m_print_treshold) == 0)
            {
               if ( (LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL) )
               {
                  LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "LONGSTAT: read % 8u record!", m_all_readrecord);
                  LogsGroup->GetServerLog()->FFlush();
               }
            }

            m_StatMutex.Release();

            reqtype = frodo_st::SDT_END;
            lastday = kday_t((unsigned long)0);
            high_part = 0, low_part = 0;
            id     = TKIPv6();
            ham    = 0;
            spam   = 0;
            malic  = 0;
            source = "";

            p1 = strstr(tbuff, ",\"");
            if (p1 != NULL)
            {
               count = p1 - tbuff;
               if (count > 0)
               {
                  datatype_s = Trim(TString(tbuff, count));
                  if (!datatype_s.empty())
                  {
                     if (datatype_s == "fnamebasa")
                        reqtype = frodo_st::SDT_FNAME;
                     else if (datatype_s == "inamebasa")
                        reqtype = frodo_st::SDT_INAME;
                     else if (datatype_s == "ifnamebasa")
                        reqtype = frodo_st::SDT_IFNAME;
                     else if (datatype_s == "ipbasa")
                        reqtype = frodo_st::SDT_IPADDRESS;

                     IncrementType(reqtype);

                     //_id
                     p1 = strstr(tbuff, id_ident.c_str());
                     if (p1 != NULL)
                     {
                        p2 = strchr(p1 + id_ident.length(), '\"');
                        if (p2 != NULL)
                        {
                           count = p2 - p1 - id_ident.length();
                           if (count > 0)
                           {
                              id_s = Trim(TString(p1 + id_ident.length(), count));
                              if (id_s.length() == 32)
                              {
                                 id_s.insert(16, " ");
                                 if (sscanf(id_s.c_str(), "%lx %lx", &high_part, &low_part) == 2)
                                 {
                                    id = TKIPv6(high_part, low_part);
                                    if ( (!id.Undefined()) && (reqtype == frodo_st::SDT_IPADDRESS) )
                                       source = id.toStroka();
                                 }
                              }
                           }
                        }
                     }

                     //lastday
                     p1 = strstr(tbuff, lastday_ident.c_str());
                     if (p1 != NULL)
                     {
                        p2 = strchr(p1 + lastday_ident.length(), '\"');
                        if (p2 != NULL)
                        {
                           count = p2 - p1 - lastday_ident.length();
                           if (count > 0)
                           {
                              lastday_s = TString(p1 + lastday_ident.length(), count);
                              if (!lastday_s.empty())
                              {
                                 tmpv = atol(lastday_s.c_str());
                                 lastday = (kday_t)static_cast<const unsigned long>(tmpv);
                              }
                           }
                        }
                     }

                     //ham
                     p1 = strstr(tbuff, ham_ident.c_str());
                     if (p1 != NULL)
                     {
                        p2 = strchr(p1 + ham_ident.length(), '\"');
                        if (p2 != NULL)
                        {
                           count = p2 - p1 - ham_ident.length();
                           if (count > 0)
                           {
                              ham_s = TString(p1 + ham_ident.length(), count);
                              if (!ham_s.empty())
                                 ham = atol(ham_s.c_str());

                           }
                        }
                     }

                     //spam85
                     p1 = strstr(tbuff, spam85_ident.c_str());
                     if (p1 != NULL)
                     {
                        p2 = strchr(p1 + spam85_ident.length(), '\"');
                        if (p2 != NULL)
                        {
                           count = p2 - p1 - spam85_ident.length();
                           if (count > 0)
                           {
                              spam_s = TString(p1 + spam85_ident.length(), count);
                              if (!spam_s.empty())
                                 spam = atol(spam_s.c_str());
                           }
                        }
                     }

                     //spam100
                     p1 = strstr(tbuff, spam100_ident.c_str());
                     if (p1 != NULL)
                     {
                        p2 = strchr(p1 + spam100_ident.length(), '\"');
                        if (p2 != NULL)
                        {
                           count = p2 - p1 - spam100_ident.length();
                           if (count > 0)
                           {
                              malic_s = TString(p1 + spam100_ident.length(), count);
                              if (!malic_s.empty())
                                 malic = atol(malic_s.c_str());
                           }
                        }
                     }


                     if (reqtype == frodo_st::SDT_END)
                        err_text = "bad storage type";
                     else if (id.Undefined())
                        err_text = "id undefined";
                     else
                     {
                        if (genobj != NULL)
                          genobj->CorrectLongStatSet(reqtype, id, source, stor_err, lastday, static_cast<i32>(ham), static_cast<i32>(spam), static_cast<i32>(malic));
                     }

                  }

               }
            }

         }

      } else if (feof(m_handle))
      {
         res = true;

      }

   }

   if (needstop)
      StopQueueThread();

   return res;
}

void TPushDataToBasa::Wait()
{
   sleep(3);
   while(!QueueThreadStopped())
     usleep(5000);
}

TString TPushDataToBasa::GetStat()
{
   TString res = "";

   res += "all="     + IntToStroka(m_all_readrecord) + ", ";
   res += "ip="      + IntToStroka(m_ip_count)       + ", ";
   res += "iname="   + IntToStroka(m_iname_count)    + ", ";
   res += "fname="   + IntToStroka(m_fname_count)    + ", ";
   res += "ifname="  + IntToStroka(m_ifname_count)   + ", ";
   res += "phone="   + IntToStroka(m_phone_count)    + ", ";
   res += "unknown=" + IntToStroka(m_unknown_count);

   return res;
}

void TPushDataToBasa::IncrementType(frodo_st::TStorageDataType reqtype)
{
   switch (reqtype)
   {
   case frodo_st::SDT_IPADDRESS:
                                 m_ip_count = IncMax32(m_ip_count, 1);
                                 break;
   case frodo_st::SDT_INAME:
                                 m_iname_count = IncMax32(m_iname_count, 1);
                                 break;
   case frodo_st::SDT_FNAME:
                                 m_fname_count = IncMax32(m_fname_count, 1);
                                 break;
   case frodo_st::SDT_IFNAME:
                                 m_ifname_count = IncMax32(m_ifname_count, 1);
                                 break;
   case frodo_st::SDT_PHONE:
                                 m_phone_count = IncMax32(m_phone_count, 1);
                                 break;
   default:
                                 m_unknown_count = IncMax32(m_unknown_count, 1);
   };

}

//**************************************************************************************************************************

}
