#pragma once

#include <sys/stat.h>
#include "util/generic/hash.h"
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/system/thread.h"
#include "util/thread/factory.h"
#include <library/cpp/cgiparam/cgiparam.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include "tlogsgroup.h"
#include "tfrodotypes.h"

namespace pushbs
{

//***************************************************************************************************************************
//                                                 TPushDataToBasa
//***************************************************************************************************************************

class TPushDataToBasa
{
public:
         static const ui32    MAX_THREAD_WORK          = 64;
         static const ui32    DEFAULT_THREAD_WORK      = 32;
         static const ui32    PRINT_TRESHOLD           = 100000;
private:
         void                 *m_general_obj_p;
         TLogsGroup           *LogsGroup;
         TThread              *m_QueueThread[MAX_THREAD_WORK];
         TMutex               m_QueueMutex;
         bool                 m_StopQueueThread;
         bool                 run_scan_thread;
         ui32                 m_thread_count;
         TString               m_dump_filename;
         ui32                 m_print_treshold;
         FILE                 *m_handle;

         TMutex               m_StatMutex;
         ui32                 m_all_readrecord;
         ui32                 m_ip_count;
         ui32                 m_iname_count;
         ui32                 m_fname_count;
         ui32                 m_ifname_count;
         ui32                 m_phone_count;
         ui32                 m_unknown_count;

         int                  use_threadcount;
         void                 StartQueueThread();
         bool                 QueueThreadStopped();

public:
         ui32                 GetThreadCount(){ return m_thread_count; }
         void                 StopQueueThread();
         int                  IncrementNumberThread();
         void                 DecrementNumberThread();
         bool                 QueueThreadShouldStop(){ return m_StopQueueThread; }
         bool                 ActionFunction(int threadnumber);
         bool                 InitBase(void *general_obj_p, TLogsGroup *LogsGroupA, ui32 thread_count, const TString &dump_filename, ui32 print_treshold);
         void                 IncrementType(frodo_st::TStorageDataType reqtype);
public:
         TPushDataToBasa();
         ~TPushDataToBasa();

         bool   Init(void *general_obj_p, TLogsGroup *LogsGroupA, TKConfig *configobjA);
         void   Wait();
         TString GetStat();

};

}

//***************************************************************************************************************************

