#include "trcptclass.h"
//#include "sofilter.h"

//*****************************************************************************************
//                              KRCPClass
//*****************************************************************************************

KRCPClass::KRCPClass()
{
   addcount  = 0;
   lostcount = 0;
}

KRCPClass::~KRCPClass()
{
   data.clear();
}

void KRCPClass::AddLogin(const TString &login, const TString &weight, TPassportRequestType passpreqtypeA, const TString &passpreqtype_sA)
{
   if (weight > 0)
   {
      m_Mutex.Acquire();

      if (data.size() < MAXHASHSIZE)
      {
         TRPCHashIt it;
         time_t     t = time(NULL);
         TString     formstr = "";
         ui64       shingle = 0;
         char       sshingle[32];

         //��������� �����
         if (IsChangePass(passpreqtypeA))
            formstr = login + "-changepass";
         else
            formstr = login + "-registration";
         memset(sshingle, 0, sizeof(sshingle));
         calc_strcrc64(formstr.c_str(), formstr.size(), sshingle);
         sscanf(sshingle, "%lx", &shingle);

         if (shingle != 0)
         {
            //��������� ��� � ���
            it = data.find(shingle);
            if (it != data.end())
               (*it).second = TRCPTSData(login, weight, t, passpreqtypeA, passpreqtype_sA, 0);
            else
            {
               data[shingle] = TRCPTSData(login, weight, t, passpreqtypeA, passpreqtype_sA, 0);
               addcount++;
            }
         }
      } else
         lostcount++;

      m_Mutex.Release();
   }
}

KRCPClass::DoubleTString KRCPClass::GetLogins(ui32 count)
{
   KRCPClass::DoubleTString    res;
   size_t                        acount      = 0;
   TRPCHashIt                 it;
   time_t                     totc        = time(NULL);
   TString                     weight      = "";
   TString                     login       = "";
   time_t                     t           = 0;
   TPassportRequestType       type        = TP_UNKNOWN;
   TString                     type_s      = "";
   ui32                       sendcount   = 0;

   res.Clear();

   m_Mutex.Acquire();

   it = data.begin();
   while (it != data.end())
   {
      if (acount > count)
         break;
      if ((totc - (*it).second.t()) > SENDPERIOD)
      {
         t = time(NULL);
         weight = (*it).second.weight();
         login = (*it).second.login();
         type = (*it).second.type();
         type_s = (*it).second.type_s();
         sendcount = (*it).second.sendcount();
         if (IsChangePass(type))
         {
            res.m_answer = res.m_answer + "<change_pass login=\"" + login + "\" weight=\"" + weight + "\" />";
            res.m_log = res.m_log + "<change_pass login=\"" + login + "\" weight=\"" + weight + "\" />*";
         } else
         {
            res.m_answer = res.m_answer + "<spam_user login=\"" + login + "\" weight=\"" + weight + "\" />";
            res.m_log = res.m_log + "<spam_user login=\"" + login + "\" weight=\"" + weight + "\" />*";
         }
         if (sendcount < 0xFFFFFFFF)
            sendcount++;
     (*it).second = TRCPTSData(login, weight, t, type, type_s, sendcount);
         acount++;
      }

      ++it;
 }

   m_Mutex.Release();

   return res;
}

void KRCPClass::RemoveLogin(TString &login, bool changepass)
{
   m_Mutex.Acquire();

   TRPCHashIt it;
   TString     formstr = "";
   ui64       shingle = 0;
   char       sshingle[32];

   //��������� �����
   if (changepass)
      formstr = login + "-changepass";
   else
      formstr = login + "-registration";
   memset(sshingle, 0, sizeof(sshingle));
   calc_strcrc64(formstr.c_str(), formstr.size(), sshingle);
   sscanf(sshingle, "%lx", &shingle);

   if (shingle != 0)
   {
      it = data.find(shingle);
      if (it != data.end())
         data.erase(it);
   }

   m_Mutex.Release();
}

ui32 KRCPClass::HashSize()
{
   ui32 res = 0;

   res = data.size();
   return res;
}

TString KRCPClass::GetStat()
{
   TString res = "";

   m_Mutex.Acquire();

   res = IntToStroka(data.size()) + " / " + I64ToStroka(addcount) + " / " + I64ToStroka(lostcount);

   m_Mutex.Release();

   return res;
}

void KRCPClass::Clear()
{
   m_Mutex.Acquire();

   data.clear();

   m_Mutex.Release();
}

void KRCPClass::Midnight()
{
   m_Mutex.Acquire();

   addcount  = 0;
   lostcount = 0;

   m_Mutex.Release();
}

bool KRCPClass::WriteData(const TString &filename)
{
   bool     res         = false;
   FILE     *handle     = NULL;
   time_t   currenttime = 0;

   if (!filename.empty())
   {
      handle = fopen(filename.c_str(), "a+b");
      if (handle != NULL)
      {
         TRPCHashIt it;
         int        remaintime = 0;

         m_Mutex.Acquire();

         currenttime = time(NULL);

         fprintf(handle, "\n\n******* PRINT REPORT %19s(%10u) *******\n", TimeToStr(currenttime).c_str(), (ui32)currenttime);
         fprintf(handle, "------------------------------------------------------------------------------------------------------------\n");
         fprintf(handle, "                         LOGIN WEIGHT                             TIME     REMAIN            TYPE  SENDCOUNT\n");
         fprintf(handle, "------------------------------------------------------------------------------------------------------------\n");
         it = data.begin();
         while (it != data.end())
         {
            remaintime = SENDPERIOD - (currenttime - (*it).second.t());
            fprintf(handle, "%30s %6s %20s(%10u) %10d %15s %10u\n", (*it).second.login().c_str(), (*it).second.weight().c_str(), TimeToStr((*it).second.t()).c_str(), (ui32)(*it).second.t(), remaintime, TPassportRequestTypeToTString((*it).second.type(), (*it).second.type_s()).c_str(), (*it).second.sendcount());

            ++it;
       }

         m_Mutex.Release();

         fclose(handle);
         res = true;
      }
   }

   return res;
}
