#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "util/generic/hash_set.h"
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "ktypes.h"
#include "tkclasses.h"
#include "tsummarydata.h"
#include "tfrodotypes.h"

//*****************************************************************************************
//                              KRCPClass
//*****************************************************************************************



class KRCPClass {
public:
    struct DoubleTString {
        TString m_answer;
        TString m_log;

        DoubleTString() {
            Clear();
        }

        void Clear() {
            m_answer = "";
            m_log = "";
        }
    };

private:
    static const ui32 MAXHASHSIZE = 25000;
    static const int SENDPERIOD = 60;

    TRPCHash data;
    TMutex m_Mutex;
    ui64 addcount;
    ui64 lostcount;

    TBlockClass receipt; //��������/��������� ���������
public:
    KRCPClass();
    ~KRCPClass();

    void AddLogin(const TString& login, const TString& weight, TPassportRequestType passpreqtypeA, const TString& passpreqtype_sA);
    KRCPClass::DoubleTString GetLogins(ui32 count);
    void RemoveLogin(TString& login, bool changepass);
    ui32 HashSize();
    TString GetStat();
    void Clear();
    void Midnight();
    bool WriteData(const TString& filename);

    void SetReceiptMode(bool enable) {
        receipt.SetBlock(enable);
    }
    bool EnableReceipt() {
        return receipt.GetBlock();
    }
};

//*******************************************************************************************************************
