#pragma once

#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/unnamedsem.h>
#include <list>
#include <mail/so/spamstop/tools/so-common/thashipv6.h>
#include "tlogsgroup.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/sp/sptop.h>
#include <mail/so/spamstop/tools/so-clients/SperrorHolder.h>
#include <mail/so/spamstop/sp/rulesholder.h>

#define KSEMA

//************************************************************************************
//                              TFilterProp
//************************************************************************************

struct TFilterProp
{
   TString dnrules;
   float  score{};
   ui32   element_count{};
   ui32   max_server_queuesize{};

   TFilterProp()
   {
      Clear();
   }

   void Clear()
   {
      dnrules              = "";
      score                = 0;
      element_count        = 0;
      max_server_queuesize = 0;
   }

};

//************************************************************************************
//                            TRenginePoolStat
//************************************************************************************

struct TRenginePoolStat
{
   ui32   filter_count;
   ui32   good_filter_count;
   ui32   bad_filter_count;
   TString rules;
   float  score;
   TString rps_str;
   TString rulescs_str;

   TRenginePoolStat()
   {
      filter_count      = 0;
      good_filter_count = 0;
      bad_filter_count  = 0;
      rules             = "";
      score             = 0;
      rps_str           = "";
      rulescs_str       = "";
   }
};

struct TResetResponce
{
   TString text;
   TString filterres;
   bool   flag_ok{};

   TResetResponce() = default;
};

//************************************************************************************
//                             TRengineElement
//************************************************************************************

class TRengineElement
{
private:
         TSoConfig            m_pSpTop;
         TSpLoggers        SpLoggers;

         THolder<TRengine>         m_hSp;          //rengine object
         TMutex            m_Mutex;
         TLogsGroup        *LogsGroup;
         kipv6::TStringsLists *RulePrintList;
         TString            m_dnRules;
         float             m_Score = 1;
         ui32              m_count;
         time_t            m_lastcalctime;
         float             m_cps;
         int               m_index;
         TString            m_rules_cs;
         time_t            m_loadrules_time;

         void              CalcCPS();
         void              OnlyCalcCPS();
public:
         explicit TRengineElement(int indexA);

         TString        RULEBUFF;

         bool        Init(TLogsGroup *LogsGroupA, const TString &dnRulesA, float ScoreA, kipv6::TStringsLists *RulePrintListA, TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder);
         ui32        PrintActionLog(TLogStatus status, const char *msg, ...);
         TString     Reset(bool &ok, TTrueAtomicSharedPtr<TRulesHolder> pRulesHolder);
         TRengine&   GetFilterHandle(){ return *m_hSp; }

         void        Lock();
         void        UnLock();
         float       GetCPS();
         TString      GetRulesCS(){ return m_rules_cs; }
         time_t      GetLoadRulesTime(){ return m_loadrules_time; }
         TString      GetLoadRulesElapsed()
         {
            TString res = "???";

            if (m_loadrules_time != 0)
            {
               time_t currtime = time(nullptr);
               ui32   diff     = 0;

               if (currtime >= m_loadrules_time)
               {
                  diff = currtime - m_loadrules_time;
                  res = IntToHourMinSec2(diff);
               }
            }

            return res;
         }

         bool        GoodFilter(){ return bool(m_hSp); }
         int         GetIndex(){ return m_index; }
};

//************************************************************************************
//                               TRenginePool
//************************************************************************************

typedef std::list<TRengineElement*>    TRengineElementList;
typedef TRengineElementList::iterator  TRengineElementListIt;

class TRenginePool
{
private:
         TString              m_rules_path;
         TSpLoggers           SpLoggersMain;
         TTrueAtomicSharedPtr<TRulesHolder>         pRulesHolder;  //rules object
         TLogsGroup           *LogsGroup;
         kipv6::TStringsLists *RulePrintList;
         TRengineElementList  m_AllElementList;
         TRengineElementList  m_AccessibleList;
         TMutex               m_Mutex;
         TMutex               m_MutexExit;
         TMutex               m_MutexCalcUsedRengine;
         int                  elementcount;
         bool                 m_exit;
         int                  m_half_elementcount;
         int                  m_quarter_elementcount;
         int                  m_threefourth_elementcount;
         time_t               m_last_calc_usedrengine;
         int                  m_max_usedrengine;
         TString               m_dnRules;
         float                m_Score;
         ui32                 m_good_filter_count;
         ui32                 m_bad_filter_count;
#ifdef KSEMA
         TUnnamedSemaphore    *m_Sema;
#endif
         TCalcRulesCSStat     rules_mon_stat;

         void                 Lock();
         void                 UnLock();
         TString               GetRulesCSList();
public:
         TRenginePool();
         ~TRenginePool();

         bool              Init(TLogsGroup *LogsGroupA, int elementcountA, const TString &dnRulesA, float ScoreA, kipv6::TStringsLists *RulePrintListA);
         TResetResponce    Reset(bool &ok);
         void              ReturnFilter(TRengineElement *elem);
         TRengineElement   *GetFilter();
         void              SetExit();
         ui32              GetAccessibleFilterCount();
         int               CalcUsedRengine();
         int               GetUsedRengine();
         TString            GetCPSList();
         TRenginePoolStat  GetStat();
         int               GetNumberSection(ui32 ip);
         void              Close();
         TCalcRulesCSStat  *GetRulesMonStat(){ return &rules_mon_stat; }
};

//************************************************************************************

