#include <mail/so/spamstop/tools/so-common/color_scheme.h>
#include "trqstlimit.h"

//*******************************************************************************************************************************************
//                                                       TMakeRequestLimit
//*******************************************************************************************************************************************

TMakeRequestLimitItem::TMakeRequestLimitItem() {
    Clear();
    m_last_calc_time = time(NULL);
}

TMakeRequestLimitItem::TMakeRequestLimitItem(ui32 max_limit) {
    Clear();
    m_max_limit = max_limit;
    m_last_calc_time = time(NULL);
}

void TMakeRequestLimitItem::Clear() {
    m_max_limit = 0;
    m_current_value = 0;
    m_max_value = 0;
    m_ok_count = 0;
    m_bad_count = 0;
    m_last_calc_time = 0;
}

void TMakeRequestLimitItem::CalcStat(ui32& count, ui32& badcount, float& avg_ok, float& avg_bad, ui32& max, TDelayTick& currtick) {
    count = 0;
    badcount = 0;
    avg_ok = 0;
    avg_bad = 0;
    max = 0;

    m_mutex.Acquire();

    ui32 currenttime = time(NULL);

    count = m_ok_count;
    badcount = m_bad_count;
    avg_ok = (currenttime > m_last_calc_time) ? static_cast<float>(m_ok_count) / static_cast<float>(currenttime - m_last_calc_time) : 0;
    avg_bad = (currenttime > m_last_calc_time) ? static_cast<float>(m_bad_count) / static_cast<float>(currenttime - m_last_calc_time) : 0;
    max = m_max_value;
    currtick = m_current_tick;

    m_max_value = 0;
    m_ok_count = 0;
    m_bad_count = 0;
    m_last_calc_time = currenttime;
    m_current_tick.Clear();

    m_mutex.Release();
}

bool TMakeRequestLimitItem::AddThread() {
    bool res = false;

    m_mutex.Acquire();

    if (m_current_value < m_max_limit) {
        m_current_value++;
        if (m_current_value > m_max_value)
            m_max_value = m_current_value;
        m_ok_count = IncMax32(m_ok_count, 1);
        res = true;

    } else {
        m_bad_count = IncMax32(m_bad_count, 1);
        res = false;
    }

    m_mutex.Release();

    return res;
}

void TMakeRequestLimitItem::ReturnThread() {
    m_mutex.Acquire();

    if (m_current_value > 0)
        m_current_value--;

    m_mutex.Release();
}

void TMakeRequestLimitItem::AddTick(ui32 tick, bool skeep) {
    m_mutex.Acquire();

    m_current_tick.AddTick(tick, skeep);
    m_today_tick.AddTick(tick, skeep);

    m_mutex.Release();
}

void TMakeRequestLimitItem::AddResStatus(TDelayTick::TSource source, bool empty) {
    m_mutex.Acquire();

    m_current_tick.AddResStatus(source, empty);
    m_today_tick.AddResStatus(source, empty);

    m_mutex.Release();
}

void TMakeRequestLimitItem::Midnight() {
    m_mutex.Acquire();

    m_yesterday_tick = m_today_tick;
    m_today_tick.Clear();

    m_mutex.Release();
}

TMakeRequestLimit::TMakeRequestLimit() {
    all_thread = 0;
    disable = false;
}

TMakeRequestLimit::~TMakeRequestLimit() {
    TMakeRequestLimitItemHashIt it;

    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            delete (*it).second;
            (*it).second = NULL;
        }

        ++it;
    }
}

void TMakeRequestLimit::Init(TKConfig* config, bool disableA) {
    if (config != NULL)
        all_thread = config->ReadInteger("fcgi", "threads", 0);

    disable = disableA;
}

TString TMakeRequestLimit::GetNameByIndex(TMakeRequestLimit::Func type) {
    TString res = "";

    switch (type) {
        case TMakeRequestLimit::CHECK:
            res = "CHECK";
            break;
        case TMakeRequestLimit::RCVRCPT:
            res = "RCVRCPT";
            break;
        case TMakeRequestLimit::INTERFACE:
            res = "INTERFACE";
            break;
        case TMakeRequestLimit::CORRLONGSTAT:
            res = "CORRLONGSTAT";
            break;
        default:
            break;
    };

    return res;
}

TString TMakeRequestLimit::GetNameByIndexShort(TMakeRequestLimit::Func type) {
    TString res = "";

    switch (type) {
        case TMakeRequestLimit::CHECK:
            res = "CHECK";
            break;
        case TMakeRequestLimit::RCVRCPT:
            res = "RCVRCPT";
            break;
        case TMakeRequestLimit::INTERFACE:
            res = "INTERFACE";
            break;
        case TMakeRequestLimit::CORRLONGSTAT:
            res = "CORRLONGSTAT";
            break;
        default:
            break;
    };
    return res;
}

void TMakeRequestLimit::AddItem(TMakeRequestLimit::Func type, ui32 percent_value) {
    TMakeRequestLimitItem* mrli = NULL;

    ui32 cnt_v = 0;
    float cnt = static_cast<float>(all_thread) * static_cast<float>(percent_value) / static_cast<float>(100);
    if ((all_thread > 0) && (cnt > 0) && (cnt < 1))
        cnt_v = 1;
    else
        cnt_v = cnt;

    if (disable)
        cnt_v = all_thread;

    //if (type != INTERFACE) //debug!!!
    //   cnt_v = 0;

    mrli = new TMakeRequestLimitItem(cnt_v);
    if (mrli != NULL)
        data[type] = mrli;
}

TString TMakeRequestLimit::GetWebStatistik() {
    TString text = "";
    TMakeRequestLimitItemHashIt it;

    text += "All input thread: " + IntToStroka(all_thread) + "<br>";
    text += "Disable limit: " + BoolToStroka2(disable) + "<br>";

    text += "<br><table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(color_table_default) + ">";
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'><td width='19%%' rowspan='2'><b>FUNCTION</b></td><td width='11%%' rowspan='2'><b>LIMIT</b></td><td width='70%%' colspan='5'><b>CURRENT COUNTERS</b></td></tr>";
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'><td width='14%%'><b>CURRVALUE (instant value)</b></td><td width='14%%'><b>MAX</b></td><td width='14%%'><b>OK CNT</b></td><td width='14%%'><b>SKEEP CNT</b></td><td width='14%%'><b>CALC TIME</b></td></tr>";
    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            text += "<tr align='right'>";
            text += "<td align='center'>" + GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_max_limit) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_value) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_max_value) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_ok_count) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_bad_count) + "</td>";
            text += "<td>" + TimeToStr((*it).second->m_last_calc_time) + "</td>";
            text += "</tr>";
        }

        ++it;
    }
    text = text + "</table><br>";

    text = text + "<br><i><b>Current tick statistik:</b></i>&nbsp;&nbsp;";
    text += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor='" + TString(color_table_default) + "'>";
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
    text += "<td width='20%%'><b>FUNCTION</b></td>";
    text += "<td width='8%%'><b>SKEEP</b></td>";
    text += "<td width='8%%'><b>0..10 ms</b></td>";
    text += "<td width='8%%'><b>10..20 ms</b></td>";
    text += "<td width='8%%'><b>20..30 ms</b></td>";
    text += "<td width='8%%'><b>30..50 ms</b></td>";
    text += "<td width='8%%'><b>50..100 ms</b></td>";
    text += "<td width='8%%'><b>100..150 ms</b></td>";
    text += "<td width='8%%'><b>150..190 ms</b></td>";
    text += "<td width='8%%'><b>190..500 ms</b></td>";
    text += "<td width='8%%'><b>more 500 ms</b></td>";
    text += "</tr>";
    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            text += "<tr align='right'>";
            text += "<td align='center'>" + GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "</td>";
            text += "<td>" + (*it).second->m_current_tick.SkeepInfo() + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_0_10) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_10_20) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_20_30) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_30_50) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_50_100) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_100_150) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_150_190) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_190_500) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_current_tick.m_more500) + "</td>";
            text += "</tr>";
        }

        ++it;
    }
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
    text += "<td width='20%%'>&nbsp;</td>";
    text += "<td width='16%%' colspan='2'><b>ALL (undefined)</b></td>";
    text += "<td width='16%%' colspan='2'><b>STORAGE EMPTY</b></td>";
    text += "<td width='16%%' colspan='2'><b>STORAGE ALL</b></td>";
    text += "<td width='16%%' colspan='2'><b>CACHE EMPTY</b></td>";
    text += "<td width='16%%' colspan='2'><b>CACHE ALL</b></td>";
    text += "</tr>";
    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            text += "<tr align='right'>";
            text += "<td align='center'>" + GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_current_tick.ResStatusAll()) + " (" + IntToStroka((*it).second->m_current_tick.m_undef_answer) + ")</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_current_tick.m_storage_answer_empty) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_current_tick.ResStatusStorageAll()) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_current_tick.m_cache_answer_empty) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_current_tick.ResStatusCacheAll()) + "</td>";
            text += "</tr>";
        }

        ++it;
    }
    text = text + "</table><br>";

    text = text + "<br><i><b>Today tick statistik:</b></i>&nbsp;&nbsp;";
    text += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor='" + TString(color_table_today) + "'>";
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
    text += "<td width='20%%'><b>FUNCTION</b></td>";
    text += "<td width='8%%'><b>SKEEP</b></td>";
    text += "<td width='8%%'><b>0..10 ms</b></td>";
    text += "<td width='8%%'><b>10..20 ms</b></td>";
    text += "<td width='8%%'><b>20..30 ms</b></td>";
    text += "<td width='8%%'><b>30..50 ms</b></td>";
    text += "<td width='8%%'><b>50..100 ms</b></td>";
    text += "<td width='8%%'><b>100..150 ms</b></td>";
    text += "<td width='8%%'><b>150..190 ms</b></td>";
    text += "<td width='8%%'><b>190..500 ms</b></td>";
    text += "<td width='8%%'><b>more 500 ms</b></td>";
    text += "</tr>";
    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            text += "<tr align='right'>";
            text += "<td align='center'>" + GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "</td>";
            text += "<td>" + (*it).second->m_today_tick.SkeepInfo() + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_0_10) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_10_20) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_20_30) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_30_50) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_50_100) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_100_150) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_150_190) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_190_500) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_today_tick.m_more500) + "</td>";
            text += "</tr>";
        }

        ++it;
    }
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
    text += "<td width='20%%'>&nbsp;</td>";
    text += "<td width='16%%' colspan='2'><b>ALL (undefined)</b></td>";
    text += "<td width='16%%' colspan='2'><b>STORAGE EMPTY</b></td>";
    text += "<td width='16%%' colspan='2'><b>STORAGE ALL</b></td>";
    text += "<td width='16%%' colspan='2'><b>CACHE EMPTY</b></td>";
    text += "<td width='16%%' colspan='2'><b>CACHE ALL</b></td>";
    text += "</tr>";
    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            text += "<tr align='right'>";
            text += "<td align='center'>" + GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_today_tick.ResStatusAll()) + " (" + IntToStroka((*it).second->m_today_tick.m_undef_answer) + ")</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_today_tick.m_storage_answer_empty) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_today_tick.ResStatusStorageAll()) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_today_tick.m_cache_answer_empty) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_today_tick.ResStatusCacheAll()) + "</td>";
            text += "</tr>";
        }

        ++it;
    }
    text = text + "</table><br>";

    text = text + "<br><i><b>Yesterday tick statistik:</b></i>&nbsp;&nbsp;";
    text += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor='" + TString(color_table_yesterday) + "'>";
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
    text += "<td width='20%%'><b>FUNCTION</b></td>";
    text += "<td width='8%%'><b>SKEEP</b></td>";
    text += "<td width='8%%'><b>0..10 ms</b></td>";
    text += "<td width='8%%'><b>10..20 ms</b></td>";
    text += "<td width='8%%'><b>20..30 ms</b></td>";
    text += "<td width='8%%'><b>30..50 ms</b></td>";
    text += "<td width='8%%'><b>50..100 ms</b></td>";
    text += "<td width='8%%'><b>100..150 ms</b></td>";
    text += "<td width='8%%'><b>150..190 ms</b></td>";
    text += "<td width='8%%'><b>190..500 ms</b></td>";
    text += "<td width='8%%'><b>more 500 ms</b></td>";
    text += "</tr>";
    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            text += "<tr align='right'>";
            text += "<td align='center'>" + GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "</td>";
            text += "<td>" + (*it).second->m_yesterday_tick.SkeepInfo() + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_0_10) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_10_20) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_20_30) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_30_50) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_50_100) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_100_150) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_150_190) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_190_500) + "</td>";
            text += "<td>" + IntToStroka((*it).second->m_yesterday_tick.m_more500) + "</td>";
            text += "</tr>";
        }

        ++it;
    }
    text += "<tr align='center' bgcolor='" + TString(color_table_shap) + "'>";
    text += "<td width='20%%'>&nbsp;</td>";
    text += "<td width='16%%' colspan='2'><b>ALL (undefined)</b></td>";
    text += "<td width='16%%' colspan='2'><b>STORAGE EMPTY</b></td>";
    text += "<td width='16%%' colspan='2'><b>STORAGE ALL</b></td>";
    text += "<td width='16%%' colspan='2'><b>CACHE EMPTY</b></td>";
    text += "<td width='16%%' colspan='2'><b>CACHE ALL</b></td>";
    text += "</tr>";
    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            text += "<tr align='right'>";
            text += "<td align='center'>" + GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_yesterday_tick.ResStatusAll()) + " (" + IntToStroka((*it).second->m_yesterday_tick.m_undef_answer) + ")</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_yesterday_tick.m_storage_answer_empty) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_yesterday_tick.ResStatusStorageAll()) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_yesterday_tick.m_cache_answer_empty) + "</td>";
            text += "<td colspan='2'>" + IntToStroka((*it).second->m_yesterday_tick.ResStatusCacheAll()) + "</td>";
            text += "</tr>";
        }

        ++it;
    }
    text = text + "</table><br>";

    return text;
}

TString TMakeRequestLimit::GetMonStatistik() {
    //"<LIMIT: FULL=okcount-avg_ok-skeepcount-avg_skeep-max,0_10-10_20-20_30-30_50-50_100-50_100-150_190-190_500-more500 FASTGET=okcount-avg_ok-skeepcount-avg_skeep-max,0_10-10_20-20_30-30_50-50_100-50_100-150_190-190_500-more500 >"
    TString text = "";
    ui32 okcount = 0;
    ui32 badcount = 0;
    float avg_ok = 0;
    float avg_bad = 0;
    ui32 max = 0;
    TDelayTick currtick;
    TMakeRequestLimitItemHashIt it;

    text += "<LIMIT: ";

    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL) {
            currtick.Clear();
            text += GetNameByIndexShort(static_cast<TMakeRequestLimit::Func>((*it).first)) + "=";
            (*it).second->CalcStat(okcount, badcount, avg_ok, avg_bad, max, currtick);
            text += IntToStroka(okcount) + "-" + FloatToStr(avg_ok) + "-" + IntToStroka(badcount) + "-" + FloatToStr(avg_bad) + "-" + IntToStroka(max) + "," + currtick.ResStatusToLog() + "," + currtick.TimingToLog() + " ";
        }

        ++it;
    }

    text += ">";

    return text;
}

bool TMakeRequestLimit::AddThread(TMakeRequestLimit::Func type) {
    bool res = false;
    TMakeRequestLimitItemHashIt it;

    it = data.find(type);
    if (it != data.end()) {
        if ((*it).second != NULL)
            res = (*it).second->AddThread();
    }

    return res;
}

void TMakeRequestLimit::ReturnThread(TMakeRequestLimit::Func type) {
    TMakeRequestLimitItemHashIt it;

    it = data.find(type);
    if (it != data.end()) {
        if ((*it).second != NULL)
            (*it).second->ReturnThread();
    }
}

void TMakeRequestLimit::AddTick(TMakeRequestLimit::Func type, ui32 tick, bool skeep) {
    TMakeRequestLimitItemHashIt it;

    it = data.find(type);
    if (it != data.end()) {
        if ((*it).second != NULL)
            (*it).second->AddTick(tick, skeep);
    }
}

void TMakeRequestLimit::AddResStatus(TMakeRequestLimit::Func type, TDelayTick::TSource source, bool empty) {
    TMakeRequestLimitItemHashIt it;

    it = data.find(type);
    if (it != data.end()) {
        if ((*it).second != NULL)
            (*it).second->AddResStatus(source, empty);
    }
}

void TMakeRequestLimit::Midnight() {
    TMakeRequestLimitItemHashIt it;

    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != NULL)
            (*it).second->Midnight();

        ++it;
    }
}

//*******************************************************************************************************************************************
