#pragma once

#include "util/generic/vector.h"
#include <util/generic/string.h>
#include "util/string/util.h"
#include "util/system/mutex.h"
#include "util/generic/hash.h"
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>

//*******************************************************************************************************************************************
//                                                       TMakeRequestLimit
//*******************************************************************************************************************************************

struct TDelayTick
{
   enum TSource {SRC_UNKNOWN, SRC_STORAGE, SRC_CACHE};

   ui32 m_all;                      //all request
   ui32 m_skeep_cnt;                //skeep count
   ui32 m_undef_answer;
   ui32 m_storage_answer_notempty;
   ui32 m_storage_answer_empty;
   ui32 m_cache_answer_notempty;
   ui32 m_cache_answer_empty;
   ui32 m_0_10;                     //0 - 10 ms
   ui32 m_10_20;                    //10 - 20 ms
   ui32 m_20_30;                    //20 - 30 ms
   ui32 m_30_50;                    //30 - 50 ms
   ui32 m_50_100;                   //50 - 100 ms
   ui32 m_100_150;                  //100 - 150 ms
   ui32 m_150_190;                  //150 - 190 ms
   ui32 m_190_500;                  //190 - 500 ms
   ui32 m_more500;                  //more 500 ms

   TDelayTick()
   {
      Clear();
   }

   void Clear()
   {
      m_all                      = 0;
      m_skeep_cnt                = 0;
      m_undef_answer             = 0;
      m_storage_answer_notempty  = 0;
      m_storage_answer_empty     = 0;
      m_cache_answer_notempty    = 0;
      m_cache_answer_empty       = 0;
      m_0_10                     = 0;
      m_10_20                    = 0;
      m_20_30                    = 0;
      m_30_50                    = 0;
      m_50_100                   = 0;
      m_100_150                  = 0;
      m_150_190                  = 0;
      m_190_500                  = 0;
      m_more500                  = 0;
   }

   ui32 ResStatusStorageAll()
   {
      return IncMax32(m_storage_answer_notempty, m_storage_answer_empty);
   }

   ui32 ResStatusCacheAll()
   {
      return IncMax32(m_cache_answer_notempty, m_cache_answer_empty);
   }

   ui32 ResStatusAll()
   {
      ui32 res = 0;

      res = IncMax32(res, m_undef_answer);
      res = IncMax32(res, ResStatusStorageAll());
      res = IncMax32(res, ResStatusCacheAll());

      return res;
   }

   TString ResStatusToLog()
   {
      char tbuff[128];

      memset(tbuff, 0, sizeof(tbuff));
      snprintf(tbuff, sizeof(tbuff) - 1, "%u-%u-%u-%u-%u-%u", ResStatusAll(), m_undef_answer, m_storage_answer_empty, ResStatusStorageAll(), m_cache_answer_empty, ResStatusCacheAll());

      return TString(tbuff);
   }

   void AddTick(ui32 tick, bool skeep)
   {
      m_all = IncMax32(m_all, 1);
      if (skeep)
         m_skeep_cnt = IncMax32(m_skeep_cnt, 1);

      if ( (tick >= 0) && (tick < 10) )
         m_0_10 = IncMax32(m_0_10, 1);
      else if ( (tick >= 10) && (tick < 20) )
         m_10_20 = IncMax32(m_10_20, 1);
      else if ( (tick >= 20) && (tick < 30) )
         m_20_30 = IncMax32(m_20_30, 1);
      else if ( (tick >= 30) && (tick < 50) )
         m_30_50 = IncMax32(m_30_50, 1);
      else if ( (tick >= 50) && (tick < 100) )
         m_50_100 = IncMax32(m_50_100, 1);
      else if ( (tick >= 100) && (tick < 150) )
         m_100_150 = IncMax32(m_100_150, 1);
      else if ( (tick >= 150) && (tick < 190) )
         m_150_190 = IncMax32(m_150_190, 1);
      else if ( (tick >= 190) && (tick < 500) )
         m_190_500 = IncMax32(m_190_500, 1);
      else if (tick >= 500)
         m_more500 = IncMax32(m_more500, 1);

   }

   void AddResStatus(TSource source, bool empty)
   {
      switch (source)
      {
      case SRC_UNKNOWN:

                                 break;
      case SRC_STORAGE:
                                 if (empty)
                                    m_storage_answer_empty = IncMax32(m_storage_answer_empty, 1);
                                 else
                                    m_storage_answer_notempty = IncMax32(m_storage_answer_notempty, 1);

                                 break;
      case SRC_CACHE:
                                 if (empty)
                                    m_cache_answer_empty = IncMax32(m_cache_answer_empty, 1);
                                 else
                                    m_cache_answer_notempty = IncMax32(m_cache_answer_notempty, 1);

                                 break;
      };

   }

   TString SkeepInfo()
   {
      TString res     = "-";
      float  percent = 0;

      if (m_skeep_cnt > 0)
      {
         if (m_all > 0)
         {
            percent = static_cast<float>(m_skeep_cnt) * static_cast<float>(100) / static_cast<float>(m_all);
            res = IntToStroka(m_skeep_cnt) + " (" + FloatToStr(percent) + "%)";

         } else
         {
            res = IntToStroka(m_skeep_cnt);
         }
      }

      return res;
   }

   TString TimingToLog()
   {
      char tbuff[128];

      memset(tbuff, 0, sizeof(tbuff));
      snprintf(tbuff, sizeof(tbuff) - 1, "%u-%u-%u-%u-%u-%u-%u-%u-%u", m_0_10, m_10_20, m_20_30, m_30_50, m_50_100, m_100_150, m_150_190, m_190_500, m_more500);

      return TString(tbuff);
   }

};

struct TMakeRequestLimitItem
{
public:
   ui32        m_max_limit;
   ui32        m_current_value;
   ui32        m_max_value;
   ui32        m_ok_count;
   ui32        m_bad_count;
   ui32        m_last_calc_time;
   TDelayTick  m_current_tick;
   TDelayTick  m_today_tick;
   TDelayTick  m_yesterday_tick;
   TMutex      m_mutex;

public:
   TMakeRequestLimitItem();
   TMakeRequestLimitItem(ui32 max_limit);

   void Clear();
   void CalcStat(ui32 &count, ui32 &badcount, float &avg_ok, float &avg_bad, ui32 &max, TDelayTick &currtick);
   bool AddThread();
   void ReturnThread();
   void AddTick(ui32 tick, bool skeep);
   void AddResStatus(TDelayTick::TSource source, bool empty);
   void Midnight();

};

typedef THashMap<ui32, TMakeRequestLimitItem *>  TMakeRequestLimitItemHash;
typedef TMakeRequestLimitItemHash::iterator   TMakeRequestLimitItemHashIt;

class TMakeRequestLimit
{
public:
         enum Func    {CHECK, RCVRCPT, CORRLONGSTAT, INTERFACE, END};

private:
         TMakeRequestLimitItemHash data;
         ui32                      all_thread;
         bool                      disable;

         TString GetNameByIndex(TMakeRequestLimit::Func type);
         static TString GetNameByIndexShort(TMakeRequestLimit::Func type);
public:
         TMakeRequestLimit();
         ~TMakeRequestLimit();

         void     Init(TKConfig *config, bool disableA);
         void     AddItem(TMakeRequestLimit::Func type, ui32 percent_value);

         TString   GetWebStatistik();
         TString   GetMonStatistik();

         bool     AddThread(TMakeRequestLimit::Func type);
         void     ReturnThread(TMakeRequestLimit::Func type);
         void     AddTick(TMakeRequestLimit::Func type, ui32 tick, bool skeep);
         void     AddResStatus(TMakeRequestLimit::Func type, TDelayTick::TSource source, bool empty);
         void     Midnight();

};

//*******************************************************************************************************************************************


