#include "trulestat.h"

//******************************************************************************
//                            TRuleStat
//******************************************************************************

TRuleStatRecord::TRuleStatRecord(time_t sec) {
    data.push_back(sec);
}

TRuleStatRecord::TRuleStatRecord(const TRuleStatRecord& value) {
    TRSRListCIt cit;

    cit = value.data.begin();
    while (cit != value.data.end()) {
        data.push_back((*cit));
        ++cit;
    }
}

TRuleStatRecord& TRuleStatRecord::operator=(const TRuleStatRecord& value) {
    TRSRListCIt cit;

    cit = value.data.begin();
    while (cit != value.data.end()) {
        this->data.push_back((*cit));
        ++cit;
    }
    return *this;
}

size_t TRuleStatRecord::size() const {
    size_t res = 0;

    auto it = data.begin();
    while (it != data.end()) {
        res += sizeof(*it);
        ++it;
    }
    return res;
}

ui32 TRuleStatRecord::GetCountFrom(time_t sec) {
    ui32 res = 0;
    auto it = lower_bound(data.begin(), data.end(), sec);

    while (it != data.end()) {
        res++;
        ++it;
    }

    return res;
}

void TRuleStatRecord::TruncData(time_t sec) {
    TRSRList datanew;
    TRSRListIt it;

    it = lower_bound(data.begin(), data.end(), sec);
    while (it != data.end()) {
        datanew.push_back(*it);
        ++it;
    }
    data = std::move(datanew);
}

void TRuleStatRecord::Add(time_t sec) {
    data.push_back(sec);
    data.sort();
}

//TRuleStat

TRuleStat::TRuleStat() {
    m_rulestatlist = nullptr;
}

TRuleStat::~TRuleStat() {
    rulehash.clear();
}

void TRuleStat::Lock() {
    m_Mutex.Acquire();
}

void TRuleStat::UnLock() {
    m_Mutex.Release();
}

void TRuleStat::SetRuleStatList(TKIniFile* rulestatlist) {
    Lock();

    m_rulestatlist = rulestatlist;

    UnLock();
}

void TRuleStat::TruncData(time_t sec, bool del, ui64& RequestCount) {
    Lock();

    if (del && ((RequestCount % 50) == 0)) {
        TRSRhashIt it;

        it = rulehash.begin();
        while (it != rulehash.end()) {
            (*it).second.TruncData(sec);
            ++it;
        }
    }

    UnLock();
}

void TRuleStat::AddRuleStat(time_t sec, const char* BUFF) {
    Lock();

    const char *p = nullptr, *pbegin = nullptr;
    const char* trimtext = nullptr;
    char rulename[128];
    size_t count = 0;
    TString rulenames = "";
    int trimtextsize = 0;
    TRSRhashIt it;
    TString prefix = "TSR_";

    p = BUFF;
    pbegin = p;
    while (true) {
        p = strstr(pbegin, ",");
        if (p != nullptr) {
            count = p - pbegin;
            memset(rulename, 0, sizeof(rulename));
            if (count <= (sizeof(rulename) - 1)) {
                memcpy(rulename, pbegin, count);
                SpTrim(rulename, &trimtext, &trimtextsize);
                rulenames = TString(trimtext, trimtextsize);

                if (m_rulestatlist != nullptr) {
                    if (m_rulestatlist->KeyExists("rules", rulenames))
                    //if ( (rulenames.size() > prefix.size()) && (memcmp(rulenames.c_str(), prefix.c_str(), prefix.size()) == 0) ) //�������� �� �������� "TSR_"
                    {
                        it = rulehash.find(rulenames);
                        if (it != rulehash.end()) {
                            (*it).second.Add(sec);
                        } else {
                            rulehash[rulenames] = TRuleStatRecord(sec);
                        }
                    }
                }
            }
            pbegin = p + 1;
        } else
            break;
    }

    UnLock();
}

void TRuleStat::GetRuleStat(time_t sec, TRuleStatResList& res) {
    res.clear();

    TRSRhashIt it;
    TRuleStatRes rsr;

    Lock();

    it = rulehash.begin();
    while (it != rulehash.end()) {
        rsr.rulename = (*it).first;
        rsr.count = (*it).second.GetCountFrom(sec);
        if (m_rulestatlist->KeyExists("rules", rsr.rulename)) {
            res.push_back(rsr);
            ++it;

        } else {
            rulehash.erase(it++);
        }
    }

    UnLock();
}

void TRuleStat::Clear() {
    Lock();

    rulehash.clear();

    UnLock();
}

ui32 TRuleStat::GetSize() {
    return rulehash.size();
}

//*******************************************************************************************************************
