#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkinifile.h>
#include "util/generic/hash_set.h"
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "ktypes.h"

//******************************************************************************
//                            TRuleStat
//******************************************************************************

typedef std::list<time_t> TRSRList;
typedef TRSRList::iterator TRSRListIt;
typedef TRSRList::const_iterator TRSRListCIt;

class TRuleStatRecord {
private:
    TRSRList data;

public:
    Y_SAVELOAD_DEFINE(data)
    TRuleStatRecord() = default;
    explicit TRuleStatRecord(time_t sec);
    TRuleStatRecord(const TRuleStatRecord& value);

    TRuleStatRecord& operator=(const TRuleStatRecord& value);

    [[nodiscard]] size_t size() const;
    void Add(time_t sec);
    ui32 GetCountFrom(time_t sec);
    void TruncData(time_t sec);
};

struct TRuleStatRes {
    TString rulename;
    ui32 count;
};

typedef THashMap<TString, TRuleStatRecord> TRSRhash;
typedef TRSRhash::iterator TRSRhashIt;
typedef std::list<TRuleStatRes> TRuleStatResList;
typedef TRuleStatResList::iterator TRuleStatResListIt;

class TRuleStat {
private:
    TRSRhash rulehash;
    TMutex m_Mutex;
    TKIniFile* m_rulestatlist;

    void Lock();
    void UnLock();

public:
    Y_SAVELOAD_DEFINE(rulehash)
    TRuleStat();
    ~TRuleStat();

    void SetRuleStatList(TKIniFile* rulestatlist);
    void TruncData(time_t sec, bool del, ui64& RequestCount);
    void AddRuleStat(time_t sec, const char* BUFF);
    void GetRuleStat(time_t sec, TRuleStatResList& res);
    void Clear();

    ui32 GetSize();
};

//*****************************************************************************************************************
