#include <library/cpp/iterator/functools.h>
#include "tshortipstorage.h"
#include <mail/so/spamstop/tools/so-clients/kshingle.h>

TString FrodoSpamTypeToTString(TFRODOSPAMTYPE type) {
    TString res = "";

    switch (type) {
        case FRS_DIRECTSPAM:
            res = "DIRECTSPAM";
            break;
        case FRS_CORRLOGIN:
            res = "CORRLOGIN";
            break;
        case FRS_LOGINRESEMB:
            res = "LOGINRESEMB";
            break;
        case FRS_HINTPASSW:
            res = "HINTPASSW";
            break;
        case FRS_COMPAREIFNAMES:
            res = "COMPAREIFNAMES";
            break;
        case FRS_PACKETTWO:
            res = "PACKETTWO";
            break;
        case FRS_TRUEBYGROUP:
            res = "TRUEBYGROUP";
            break;
        case FRS_3MIN:
            res = "3MIN";
            break;
        case FRS_3MINPREV:
            res = "3MINPREV";
            break;
        default:
            res = "UNKNOWN";
    };

    return res;
}

//******************************************************************************************************************
//                                              TLoginTime
//******************************************************************************************************************

TLoginTime::TLoginTime() {
    ftime = 0;
    flogin = "";
    fspam = 0;
    fpassw_hint.Clear();
    fquest_hint.Clear();
    fanswer_hint.Clear();
    //fuid         = 0;
    fweight = 0;
    finame = "";
    ffname = "";
    fpacket2 = TPacket();
    fpr = 0;
    fgeodata = 0;
}

TLoginTime::TLoginTime(time_t t) {
    ftime = t;
    flogin = "";
    fspam = 0;
    fpassw_hint.Clear();
    fquest_hint.Clear();
    fanswer_hint.Clear();
    //fuid         = 0;
    fweight = 0;
    finame = "";
    ffname = "";
    fpacket2 = TPacket();
    fpr = 0;
    fgeodata = 0;
}

TLoginTime::TLoginTime(time_t t, TString login, TPackHint passw_hint, TPackHint quest_hint, TPackHint answer_hint, ui32 /*uid*/, TString iname, TString fname, TPacket packet2, ui32 geodata, bool pdd) {
    ftime = t;
    flogin = login;
    fspam = 0;
    fpassw_hint = passw_hint;
    fquest_hint = quest_hint;
    fanswer_hint = answer_hint;
    //fuid         = uid;
    fweight = 0;
    finame = iname;
    ffname = fname;
    fpacket2 = packet2;
    fpr = 0;
    if (finame == ffname)
        SET_PR_EQUALIFNAME(fpr);
    if (pdd)
        SET_PR_PDD(fpr);

    fgeodata = geodata;
}

TLoginTime::TLoginTime(const TLoginTime& value) {
    ftime = value.ftime;
    flogin = value.flogin;
    fspam = value.fspam;
    fpassw_hint = value.fpassw_hint;
    fquest_hint = value.fquest_hint;
    fanswer_hint = value.fanswer_hint;
    //fuid         = value.fuid;
    fweight = value.fweight;
    finame = value.finame;
    ffname = value.ffname;
    fpacket2 = value.fpacket2;
    fpr = value.fpr;
    fgeodata = value.fgeodata;
}

TLoginTime& TLoginTime::operator=(const TLoginTime& value) {
    if (this == &value)
        return *this;
    else {
        ftime = value.ftime;
        flogin = value.flogin;
        fspam = value.fspam;
        fpassw_hint = value.fpassw_hint;
        fquest_hint = value.fquest_hint;
        fanswer_hint = value.fanswer_hint;
        //fuid         = value.fuid;
        fweight = value.fweight;
        finame = value.finame;
        ffname = value.ffname;
        fpacket2 = value.fpacket2;
        fpr = value.fpr;
        fgeodata = value.fgeodata;
    }
    return *this;
}

bool TLoginTime::operator<(const TLoginTime& value) const {
    return (ftime < value.ftime);
}

bool TLoginTime::operator==(const TLoginTime& value) const {
    return (ftime == value.ftime);
}

time_t TLoginTime::time(void) const {
    return ftime;
}

TString TLoginTime::login(void) const {
    return flogin;
}

bool TLoginTime::spam(void) const {
    TReadGuard g(Lock);
    return fspam & 0x01;
}

//void TLoginTime::set_spam(bool spam)
//{
// fspam = spam;
//}

void TLoginTime::set_spam(bool spam, ui8 alg, ui8 weight) {
    TWriteGuard g(Lock);
    if (spam) {
        fspam = alg << 1;
        fspam = fspam | 0x01;
    } else
        fspam = 0;
    fweight = weight;
}

void TLoginTime::set_spam(bool spam, ui8 alg) {
    TWriteGuard g(Lock);
    if (spam) {
        fspam = alg << 1;
        fspam = fspam | 0x01;
    } else
        fspam = 0;
}

void TLoginTime::set_weight(ui8 weight) {
    TWriteGuard g(Lock);
    fweight = weight;
}

TPackHint TLoginTime::passw_hint(void) const {
    return fpassw_hint;
}

TPackHint TLoginTime::quest_hint(void) const {
    return fquest_hint;
}

TPackHint TLoginTime::answer_hint(void) const {
    return fanswer_hint;
}

ui32 TLoginTime::uid(void) const {
    //return fuid;
    return 0;
}

ui8 TLoginTime::weight(void) const {
    return fweight;
}

TString TLoginTime::iname(void) const {
    return finame;
}

TString TLoginTime::fname(void) const {
    return ffname;
}

TPacket TLoginTime::packet2(void) const {
    return fpacket2;
}

bool TLoginTime::equal_ifname(void) const {
    return IS_PR_EQUALIFNAME(fpr);
}

bool TLoginTime::is_pdd(void) const {
    return IS_PR_PDD(fpr);
}

ui32 TLoginTime::geodata(void) const {
    return fgeodata;
}

ui8 TLoginTime::priznak(void) const {
    return fpr;
}

size_t TLoginTime::size() const {
    size_t res = 0;

    res += sizeof(ftime);
    res += sizeof(ui16); //������ ������ � flogin
    res += flogin.size();
    res += sizeof(fspam);
    res += sizeof(fpassw_hint);
    res += sizeof(fquest_hint);
    res += sizeof(fanswer_hint);
    res += sizeof(fweight);
    res += sizeof(ui16); //������ ������ � finame
    res += finame.size();
    res += sizeof(ui16); //������ ������ � ffname
    res += ffname.size();
    res += sizeof(fpacket2);
    res += sizeof(fpr);
    res += sizeof(fgeodata);

    return res;
}

TLoginTime::TLoginTime(char* BUFF, ui32 BuffSize, ui32& count) {
    ui32 minsize = 0;
    ui32 pos = 0;
    ui16 floginsize = 0, finamesize = 0, ffnamesize = 0;

    count = 0;
    minsize = sizeof(ftime) + sizeof(floginsize) + sizeof(fspam) + sizeof(fpassw_hint) + sizeof(fquest_hint) + sizeof(fanswer_hint) + sizeof(fweight) + sizeof(finamesize) + sizeof(ffnamesize) + sizeof(fpacket2) /* + sizeof(fpacket4)*/ + sizeof(fpr) + sizeof(fgeodata);
    if (BuffSize >= minsize) {
        memcpy(&ftime, BUFF + pos, sizeof(ftime));
        pos += sizeof(ftime);

        memcpy(&floginsize, BUFF + pos, sizeof(floginsize));
        pos += sizeof(floginsize);
        if (floginsize > 0) {
            flogin = TString(BUFF + pos, floginsize);
            pos += floginsize;
        }

        memcpy(&fspam, BUFF + pos, sizeof(fspam));
        pos += sizeof(fspam);

        memcpy(&fpassw_hint, BUFF + pos, sizeof(fpassw_hint));
        pos += sizeof(fpassw_hint);

        memcpy(&fquest_hint, BUFF + pos, sizeof(fquest_hint));
        pos += sizeof(fquest_hint);

        memcpy(&fanswer_hint, BUFF + pos, sizeof(fanswer_hint));
        pos += sizeof(fanswer_hint);

        memcpy(&fweight, BUFF + pos, sizeof(fweight));
        pos += sizeof(fweight);

        memcpy(&finamesize, BUFF + pos, sizeof(finamesize));
        pos += sizeof(finamesize);
        if (finamesize > 0) {
            finame = TString(BUFF + pos, finamesize);
            pos += finamesize;
        }

        memcpy(&ffnamesize, BUFF + pos, sizeof(ffnamesize));
        pos += sizeof(ffnamesize);
        if (ffnamesize > 0) {
            ffname = TString(BUFF + pos, ffnamesize);
            pos += ffnamesize;
        }

        memcpy(&fpacket2, BUFF + pos, sizeof(fpacket2));
        pos += sizeof(fpacket2);

        memcpy(&fpr, BUFF + pos, sizeof(fpr));
        pos += sizeof(fpr);

        memcpy(&fgeodata, BUFF + pos, sizeof(fgeodata));
        pos += sizeof(fgeodata);

        count = pos;
    }
}

//*************************************************************************************************************
//                                              TLoginTimeExt
//*************************************************************************************************************

TLoginTimeExt::TLoginTimeExt(time_t t, TString login, TString ipaddress, ui8 type, ui32 /*uid*/, ui8 weight, ui32 geodata, ui8 priznak) {
    ftime = t;
    flogin = login;
    fspam = 0;
    fipaddress = ipaddress;
    ftype = type;
    //fuid     = uid;
    fweight = weight;
    fgeodata = geodata;
    fpr = priznak;
}

TString TLoginTimeExt::ipaddress(void) const {
    return fipaddress;
}

ui8 TLoginTimeExt::type(void) const {
    return ftype;
}

bool TLoginTimeExt::operator==(const TLoginTimeExt& value) const {
    return (flogin == value.flogin);
}

//***************************************************************************************************************
//                                                 CItemStatSet
//***************************************************************************************************************

CItemStatSet::CItemStatSet(TLoginTime value) {
    fspam_count = value.spam() ? 1 : 0;
    {
        TReadGuard g(ListLock);
        TString login = value.login();
        LoginIndex.emplace(std::move(login), m_pISet.emplace_back(MakeAtomicShared<TLoginTime>(std::move(value))));
    }
}

void CItemStatSet::Update(TLoginTime&& loginTime) {
    {
        TWriteGuard g(ListLock);
        auto& emplaced = m_pISet.emplace_back(MakeAtomicShared<TLoginTime>(std::move(loginTime)));
        if(auto it = MapFindPtr(LoginIndex, emplaced->login())) {
            if(it && (*it)->time() < emplaced->time())
                *it = emplaced;
        } else {
            LoginIndex.emplace(emplaced->login(), emplaced);
        }
    }
    if(loginTime.spam()) {
        fspam_count.Add(1);
    }
}

ui32 CItemStatSet::GetCount(void) const {
    TReadGuard g(ListLock);
    return m_pISet.size();
}

void CItemStatSet::Add(TLoginTime t) {
    if (t.spam())
        fspam_count.Inc();
    {
        TWriteGuard g(ListLock);
        auto& emplaced = m_pISet.emplace_back(MakeAtomicShared<TLoginTime>(std::move(t)));
        if(auto it = MapFindPtr(LoginIndex, emplaced->login())) {
            if(it && (*it)->time() < emplaced->time())
                *it = emplaced;
        } else {
            LoginIndex.emplace(emplaced->login(), emplaced);
        }
    }
}

void CItemStatSet::Init() {
    {
        TWriteGuard g(ListLock);
        m_pISet.clear();
        LoginIndex.clear();
    }
    TWriteGuard g(HostNameGeoLock);
    {
        fhostname.clear();
        fgeo.clear();
    }
    fspam = 0;
    spam_login_count = 0;
}

void CItemStatSet::AddHostName(TString hostname) {
    TWriteGuard g(HostNameGeoLock);
    fhostname = std::move(hostname);
}

void CItemStatSet::AddGeo(TString geo) {
    TWriteGuard g(HostNameGeoLock);
    fgeo = std::move(geo);
}

void CItemStatSet::GetGeoAndHost(TString geo, TString hostname) {
    TWriteGuard g(HostNameGeoLock);
    geo = std::move(fgeo);
    hostname = std::move(fhostname);
}

TString CItemStatSet::GetHostName(void) const {
    TReadGuard g(HostNameGeoLock);
    return fhostname;
}

TString CItemStatSet::GetGeo() const {
    TReadGuard g(HostNameGeoLock);
    return fgeo;
}

void CItemStatSet::SetSpam(bool spam, time_t t, TString login, ui8 weight) {
    TLoginTime lt(t);
    TLTListIt it;
    TString s = "";
    TString dlogin = "";

    fspam = spam ? 1 : 0;
    spam_login_count.Inc();

    size_t totalSpam = 0;

    {
        TReadGuard g(ListLock);
        auto [begin, end] = LoginIndex.equal_range(login);

        for(auto it = begin; it != end; ++it){
            if ((*it).second->time() == t) {
                (*it).second->set_spam(spam, FRS_DIRECTSPAM, weight);
                if (spam) {
                    totalSpam++;
                } else {
                    totalSpam--;
                }

                break;
            }
        }
    }
    fspam_count.Add(totalSpam);
}

bool CItemStatSet::CorrectLogins(TString login, ui32 karma, ui32& lastkarma) {
    bool res = false;

    size_t totalSpam{};
    {
        TReadGuard g(ListLock);

        if(auto it = MapFindPtr(LoginIndex, login)) {
            TLoginTime& last =  **it;

            lastkarma = last.weight();
            switch (karma) {
                case KPHAM:
                    if (lastkarma != KPHAM) {
                        last.set_spam(false, FRS_CORRLOGIN);
                        totalSpam--;
                        last.set_weight(karma);
                    }
                    res = true;
                    break;
                case KPSPAM:
                    if (lastkarma == KPHAM) {
                        last.set_spam(true, FRS_CORRLOGIN);
                        totalSpam++;
                    }
                    if (lastkarma != KPSPAM)
                        last.set_weight(karma);
                    res = true;
                    break;
                case KPMALIC:
                    if (lastkarma == KPHAM) {
                        last.set_spam(true, FRS_CORRLOGIN);
                        totalSpam++;
                    }
                    if (lastkarma != KPMALIC)
                        last.set_weight(karma);
                    res = true;
                    break;
            };
        }
    }
    fspam_count.Add(totalSpam);

    return res;
}

void CItemStatSet::Clear(void) {
    Init();
}

void CItemStatSet::AllResemblances(const TKIPv6& ipaddress, const TVector<THolder<IResemblancer>>& resemblancers, TLTExtList& SpamList) {
    TReadGuard g(ListLock);
    size_t spamCount = 0;
    for(auto itr : NFuncTools::Reversed(m_pISet)) {
        for(auto& resemblancer : resemblancers) {
            if (resemblancer->ShouldResemblance(*itr)) {
                itr->set_spam(true, resemblancer->GetType(), KPSPAM);
                ++spamCount;
                SpamList.emplace_back(itr->time(), itr->login(), ipaddress.toStroka(), resemblancer->GetCode(), itr->uid(), itr->weight(), itr->geodata(), itr->priznak());
                break;
            }
        }
    }
    fspam_count.Add(spamCount);
}

ui64 CItemStatSet::Spam_count(void) const {
    return fspam_count.Val();
}

size_t CItemStatSet::size() const {
    size_t res = 0;
    ;

    {
        TReadGuard g(HostNameGeoLock);
        res += sizeof(ui16);
        res += fhostname.size();
        res += sizeof(ui16);
        res += fgeo.size();
    }
    res += sizeof(fspam);
    res += sizeof(spam_login_count);
    res += sizeof(fspam_count);

    {
        TReadGuard g(ListLock);
        TLTListCIt it = m_pISet.begin();
        while (it != m_pISet.end()) {
            res += (*it)->size();
            ++it;
        }
    }

    return res;
}

TIPStat CItemStatSet::CalcStatist(time_t regtime, TString PrefixLogin, TString first_nsymb_login, TPackHint passw_hint, TPackHint quest_hint, TPackHint answer_hint, TString iname, TString fname) {
    TIPStat res;
    TLoginTime lt300(regtime - 300);
    TLoginTime lt600(regtime - 600);
    TLoginTime lt1200(regtime - 1200);
    TLoginTime lt3600(regtime - 3600);
    bool equal_ifname = false;

    res.Clear();
    {
        TReadGuard g(HostNameGeoLock);
        res.host = std::move(fhostname);
        res.geo = std::move(fgeo);
    }

    {
        TReadGuard g(ListLock);
        res.record_count = m_pISet.size();
        for(const auto& ipItem : Reversed(m_pISet)) {
            const auto& pref = GetLoginPrefix(ipItem->login());
            if (pref == PrefixLogin)
                res.repeat_loginprefix_ip++;
            const auto pref4 = ipItem->login().substr(0, 4);
            if (pref4 == first_nsymb_login)
                res.first_nsymb_login_ip++;

            if (ipItem->passw_hint() == passw_hint)
                res.passw_hint_count++;
            if (ipItem->quest_hint() == quest_hint)
                res.quest_hint_count++;
            if (ipItem->answer_hint() == answer_hint)
                res.answer_hint_count++;

            if ((ipItem->passw_hint() == passw_hint) && (ipItem->quest_hint() == quest_hint) && (ipItem->answer_hint() == answer_hint))
                res.addit_hint_count++;

            res.allreg_count_ip++;
            if (ipItem->spam())
                res.spamreg_count_ip++;

            if (ipItem->iname() == iname)
                res.count_iname++;
            if (ipItem->fname() == fname)
                res.count_fname++;
            if ((ipItem->iname() == iname) && (ipItem->fname() == fname))
                res.count_both++;

            if (lt3600 < *ipItem)
                equal_ifname = ipItem->equal_ifname();
            else
                equal_ifname = false;

            if (lt300 < *ipItem) {
                res.count_ip_record300++;
                if (equal_ifname)
                    res.count_ip_equalifname300++;
            }
            if (lt600 < *ipItem) {
                res.count_ip_record600++;
                if (equal_ifname)
                    res.count_ip_equalifname600++;
            }
            if (lt1200 < *ipItem) {
                res.count_ip_record1200++;
                if (equal_ifname)
                    res.count_ip_equalifname1200++;
            }
            if (lt3600 < *ipItem) {
                res.count_ip_record3600++;
                if (equal_ifname)
                    res.count_ip_equalifname3600++;
            }
        }
    }
    res.allreg_count_ip--;

    return res;
}

int CItemStatSet::GetLoginInfo(const TString& login) {
    int res = KPUNKNOWN;

    TReadGuard g(ListLock);
    {
        if(auto it = MapFindPtr(LoginIndex, login)) {
            return (*it)->weight();
        }
    }

    return res;
}
