#pragma once

#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <util/generic/hash_set.h>
#include <util/generic/hash.h>
#include <mail/so/spamstop/tools/so-common/sputil.h>
#include "ktypes.h"
#include "tpackets.h"
#include "tlogsgroup.h"
#include "tsymbolsclass.h"
#include <math.h>

enum TFRODOSPAMTYPE { FRS_DIRECTSPAM,
                      FRS_CORRLOGIN,
                      FRS_LOGINRESEMB,
                      FRS_HINTPASSW,
                      FRS_COMPAREIFNAMES,
                      FRS_PACKETTWO,
                      FRS_TRUEBYGROUP,
                      FRS_3MIN,
                      FRS_3MINPREV };

TString FrodoSpamTypeToTString(TFRODOSPAMTYPE type);

struct TIPStat {
    ui32 record_count;
    TString host;
    TString geo;
    ui32 passw_hint_count;
    ui32 quest_hint_count;
    ui32 answer_hint_count;
    ui32 addit_hint_count;
    ui32 allreg_count_ip;
    ui32 spamreg_count_ip;
    ui32 repeat_loginprefix_ip;
    ui32 first_nsymb_login_ip;
    float sco_3600;
    time_t mo_3600;
    ui32 count_ip_record600;
    ui32 count_ip_record300;
    ui32 count_ip_record1200;
    ui32 count_ip_record3600;
    ui32 count_ip_equalifname3600;
    ui32 count_ip_equalifname1200;
    ui32 count_ip_equalifname600;
    ui32 count_ip_equalifname300;
    ui32 count_iname;
    ui32 count_fname;
    ui32 count_both;

    TIPStat() {
        Clear();
    }

    void Clear() {
        record_count = 0;
        host = "";
        geo = "";
        passw_hint_count = 0;
        quest_hint_count = 0;
        answer_hint_count = 0;
        addit_hint_count = 0;
        allreg_count_ip = 0;
        spamreg_count_ip = 0;
        repeat_loginprefix_ip = 0;
        first_nsymb_login_ip = 0;
        sco_3600 = 0;
        mo_3600 = 0;
        count_ip_record300 = 0;
        count_ip_record600 = 0;
        count_ip_record1200 = 0;
        count_ip_record3600 = 0;
        count_ip_equalifname300 = 0;
        count_ip_equalifname600 = 0;
        count_ip_equalifname1200 = 0;
        count_ip_equalifname3600 = 0;
        count_iname = 0;
        count_fname = 0;
        count_both = 0;
    }

    TIPStat operator+(TIPStat& value) {
        record_count += value.record_count;
        passw_hint_count += value.passw_hint_count;
        quest_hint_count += value.quest_hint_count;
        answer_hint_count += value.answer_hint_count;
        addit_hint_count += value.addit_hint_count;
        allreg_count_ip += value.allreg_count_ip;
        spamreg_count_ip += value.spamreg_count_ip;
        repeat_loginprefix_ip += value.repeat_loginprefix_ip;
        first_nsymb_login_ip += value.first_nsymb_login_ip;
        count_ip_record300 += value.count_ip_record300;
        count_ip_record600 += value.count_ip_record600;
        count_ip_record1200 += value.count_ip_record1200;
        count_ip_record3600 += value.count_ip_record3600;
        count_ip_equalifname300 += value.count_ip_equalifname300;
        count_ip_equalifname600 += value.count_ip_equalifname600;
        count_ip_equalifname1200 += value.count_ip_equalifname1200;
        count_ip_equalifname3600 += value.count_ip_equalifname3600;
        count_iname += value.count_iname;
        count_fname += value.count_fname;
        count_both += value.count_both;

        return *this;
    }
};

//******************************************************************************************************************
//                                              CLoginTime
//******************************************************************************************************************

#define PR_EQUALIFNAME 0x00000001 //equal_ifname
#define PR_PDD 0x00000002         //pdd

#define IS_PR_EQUALIFNAME(flag) ((flag)&PR_EQUALIFNAME)
#define IS_PR_PDD(flag) ((flag)&PR_PDD)

#define SET_PR_EQUALIFNAME(flag) \
    { (flag) |= PR_EQUALIFNAME; }
#define SET_PR_PDD(flag) \
    { (flag) |= PR_PDD; }

class TLoginTime {
public:
    Y_SAVELOAD_DEFINE(
        ftime,
        flogin,
        fspam,
        fpassw_hint,
        fquest_hint,
        fweight,
        finame,
        ffname,
        fpacket2,
        fpr,
        fgeodata,
        modified)
protected:
    time_t ftime;
    TString flogin;
    ui8 fspam;
    TPackHint fpassw_hint;
    TPackHint fquest_hint, fanswer_hint;
    ui8 fweight;
    TString finame;
    TString ffname;
    TPacket fpacket2;
    ui8 fpr; //��������
    ui32 fgeodata;
    bool modified;

    mutable TRWMutex Lock;

public:
    TLoginTime();
    TLoginTime(time_t t);
    TLoginTime(time_t t, TString loginA, TPackHint passw_hint, TPackHint quest_hint, TPackHint answer_hint, ui32 uid, TString iname, TString fname, TPacket packet2, ui32 geodata, bool pdd);
    TLoginTime(const TLoginTime& value);
    TLoginTime(char* BUFF, ui32 BuffSize, ui32& count);

    TLoginTime& operator=(const TLoginTime& value);
    bool operator<(const TLoginTime& value) const;
    bool operator==(const TLoginTime& value) const;

    time_t time(void) const;
    TString login(void) const;
    bool spam(void) const;
    TPackHint passw_hint(void) const;
    TPackHint quest_hint(void) const;
    TPackHint answer_hint(void) const;
    ui32 uid(void) const;
    ui8 weight(void) const;
    TString iname(void) const;
    TString fname(void) const;
    TPacket packet2(void) const;
    bool equal_ifname(void) const;
    bool is_pdd(void) const;
    ui32 geodata(void) const;
    ui8 priznak(void) const;

    void set_spam(bool spam, ui8 alg, ui8 weight);
    void set_spam(bool spam, ui8 alg);
    void set_weight(ui8 weight);

    size_t size() const;
};

//******************************************************************************************************************
//                                              TLoginTimeEx
//******************************************************************************************************************

class TLoginTimeExt : public TLoginTime {
protected:
    TString fipaddress;
    ui8 ftype;

public:
    TLoginTimeExt(time_t t, TString login, TString ipaddress, ui8 type, ui32 uid, ui8 weight, ui32 geodata, ui8 priznak);

    TString ipaddress(void) const;
    ui8 type(void) const;

    bool operator==(const TLoginTimeExt& value) const;
};

//*******************************************************************************************************************
//                                              CItemStatSet
//*******************************************************************************************************************

using TLoginTimePtr = TAtomicSharedPtr <TLoginTime>;
typedef TList<TLoginTimePtr> TLTList;
typedef TLTList::iterator TLTListIt;
typedef TLTList::const_iterator TLTListCIt;

typedef std::list<TLoginTimeExt> TLTExtList;

typedef std::list<float> TFList;

class IResemblancer {
public:
    virtual int GetCode() const = 0;
    virtual TFRODOSPAMTYPE GetType() const = 0;
    virtual bool ShouldResemblance(const TLoginTime& loginTimeItem) = 0;
    virtual ~IResemblancer() = default;
};

struct TLoginResemblancer : public IResemblancer {
    const TString current_login;
    TString last_login{};
    const float threshold_first = 0.67, threshold_last = .8;

    explicit TLoginResemblancer(const TString& current_login) noexcept
        : current_login(current_login) {
    }

    int GetCode() const override {
        return 1;
    }
    TFRODOSPAMTYPE GetType() const override {
        return FRS_LOGINRESEMB;
    }

    bool ShouldResemblance(const TLoginTime& loginTimeItem) override {
        auto tek_login = loginTimeItem.login();
        if (loginTimeItem.spam()) {
            last_login = std::move(tek_login);
            return false;
        } else if ((CompareLoginEng(tek_login, current_login) >= threshold_first) &&
                   (!last_login || CompareLoginEng(tek_login, last_login) >= threshold_last)) {
            last_login = std::move(tek_login);
            return true;
        }
        return false;
    }
};

struct THintPasswAnswerResemblancer : public IResemblancer {
    const TPackHint passw_hint;
    const TPackHint answer_hint;
    THintPasswAnswerResemblancer(const TPackHint& passw_hint, const TPackHint& answer_hint) noexcept
        : passw_hint(passw_hint)
        , answer_hint(answer_hint) {
    }
    int GetCode() const override {
        return 2;
    }
    TFRODOSPAMTYPE GetType() const override {
        return FRS_HINTPASSW;
    }
    bool ShouldResemblance(const TLoginTime& loginTimeItem) override {
        if (!loginTimeItem.spam()) {
            if ((loginTimeItem.passw_hint() == passw_hint) && (loginTimeItem.answer_hint() == answer_hint)) {
                return true;
            }
        }
        return false;
    }
};

struct TSpamRecord_3minResemblancer : public IResemblancer {
    const time_t t;
    size_t n{};
    bool enoght{};
    explicit TSpamRecord_3minResemblancer(time_t t) noexcept
        : t(t) {
    }
    int GetCode() const override {
        return 4;
    }
    TFRODOSPAMTYPE GetType() const override {
        return FRS_3MIN;
    }
    bool ShouldResemblance(const TLoginTime& loginTimeItem) override {
        if (enoght)
            return false;

        n++;
        if (loginTimeItem.time() >= long(t - 180 * n)) {
            if (!loginTimeItem.spam()) {
                return true;
            }
        } else {
            enoght = true;
        }
        return false;
    }
};

struct TIFNamesResemblancer : public IResemblancer {
    const TString iname;
    const TString fname;
    int GetCode() const override {
        return 6;
    }
    TFRODOSPAMTYPE GetType() const override {
        return FRS_COMPAREIFNAMES;
    }
    TIFNamesResemblancer(TString  iname, TString  fname) noexcept
        : iname(std::move(iname))
        , fname(std::move(fname)) {
    }
    bool ShouldResemblance(const TLoginTime& loginTimeItem) override {
        return !loginTimeItem.spam() && loginTimeItem.iname() == iname && loginTimeItem.fname() == fname;
    }
};

struct TPacketTwoResemblancer : public IResemblancer {
    const TPacket packet;
    explicit TPacketTwoResemblancer(const TPacket& packet) noexcept
        : packet(packet) {
    }
    int GetCode() const override {
        return 5;
    }
    TFRODOSPAMTYPE GetType() const override {
        return FRS_PACKETTWO;
    }
    bool ShouldResemblance(const TLoginTime& loginTimeItem) override {
        return !loginTimeItem.spam() && loginTimeItem.packet2() == packet;
    }
};

class CItemStatSet {
private:
    mutable TRWMutex HostNameGeoLock, ListLock;
    TLTList m_pISet;
    THashMap<TString, TLoginTimePtr> LoginIndex;
    TString fhostname;
    TString fgeo;
    std::atomic_bool fspam{};
    TAtomicCounter spam_login_count;
    TAtomicCounter fspam_count;

public:

    CItemStatSet() = default;
    explicit CItemStatSet(TLoginTime value);

    void Init();
    void Update(TLoginTime&& loginTime);
    ui32 GetCount(void) const;
    void Add(TLoginTime t);

    void AddHostName(TString hostname);
    void AddGeo(TString geo);
    void GetGeoAndHost(TString geo, TString hostname);
    TString GetHostName(void) const;
    TString GetGeo() const;

    void SetSpam(bool spam, time_t t, TString login, ui8 weight);

    bool CorrectLogins(TString login, ui32 karma, ui32& lastkarma);
    int LoginInfo(TString login);

    ui64 Spam_count(void) const;

    void Clear(void);

    void AllResemblances(const TKIPv6& Ip, const TVector<THolder<IResemblancer>>& resemblancers, TLTExtList& SpamList);

    size_t size() const;

    TIPStat CalcStatist(time_t regtime, TString PrefixLogin, TString first_nsymb_login, TPackHint passw_hint, TPackHint quest_hint, TPackHint answer_hint, TString iname, TString fname);

    int GetLoginInfo(const TString& login);
};

//******************************************************************************************************************
//                                                    CItemStat
//******************************************************************************************************************

class CItemStat {
private:
    ui16 m_Count;

public:
    CItemStat() {
        Init();
    };
    CItemStat(ui16 value) {
        m_Count = value;
    };
    CItemStat(char* BUFF, ui32 BuffSize) {
        Init();
        if (BuffSize >= sizeof(m_Count))
            memcpy(&m_Count, BUFF, sizeof(m_Count));
    }

    void Init() {
        m_Count = 0;
    };
    void Update(const CItemStat& Stat) {
        m_Count += Stat.m_Count;
    };
    ui16 GetCount(void) {
        return m_Count;
    };
    size_t size() const {
        return sizeof(m_Count);
    }
};

//*******************************************************************************************************************
