#include "tspamonlog.h"

#ifdef WIN32
#include <sys/timeb.h>
#include <io.h>
#include <process.h>
#else
#include <sys/uio.h>
#include <sys/time.h>
#include <unistd.h>
#include <dirent.h>
#endif

//******************************************************************************************************************************************
//                                                       TSpamonLogStruct
//******************************************************************************************************************************************

TSpamonLogStruct::TSpamonLogStruct() {
    Clear();
}

TSpamonLogStruct::~TSpamonLogStruct() {
}

void TSpamonLogStruct::Init(const TString& server_name, const TString& Numbrequest) {
    m_server_name = server_name;
    m_Numbrequest = Numbrequest;
}

void TSpamonLogStruct::Clear() {
    m_server_name = "";
    m_Numbrequest = "";
    srvc_tags.clear();
}

TString PrintTimeStr() {
    char tbuff[128];
    char pidstr[32];
    int count = 0;

    memset(tbuff, 0, sizeof(tbuff));
    memset(pidstr, 0, sizeof(pidstr));

#ifdef WIN32
    char* timeline;
    struct _timeb timebuffer;
    _ftime(&timebuffer);
    timeline = ctime(&(timebuffer.time));
    if ((sizeof(tbuff) - count - 1) > 0)
        count += snprintf(tbuff + count, sizeof(tbuff) - count - 1, "%.15s.%03hu - ", &timeline[4], timebuffer.millitm);

#else // if SYSTEM_UNIX
    struct timeval tv;
    gettimeofday(&tv, NULL);
    time_t sec = (time_t)tv.tv_sec;
    char* timeline = ctime(&sec);
    if ((sizeof(tbuff) - count - 1) > 0)
        count += snprintf(tbuff + count, sizeof(tbuff) - count - 1, "%.15s.%.03lu - ", &timeline[4], tv.tv_usec / 1000);

#endif

    if ((sizeof(tbuff) - count - 1) > 0)
        count += snprintf(tbuff + count, sizeof(tbuff) - count - 1, " %s", GetStrPid(pidstr));

    return TString(tbuff);
}

void TSpamonLogStruct::AddTag(const TString& srvc, const TString& func, TSpamonLogStruct::TError error, ui32 tick) {
    TString text = "";
    TString error_text = "";

    switch (error) {
        case TSpamonLogStruct::OK:
            error_text = "OK";
            break;
        case TSpamonLogStruct::CODE400:
            error_text = "HTP-RC400";
            break;
        case TSpamonLogStruct::CODE500:
            error_text = "HTP-RC500";
            break;
        case TSpamonLogStruct::LOST:
            error_text = "HTP-RC410";
            break;
        case TSpamonLogStruct::LMT:
            error_text = "HTP-RC509";
            break;
        case TSpamonLogStruct::CE:
            error_text = "HTP-CE";
            break;
        case TSpamonLogStruct::CT:
            error_text = "HTP-CT";
            break;
        case TSpamonLogStruct::RE:
            error_text = "HTP-RE";
            break;
        case TSpamonLogStruct::RT:
            error_text = "HTP-RT";
            break;
        case TSpamonLogStruct::BAD_RESPONSE:
            error_text = "BRS";
            break;

        case TSpamonLogStruct::OTHERERR:
            error_text = "OE";
            break;
        default:
            error_text = "???";
    };

    text += "<" + srvc + ":" + func + "," + IntToStroka(tick) + "," + error_text + ",F,127.0.0.1>";
    srvc_tags.push_back(text);
    }

TString TSpamonLogStruct::GetDataLog(ui32 func_time) {
    TString res = "";
    std::list<TString>::iterator it;

    res = PrintTimeStr() + " '" + m_server_name + "' FRODO '" + m_Numbrequest + "' <VERS,1.000,0><FUNC:TIME," + IntToStroka(func_time) + ",OK,F,0.0.0.0>";
    it = srvc_tags.begin();
    while (it != srvc_tags.end()) {
        res += (*it);

        ++it;
    }

    return res;
}

//******************************************************************************************************************************************
