#pragma once

#ifdef WIN32
#   include <windows.h>
#else
#   include <sys/types.h>
#   include <time.h>
#   include <sys/resource.h>
#endif

#include <util/generic/string.h>
#include "util/system/mutex.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>

//******************************************************************************************************************************************
//                                                       TSpamonLogStruct
//******************************************************************************************************************************************

//FRODO:LG    - longs storage get
//FRODO:QA    - async queue add
//FRODO:QWL   - async queue write lost request to log
//FRODO:QG    - async queue get
//FRODO:ACHK  - frodo async check
//FRODO:LRCPT - login receipt
//FRODO:INCHK - check in
//FRODO:BBX   - request to blackbox
//FRODO:PDD   - request to pdd
//FRODO:ML    - request to ML
//FRODO:SPST  - request to spamstat
//FRODO:GEO   - request to geo
//FRODO:RBL   - rbl ruls (COMBINED_BL and other)

class TSpamonLogStruct
{
public:
         enum TError {UNKNOWN, OK, CODE400, CODE500, LMT, LOST, CE, CT, RE, RT, BAD_RESPONSE, OTHERERR};
private:
         TString            m_server_name;
         TString            m_Numbrequest;
         std::list<TString> srvc_tags;

public:
         TSpamonLogStruct();
         ~TSpamonLogStruct();

         void     Init(const TString &server_name, const TString &Numbrequest);
         void     Clear();

         void     AddTag(const TString &srvc, const TString &func, TError error, ui32 tick);
         TString   GetDataLog(ui32 func_time);
};

//******************************************************************************************************************************************



