#include "tstoragenosql.h"

//****************************************************************************************************************************************
//                                                       TStorageNoSql
//****************************************************************************************************************************************

TStorageNoSql::TStorageNoSql() {
    m_index = -1;
    m_server_hostname = "";
    m_server_code = "";
    m_server_start_time = "";
    m_server_version = "";
    LogsGroup = NULL;
    configobj = NULL;
    m_storage_name = "";
    m_basa_type_name = "";
    m_otherdata = "";
    m_storage_connect = false;
    m_storage_status = "";
    m_use_putqueue = true;
    m_putqueue = NULL;
    m_liverqst_lastupdate = 0;
}

TStorageNoSql::~TStorageNoSql() {
    if (m_putqueue != NULL) {
        delete m_putqueue;
        m_putqueue = NULL;
    }
}

bool TStorageNoSql::InitBeforeFork_base(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA) {
    bool res = true;
    ui32 traffic_min_treshold = 10000000;
    ui32 traffic_max_treshold = 20000000;
    bool no_control_traffic = false;

    m_index = index;

    m_server_hostname = server_hostname;
    m_server_code = server_code;
    m_server_start_time = server_start_time;
    m_server_version = server_version;
    LogsGroup = LogsGroupA;
    configobj = configobjA;
    if (configobj != NULL) {
        traffic_min_treshold = configobj->ReadInteger("storage_" + IntToStroka(index), "traffic_min_treshold", 10000000);
        traffic_max_treshold = configobj->ReadInteger("storage_" + IntToStroka(index), "traffic_max_treshold", 20000000);
        no_control_traffic = configobj->ReadBool("storage_" + IntToStroka(index), "no_control_traffic", false);

        m_use_putqueue = configobj->ReadBool("update_queue", "enable", true);
        m_use_longstorecache = configobj->ReadBool("storcache", "enable", true);
    }
    TRControl.Init(traffic_min_treshold, traffic_max_treshold, !no_control_traffic);

    //cache long basa
    m_longstor_cache.Init(m_use_longstorecache, LogsGroupA, configobjA);

    m_traccert_driver.Init();

    return res;
}

void TStorageNoSql::InitAfterFork_base() {
    if (m_use_putqueue) {
        m_putqueue = new TUpdateQueueMain();
        if (m_putqueue != NULL)
            m_putqueue->Init(this, configobj);
    }
}

void TStorageNoSql::StoragesClose() {
}

bool TStorageNoSql::Midnight() {
    bool res = true;

    m_traccert_driver.Midnight();
    webstat.Midnight();
    if (m_putqueue != NULL)
        m_putqueue->Midnight();
    m_longstor_cache.Midnight();

    TGuard<TMutex> g(m_LiveRqstMutex);
    m_liverqst_yesterday_stat_master = m_liverqst_today_stat_master;
    m_liverqst_today_stat_master.Clear();
    m_liverqst_yesterday_stat_replica = m_liverqst_today_stat_replica;
    m_liverqst_today_stat_replica.Clear();

    return res;
}

void TStorageNoSql::EventTick() {
    m_longstor_cache.EventTick();
    LiveRqstUpdate();
}

void TStorageNoSql::Shutdown() {
}

TString TStorageNoSql::GetCollectionName(TShingleStorageType sstype, int /*type*/) {
    TString res = "";

    switch (sstype) {
        case SST_LONGSTAT:
            res = TString(LONGSTAT_COLLECTION);
            break;
        case SST_STAT:
            res = TString(STAT_COLLECTION);
            break;
    };

    return res;
};

void TStorageNoSql::IncrementStat(TShingleStorageType sstype, bool /*res*/) {
    switch (sstype) {
        case SST_LONGSTAT:
            /*if (res)
                                    m_good_shinww_storage.Increment();
                                 else
                                    m_error_shinww_storage.Increment();*/

            break;
        case SST_STAT:
            /*if (res)
                                    m_good_stat_storage.Increment();
                                 else
                                    m_error_stat_storage.Increment();*/
            break;
    };
};

void TStorageNoSql::AddStorageStat(TShingleStorageType stortype, TStorageActionType acttype, int count, NStorageStats::TSRSErrType good, ui32 tick) {
    NStorageStats::TStorageRequestStat::TStorageActionType acttype_cnv = NStorageStats::TStorageRequestStat::SAT_UPDATE;

    switch (acttype) {
        case SAT_UPDATE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_UPDATE;
            break;
        case SAT_FINDONE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_FINDONE;
            break;
        case SAT_ERASE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_ERASE;
            break;
        case SAT_SIZE:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_SIZE;
            break;
        case SAT_MULTYACTION:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_MULTYACTION;
            break;
        case SAT_FIND:
            acttype_cnv = NStorageStats::TStorageRequestStat::SAT_FIND;
            break;
    };

    switch (stortype) {
        case SST_LONGSTAT:
            webstat.AddCount(TString(DATABASE_NAME), TString(LONGSTAT_COLLECTION), acttype_cnv, count, good, tick);
            monstat.AddCount(TString(DATABASE_NAME), TString(LONGSTAT_COLLECTION), acttype_cnv, count, good, tick);
            break;
        case SST_STAT:
            webstat.AddCount(TString(DATABASE_NAME), TString(STAT_COLLECTION), acttype_cnv, count, good, tick);
            monstat.AddCount(TString(DATABASE_NAME), TString(STAT_COLLECTION), acttype_cnv, count, good, tick);
            break;
    };
}

TStorageInfoFull TStorageNoSql::GetStorageFullInfo() {
    TStorageInfoFull res;

    res.basatypename = GetBasaTypeName();
    res.storageident = GetStorageIdent();

    return res;
}

i64 UI64ToI64(ui64 value) {
    i64 res = 0;

    memcpy(&res, &value, sizeof(value));

    return res;
}

bool TStorageNoSql::WriteConsoleDataToStorage(ui64 shingle, nosql::HashMap& sets) {
    bool res = false;
    nosql::HashMap incrs;
    bool err = false;

    if (m_storage_connect)
        res = StorageUpdate(shingle, 0, SST_STAT, incrs, sets, err);

    return res;
}

bool TStorageNoSql::ReadConsoleDataFromStorage(TConsoleStatDataList& srv_list) {
    bool res = false;
    bool err = false;
    TVector<nosql::HashMap> hashes;
    TVector<nosql::HashMap>::const_iterator it;
    TConsoleStatData cs_data;
    TString errstr_ext = "";

    res = StorageFind(SST_STAT, hashes, err);
    if (res) {
        it = hashes.begin();
        while (it != hashes.end()) {
            if ((*it).size() > 0) {
                cs_data.Clear();
                errstr_ext = "";
                if (cs_data.ParseRequestFromStorage(*it, errstr_ext)) {
                    srv_list.push_back(cs_data);

                } else {
                    if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
                        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "CONSOLE_STAT: err='%s' [%s]", errstr_ext.c_str(), nosql::HashMapToStrokaBase(*it).c_str());
                }
            }

            ++it;
        }
    }

    return res;
}

bool TStorageNoSql::StorageInitStatus(TString& status) {
    status = m_storage_status;
    return m_storage_connect;
}

i64 TStorageNoSql::GetStorageSize() {
    i64 res = 0;
    bool err = false;

    res = StorageSize(0, SST_LONGSTAT, err);
    if (err)
        res = 0;

    return res;
}

void TStorageNoSql::GetLongDataFltr(frodo_st::TStorageData& longdata, const TString& Numbrequest, TGetStorStat& err_stat) {
    TStorageActionList sactlist;
    bool cache_exists = false;
    frodo_st::TStorageDataItem cache_data;
    bool err = false;
    ui32 tick = 0;

    err_stat.Clear();
    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        longdata.m_data[i].m_err = false;
        longdata.m_data[i].m_tick = 0;
        longdata.m_data[i].m_in_cache = false;
        longdata.m_data[i].nosqldata.clear();

        if (longdata.m_data[i].m_rec_shingle != 0) {
            if ((m_use_longstorecache) && (m_longstor_cache.GetCacheMode() == TLongBasaCache::CM_ALL)) {
                cache_exists = false;
                cache_data.Clear();

                cache_data = m_longstor_cache.Get(longdata.m_data[i].m_rec_shingle, cache_exists);
                if (cache_exists) {
                    if (cache_data.m_stordata_type != longdata.m_data[i].m_rec_stordata_type) {
                        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "CACHESTOR: collision data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());

                    } else {
                        longdata.m_data[i].m_in_cache = true;
                        longdata.m_data[i].m_stordata = cache_data;
                    }
                }
            }

            if (!longdata.m_data[i].m_in_cache) {
                err_stat.needstor_count = IncMax32(err_stat.needstor_count, 1);
                longdata.m_data[i].nosqldata = TNoSqlItem(longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_stordata_type);
                sactlist.push_back(TStorageActionItem(SAT_FINDONE, SST_LONGSTAT, &longdata.m_data[i].nosqldata, &longdata.m_data[i].m_err, &longdata.m_data[i].m_tick));
            }
        }
    }

    tick = CShingleTime::GetMs();

    StorageMultiAction(sactlist, err);

    tick = CShingleTime::GetMs() - tick;

    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        if (longdata.m_data[i].m_rec_shingle != 0) {
            err_stat.allstor_count = IncMax32(err_stat.allstor_count, 1);
            if (longdata.m_data[i].m_err) {
                err_stat.errstor_count = IncMax32(err_stat.errstor_count, 1);

                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: read data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());

                //find in cache
                if ((m_use_longstorecache) && (m_longstor_cache.GetCacheMode() == TLongBasaCache::CM_BYERR)) {
                    cache_exists = false;
                    cache_data.Clear();

                    cache_data = m_longstor_cache.Get(longdata.m_data[i].m_rec_shingle, cache_exists);
                    if (cache_exists) {
                        if (cache_data.m_stordata_type != longdata.m_data[i].m_rec_stordata_type) {
                            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "CACHESTOR: collision data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());

                            err_stat.errstor_and_findcache_collision = IncMax32(err_stat.errstor_and_findcache_collision, 1);

                        } else {
                            longdata.m_data[i].m_in_cache = true;
                            longdata.m_data[i].m_stordata = cache_data;

                            err_stat.errstor_and_findcache = IncMax32(err_stat.errstor_and_findcache, 1);
                        }
                    } else {
                        err_stat.errstor_and_nocache = IncMax32(err_stat.errstor_and_nocache, 1);
                    }
                }

            } else {
                if (!longdata.m_data[i].m_in_cache) {
                    longdata.m_data[i].m_stordata.Clear();
                    if (!longdata.m_data[i].nosqldata.Empty()) {
                        frodo_st::TStorageDataItemSerialization::Deserialize(longdata.m_data[i].nosqldata.hash, longdata.m_data[i].m_stordata);
                        if (!longdata.m_data[i].m_stordata.Empty()) {
                            if (longdata.m_data[i].m_stordata.m_stordata_type != longdata.m_data[i].m_rec_stordata_type) {
                                err_stat.okstor_and_find_collision = IncMax32(err_stat.okstor_and_find_collision, 1);

                                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: collision data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());
                                longdata.m_data[i].m_stordata.Clear();
                                longdata.m_data[i].m_stordata.is_collision = true;

                            } else {
                                err_stat.okstor_and_find = IncMax32(err_stat.okstor_and_find, 1);

                                //add to cache
                                if (m_use_longstorecache)
                                    m_longstor_cache.Add(longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_stordata);
                            }
                        }
                    } else {
                        err_stat.okstor_and_empty = IncMax32(err_stat.okstor_and_empty, 1);
                    }
                }
            }
        }
    }

    if ((LogsGroup != NULL) && (LogsGroup->GetLogTrace() != NULL))
        LogsGroup->GetLogTrace()->WriteMessageAndData("%s LONGSTORSTAT: %u %s", Numbrequest.c_str(), tick, err_stat.PrintToLog().c_str());
}

void TStorageNoSql::GetLongDataStorage(frodo_st::TStorageData& longdata, const TString& Numbrequest) {
    TStorageActionList sactlist;
    bool err = false;

    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        longdata.m_data[i].m_err = false;
        longdata.m_data[i].m_tick = 0;
        longdata.m_data[i].m_in_cache = false;
        longdata.m_data[i].nosqldata.clear();

        if (longdata.m_data[i].m_rec_shingle != 0) {
            longdata.m_data[i].nosqldata = TNoSqlItem(longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_stordata_type);
            sactlist.push_back(TStorageActionItem(SAT_FINDONE, SST_LONGSTAT, &longdata.m_data[i].nosqldata, &longdata.m_data[i].m_err, &longdata.m_data[i].m_tick));
        }
    }

    StorageMultiAction(sactlist, err);

    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        if (longdata.m_data[i].m_rec_shingle != 0) {
            if (longdata.m_data[i].m_err) {
                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: read data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());

            } else {
                longdata.m_data[i].m_stordata.Clear();
                if (!longdata.m_data[i].nosqldata.Empty()) {
                    frodo_st::TStorageDataItemSerialization::Deserialize(longdata.m_data[i].nosqldata.hash, longdata.m_data[i].m_stordata);
                    if (!longdata.m_data[i].m_stordata.Empty()) {
                        if (longdata.m_data[i].m_stordata.m_stordata_type != longdata.m_data[i].m_rec_stordata_type) {
                            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: collision data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());
                            longdata.m_data[i].m_stordata.Clear();
                            longdata.m_data[i].m_stordata.is_collision = true;

                        } else {
                        }
                    }
                }
            }
        }
    }
}

void TStorageNoSql::GetLongDataCache(frodo_st::TStorageData& longdata, const TString& Numbrequest) {
    TStorageActionList sactlist;
    bool cache_exists = false;
    frodo_st::TStorageDataItem cache_data;

    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        longdata.m_data[i].m_err = false;
        longdata.m_data[i].m_tick = 0;
        longdata.m_data[i].m_in_cache = false;
        longdata.m_data[i].nosqldata.clear();

        if (longdata.m_data[i].m_rec_shingle != 0) {
            if (m_use_longstorecache) {
                cache_exists = false;
                cache_data.Clear();

                cache_data = m_longstor_cache.Get(longdata.m_data[i].m_rec_shingle, cache_exists);
                if (cache_exists) {
                    if (cache_data.m_stordata_type != longdata.m_data[i].m_rec_stordata_type) {
                        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "CACHESTOR: collision data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());

                    } else {
                        longdata.m_data[i].m_in_cache = true;
                        longdata.m_data[i].m_stordata = cache_data;
                    }
                }
            }
        }
    }
}

void TStorageNoSql::UpdateLongDataDirect(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, TKTypeSpam spamt) {
    TStorageActionList sactlist;
    bool err = false;

    for (auto& i : longdata.m_data) {
        i.nosqldata.clear();
        if (i.m_rec_shingle != 0) {
            i.nosqldata = TNoSqlItem(i.m_rec_shingle, i.m_rec_stordata_type);
            if (!i.m_stordata.IsCollision()) {
                i.nosqldata.sets[FIELD_LASTDAY] = static_cast<ui32>(day);
                i.nosqldata.sets[FIELD_TYPE] = i.m_rec_stordata_type;
                i.nosqldata.sets[FIELD_SOURCE] = i.m_rec_source;

                switch (spamt) {
                    case KHAM0:
                        if (is_incrs)
                            i.nosqldata.incrs[FIELD_HAM] = 1;
                        else
                            i.nosqldata.sets[FIELD_HAM] = 1;
                        break;
                    case KSPAM85:
                        if (is_incrs)
                            i.nosqldata.incrs[FIELD_SPAM85] = 1;
                        else
                            i.nosqldata.sets[FIELD_SPAM85] = 1;
                        break;
                    case KSPAM100:
                        if (is_incrs)
                            i.nosqldata.incrs[FIELD_SPAM100] = 1;
                        else
                            i.nosqldata.sets[FIELD_SPAM100] = 1;
                        break;
                };

                sactlist.push_back(TStorageActionItem(SAT_UPDATE, SST_LONGSTAT, &i.nosqldata, &i.m_err, &i.m_tick));
            }
        }
    }

    if (sactlist.size() > 0)
        StorageMultiAction(sactlist, err);

    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        if (longdata.m_data[i].m_rec_shingle != 0) {
            if (longdata.m_data[i].m_err) {
                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: update data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());
            }
        }
    }
}

void TStorageNoSql::UpdateLongDataDirect(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100) {
    TStorageActionList sactlist;
    bool err = false;

    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        longdata.m_data[i].m_err = false;
        longdata.m_data[i].m_tick = 0;
        longdata.m_data[i].nosqldata.clear();
        if (longdata.m_data[i].m_rec_shingle != 0) {
            longdata.m_data[i].nosqldata = TNoSqlItem(longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_stordata_type);
            if (!longdata.m_data[i].m_stordata.IsCollision()) {
                longdata.m_data[i].nosqldata.sets[FIELD_LASTDAY] = static_cast<ui32>(day);
                longdata.m_data[i].nosqldata.sets[FIELD_TYPE] = longdata.m_data[i].m_rec_stordata_type;
                longdata.m_data[i].nosqldata.sets[FIELD_SOURCE] = longdata.m_data[i].m_rec_source;

                if (is_incrs) {
                    if (ham != 0)
                        longdata.m_data[i].nosqldata.incrs[FIELD_HAM] = ham;

                    if (spam85 != 0)
                        longdata.m_data[i].nosqldata.incrs[FIELD_SPAM85] = spam85;

                    if (spam100 != 0)
                        longdata.m_data[i].nosqldata.incrs[FIELD_SPAM100] = spam100;

                } else {
                    i32 ham_v = 0, spam85_v = 0, spam100_v = 0;

                    if (ham < 0)
                        ham_v = 0;
                    else if (ham > 2000000000)
                        ham_v = 2000000000;
                    else
                        ham_v = ham;
                    longdata.m_data[i].nosqldata.sets[FIELD_HAM] = ham_v;

                    if (spam85 < 0)
                        spam85_v = 0;
                    else if (spam85 > 2000000000)
                        spam85_v = 2000000000;
                    else
                        spam85_v = spam85;
                    longdata.m_data[i].nosqldata.sets[FIELD_SPAM85] = spam85_v;

                    if (spam100 < 0)
                        spam100_v = 0;
                    else if (spam100 > 2000000000)
                        spam100_v = 2000000000;
                    else
                        spam100_v = spam100;
                    longdata.m_data[i].nosqldata.sets[FIELD_SPAM100] = spam100_v;
                }

                sactlist.push_back(TStorageActionItem(SAT_UPDATE, SST_LONGSTAT, &longdata.m_data[i].nosqldata, &longdata.m_data[i].m_err, &longdata.m_data[i].m_tick));
            }
        }
    }

        if (sactlist.size() > 0)
        StorageMultiAction(sactlist, err);

    for (size_t i = 0; i < frodo_st::SDT_END; i++) {
        if (longdata.m_data[i].m_rec_shingle != 0) {
            if (longdata.m_data[i].m_err) {
                if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                    LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: update2 data error 0x%016llx '%s' (%s)", longdata.m_data[i].m_rec_shingle, longdata.m_data[i].m_rec_source.c_str(), Numbrequest.c_str());
            }
        }
    }
}

void TStorageNoSql::UpdateLongData(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, TKTypeSpam spamt) {
    if (m_use_putqueue) {
        if (m_putqueue != NULL)
            m_putqueue->AddRecord(TUpdateQueueRecord(is_incrs, longdata, Numbrequest, day, spamt));

    } else
        UpdateLongDataDirect(is_incrs, longdata, Numbrequest, day, spamt);
}

void TStorageNoSql::UpdateLongData(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100) {
    if (m_use_putqueue) {
        if (m_putqueue != NULL)
            m_putqueue->AddRecord(TUpdateQueueRecord(is_incrs, longdata, Numbrequest, day, ham, spam85, spam100));

    } else
        UpdateLongDataDirect(is_incrs, longdata, Numbrequest, day, ham, spam85, spam100);
}

void TStorageNoSql::GetLongDataByShingleStorage(ui64 shingle, frodo_st::TStorageDataItemExt& value, const TString& Numbrequest) {
    TStorageActionList sactlist;
    bool err = false;

    value.Clear();
    value.m_rec_shingle = shingle;

    value.nosqldata.clear();
    if (value.m_rec_shingle != 0) {
        value.nosqldata = TNoSqlItem(value.m_rec_shingle, frodo_st::SDT_END);

        sactlist.push_back(TStorageActionItem(SAT_FINDONE, SST_LONGSTAT, &value.nosqldata, &value.m_err, &value.m_tick));
    }

        if (sactlist.size() > 0)
        StorageMultiAction(sactlist, err);

    if (value.m_err) {
        if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
            LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: read data error 0x%016llx '%s' (%s)", value.m_rec_shingle, value.m_rec_source.c_str(), Numbrequest.c_str());

    } else {
        value.m_stordata.Clear();
        if (!value.nosqldata.Empty())
            frodo_st::TStorageDataItemSerialization::Deserialize(value.nosqldata.hash, value.m_stordata);
    }
}

void TStorageNoSql::GetLongDataByShingleCache(ui64 shingle, frodo_st::TStorageDataItemExt& value, const TString& /*Numbrequest*/) {
    bool exists = false;
    frodo_st::TStorageDataItem resdata;

    value.Clear();
    value.m_rec_shingle = shingle;

    value.nosqldata.clear();
    if (value.m_rec_shingle != 0) {
        if (m_use_longstorecache) {
            resdata = m_longstor_cache.Get(value.m_rec_shingle, exists);
            if (exists)
                value.m_stordata = resdata;
        }
    }
}

void TStorageNoSql::UpdateLongDataByShingle(frodo_st::TStorageDataItemExt& value, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100) {
    TStorageActionList sactlist;
    bool err = false;

    value.nosqldata.clear();
    if (value.m_rec_shingle != 0) {
        value.nosqldata = TNoSqlItem(value.m_rec_shingle, value.m_rec_stordata_type);

        value.nosqldata.sets[FIELD_LASTDAY] = static_cast<ui32>(day);
        value.nosqldata.sets[FIELD_TYPE] = value.m_rec_stordata_type;
        value.nosqldata.sets[FIELD_SOURCE] = value.m_rec_source;

        if (ham != 0)
            value.nosqldata.incrs[FIELD_HAM] = ham;

        if (spam85 != 0)
            value.nosqldata.incrs[FIELD_SPAM85] = spam85;

        if (spam100 != 0)
            value.nosqldata.incrs[FIELD_SPAM100] = spam100;

        sactlist.push_back(TStorageActionItem(SAT_UPDATE, SST_LONGSTAT, &value.nosqldata, &value.m_err, &value.m_tick));
    }

    if (sactlist.size() > 0)
        StorageMultiAction(sactlist, err);

    if (value.m_rec_shingle != 0) {
        if (value.m_err) {
            if ((LogsGroup != NULL) && (LogsGroup->GetStorageLog() != NULL))
                LogsGroup->GetStorageLog()->WriteMessageAndDataStatus(KERROR, "STOR: update data error 0x%016llx '%s' (%s)", value.m_rec_shingle, value.m_rec_source.c_str(), Numbrequest.c_str());
        }
    }
}

TString TStorageNoSql::GetPutQueueMonStatistik() {
    TString res = "";

    if ((m_use_putqueue) && (m_putqueue != NULL))
        res = m_putqueue->GetMonStatistik();

    return res;
}

qustat::TDriverRqstPoolStatFour TStorageNoSql::GetConsoleStat() {
    qustat::TDriverRqstPoolStatFour res;

    if ((m_use_putqueue) && (m_putqueue != NULL))
        res = m_putqueue->GetConsoleStat();

    return res;
}

TString TStorageNoSql::GetPutQueueProperties() {
    TString res = "";

    if (m_putqueue != NULL)
        res = m_putqueue->GetProperties();
    else
        res = "Put queue disabled!";

    return res;
}

TString TStorageNoSql::GetUpdateQueueWebStatistik() {
    TString res = "";

    if ((m_use_putqueue) && (m_putqueue != NULL))
        res = m_putqueue->PrintWebStatistik();

    return res;
}

void TStorageNoSql::LiveRqstUpdate() {
    TGuard<TMutex> g(m_LiveRqstMutex);

    time_t currtime = time(NULL);
    qustat::TDriverRqstPoolStat data_from_drv_master;
    qustat::TDriverRqstPoolStat data_from_drv_replica;

    data_from_drv_master = ReturnLiveRqstStatMaster();
    data_from_drv_replica = ReturnLiveRqstStatReplica();

    if ((currtime > m_liverqst_lastupdate) && ((currtime - m_liverqst_lastupdate) >= 15)) {
        m_liverqst_current_stat_master.Clear();
        m_liverqst_current_stat_replica.Clear();
        m_liverqst_lastupdate = currtime;
    }

    m_liverqst_current_stat_master += data_from_drv_master;
    m_liverqst_today_stat_master += data_from_drv_master;

    m_liverqst_current_stat_replica += data_from_drv_replica;
    m_liverqst_today_stat_replica += data_from_drv_replica;
}

void TStorageNoSql::GetLiveRqstDataMaster(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat) {
    liverqst_current_stat = m_liverqst_current_stat_master;
    liverqst_today_stat = m_liverqst_today_stat_master;
    liverqst_yesterday_stat = m_liverqst_yesterday_stat_master;
}

void TStorageNoSql::GetLiveRqstDataReplica(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat) {
    liverqst_current_stat = m_liverqst_current_stat_replica;
    liverqst_today_stat = m_liverqst_today_stat_replica;
    liverqst_yesterday_stat = m_liverqst_yesterday_stat_replica;
}

TString TStorageNoSql::GetLiveRqstData(bool is_master) {
    TString res = "";
    qustat::TDriverRqstPoolStat liverqst_current_stat;
    qustat::TDriverRqstPoolStat liverqst_today_stat;
    qustat::TDriverRqstPoolStat liverqst_yesterday_stat;

    if (is_master)
        GetLiveRqstDataMaster(liverqst_current_stat, liverqst_today_stat, liverqst_yesterday_stat);
    else
        GetLiveRqstDataReplica(liverqst_current_stat, liverqst_today_stat, liverqst_yesterday_stat);

    if (is_master)
        res += "<br><i><b>Request live time statistik (master):</b></i>&nbsp;&nbsp;";
    else
        res += "<br><i><b>Request live time statistik (replica):</b></i>&nbsp;&nbsp;";
    res += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor='#ffffcc'>";

    res += "<tr align='center' bgcolor='DarkKhaki'>";
    res += "<td width='30%'>&nbsp;</td>";
    res += "<td width='9%'><b>0..10</b></td>";
    res += "<td width='9%'><b>10..20</b></td>";
    res += "<td width='9%'><b>20..50</b></td>";
    res += "<td width='9%'><b>50..100</b></td>";
    res += "<td width='9%'><b>100..150</b></td>";
    res += "<td width='9%'><b>150..190</b></td>";
    res += "<td width='8%'><b>190..500</b></td>";
    res += "<td width='8%'><b>more 500</b></td>";
    res += "</tr>";

    res += "<tr align='right'>";
    res += "<td>current request live</td>";
    res += "<td>" + liverqst_current_stat.GetCount_0_10_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_10_20_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_20_50_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_50_100_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_100_150_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_150_190_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_190_500_s() + "</td>";
    res += "<td>" + liverqst_current_stat.GetCount_MORE500_s() + "</td>";
    res += "</tr>";

    res += "<tr align='right'>";
    res += "<td>today request live</td>";
    res += "<td>" + liverqst_today_stat.GetCount_0_10_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_10_20_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_20_50_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_50_100_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_100_150_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_150_190_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_190_500_s() + "</td>";
    res += "<td>" + liverqst_today_stat.GetCount_MORE500_s() + "</td>";
    res += "</tr>";

    res += "<tr align='right'>";
    res += "<td>yesterday request live</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_0_10_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_10_20_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_20_50_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_50_100_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_100_150_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_150_190_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_190_500_s() + "</td>";
    res += "<td>" + liverqst_yesterday_stat.GetCount_MORE500_s() + "</td>";
    res += "</tr>";

    res += "</table>";

    return res;
}

//****************************************************************************************************************************************
