#pragma once

#include "util/generic/hash.h"
#include "util/generic/vector.h"
#include "util/system/mutex.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/string/util.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/tools/so-common/tkipv6.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/tkconfig.h>
#include <mail/so/spamstop/tools/so-clients/ktime.h>
#include <mail/so/spamstop/tools/so-clients/kshingle.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/so-common/tstoragerequeststat.h>
#include "tstoragetypes.h"
#include <list>
#include "tdelaysquantile.h"
#include <mail/so/spamstop/tools/so-clients/functional_clients/UserReputClient.h>
#include "tconsolestat.h"
#include "tkclasses.h"
#include <mail/so/spamstop/tools/fcgiserver_base/sotypes.h>
#include "tshortipstorage.h"
#include "sofilter.h"
#include "tupdatequeue.h"
#include "tlongbasacache.h"
#include "kqueuestat.h"

#define DATABASE_NAME "FRODOOBORONA"
#define LONGSTAT_COLLECTION "LONGSTAT"
#define STAT_COLLECTION "GENSTAT"

//****************************************************************************************************************************************
//                                                       TStorageNoSql
//****************************************************************************************************************************************

class TStorageNoSql {
public:
    enum ERRTYPE { ER_GOOD,
                   ER_ERROR,
                   ER_POOLTIMEOUT,
                   ER_SENDTIMEOUT,
                   ER_RCVTIMEOUT,
                   ER_UNKNOWN };

public:
    int m_index;
    TString m_storage_name;
    TString m_basa_type_name;
    TLogsGroup* LogsGroup;
    TKConfig* configobj;
    TTrafficControl TRControl;
    bool m_storage_connect;
    TString m_storage_status;

    TString m_server_hostname;
    TString m_server_code;
    TString m_server_start_time;
    TString m_server_version;
    TString m_otherdata;

    TLongBasaCache m_longstor_cache;
    TUpdateQueueMain* m_putqueue;
    bool m_use_putqueue;
    bool m_use_longstorecache;

    NStorageStats::TStorageRequestStatMain webstat;
    NStorageStats::TStorageRequestStatMain monstat;

    trcstat::TTraccertStat m_traccert_driver;

    ui32 m_liverqst_lastupdate;
    qustat::TDriverRqstPoolStat m_liverqst_current_stat_master;
    qustat::TDriverRqstPoolStat m_liverqst_today_stat_master;
    qustat::TDriverRqstPoolStat m_liverqst_yesterday_stat_master;
    qustat::TDriverRqstPoolStat m_liverqst_current_stat_replica;
    qustat::TDriverRqstPoolStat m_liverqst_today_stat_replica;
    qustat::TDriverRqstPoolStat m_liverqst_yesterday_stat_replica;
    TMutex m_LiveRqstMutex;
    void LiveRqstUpdate();

    TString GetCollectionName(TShingleStorageType sstype, int type);
    void IncrementStat(TShingleStorageType sstype, bool res);
    void AddStorageStat(TShingleStorageType stortype, TStorageActionType acttype, int count, NStorageStats::TSRSErrType good, ui32 tick);

    //������� ������ � �����
    virtual bool StorageUpdate(ui64 shingle, int type, TShingleStorageType sstype, const nosql::HashMap& incrs, const nosql::HashMap& sets, bool& err) = 0;
    virtual bool StorageFindOne(ui64 shingle, int type, TShingleStorageType sstype, nosql::HashMap& hash, bool& err) = 0;
    virtual bool StorageFind(TShingleStorageType sstype, TVector<nosql::HashMap>& hashes, bool& err) = 0;
    virtual bool StorageErase(ui64 shingle, int type, TShingleStorageType sstype, bool& err) = 0;
    virtual i64 StorageSize(int type, TShingleStorageType sstype, bool& err) = 0;
    virtual void StorageMultiAction(TStorageActionList& actlist, bool& err) = 0;
    virtual TString ReturnDriverProp() = 0;
    virtual qustat::TDriverRqstPoolStat ReturnLiveRqstStatMaster() = 0;
    virtual qustat::TDriverRqstPoolStat ReturnLiveRqstStatReplica() = 0;

public:
    TStorageNoSql();
    virtual ~TStorageNoSql();

    virtual bool InitBeforeFork(const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA) = 0;
    virtual bool InitBeforeForkNum(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA) = 0;
    virtual void InitAfterFork() = 0;

    int GetIndex() {
        return m_index;
    }
    bool InitBeforeFork_base(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroup* LogsGroupA, TKConfig* configobjA);
    void InitAfterFork_base();
    virtual void StoragesClose();
    bool Midnight();
    void EventTick();
    void Shutdown();

    virtual void Save(IOutputStream* s) const = 0;
    virtual void Load(IInputStream* s) = 0;

    TString GetBasaTypeName() {
        return m_basa_type_name;
    }
    TString GetOnlyStorageName() {
        return m_storage_name;
    }
    TString GetStorageIdent() {
        return GetOnlyStorageName() + " (" + GetBasaTypeName() + ")";
    }
    TStorageInfoFull GetStorageFullInfo();

    NStorageStats::TStorageStatVector GetWebStatistik() {
        return webstat.GetWebStat();
    }
    NStorageStats::TStorageStatVector GetMonStatistik() {
        return monstat.GetMonStat();
    }
    TString GetTraccertStat() {
        return m_traccert_driver.GetWebData();
    }

    bool WriteConsoleDataToStorage(ui64 shingle, nosql::HashMap& sets);
    bool ReadConsoleDataFromStorage(TConsoleStatDataList& srv_list);

    bool StorageInitStatus(TString& status);
    i64 GetStorageSize();

    TLongBasaCache::TLongBasaCacheStat GetLongStorCacheStat() {
        return m_longstor_cache.GetStat();
    }
    TString GetLongStorCacheStatS() {
        return m_longstor_cache.GetCacheStatistic();
    }

    TString GetPutQueueMonStatistik();
    qustat::TDriverRqstPoolStatFour GetConsoleStat();
    TString GetPutQueueProperties();
    TString GetUpdateQueueWebStatistik();

    void GetLongDataFltr(frodo_st::TStorageData& longdata, const TString& Numbrequest, TGetStorStat& err_stat);
    void GetLongDataStorage(frodo_st::TStorageData& longdata, const TString& Numbrequest);
    void GetLongDataCache(frodo_st::TStorageData& longdata, const TString& Numbrequest);
    void UpdateLongDataDirect(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, TKTypeSpam spamt);
    void UpdateLongDataDirect(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100);
    void UpdateLongData(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, TKTypeSpam spamt);
    void UpdateLongData(bool is_incrs, frodo_st::TStorageData& longdata, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100);

    void GetLongDataByShingleStorage(ui64 shingle, frodo_st::TStorageDataItemExt& value, const TString& Numbrequest);
    void GetLongDataByShingleCache(ui64 shingle, frodo_st::TStorageDataItemExt& value, const TString& Numbrequest);
    void UpdateLongDataByShingle(frodo_st::TStorageDataItemExt& value, const TString& Numbrequest, kday_t day, i32 ham, i32 spam85, i32 spam100);

    void GetLiveRqstDataMaster(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat);
    void GetLiveRqstDataReplica(qustat::TDriverRqstPoolStat& liverqst_current_stat, qustat::TDriverRqstPoolStat& liverqst_today_stat, qustat::TDriverRqstPoolStat& liverqst_yesterday_stat);
    TString GetLiveRqstData(bool is_master);
};

//****************************************************************************************************************************************
