#include "tstoragepool.h"
#include "tstoragenosql.h"

TString TSTORAGEPOOLMODEToTString(TSTORAGEPOOLMODE value) {
    TString res = "";

    switch (value) {
        case PM_SINGLE:
            res = "SINGLE";
            break;
        case PM_MOD2:
            res = "MOD2";
            break;
        case PM_MOD3:
            res = "MOD3";
            break;
    };

    return res;
}

//*******************************************************************************************************************************
//                                                 TStoragePool
//*******************************************************************************************************************************

TStoragePool::TStoragePool() {
    m_mode = PM_SINGLE;
    LogsGroup = NULL;
    m_config = NULL;
    m_server_hostname = "";
    m_server_code = "";
    m_server_starttime = "";
    m_server_version = "";
}

bool TStoragePool::InitBeforeFork(TLogsGroupBase* LogsGroupA, TKConfig* configA, const TString& server_hostname, const TString& server_code, const TString& server_starttime, const TString& server_version) {
    bool res = true;
    TString stortype = "";
    TString poolmode = "";

    LogsGroup = (TLogsGroup*)LogsGroupA;
    m_config = configA;

    m_server_hostname = server_hostname;
    m_server_code = server_code;
    m_server_starttime = server_starttime;
    m_server_version = server_version;

    return res;
}

bool TStoragePool::InitAfterFork() {
    bool res = true;
    TStorageNoSqlVectorIt it;
    TString stortype = "";
    TString poolmode = "";
    bool create_skeep_obj = false;
    ui32 create_obj_count = 0;

    if (m_config != NULL) {
        poolmode = m_config->ReadStroka("storpool", "mode", "");
        if (!poolmode.empty()) {
            if (poolmode == "single") {
                m_mode = PM_SINGLE;
                create_skeep_obj = false;

            } else if (poolmode == "mod2") {
                m_mode = PM_MOD2;
                create_skeep_obj = false;

            } else if (poolmode == "mod3") {
                m_mode = PM_MOD3;
                create_skeep_obj = false;
            }
        }

        //storage by number from config
        for (size_t i = 1; i <= 3; i++) {
            if (m_config->SectionExists("storage_" + IntToStroka(i))) {
                stortype = m_config->ReadStroka("storage_" + IntToStroka(i), "stortype", "");
                if (!stortype.empty()) {
                    if ((stortype == "postgre") || (stortype == "POSTGRE") || (stortype == "pgaas") || (stortype == "PGAAS")) {
                        auto m_Storage = MakeAtomicShared<TDataBasaPostgre>();
                        m_Storage->InitBeforeForkNum(i, m_server_hostname, m_server_code, m_server_starttime, m_server_version, LogsGroup, m_config);
                        storage_list.emplace_back(ST_SQL, SHT_NUMBER, i, m_Storage, m_Storage->GetOnlyStorageName());
                        create_obj_count = IncMax32(create_obj_count, 1);
                    } else //stortype == "HASH"
                    {
                        auto m_Storage = MakeAtomicShared<TDataBasaHash>();
                        m_Storage->InitBeforeForkNum(i, m_server_hostname, m_server_code, m_server_starttime, m_server_version, LogsGroup, m_config);
                        storage_list.emplace_back(ST_NOSQL, SHT_NUMBER, i, m_Storage, m_Storage->GetOnlyStorageName());
                        create_obj_count = IncMax32(create_obj_count, 1);
                    }
                }

            }

            if (m_mode == PM_SINGLE) {
                if (create_obj_count == 1)
                    break;

            } else if (m_mode == PM_MOD2) {
                if (create_obj_count == 2)
                    break;

            } else if (m_mode == PM_MOD3) {
                if (create_obj_count == 3)
                    break;
            }
        }

        switch (m_mode) {
            case PM_SINGLE:
                if (create_obj_count < 1)
                    create_skeep_obj = true;
                break;
            case PM_MOD2:
                if (create_obj_count < 2)
                    create_skeep_obj = true;
                break;
            case PM_MOD3:
                if (create_obj_count < 3)
                    create_skeep_obj = true;
                break;
        };
    }

    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            ((*it).storage)->InitAfterFork();
        }

        ++it;
    }

    return res;
}

bool TStoragePool::Midnight() {
    bool res = true;
    bool tres = false;
    TStorageNoSqlVectorIt it;

    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            tres = ((*it).storage)->Midnight();
            if (!tres)
                res = tres;
        }

        ++it;
    }

    return res;
}

bool TStoragePool::Shutdown() {
    bool res = true;
    TStorageNoSqlVectorIt it;

    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            ((*it).storage)->Shutdown();
        }

        ++it;
    }

    return res;
}

void TStoragePool::EventTick() {
    TStorageNoSqlVectorIt it;

    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            ((*it).storage)->EventTick();
        }

        ++it;
    }
}

bool TStoragePool::Close() {
    bool res = true;

    auto it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage)
            ((*it).storage)->StoragesClose();

        ++it;
    }

    return res;
}

TStorageInfoExt& TStoragePool::GetStorageInfo(ui64 /*shingle*/, int /*type*/, ui64 uid, TActivityRequestType /*request_type*/) {
    switch (m_mode) {
        case PM_SINGLE:
            return storage_list.at(0);
        case PM_MOD2:
            return storage_list.at(uid % 2);
        case PM_MOD3:
            return storage_list.at(uid % 3);
    };
}

void TStoragePool::GetStorageStat(TStorageNameStatList& statlist) {
    TStorageNameStat rec;
    TStorageNoSqlVectorIt it;

    statlist.clear();
    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            rec.m_index = ((*it).storage)->GetIndex();
            rec.m_storname = ((*it).storage)->GetStorageIdent();
            rec.m_stortype = ((*it).storage)->GetBasaTypeName();
            //((TStorageNoSql *)(*it).storage)->ReadStatistik(rec.m_stat_list);
            //rec.m_localcachestat = ((TStorageNoSql *)(*it).storage)->LocalCacheGetStat();

            statlist.push_back(rec);
        }

        ++it;
    }
}

TStorageNameStat TStoragePool::GetStatByUID(ui32 uid, bool& notfound) {
    TStorageNameStat res;
    int index = -1;

    notfound = true;
    auto& storinfo = GetStorageInfo(0, -1, uid, AT_UNKNOWN);
    if (storinfo.storage) {
        index = (storinfo.storage)->GetIndex();
        if (index >= 0)
            res = GetStat(index, notfound);
    }

    return res;
}

TStorageNameStat TStoragePool::GetStat(int index, bool& notfound) {
    TStorageNameStat res;
    TStorageNoSqlVectorIt it;

    notfound = true;
    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            if (((*it).storage)->GetIndex() == index) {
                res.m_index = ((*it).storage)->GetIndex();
                res.m_storname = ((*it).storage)->GetStorageIdent();
                res.m_stortype = ((*it).storage)->GetBasaTypeName();
                //((TStorageNoSql *)(*it).storage)->ReadStatistik(res.m_stat_list);
                //res.m_localcachestat = ((TStorageNoSql *)(*it).storage)->LocalCacheGetStat();
                notfound = false;
                break;
            }
        }

        ++it;
    }

    return res;
}

TStorageRequestNameStat TStoragePool::GetRequestStat(int index, bool& notfound) {
    TStorageRequestNameStat res;
    TStorageNoSqlVectorIt it;

    notfound = true;
    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            if (((*it).storage)->GetIndex() == index) {
                res.m_storname = ((*it).storage)->GetStorageIdent();
                res.m_stortype = ((*it).storage)->GetBasaTypeName();
                //res.m_requeststat = ((TStorageNoSql *)(*it).storage)->GetRequestStorageStat();
                notfound = false;
                break;
            }
        }

        ++it;
    }

    return res;
}

TStorageQuantileStat TStoragePool::GetQuantileStat(int index, bool& notfound) {
    TStorageQuantileStat res;
    TStorageNoSqlVectorIt it;

    notfound = true;
    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            if (((*it).storage)->GetIndex() == index) {
                res.m_storname = ((*it).storage)->GetStorageIdent();
                res.m_stortype = ((*it).storage)->GetBasaTypeName();
                //res.m_abuse_quantile      = ((TStorageNoSql *)(*it).storage)->GetAbuseQuantile();
                //res.m_clusterget_quantile = ((TStorageNoSql *)(*it).storage)->GetClusterGetQuantile();
                //res.m_clusterput_quantile = ((TStorageNoSql *)(*it).storage)->GetClusterPutQuantile();
                notfound = false;
                break;
            }
        }

        ++it;
    }

    return res;
}

TStorageInfoFull TStoragePool::GetStorageFullInfo(int index, bool& notfound) {
    TStorageInfoFull res;
    TStorageNoSqlVectorIt it;

    notfound = true;
    it = storage_list.begin();
    while (it != storage_list.end()) {
        if ((*it).storage) {
            if (((*it).storage)->GetIndex() == index) {
                res = ((*it).storage)->GetStorageFullInfo();
                res.info = (*it).info;

                notfound = false;
                break;
            }
        }

        ++it;
    }

    return res;
}

void TStoragePool::GetAllDrivers(std::list<TString>& strlist) {
    strlist.clear();
    for (const auto & i : storage_list)
        strlist.push_back(i.AsText());
}

//*******************************************************************************************************************************
