#pragma once

#include <list>
#include <vector>
#include "util/generic/hash.h"
#include <util/generic/string.h>
#include "util/system/mutex.h"
#include "util/string/util.h"
#include "util/generic/hash.h"
#include "tlogsgroup.h"
#include "tdatabasa_postgre.h"
#include "tdatabasa_hash.h"
#include "tstoragepooltypes.h"
#include <mail/so/spamstop/tools/so-clients/activity/tactivityshinglerenv.h>

//*******************************************************************************************************************************
//                                                 TStorageNameStat
//*******************************************************************************************************************************

struct TStorageNameStat {
    int m_index;
    TString m_storname;
    TString m_stortype;

    TStorageNameStat() {
        m_index = -1;
        m_storname = "";
        m_stortype = "";
    }
};

typedef std::list<TStorageNameStat> TStorageNameStatList;
typedef TStorageNameStatList::iterator TStorageNameStatListIt;

//*******************************************************************************************************************************
//                                                 TStorageQuantileStat
//*******************************************************************************************************************************

struct TStorageQuantileStat {
    TString m_storname;
    TString m_stortype;
    TString m_abuse_quantile;
    TString m_clusterget_quantile;
    TString m_clusterput_quantile;

    TStorageQuantileStat() {
        Clear();
    }

    void Clear() {
        m_storname = "";
        m_stortype = "";
        m_abuse_quantile = "";
        m_clusterget_quantile = "";
        m_clusterput_quantile = "";
    }
};

//*******************************************************************************************************************************
//                                                 TStorageRequestNameStat
//*******************************************************************************************************************************

struct TStorageRequestNameStat {
    TString m_storname;
    TString m_stortype;
    //TDataBasaStat m_requeststat;

    TStorageRequestNameStat() {
        Clear();
    }

    void Clear() {
        m_storname = "";
        m_stortype = "";
    }
};

//*******************************************************************************************************************************
//                                                 TStoragePool
//*******************************************************************************************************************************

enum TSTORAGEPOOLMODE { PM_SINGLE,
                        PM_MOD2,
                        PM_MOD3 };

TString TSTORAGEPOOLMODEToTString(TSTORAGEPOOLMODE value);


typedef std::vector<TStorageInfoExt> TStorageNoSqlVector;
typedef TStorageNoSqlVector::iterator TStorageNoSqlVectorIt;

class TStoragePool {
private:
    TSTORAGEPOOLMODE m_mode;
    TStorageNoSqlVector storage_list;
    TLogsGroup* LogsGroup;
    TKConfig* m_config;

    TString m_server_hostname;
    TString m_server_code;
    TString m_server_starttime;
    TString m_server_version;

public:
    inline void Save(IOutputStream* s) const {
        ::Save(s, storage_list);
    }

    inline void Load(IInputStream* s) {
        ::Load(s, storage_list);
    }
    TStoragePool();

    bool InitBeforeFork(TLogsGroupBase* LogsGroupA, TKConfig* configA, const TString& server_hostname, const TString& server_code, const TString& server_starttime, const TString& server_version);
    bool InitAfterFork();

    TString GetPoolType() {
        return TSTORAGEPOOLMODEToTString(m_mode);
    }
    bool Midnight();
    bool Shutdown();
    void EventTick();
    bool Close();

    TStorageInfoExt& GetStorageInfo(ui64 shingle, int type, ui64 uid, TActivityRequestType request_type);

    void GetStorageStat(TStorageNameStatList& statlist);
    TStorageNameStat GetStatByUID(ui32 uid, bool& notfound);
    TStorageNameStat GetStat(int index, bool& notfound);
    TStorageRequestNameStat GetRequestStat(int index, bool& notfound);
    TStorageQuantileStat GetQuantileStat(int index, bool& notfound);
    TStorageInfoFull GetStorageFullInfo(int index, bool& notfound);

    void GetAllDrivers(std::list<TString>& strlist);
};

//*******************************************************************************************************************************
