#include "tstoragepooltypes.h"
#include "tstoragenosql.h"

TStorageInfoExt::TStorageInfoExt() {
    info.Clear();
}

TStorageInfoExt::TStorageInfoExt(TSQLTypeK sql_type, TShardType shard_type, ui16 shar_number, TAtomicSharedPtr<TStorageNoSql> storA, const TString& name) {
    info = TStorageInfo(sql_type, shard_type, shar_number, name);
    storage = std::move(storA);
}

TStorageInfoExt::~TStorageInfoExt() = default;

void TStorageInfoExt::Save(IOutputStream* s) const {
    ::Save(s, info.m_sql_type);
    if(storage)
        storage->Save(s);
}

void TStorageInfoExt::Load(IInputStream* s) {
    TSQLTypeK m_sql_type;
    ::Load(s, m_sql_type);
    if(storage && m_sql_type == info.m_sql_type)
        storage->Load(s);
}
