#include "tstoragetypes.h"
#include "tstoragepool.h"

void RequestBasaKDayT(const TString &ident, kday_t &varvalue, nosql::HashMap &hash, TConstructError &errobj)
{
   i64 value = 0;

   value = hash[ident].Long();
   if (value < 0)
   {
      errobj.err = true;
      if (errobj.err_text.empty())
         errobj.err_text = errobj.err_text + ident + "='" + I64ToStroka(value) + "'";
      else
         errobj.err_text = errobj.err_text + "," + ident + "='" + I64ToStroka(value) + "'";
   }
   if (value > 0xFFFF)
      value = 0xFFFF;
   varvalue = kday_t((unsigned long)(value & 0xFFFF));
}

void RequestBasaUI32(const TString &ident, ui32 &varvalue, nosql::HashMap &hash, TConstructError &errobj)
{
   i64 value = 0;

   value = hash[ident].Long();
   if (value < 0)
   {
      errobj.err = true;
      if (errobj.err_text.empty())
         errobj.err_text = errobj.err_text + ident + "='" + I64ToStroka(value) + "'";
      else
         errobj.err_text = errobj.err_text + "," + ident + "='" + I64ToStroka(value) + "'";
   }
   if (value < 0)
      varvalue = 0;
   else if (value > 0xFFFFFFFF)
      varvalue = 0xFFFFFFFF;
   else
      varvalue = value & 0xFFFFFFFF;
}

bool RequestBasaUI32b(const TString &ident, ui32 &varvalue, nosql::HashMap &hash, TConstructError &errobj)
{
   bool                     res = false;
   nosql::HashMap::iterator it;

   it = hash.find(ident);
   if (it != hash.end())
   {
      i64  value = 0;

      res = true;
      value = (*it).second.Long();
      if (value < 0)
      {
         errobj.err = true;
         if (errobj.err_text.empty())
            errobj.err_text = errobj.err_text + ident + "='" + I64ToStroka(value) + "'";
         else
            errobj.err_text = errobj.err_text + "," + ident + "='" + I64ToStroka(value) + "'";
      }
      if (value < 0)
         varvalue = 0;
      else if (value > 0xFFFFFFFF)
         varvalue = 0xFFFFFFFF;
      else
         varvalue = value & 0xFFFFFFFF;
   }

   return res;
}

TString HashMapToTString(nosql::HashMap &hash)
{
   TString                           res      = "";
   TString                           field    = "";
   nosql::HashMap::const_iterator   hit;
   std::list<TString>                list_str;
   std::list<TString>::iterator      lit;
   nosql::TDataCounters             counters;

   lit = list_str.begin();
   while (lit != list_str.end())
   {
      field = *lit;
      hit = hash.find(field);
      if (hit != hash.end())
         res += nosql::AnyValueByTypeToStroka(hit, counters) + "&";
      else
         res += field + "=#" + IntToStroka(nosql::AnyValue::NOTYPE) + "''&";

      ++lit;
   }

   return res;
}

//**************************************************************************************************************************************

