#pragma once

#include <list>
#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "util/string/util.h"
#include "util/generic/hash.h"
#include <mail/so/spamstop/tools/so-clients/kshingle.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include "tlogsgroup.h"
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include "tstoragepooltypes.h"

enum TStorageActionType{SAT_UPDATE, SAT_FINDONE, SAT_ERASE, SAT_SIZE, SAT_MULTYACTION, SAT_FIND};
enum TShingleStorageType{SST_LONGSTAT, SST_STAT};
enum TCntValueType {CNT_HAM, CNT_SPAM, CNT_MALIC, CNT_PERSHAM, CNT_PERSSPAM, CNT_UNKNOWN};
enum TWWAction {WWA_NONE, WWA_ADD, WWA_DEL};

//table "GENSTAT" (STAT_COLLECTION)
#define SERVER_IDENT_SID                  "srv_ident"          //������������� �������
#define SERVER_NAME_SID                   "srv_name"           //��� ������� (����)
#define START_SERVER_TIME_SID             "srv_start"          //����� ������ �������
#define SERVER_VERSION_SID                "srv_vers"           //������ �������
#define LASTWRITEDATA_SID                 "refresh_time"       //����� ���������� ���������� ������ ����������

//**********************************************************************************************************************************************
//                                                   TNoSqlItem
//**********************************************************************************************************************************************

class TNoSqlItem
{
public:
         ui64           shingle{};      //�����
         int            type{};         //���
         nosql::HashMap incrs;        //���� ��� ����������
         nosql::HashMap sets;         //���� ��� ����
         nosql::HashMap hash;         //������ �� ����� �� ���� ������

public:
         TNoSqlItem()
         {
            clear();
         }

         TNoSqlItem(ui64 shingleA, int typeA)
         {
            shingle      = shingleA;
            type         = typeA;
            clear();
         }
         ~TNoSqlItem()= default;;

         void clear()
         {
            incrs.clear();
            sets.clear();
            hash.clear();
         }

         bool Valid()
         {
            if (shingle != 0)
               return true;
            else
               return false;
         }

         TString ShingleS()
         {
            return ShingleToStroka(shingle);
         }

         TString TypeS()
         {
            return IntToStroka(type);
         }

         bool Empty()
         {
            return hash.empty();
         }

         bool RequestEmpty()
         {
            bool res = true;

            if ( (!incrs.empty()) || (!sets.empty()) )
               res = false;

            return res;
         }
};

//**********************************************************************************************************************************************
//                                                 TConstructError
//**********************************************************************************************************************************************

struct TConstructError
{
   bool        err{};
   TString      err_text;

   TConstructError()
   {
      Clear();
   }

   void Clear()
   {
      err         = false;
      err_text    = "";
   }

   void PrintErrToLog(ui64 shingle, int type, const TString &functionA, TLogsGroup *LogsGroupA)
   {
      if (err)
      {
         if ( (LogsGroupA != nullptr) && (LogsGroupA->GetStorageLog() != nullptr) )
            LogsGroupA->GetStorageLog()->WriteMessageAndData("Negativ value: shingle=0x%016llx-%d, func='%s', errtext='%s'", shingle, type, functionA.c_str(), err_text.c_str());
      }
   }

};

//**********************************************************************************************************************************************
//                                                 TStorageActionList
//**********************************************************************************************************************************************

TString HashMapToTString(nosql::HashMap &hash);

struct TStorageActionItem
{
   TStorageActionType  m_action;
   TShingleStorageType m_storage_type;
   bool                *m_err;
   ui32                *m_tick;
   TNoSqlItem          *m_nosqldata;
   ui64                m_data_shingle;

   TStorageActionItem(TStorageActionType actionA, TShingleStorageType storage_typeA, TNoSqlItem *nosqldataA, bool *errA, ui32 *tickA)
   {
      m_action       = actionA;
      m_storage_type = storage_typeA;
      m_err          = errA;
      m_tick         = tickA;
      m_nosqldata    = nosqldataA;
      m_data_shingle = CalcDataShingle(m_action, m_storage_type, m_nosqldata);
   }

   void Clear()
   {
      if (m_nosqldata != nullptr)
      {
         delete m_nosqldata;
         m_nosqldata = nullptr;
      }
      m_data_shingle = 0;
   }

   static ui64 CalcDataShingle(TStorageActionType action, TShingleStorageType storage_type, TNoSqlItem *nosqldata)
   {
      ui64   res  = 0;
      TString tres = "";

      if (nosqldata != nullptr)
      {
         tres += "act=" + IntToStroka(static_cast<int>(action)) + ",";
         tres += "stortype=" + IntToStroka(static_cast<int>(storage_type)) + ",";
         tres += "incrs=" + HashMapToTString(nosqldata->incrs) + ",";
         tres += "sets=" + HashMapToTString(nosqldata->sets) + ",";
         tres += "hash=" + HashMapToTString(nosqldata->hash) + ",";

         res = ShingleFromStroka(tres);
      }

      return res;
   }
};

typedef std::list<TStorageActionItem> TStorageActionList;
typedef TStorageActionList::iterator  TStorageActionListIt;

//****************************************************************************************************************************************
//                                                       TGetStorStat
//****************************************************************************************************************************************

struct TGetStorStat
{
   ui32                allstor_count{};                    //����� �������
   ui32                needstor_count{};                   //���-�� �������, �� ������� ����� ������ ������� � �������
   ui32                errstor_count{};                    //������ � ������� ��� � ������� (���-�� �������)
   ui32                errstor_and_nocache{};              //������ � ������� ��� � �������, � ���� ������ �� ����� (���-�� �������)
   ui32                errstor_and_findcache{};            //������ � ������� ��� � �������, � ���� ������ ����� (���-�� �������)
   ui32                errstor_and_findcache_collision{};  //������ � ������� ��� � �������, � ���� ������ �����, �� ������ ��� - ���� �������� �� ���� (���-�� �������)
   ui32                okstor_and_empty{};                 //������ � ������� ��, ������ � ���� ���
   ui32                okstor_and_find{};                  //������ � ������� ��, ������ �����
   ui32                okstor_and_find_collision{};        //������ � ������� ��, ������ �����, �� �������� �� ����

   TGetStorStat()
   {
      Clear();
   }

   void Clear()
   {
      allstor_count                     = 0;
      needstor_count                    = 0;
      errstor_count                     = 0;
      errstor_and_nocache               = 0;
      errstor_and_findcache             = 0;
      errstor_and_findcache_collision   = 0;
      okstor_and_empty                  = 0;
      okstor_and_find                   = 0;
      okstor_and_find_collision         = 0;
   }

   bool IsStorErr()
   {
      if (errstor_and_nocache > 0)
         return true;
      else
         return false;
   }

   TString PrintToLog()
   {
      char     tbuff[64];
      TString   alarm_str = "";

      if ( (errstor_count > 0) && (errstor_count != needstor_count) )
      {
         if (alarm_str.empty())
            alarm_str += "ALRM01";
         else
            alarm_str += ",ALRM01";
      }

      tbuff[sizeof(tbuff) - 1] = 0x00;
      snprintf(tbuff, sizeof(tbuff) - 1, "%u,%u-%u,%u-%u-%u,%u-%u-%u", allstor_count, needstor_count, errstor_count, errstor_and_nocache, errstor_and_findcache, errstor_and_findcache_collision, okstor_and_empty, okstor_and_find, okstor_and_find_collision);

      return alarm_str + "(" + TString(tbuff) + ")";
   }

};

//**********************************************************************************************************************************************

